/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.TeachingClassRequest;
import org.unitime.timetable.model.TeachingResponsibility;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;

@SerializeWith(value=XInstructorSerializer.class)
public class XInstructor
implements Serializable,
Externalizable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iExternalId;
    private String iName;
    private String iEmail;
    private boolean iAllowOverlap;
    private boolean iDisplay = true;
    private boolean iInstructing = false;

    public XInstructor() {
    }

    public XInstructor(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XInstructor(ClassInstructor instructor, OnlineSectioningHelper helper) {
        this.iUniqueId = instructor.getInstructor().getUniqueId();
        this.iExternalId = instructor.getInstructor().getExternalUniqueId();
        this.iName = helper.getInstructorNameFormat().format(instructor.getInstructor());
        this.iEmail = instructor.getInstructor().getEmail();
        this.iDisplay = instructor.getClassInstructing().isDisplayInstructor() != false && (instructor.getResponsibility() == null || !instructor.getResponsibility().hasOption(TeachingResponsibility.Option.auxiliary));
        this.iAllowOverlap = instructor.isLead() == false;
        this.iInstructing = true;
        if (instructor.getTeachingRequest() != null) {
            for (TeachingClassRequest tcr : instructor.getTeachingRequest().getClassRequests()) {
                if (!tcr.getTeachingClass().equals(instructor.getClassInstructing())) continue;
                this.iAllowOverlap = tcr.isCanOverlap();
                break;
            }
        }
    }

    public XInstructor(DepartmentalInstructor instructor, TeachingClassRequest tcr, OnlineSectioningHelper helper) {
        this.iUniqueId = instructor.getUniqueId();
        this.iExternalId = instructor.getExternalUniqueId();
        this.iName = helper.getInstructorNameFormat().format(instructor);
        this.iEmail = instructor.getEmail();
        this.iDisplay = false;
        this.iAllowOverlap = tcr.isCanOverlap();
        this.iInstructing = false;
    }

    public XInstructor(Long uniqueId, String externalId, String name, String email, boolean display, boolean allowOverlap, boolean instructing) {
        this.iUniqueId = uniqueId;
        this.iExternalId = externalId;
        this.iName = name;
        this.iEmail = email;
        this.iDisplay = display;
        this.iAllowOverlap = allowOverlap;
        this.iInstructing = instructing;
    }

    public Long getIntructorId() {
        return this.iUniqueId;
    }

    public String getExternalId() {
        return this.iExternalId;
    }

    public boolean hasExternalId() {
        return this.iExternalId != null && !this.iExternalId.isEmpty();
    }

    public String getName() {
        return this.iName;
    }

    public String getEmail() {
        return this.iEmail;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isAllowOverlap() {
        return this.iAllowOverlap;
    }

    public boolean isAllowDisplay() {
        return this.iDisplay;
    }

    public boolean isInstructing() {
        return this.iInstructing;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof XInstructor)) {
            return false;
        }
        return this.getIntructorId().equals(((XInstructor)o).getIntructorId());
    }

    public int hashCode() {
        return Long.valueOf(this.getIntructorId()).hashCode();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.iUniqueId = in.readLong();
        this.iExternalId = (String)in.readObject();
        this.iName = (String)in.readObject();
        this.iEmail = (String)in.readObject();
        this.iAllowOverlap = in.readBoolean();
        this.iDisplay = in.readBoolean();
        this.iInstructing = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.iUniqueId);
        out.writeObject(this.iExternalId);
        out.writeObject(this.iName);
        out.writeObject(this.iEmail);
        out.writeBoolean(this.iAllowOverlap);
        out.writeBoolean(this.iDisplay);
        out.writeBoolean(this.iInstructing);
    }

    public static class XInstructorSerializer
    implements Externalizer<XInstructor> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, XInstructor object) throws IOException {
            object.writeExternal(output);
        }

        public XInstructor readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new XInstructor(input);
        }
    }
}

