/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.AdvisorCourseRequest;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CriticalCoursesProvider;
import org.unitime.timetable.onlinesectioning.model.XAdvisorRequest;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentId;

public class AdvisorCriticalCourses
implements CriticalCoursesProvider {
    private CriticalCoursesProvider iParent = null;
    private static Log sLog = LogFactory.getLog(CriticalCoursesProvider.AdvisorCriticalCourses.class);

    public AdvisorCriticalCourses() throws ServletException, IOException {
        String fallback = ApplicationProperties.getProperty("purdue.advisorCriticalCourses.fallback");
        if (fallback != null && !fallback.isEmpty()) {
            try {
                this.iParent = (CriticalCoursesProvider)Class.forName(fallback).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                sLog.error((Object)"Failed to create critical courses fallback.", (Throwable)e);
            }
        }
    }

    @Override
    public CriticalCoursesProvider.CriticalCourses getCriticalCourses(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudentId studentId) {
        return this.getCriticalCourses(server, helper, studentId, helper.getAction());
    }

    @Override
    public CriticalCoursesProvider.CriticalCourses getCriticalCourses(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudentId studentId, OnlineSectioningLog.Action.Builder action) {
        XStudent student;
        XStudent xStudent = student = studentId instanceof XStudent ? (XStudent)studentId : server.getStudent(studentId.getStudentId());
        if (student == null) {
            return this.iParent == null ? null : this.iParent.getCriticalCourses(server, helper, student, action);
        }
        CourseDemand.Critical critical = CourseDemand.Critical.fromText(ApplicationProperty.AdvisorCourseRequestsAllowCritical.valueOfSession(server.getAcademicSession().getUniqueId()));
        CriticalCoursesImpl cc = new CriticalCoursesImpl(critical, this.iParent == null ? null : this.iParent.getCriticalCourses(server, helper, student, action));
        if (student.hasAdvisorRequests()) {
            block6: for (XAdvisorRequest ar : student.getAdvisorRequests()) {
                switch (critical) {
                    case NORMAL: {
                        if (!ar.isNoSub() || ar.isSubstitute() || !ar.hasCourseId() || ar.getAlternative() != 0) break;
                        cc.addVital(ar.getCourseId());
                        for (XAdvisorRequest alt : student.getAdvisorRequests()) {
                            if (alt.getPriority() != ar.getPriority() || alt.getAlternative() <= 0 || alt.isSubstitute()) continue;
                            cc.addVital(alt.getCourseId());
                        }
                        continue block6;
                    }
                    case CRITICAL: {
                        if (!ar.isCritical() || ar.isSubstitute() || !ar.hasCourseId() || ar.getAlternative() != 0) break;
                        cc.addCritical(ar.getCourseId());
                        for (XAdvisorRequest alt : student.getAdvisorRequests()) {
                            if (alt.getPriority() != ar.getPriority() || alt.getAlternative() <= 0 || alt.isSubstitute()) continue;
                            cc.addCritical(alt.getCourseId());
                        }
                        continue block6;
                    }
                    case IMPORTANT: {
                        if (!ar.isCritical() || ar.isSubstitute() || !ar.hasCourseId() || ar.getAlternative() != 0) break;
                        cc.addImportant(ar.getCourseId());
                        for (XAdvisorRequest alt : student.getAdvisorRequests()) {
                            if (alt.getPriority() != ar.getPriority() || alt.getAlternative() <= 0 || alt.isSubstitute()) continue;
                            cc.addImportant(alt.getCourseId());
                        }
                        continue block6;
                    }
                    case VITAL: {
                        if (!ar.isCritical() || ar.isSubstitute() || !ar.hasCourseId() || ar.getAlternative() != 0) break;
                        cc.addVital(ar.getCourseId());
                        for (XAdvisorRequest alt : student.getAdvisorRequests()) {
                            if (alt.getPriority() != ar.getPriority() || alt.getAlternative() <= 0 || alt.isSubstitute()) continue;
                            cc.addVital(alt.getCourseId());
                        }
                        break;
                    }
                }
            }
        }
        return cc;
    }

    @Override
    public void dispose() {
        if (this.iParent != null) {
            this.iParent.dispose();
        }
    }

    protected static class CriticalCoursesImpl
    implements CriticalCoursesProvider.CriticalCourses,
    CriticalCoursesProvider.AdvisorCriticalCourses {
        private CourseDemand.Critical iCritical = null;
        private CriticalCoursesProvider.CriticalCourses iParent = null;
        private Map<Long, String> iCriticalCourses = new HashMap<Long, String>();
        private Map<Long, String> iVitalCourses = new HashMap<Long, String>();
        private Map<Long, String> iImportantCourses = new HashMap<Long, String>();

        CriticalCoursesImpl(CourseDemand.Critical critical, CriticalCoursesProvider.CriticalCourses parent) {
            this.iCritical = critical;
            this.iParent = parent;
        }

        CriticalCoursesImpl() {
            this(CourseDemand.Critical.NORMAL, null);
        }

        public boolean addCritical(XCourseId course) {
            return this.iCriticalCourses.put(course.getCourseId(), course.getCourseName()) != null;
        }

        public boolean addVital(XCourseId course) {
            return this.iVitalCourses.put(course.getCourseId(), course.getCourseName()) != null;
        }

        public boolean addImportant(XCourseId course) {
            return this.iImportantCourses.put(course.getCourseId(), course.getCourseName()) != null;
        }

        @Override
        public boolean isEmpty() {
            switch (this.iCritical) {
                case VITAL: {
                    return this.iVitalCourses.isEmpty() && (this.iParent == null || this.iParent.isEmpty());
                }
                case IMPORTANT: {
                    return this.iImportantCourses.isEmpty() && (this.iParent == null || this.iParent.isEmpty());
                }
                case CRITICAL: {
                    return this.iCriticalCourses.isEmpty() && (this.iParent == null || this.iParent.isEmpty());
                }
            }
            return this.iCriticalCourses.isEmpty() && this.iImportantCourses.isEmpty() && this.iVitalCourses.isEmpty() && (this.iParent == null || this.iParent.isEmpty());
        }

        protected int combine(CourseDemand.Critical c1, CourseDemand.Critical c2) {
            if (c1 == null && c2 == null) {
                return CourseDemand.Critical.NORMAL.ordinal();
            }
            if (c1 == null) {
                return c2.ordinal();
            }
            if (c2 == null) {
                return c1.ordinal();
            }
            return c1.toRequestPriority().ordinal() <= c2.toRequestPriority().ordinal() ? c1.ordinal() : c2.ordinal();
        }

        @Override
        public int isCritical(CourseOffering course) {
            CourseDemand.Critical parent;
            CourseDemand.Critical critical = parent = this.iParent == null ? CourseDemand.Critical.NORMAL : CourseDemand.Critical.values()[this.iParent.isCritical(course)];
            if (this.iCriticalCourses.containsKey(course.getUniqueId())) {
                return this.combine(CourseDemand.Critical.CRITICAL, parent);
            }
            if (this.iVitalCourses.containsKey(course.getUniqueId())) {
                return this.combine(CourseDemand.Critical.VITAL, parent);
            }
            if (this.iImportantCourses.containsKey(course.getUniqueId())) {
                return this.combine(CourseDemand.Critical.IMPORTANT, parent);
            }
            return parent.ordinal();
        }

        @Override
        public int isCritical(XCourseId course) {
            CourseDemand.Critical parent;
            CourseDemand.Critical critical = parent = this.iParent == null ? CourseDemand.Critical.NORMAL : CourseDemand.Critical.values()[this.iParent.isCritical(course)];
            if (this.iCriticalCourses.containsKey(course.getCourseId())) {
                return this.combine(CourseDemand.Critical.CRITICAL, parent);
            }
            if (this.iVitalCourses.containsKey(course.getCourseId())) {
                return this.combine(CourseDemand.Critical.VITAL, parent);
            }
            if (this.iImportantCourses.containsKey(course.getCourseId())) {
                return this.combine(CourseDemand.Critical.IMPORTANT, parent);
            }
            return parent.ordinal();
        }

        public String toString() {
            TreeSet<String> courses = null;
            switch (this.iCritical) {
                case IMPORTANT: {
                    courses = new TreeSet<String>(this.iImportantCourses.values());
                    break;
                }
                case VITAL: {
                    courses = new TreeSet<String>(this.iVitalCourses.values());
                    break;
                }
                case CRITICAL: {
                    courses = new TreeSet<String>(this.iCriticalCourses.values());
                    break;
                }
                default: {
                    courses = new TreeSet<String>(this.iCriticalCourses.values());
                    courses.addAll(this.iVitalCourses.values());
                    courses.addAll(this.iImportantCourses.values());
                }
            }
            return courses == null ? null : ((Object)courses).toString();
        }

        @Override
        public int isCritical(AdvisorCourseRequest request) {
            CourseDemand.Critical parent;
            if (request.getCourseOffering() == null || request.isSubstitute().booleanValue()) {
                return CourseDemand.Critical.NORMAL.ordinal();
            }
            CourseDemand.Critical critical = parent = this.iParent == null ? CourseDemand.Critical.NORMAL : CourseDemand.Critical.values()[this.iParent.isCritical(request.getCourseOffering())];
            if (this.iCritical == CourseDemand.Critical.NORMAL) {
                if (Boolean.TRUE.equals(request.isNoSub())) {
                    return this.combine(CourseDemand.Critical.VITAL, parent);
                }
                return parent.ordinal();
            }
            return this.combine(request.getEffectiveCritical(), parent);
        }

        @Override
        public int isCritical(XAdvisorRequest request) {
            CourseDemand.Critical parent;
            if (request.getCourseId() == null || request.isSubstitute()) {
                return CourseDemand.Critical.NORMAL.ordinal();
            }
            CourseDemand.Critical critical = parent = this.iParent == null ? CourseDemand.Critical.NORMAL : CourseDemand.Critical.values()[this.iParent.isCritical(request.getCourseId())];
            if (this.iCritical == CourseDemand.Critical.NORMAL) {
                if (Boolean.TRUE.equals(request.isNoSub())) {
                    return this.combine(CourseDemand.Critical.VITAL, parent);
                }
                return parent.ordinal();
            }
            return this.combine(CourseDemand.Critical.values()[request.getCritical()], parent);
        }
    }
}

