/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.basic;

import org.hibernate.Session;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.basic.CheckEligibility;
import org.unitime.timetable.onlinesectioning.custom.CustomCourseRequestsValidationHolder;
import org.unitime.timetable.onlinesectioning.custom.CustomStudentEnrollmentHolder;

public class CourseRequestEligibility
extends CheckEligibility {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);

    @Override
    protected void logCheck(OnlineSectioningLog.Action.Builder action, OnlineSectioningInterface.EligibilityCheck check) {
        for (OnlineSectioningInterface.EligibilityCheck.EligibilityFlag f : OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.values()) {
            if (!check.hasFlag(f)) continue;
            action.addOptionBuilder().setKey(f.name().replace('_', ' ')).setValue("true");
        }
        if (check.hasMessage()) {
            action.addMessageBuilder().setText(check.getMessage()).setLevel(OnlineSectioningLog.Message.Level.WARN);
        }
        if (check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REGISTER)) {
            action.setResult(OnlineSectioningLog.Action.ResultType.TRUE);
        } else {
            action.setResult(OnlineSectioningLog.Action.ResultType.FALSE);
        }
        if (check.getAdvisorWaitListedCourseIds() != null && !check.getAdvisorWaitListedCourseIds().isEmpty()) {
            action.addOptionBuilder().setKey("Wait-Listed Courses").setValue(check.getAdvisorWaitListedCourseIds().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OnlineSectioningInterface.EligibilityCheck execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        OnlineSectioningInterface.EligibilityCheck eligibilityCheck;
        if (this.iCheck == null) {
            this.iCheck = new OnlineSectioningInterface.EligibilityCheck();
        }
        OnlineSectioningLog.Action.Builder action = helper.getAction();
        OnlineSectioningServer.Lock lock = this.iStudentId == null || server.getStudent(this.iStudentId) == null ? null : server.lockStudent(this.iStudentId, null, this.name());
        try {
            this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_USE_ASSISTANT, true);
            if (this.iStudentId != null) {
                action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.iStudentId));
            }
            this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_WAITLIST, CustomStudentEnrollmentHolder.isAllowWaitListing());
            try (Session hibSession = StudentDAO.getInstance().createNewSession();){
                StudentSectioningStatus s;
                boolean disabled;
                Student student;
                Student student2 = student = this.iStudentId == null ? null : (Student)StudentDAO.getInstance().get(this.iStudentId, hibSession);
                if (student == null) {
                    if (!(this.iCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADMIN) || this.iCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADVISOR) || this.iCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_GUEST))) {
                        this.iCheck.setMessage(MSG.exceptionEnrollNotStudent(server.getAcademicSession().toString()));
                    }
                    this.logCheck(action, this.iCheck);
                    action.setResult(OnlineSectioningLog.Action.ResultType.NULL);
                    OnlineSectioningInterface.EligibilityCheck eligibilityCheck2 = this.iCheck;
                    return eligibilityCheck2;
                }
                if (this.iStudentId != null) {
                    this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.HAS_ADVISOR_REQUESTS, student.getAdvisorCourseRequests() != null && !student.getAdvisorCourseRequests().isEmpty());
                }
                this.iCheck.setMaxCredit(student.getMaxCredit());
                action.getStudentBuilder().setExternalId(student.getExternalUniqueId());
                action.getStudentBuilder().setName(helper.getStudentNameFormat().format(student));
                StudentSectioningStatus status = student.getEffectiveStatus();
                boolean bl = disabled = status != null && !status.hasOption(StudentSectioningStatus.Option.regenabled);
                if (disabled && status != null && status.hasOption(StudentSectioningStatus.Option.regadmin) && this.iCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADMIN)) {
                    disabled = false;
                }
                if (disabled && status != null && status.hasOption(StudentSectioningStatus.Option.regadvisor) && this.iCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADVISOR)) {
                    disabled = false;
                }
                boolean noreg = false;
                if (this.iPermissionCanEnroll != null) {
                    noreg = this.iPermissionCanEnroll == false;
                } else {
                    boolean bl2 = noreg = status != null && !status.hasOption(StudentSectioningStatus.Option.registration);
                    if (noreg && status.hasOption(StudentSectioningStatus.Option.regadmin) && this.iCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADMIN)) {
                        noreg = false;
                    }
                    if (noreg && status.hasOption(StudentSectioningStatus.Option.regadvisor) && this.iCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADVISOR)) {
                        noreg = false;
                    }
                }
                if (status != null && !status.hasOption(StudentSectioningStatus.Option.waitlist)) {
                    this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_WAITLIST, false);
                }
                if (status == null || status.hasOption(StudentSectioningStatus.Option.nosubs)) {
                    this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_NO_SUBS, true);
                }
                if (student != null) {
                    this.iCheck.setAdvisorWaitListedCourseIds(student.getAdvisorWaitListedCourseIds(server));
                }
                if (this.iPermissionCanRequirePreferences != null) {
                    this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REQUIRE, this.iPermissionCanRequirePreferences);
                } else {
                    this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REQUIRE, this.iCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADMIN) || this.iCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADVISOR) || status == null || status.hasOption(StudentSectioningStatus.Option.canreq));
                }
                if (disabled) {
                    this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_USE_ASSISTANT, false);
                }
                if (student.getSession().getStatusType().canPreRegisterStudents()) {
                    if (!noreg) {
                        this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REGISTER, true);
                    }
                } else {
                    this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REGISTER, false);
                }
                if ((s = StudentSectioningStatus.getPresentStatus(student.getSectioningStatus() != null ? student.getSectioningStatus() : student.getSession().getDefaultSectioningStatus())) != null && s.getMessage() != null) {
                    this.iCheck.setMessage(s.getMessage());
                } else if (status != null && status.getMessage() != null) {
                    this.iCheck.setMessage(status.getMessage());
                } else if (disabled) {
                    this.iCheck.setMessage(MSG.exceptionAccessDisabled());
                } else if (noreg) {
                    this.iCheck.setMessage(MSG.exceptionRegistrationDisabled());
                }
                if (ApplicationProperty.StudentStatusEffectivePeriodMessage.isTrue()) {
                    String effectivePeriod;
                    String string = s != null ? s.getEffectivePeriod() : (effectivePeriod = status != null ? status.getEffectivePeriod() : null);
                    if (effectivePeriod != null) {
                        this.iCheck.setMessage((this.iCheck.hasMessage() ? this.iCheck.getMessage() + "\n" : "") + MSG.messageTimeWindow(effectivePeriod));
                    }
                }
                if (this.iCustomCheck && CustomCourseRequestsValidationHolder.hasProvider()) {
                    CustomCourseRequestsValidationHolder.getProvider().checkEligibility(server, helper, this.iCheck, student);
                }
            }
            this.logCheck(action, this.iCheck);
            eligibilityCheck = this.iCheck;
            return eligibilityCheck;
        }
        catch (SectioningException e) {
            this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REGISTER, false);
            this.iCheck.setMessage(MSG.exceptionFailedEligibilityCheck(e.getMessage()));
            helper.info(MSG.exceptionFailedEligibilityCheck(e.getMessage()));
            this.logCheck(action, this.iCheck);
            action.setResult(OnlineSectioningLog.Action.ResultType.FAILURE);
            eligibilityCheck = this.iCheck;
            return eligibilityCheck;
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
    }
}

