/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import java.util.List;
import org.hibernate.Session;
import org.unitime.timetable.model.WaitList;
import org.unitime.timetable.model.dao.WaitListDAO;
import org.unitime.timetable.model.dao._RootDAO;

public abstract class BaseWaitListDAO
extends _RootDAO<WaitList, Long> {
    private static WaitListDAO sInstance;

    public static WaitListDAO getInstance() {
        if (sInstance == null) {
            sInstance = new WaitListDAO();
        }
        return sInstance;
    }

    @Override
    public Class<WaitList> getReferenceClass() {
        return WaitList.class;
    }

    public List<WaitList> findByStudent(Session hibSession, Long studentId) {
        return hibSession.createQuery("from WaitList x where x.student.uniqueId = :studentId").setLong("studentId", studentId.longValue()).list();
    }

    public List<WaitList> findByCourseOffering(Session hibSession, Long courseOfferingId) {
        return hibSession.createQuery("from WaitList x where x.courseOffering.uniqueId = :courseOfferingId").setLong("courseOfferingId", courseOfferingId.longValue()).list();
    }

    public List<WaitList> findByEnrolledCourse(Session hibSession, Long enrolledCourseId) {
        return hibSession.createQuery("from WaitList x where x.enrolledCourse.uniqueId = :enrolledCourseId").setLong("enrolledCourseId", enrolledCourseId.longValue()).list();
    }

    public List<WaitList> findByCourseDemand(Session hibSession, Long courseDemandId) {
        return hibSession.createQuery("from WaitList x where x.courseDemand.uniqueId = :courseDemandId").setLong("courseDemandId", courseDemandId.longValue()).list();
    }

    public List<WaitList> findBySwapCourseOffering(Session hibSession, Long swapCourseOfferingId) {
        return hibSession.createQuery("from WaitList x where x.swapCourseOffering.uniqueId = :swapCourseOfferingId").setLong("swapCourseOfferingId", swapCourseOfferingId.longValue()).list();
    }
}

