/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.Date;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.util.ToolBox;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePatternModel;
import org.unitime.timetable.model.base.BaseTimePref;
import org.unitime.timetable.webutil.RequiredTimeTable;

public class TimePref
extends BaseTimePref
implements Comparable {
    private static final long serialVersionUID = 1L;

    public TimePref() {
    }

    public TimePref(Long uniqueId) {
        super(uniqueId);
    }

    @Override
    public String preferenceText() {
        return this.getTimePattern().getName();
    }

    public TimePatternModel getTimePatternModel() {
        return this.getTimePatternModel(null);
    }

    public TimePatternModel getTimePatternModel(TimeLocation assignment) {
        TimePatternModel model = new TimePatternModel(this.getTimePattern(), assignment, true);
        model.setPreferences(super.getPreference());
        return model;
    }

    public void setTimePatternModel(TimePatternModel model) {
        if (model == null) {
            this.setPreference(null);
            this.setTimePattern(null);
        } else {
            this.setPreference(model.getPreferences());
            this.setTimePattern(model.getTimePattern());
        }
    }

    @Override
    public int compareTo(Object o) {
        try {
            TimePattern t1 = this.getTimePattern();
            TimePattern t2 = ((TimePref)o).getTimePattern();
            int cmp = t1.compareTo(t2);
            if (cmp != 0) {
                return cmp;
            }
            cmp = -this.getPreference().compareTo(((TimePref)o).getPreference());
            if (cmp != 0) {
                return cmp;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.compareTo(o);
    }

    public void setInOldFormat(String days, Date startTime, Date endTime, PreferenceLevel pref) {
        TimePatternModel model = this.getTimePatternModel();
        if (model == null) {
            return;
        }
        model.setInOldFormat(days, startTime, endTime, pref);
        this.setPreference(model.getPreferences());
    }

    public void combineWith(TimePref other, boolean clear) {
        this.combineWith(other, clear, 2);
    }

    public void combineWith(TimePref other, boolean clear, int alg) {
        TimePatternModel model = this.getTimePatternModel();
        TimePatternModel otherModel = other.getTimePatternModel();
        if (model == null || otherModel == null) {
            return;
        }
        model.combineWith(otherModel, clear, alg);
        this.setPreference(model.getPreferences());
    }

    @Override
    public boolean weakenHardPreferences() {
        TimePatternModel model = this.getTimePatternModel();
        if (model == null) {
            return false;
        }
        model.weakenHardPreferences();
        this.setPreference(model.getPreferences());
        return true;
    }

    public RequiredTimeTable getRequiredTimeTable() {
        return this.getRequiredTimeTable(null);
    }

    public RequiredTimeTable getRequiredTimeTable(TimeLocation assignment) {
        return new RequiredTimeTable(this.getTimePatternModel(assignment));
    }

    @Override
    public Object clone() {
        TimePref p = new TimePref();
        p.setPreference(this.getPreference());
        p.setTimePattern(this.getTimePattern());
        p.setPrefLevel(this.getPrefLevel());
        return p;
    }

    @Override
    public boolean isSame(Preference other) {
        if (other == null || !(other instanceof TimePref)) {
            return false;
        }
        return ToolBox.equals((Object)this.getTimePattern(), (Object)((TimePref)other).getTimePattern());
    }

    @Override
    public String getPreference() {
        if (super.getPreference() == null) {
            return this.getTimePatternModel().getPreferences();
        }
        return super.getPreference();
    }

    @Override
    public Preference.Type getType() {
        return Preference.Type.TIME;
    }
}

