/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.HashSet;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.commons.Debug;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.CourseRequestOption;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.StudentClassPref;
import org.unitime.timetable.model.StudentInstrMthPref;
import org.unitime.timetable.model.base.BaseStudentClassPref;
import org.unitime.timetable.model.base.BaseStudentInstrMthPref;
import org.unitime.timetable.model.base.BaseStudentSectioningPref;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.InstructionalMethodDAO;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;

public abstract class StudentSectioningPref
extends BaseStudentSectioningPref {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateStudentSectioningPreferences() {
        Session hibSession = new _RootDAO().createNewSession();
        Transaction tx = hibSession.beginTransaction();
        try {
            boolean first = true;
            for (CourseRequestOption option : hibSession.createQuery("from CourseRequestOption where optionType = :type").setInteger("type", OnlineSectioningLog.CourseRequestOption.OptionType.REQUEST_PREFERENCE.getNumber()).list()) {
                if (first) {
                    Debug.info(" - Updating student scheduling preferences ...");
                    first = false;
                }
                CourseRequest cr = option.getCourseRequest();
                hibSession.delete((Object)option);
                cr.getCourseRequestOptions().remove(option);
                if (cr.getPreferences() == null) {
                    cr.setPreferences(new HashSet<StudentSectioningPref>());
                }
                try {
                    OnlineSectioningLog.CourseRequestOption pref = option.getOption();
                    if (pref != null) {
                        boolean required;
                        if (pref.getInstructionalMethodCount() > 0) {
                            for (OnlineSectioningLog.Entity e : pref.getInstructionalMethodList()) {
                                InstructionalMethod im;
                                required = false;
                                if (e.getParameterCount() > 0) {
                                    for (OnlineSectioningLog.Property p : e.getParameterList()) {
                                        if (!"required".equals(p.getKey())) continue;
                                        required = "true".equals(p.getValue());
                                    }
                                }
                                if ((im = (InstructionalMethod)InstructionalMethodDAO.getInstance().get(e.getUniqueId())) == null) {
                                    im = InstructionalMethod.findByReference(e.getName(), hibSession);
                                }
                                if (im == null) continue;
                                StudentInstrMthPref imp = new StudentInstrMthPref();
                                imp.setCourseRequest(cr);
                                imp.setRequired(required);
                                imp.setInstructionalMethod(im);
                                imp.setLabel(im.getReference());
                                cr.getPreferences().add(imp);
                            }
                        }
                        if (pref.getSectionCount() > 0) {
                            for (OnlineSectioningLog.Section x : pref.getSectionList()) {
                                boolean bl = required = x.hasPreference() && x.getPreference() == OnlineSectioningLog.Section.Preference.REQUIRED;
                                Class_ clazz = (Class_)Class_DAO.getInstance().get(x.getClazz().getUniqueId(), hibSession);
                                if (clazz == null) continue;
                                StudentClassPref scp = new StudentClassPref();
                                scp.setCourseRequest(cr);
                                scp.setRequired(required);
                                scp.setClazz(clazz);
                                scp.setLabel(clazz.getClassPrefLabel(cr.getCourseOffering()));
                                cr.getPreferences().add(scp);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                hibSession.update((Object)cr);
            }
            for (StudentSectioningPref p : hibSession.createQuery("from StudentInstrMthPref where label is null and instructionalMethod.label is not null").list()) {
                p.setLabel(((BaseStudentInstrMthPref)p).getInstructionalMethod().getLabel());
                hibSession.update((Object)p);
            }
            for (StudentSectioningPref p : hibSession.createQuery("from StudentClassPref where label is null").list()) {
                p.setLabel(((BaseStudentClassPref)p).getClazz().getClassPrefLabel(p.getCourseRequest().getCourseOffering()));
                hibSession.update((Object)p);
            }
            tx.commit();
        }
        catch (Exception e) {
            Debug.error("Failed to update student sectioning preferences: " + e.getMessage(), e);
            tx.rollback();
        }
        finally {
            hibSession.getSessionFactory().getCache().evictCollectionRegion(CourseRequest.class.getName() + ".courseRequestOptions");
            hibSession.close();
        }
    }
}

