/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.List;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.unitime.timetable.model.base.BaseStudentGroup;
import org.unitime.timetable.model.dao.StudentGroupDAO;

public class StudentGroup
extends BaseStudentGroup {
    private static final long serialVersionUID = 1L;
    public static String STUGRP_ATTR_NAME = "studentGroupList";

    public StudentGroup() {
    }

    public StudentGroup(Long uniqueId) {
        super(uniqueId);
    }

    public static List getStudentGroupList(Long sessionId) {
        StudentGroupDAO sdao = new StudentGroupDAO();
        Session hibSession = sdao.getSession();
        List l = hibSession.createCriteria(StudentGroup.class).add((Criterion)Restrictions.eq((String)"sessionId", (Object)sessionId)).addOrder(Order.asc((String)"groupName")).list();
        return l;
    }

    public static StudentGroup findByAbbv(Long sessionId, String abbv) {
        return (StudentGroup)new StudentGroupDAO().getSession().createQuery("select a from StudentGroup a where a.session.uniqueId=:sessionId and a.groupAbbreviation=:abbv").setLong("sessionId", sessionId.longValue()).setString("abbv", abbv).setCacheable(true).uniqueResult();
    }

    public static StudentGroup findByExternalId(Session hibSession, String externalId, Long acadSessionId) {
        return (StudentGroup)hibSession.createQuery("select a from StudentGroup a where a.session.uniqueId = :acadSessionId and externalUniqueId=:eId ").setLong("acadSessionId", acadSessionId.longValue()).setString("eId", externalId).setCacheable(true).uniqueResult();
    }

    public static List<StudentGroup> findByType(Session hibSession, Long sessionId, Long typeId) {
        if (typeId == null) {
            return hibSession.createQuery("from StudentGroup x where x.session.uniqueId = :sessionId and x.type is null").setLong("sessionId", sessionId.longValue()).list();
        }
        return hibSession.createQuery("from StudentGroup x where x.session.uniqueId = :sessionId and x.type.uniqueId = :typeId").setLong("sessionId", sessionId.longValue()).setLong("typeId", typeId.longValue()).list();
    }
}

