/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.hibernate.Session;
import org.unitime.commons.Debug;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseCreditUnitConfig;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentRoomFeature;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.InstructorAttributePref;
import org.unitime.timetable.model.InstructorPref;
import org.unitime.timetable.model.ItypeDesc;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.TeachingClassRequest;
import org.unitime.timetable.model.TeachingRequest;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePatternModel;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.base.BaseSchedulingSubpart;
import org.unitime.timetable.model.comparators.NavigationComparator;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.duration.DurationModel;
import org.unitime.timetable.webutil.Navigation;

public class SchedulingSubpart
extends BaseSchedulingSubpart {
    private static final long serialVersionUID = 1L;
    public static final String SCHED_SUBPART_ATTR_NAME = "schedSubpartList";

    public SchedulingSubpart() {
    }

    public SchedulingSubpart(Long uniqueId) {
        super(uniqueId);
    }

    public String getCourseNameWithTitle() {
        return this.getInstrOfferingConfig().getCourseNameWithTitle();
    }

    public CourseOffering getControllingCourseOffering() {
        return this.getInstrOfferingConfig().getControllingCourseOffering();
    }

    public String getItypeDesc() {
        try {
            ItypeDesc itype = this.getItype();
            return itype == null ? null : itype.getAbbv();
        }
        catch (Exception e) {
            Debug.error(e);
            return null;
        }
    }

    public Department getManagingDept() {
        if (this.getClasses() != null) {
            boolean allSame = true;
            Department d = null;
            Department d1 = null;
            Iterator<Class_> it = this.getClasses().iterator();
            Class_ c = null;
            while (it.hasNext() && allSame) {
                c = it.next();
                d = c.getManagingDept();
                if (d1 == null) {
                    d1 = d;
                }
                if (d1 == null || d != null && d.getUniqueId() != null && d.getUniqueId().equals(d1.getUniqueId())) continue;
                allSame = false;
            }
            if (d != null && allSame) {
                return d;
            }
            return this.getControllingDept();
        }
        return this.getControllingDept();
    }

    public Department getControllingDept() {
        return this.getInstrOfferingConfig().getDepartment();
    }

    public Long getSessionId() {
        return this.getSession().getUniqueId();
    }

    @Override
    public String htmlLabel() {
        return this.getItype().getDesc();
    }

    private String htmlForTimePatterns(Set patterns) {
        StringBuffer sb = new StringBuffer();
        if (patterns != null) {
            Iterator it = patterns.iterator();
            TimePattern t = null;
            while (it.hasNext()) {
                t = (TimePattern)it.next();
                sb.append(t.getName());
                if (!it.hasNext()) continue;
                sb.append("<BR>");
            }
        }
        return sb.toString();
    }

    @Override
    public String effectiveTimePatternHtml() {
        return this.htmlForTimePatterns(this.effectiveTimePatterns());
    }

    public String timePatternHtml() {
        return this.htmlForTimePatterns(this.getTimePatterns());
    }

    public int getMinClassLimit() {
        Set<Class_> classes = this.getClasses();
        if (classes == null) {
            return -1;
        }
        if (classes.size() == 0) {
            return 0;
        }
        int limit = 0;
        for (Class_ c : classes) {
            int ct = c.getExpectedCapacity();
            if (ct <= limit) continue;
            limit = ct;
        }
        return limit;
    }

    public int getMaxClassLimit() {
        Set<Class_> classes = this.getClasses();
        if (classes == null) {
            return -1;
        }
        if (classes.size() == 0) {
            return 0;
        }
        int limit = 0;
        for (Class_ c : classes) {
            int ct = c.getMaxExpectedCapacity();
            if (ct <= limit) continue;
            limit = ct;
        }
        return limit;
    }

    public int getNumClasses() {
        Set<Class_> classes = this.getClasses();
        if (classes == null) {
            return -1;
        }
        return classes.size();
    }

    public String getSchedulingSubpartLabel() {
        String sufix = this.getSchedulingSubpartSuffix();
        String cfgName = this.getInstrOfferingConfig().getInstructionalOffering().hasMultipleConfigurations() ? this.getInstrOfferingConfig().getName() : null;
        return this.getCourseName() + " " + this.getItypeDesc().trim() + (sufix == null || sufix.length() == 0 ? "" : " (" + sufix + ")") + (cfgName == null ? "" : " [" + cfgName + "]");
    }

    @Override
    public String toString() {
        return this.getSchedulingSubpartLabel();
    }

    @Override
    public Class getInstanceOf() {
        return SchedulingSubpart.class;
    }

    public float getMaxRoomRatio() {
        Set<Class_> classes = this.getClasses();
        if (classes == null) {
            return -1.0f;
        }
        if (classes.size() == 0) {
            return 1.0f;
        }
        float rc = 0.0f;
        for (Class_ c : classes) {
            Float rc1 = c.getRoomRatio();
            if (rc1 == null || !(rc1.floatValue() > rc)) continue;
            rc = rc1.floatValue();
        }
        return rc;
    }

    public int getMaxRooms() {
        Set<Class_> classes = this.getClasses();
        if (classes == null) {
            return -1;
        }
        if (classes.size() == 0) {
            return -1;
        }
        int numRooms = 0;
        for (Class_ c : classes) {
            int ct = c.getNbrRooms();
            if (ct <= numRooms) continue;
            numRooms = ct;
        }
        return numRooms;
    }

    @Override
    public Set getDistributionPreferences() {
        TreeSet<DistributionPref> prefs = new TreeSet<DistributionPref>();
        if (this.getDistributionObjects() != null) {
            for (DistributionObject distObj : this.getDistributionObjects()) {
                prefs.add(distObj.getDistributionPref());
            }
        }
        return prefs;
    }

    public Set effectiveDistributionPreferences(Department owningDept) {
        if (this.getDistributionObjects() == null) {
            return null;
        }
        TreeSet<DistributionPref> prefs = new TreeSet<DistributionPref>();
        for (DistributionObject distObj : this.getDistributionObjects()) {
            DistributionPref pref = distObj.getDistributionPref();
            if (owningDept != null && !owningDept.equals(pref.getOwner())) continue;
            prefs.add(pref);
        }
        return prefs;
    }

    protected Set combinePreferences(Class type, Set subpartPrefs, Set parentPrefs) {
        if (TimePref.class.equals((Object)type)) {
            if (parentPrefs == null || parentPrefs.isEmpty() || !this.getParentSubpart().getMinutesPerWk().equals(this.getMinutesPerWk())) {
                return subpartPrefs;
            }
            HashSet<TimePattern> tp = new HashSet<TimePattern>();
            TreeSet<TimePref> ret = new TreeSet<TimePref>();
            for (TimePref pref : subpartPrefs) {
                ret.add(pref);
                tp.add(pref.getTimePattern());
            }
            for (TimePref p : parentPrefs) {
                if (!tp.add(p.getTimePattern())) continue;
                ret.add(p);
            }
            return ret;
        }
        if (subpartPrefs == null || subpartPrefs.isEmpty()) {
            return parentPrefs;
        }
        if (parentPrefs == null || parentPrefs.isEmpty()) {
            return subpartPrefs;
        }
        TreeSet<Preference> ret = new TreeSet<Preference>(subpartPrefs);
        block2: for (Preference parentPref : parentPrefs) {
            for (Preference p : ret) {
                if (!p.isSame(parentPref)) continue;
                continue block2;
            }
            ret.add(parentPref);
        }
        return ret;
    }

    private Set removeDepartmentalPreferences(Set prefs) {
        if (prefs == null) {
            return new TreeSet();
        }
        if (prefs.isEmpty()) {
            return prefs;
        }
        TreeSet<Preference> ret = new TreeSet<Preference>();
        block0: for (Preference pref : prefs) {
            if (pref instanceof RoomPref) {
                Location loc = ((RoomPref)pref).getRoom();
                for (RoomDept rd : loc.getRoomDepts()) {
                    if (!rd.getDepartment().equals(this.getManagingDept())) continue;
                    ret.add(pref);
                    continue block0;
                }
                continue;
            }
            if (pref instanceof BuildingPref) {
                Building b = ((BuildingPref)pref).getBuilding();
                if (!this.getAvailableBuildings().contains(b)) continue;
                ret.add(pref);
                continue;
            }
            if (pref instanceof RoomFeaturePref) {
                RoomFeature rf = ((RoomFeaturePref)pref).getRoomFeature();
                if (rf instanceof GlobalRoomFeature) {
                    ret.add(pref);
                    continue;
                }
                if (!(rf instanceof DepartmentRoomFeature) || !((DepartmentRoomFeature)rf).getDepartment().equals(this.getManagingDept())) continue;
                ret.add(pref);
                continue;
            }
            if (pref instanceof RoomGroupPref) {
                RoomGroup rg = ((RoomGroupPref)pref).getRoomGroup();
                if (!rg.isGlobal().booleanValue() && !this.getManagingDept().equals(rg.getDepartment())) continue;
                ret.add(pref);
                continue;
            }
            ret.add(pref);
        }
        return ret;
    }

    private Set weakenHardPreferences(Set prefs) {
        if (prefs == null || prefs.isEmpty()) {
            return prefs;
        }
        TreeSet<Preference> ret = new TreeSet<Preference>();
        Iterator i = prefs.iterator();
        while (i.hasNext()) {
            Preference pref = (Preference)((Preference)i.next()).clone();
            if (!pref.weakenHardPreferences()) continue;
            ret.add(pref);
        }
        return ret;
    }

    private Set removeNeutralPreferences(Set prefs) {
        if (prefs == null) {
            return new TreeSet();
        }
        if (prefs.isEmpty()) {
            return prefs;
        }
        TreeSet ret = new TreeSet(prefs);
        Iterator i = ret.iterator();
        while (i.hasNext()) {
            Preference pref = (Preference)i.next();
            if (!PreferenceLevel.sNeutral.equals(pref.getPrefLevel().getPrefProlog())) continue;
            i.remove();
        }
        return ret;
    }

    private Set fixDurationInTimePreferences(Set prefs) {
        if (prefs == null || prefs.isEmpty()) {
            return prefs;
        }
        DatePattern dp = this.effectiveDatePattern();
        if (dp == null) {
            return prefs;
        }
        DurationModel dm = this.getInstrOfferingConfig().getDurationModel();
        TreeSet ret = new TreeSet(prefs);
        ArrayList<TimePref> fixed = new ArrayList<TimePref>();
        Iterator i = ret.iterator();
        while (i.hasNext()) {
            int t;
            int d;
            TimePref tp;
            Preference pref = (Preference)i.next();
            if (!(pref instanceof TimePref) || (tp = (TimePref)pref).getTimePattern().getType() != null && tp.getTimePattern().isExactTime()) continue;
            Set<Integer> days = dm.getDayCodes(this.getMinutesPerWk(), dp, tp.getTimePattern());
            if (days.isEmpty()) {
                i.remove();
                continue;
            }
            if (days.size() >= tp.getTimePattern().getDays().size()) continue;
            TimePatternModel model = tp.getTimePatternModel();
            boolean req = model.hasRequiredPreferences();
            for (d = 0; d < model.getNrDays(); ++d) {
                if (days.contains(model.getDayCode(d))) continue;
                for (t = 0; t < model.getNrTimes(); ++t) {
                    model.setPreference(d, t, PreferenceLevel.sNotAvailable);
                }
            }
            if (req && !model.hasRequiredPreferences()) {
                for (d = 0; d < model.getNrDays(); ++d) {
                    if (!days.contains(model.getDayCode(d))) continue;
                    for (t = 0; t < model.getNrTimes(); ++t) {
                        model.setPreference(d, t, PreferenceLevel.sProhibited);
                    }
                }
            }
            i.remove();
            TimePref copy = (TimePref)tp.clone();
            copy.setPreference(model.getPreferences());
            fixed.add(copy);
        }
        ret.addAll(fixed);
        return ret;
    }

    public boolean canInheritParentPreferences() {
        return this.getParentSubpart() != null && this.getParentSubpart().getItype().equals(this.getItype()) && ApplicationProperty.PreferencesHierarchicalInheritance.isTrue();
    }

    @Override
    public Set effectivePreferences(Class type, boolean fixDurationInTimePreferences) {
        if (DistributionPref.class.equals((Object)type)) {
            return this.effectiveDistributionPreferences(this.getManagingDept());
        }
        if (InstructorAttributePref.class.equals((Object)type) || InstructorPref.class.equals((Object)type)) {
            TreeSet prefs = new TreeSet();
            ArrayList<TeachingRequest> requests = new ArrayList<TeachingRequest>();
            for (Class_ clazz : this.getClasses()) {
                block1: for (TeachingClassRequest tcr : clazz.getTeachingRequests()) {
                    if (!tcr.getAssignInstructor().booleanValue()) continue;
                    for (TeachingRequest r : requests) {
                        if (!r.equals(tcr.getTeachingRequest()) && !r.canCombine(tcr.getTeachingRequest())) continue;
                        continue block1;
                    }
                    requests.add(tcr.getTeachingRequest());
                    prefs.addAll(tcr.getTeachingRequest().getPreferences(type));
                }
            }
            return prefs;
        }
        Set subpartPrefs = this.getPreferences(type, this);
        if (this.canInheritParentPreferences()) {
            Set parentPrefs = this.getParentSubpart().effectivePreferences(type, this);
            Department mngDept = this.getManagingDept();
            if (parentPrefs != null && !parentPrefs.isEmpty() && !mngDept.equals(this.getParentSubpart().getManagingDept())) {
                if (TimePref.class.equals((Object)type)) {
                    if (mngDept.isExternalManager().booleanValue() && !mngDept.isAllowReqTime().booleanValue()) {
                        parentPrefs = this.weakenHardPreferences(parentPrefs);
                    }
                } else if (mngDept.isExternalManager().booleanValue() && !mngDept.isAllowReqRoom().booleanValue()) {
                    parentPrefs = this.weakenHardPreferences(parentPrefs);
                }
                if (mngDept.isExternalManager().booleanValue()) {
                    parentPrefs = this.removeDepartmentalPreferences(parentPrefs);
                }
            }
            Set ret = this.removeNeutralPreferences(this.combinePreferences(type, subpartPrefs, parentPrefs));
            return fixDurationInTimePreferences ? this.fixDurationInTimePreferences(ret) : ret;
        }
        return fixDurationInTimePreferences ? this.fixDurationInTimePreferences(subpartPrefs) : subpartPrefs;
    }

    public Set effectivePreferences(Class type, PreferenceGroup appliesTo) {
        if (appliesTo == null) {
            return this.effectivePreferences(type);
        }
        TreeSet<Preference> ret = new TreeSet<Preference>();
        for (Preference preference : this.effectivePreferences(type, false)) {
            if (!preference.appliesTo(appliesTo)) continue;
            ret.add(preference);
        }
        return ret;
    }

    @Override
    public DatePattern effectiveDatePattern() {
        if (this.getDatePattern() != null) {
            return this.getDatePattern();
        }
        if (this.canInheritParentPreferences()) {
            return this.getParentSubpart().effectiveDatePattern();
        }
        return this.getSession().getDefaultDatePatternNotNull();
    }

    @Override
    public Set getAvailableRooms() {
        TreeSet<Location> rooms = new TreeSet<Location>();
        for (RoomDept roomDept : this.getManagingDept().getRoomDepts()) {
            rooms.add(roomDept.getRoom());
        }
        return rooms;
    }

    @Override
    public Set getAvailableRoomFeatures() {
        Set features = super.getAvailableRoomFeatures();
        Department dept = this.getManagingDept();
        if (dept != null) {
            features.addAll(DepartmentRoomFeature.getAllDepartmentRoomFeatures(dept));
        }
        return features;
    }

    @Override
    public Set getAvailableRoomGroups() {
        Set groups = super.getAvailableRoomGroups();
        Department dept = this.getManagingDept();
        if (dept != null) {
            groups.addAll(RoomGroup.getAllDepartmentRoomGroups(dept));
        }
        return groups;
    }

    @Override
    public Set getAvailableAttributeTypes() {
        return this.getControllingDept().getAvailableAttributeTypes();
    }

    @Override
    public Set getAvailableAttributes() {
        return this.getControllingDept().getAvailableAttributes();
    }

    public SchedulingSubpart getNextSchedulingSubpart(SessionContext context, Right right) {
        return this.getNextSchedulingSubpart(context, new NavigationComparator(), right);
    }

    public SchedulingSubpart getPreviousSchedulingSubpart(SessionContext context, Right right) {
        return this.getPreviousSchedulingSubpart(context, new NavigationComparator(), right);
    }

    public SchedulingSubpart getNextSchedulingSubpart(SessionContext context, Comparator cmp, Right right) {
        Long nextId = Navigation.getNext(context, Navigation.sSchedulingSubpartLevel, this.getUniqueId());
        if (nextId != null) {
            if (nextId < 0L) {
                return null;
            }
            SchedulingSubpart next = (SchedulingSubpart)new SchedulingSubpartDAO().get(nextId);
            if (next == null) {
                return null;
            }
            if (right != null && !context.hasPermission(Department.class.equals(right.type()) ? next.getControllingDept() : next, right)) {
                return next.getNextSchedulingSubpart(context, cmp, right);
            }
            return next;
        }
        SchedulingSubpart next = null;
        for (InstructionalOffering offering = this.getInstrOfferingConfig().getInstructionalOffering(); next == null && offering != null; offering = offering.getNextInstructionalOffering(context, cmp)) {
            for (InstrOfferingConfig c : offering.getInstrOfferingConfigs()) {
                for (SchedulingSubpart s : c.getSchedulingSubparts()) {
                    if (right != null && !context.hasPermission(Department.class.equals(right.type()) ? s.getControllingDept() : s, right) || offering.equals(this.getInstrOfferingConfig().getInstructionalOffering()) && cmp.compare(this, s) >= 0 || next != null && cmp.compare(next, s) <= 0) continue;
                    next = s;
                }
            }
        }
        return next;
    }

    public SchedulingSubpart getPreviousSchedulingSubpart(SessionContext context, Comparator cmp, Right right) {
        Long previousId = Navigation.getPrevious(context, Navigation.sSchedulingSubpartLevel, this.getUniqueId());
        if (previousId != null) {
            if (previousId < 0L) {
                return null;
            }
            SchedulingSubpart previous = (SchedulingSubpart)new SchedulingSubpartDAO().get(previousId);
            if (previous == null) {
                return null;
            }
            if (right != null && !context.hasPermission(Department.class.equals(right.type()) ? previous.getControllingDept() : previous, right)) {
                return previous.getPreviousSchedulingSubpart(context, cmp, right);
            }
            return previous;
        }
        SchedulingSubpart previous = null;
        for (InstructionalOffering offering = this.getInstrOfferingConfig().getInstructionalOffering(); previous == null && offering != null; offering = offering.getPreviousInstructionalOffering(context, cmp)) {
            for (InstrOfferingConfig c : offering.getInstrOfferingConfigs()) {
                for (SchedulingSubpart s : c.getSchedulingSubparts()) {
                    if (right != null && !context.hasPermission(Department.class.equals(right.type()) ? s.getControllingDept() : s, right) || offering.equals(this.getInstrOfferingConfig().getInstructionalOffering()) && cmp.compare(this, s) <= 0 || previous != null && cmp.compare(previous, s) >= 0) continue;
                    previous = s;
                }
            }
        }
        return previous;
    }

    public String getSchedulingSubpartSuffix() {
        return this.getSchedulingSubpartSuffix(null, true);
    }

    public String getSchedulingSubpartSuffix(Session hibSession) {
        return this.getSchedulingSubpartSuffix(hibSession, true);
    }

    public String getSchedulingSubpartSuffix(boolean save) {
        return this.getSchedulingSubpartSuffix(null, save);
    }

    public String getSchedulingSubpartSuffix(Session hibSession, boolean save) {
        String suffix = this.getSchedulingSubpartSuffixCache();
        if (suffix != null) {
            return "-".equals(suffix) ? "" : suffix;
        }
        int nrItypes = 0;
        int nrItypesBefore = 0;
        SchedulingSubpartComparator cmp = new SchedulingSubpartComparator();
        for (SchedulingSubpart ss : this.getInstrOfferingConfig().getSchedulingSubparts()) {
            if (!ss.getItype().equals(this.getItype())) continue;
            ++nrItypes;
            if (cmp.compare(ss, this) >= 0) continue;
            ++nrItypesBefore;
        }
        if (nrItypes <= 1 || nrItypesBefore < 1) {
            suffix = "";
        } else if (nrItypesBefore < 27) {
            suffix = String.valueOf((char)(97 + (nrItypesBefore - 1)));
        } else {
            int a = (nrItypesBefore - 1) / 26;
            int b = (nrItypesBefore - 1) % 26;
            suffix = String.valueOf((char)(97 + (a - 1))) + String.valueOf((char)(97 + b));
        }
        this.setSchedulingSubpartSuffixCache(suffix.length() == 0 ? "-" : suffix);
        if (save) {
            if (hibSession == null) {
                new SchedulingSubpartDAO().getSession().saveOrUpdate((Object)this);
                new SchedulingSubpartDAO().getSession().flush();
            } else {
                hibSession.saveOrUpdate((Object)this);
            }
        }
        return suffix;
    }

    public void deleteAllDistributionPreferences(Session hibSession) {
        for (Class_ c : this.getClasses()) {
            c.deleteAllDistributionPreferences(hibSession);
        }
        boolean deleted = false;
        Iterator<DistributionObject> i = this.getDistributionObjects().iterator();
        while (i.hasNext()) {
            DistributionObject relatedObject = i.next();
            DistributionPref distributionPref = relatedObject.getDistributionPref();
            distributionPref.getDistributionObjects().remove(relatedObject);
            Integer seqNo = relatedObject.getSequenceNumber();
            hibSession.delete((Object)relatedObject);
            deleted = true;
            if (distributionPref.getDistributionObjects().isEmpty()) {
                PreferenceGroup owner = distributionPref.getOwner();
                owner.getPreferences().remove(distributionPref);
                this.getPreferences().remove(distributionPref);
                hibSession.saveOrUpdate((Object)owner);
                hibSession.delete((Object)distributionPref);
            } else {
                if (seqNo != null) {
                    for (DistributionObject dObj : distributionPref.getDistributionObjects()) {
                        if (seqNo.compareTo(dObj.getSequenceNumber()) >= 0) continue;
                        dObj.setSequenceNumber(dObj.getSequenceNumber() - 1);
                        hibSession.saveOrUpdate((Object)dObj);
                    }
                }
                hibSession.saveOrUpdate((Object)distributionPref);
            }
            i.remove();
        }
        if (deleted) {
            hibSession.saveOrUpdate((Object)this);
        }
    }

    public int getMaxExpectedCapacity() {
        int ret = 0;
        for (Class_ c : this.getClasses()) {
            if (c.getMaxExpectedCapacity() != null) {
                ret += c.getMaxExpectedCapacity().intValue();
                continue;
            }
            if (c.getExpectedCapacity() == null) continue;
            ret += c.getExpectedCapacity().intValue();
        }
        return ret;
    }

    public static List findAll(Long sessionId) {
        return new SchedulingSubpartDAO().getSession().createQuery("select distinct s from SchedulingSubpart s where s.instrOfferingConfig.instructionalOffering.session.uniqueId=:sessionId").setLong("sessionId", sessionId.longValue()).list();
    }

    public boolean hasMixedManagedClasses() {
        Department d = null;
        for (Class_ c : this.getClasses()) {
            if (d == null) {
                d = c.getManagingDept();
                continue;
            }
            if (d.equals(c.getManagingDept())) continue;
            return true;
        }
        return false;
    }

    public CourseCreditUnitConfig getCredit() {
        if (this.getCreditConfigs() == null || this.getCreditConfigs().size() != 1) {
            return null;
        }
        return this.getCreditConfigs().iterator().next();
    }

    public void setCredit(CourseCreditUnitConfig courseCreditUnitConfig) {
        if (this.getCreditConfigs() == null || this.getCreditConfigs().size() == 0) {
            this.addTocreditConfigs(courseCreditUnitConfig);
        } else if (!this.getCreditConfigs().contains(courseCreditUnitConfig)) {
            this.getCreditConfigs().clear();
            this.getCreditConfigs().add(courseCreditUnitConfig);
        }
    }

    public Object clone() {
        SchedulingSubpart newSchedulingSubpart = new SchedulingSubpart();
        newSchedulingSubpart.setAutoSpreadInTime(this.isAutoSpreadInTime());
        if (this.getCreditConfigs() != null) {
            CourseCreditUnitConfig ccuc2 = null;
            CourseCreditUnitConfig newCcuc = null;
            for (CourseCreditUnitConfig ccuc2 : this.getCreditConfigs()) {
                newCcuc = (CourseCreditUnitConfig)ccuc2.clone();
                newCcuc.setOwner(newSchedulingSubpart);
                newSchedulingSubpart.addTocreditConfigs(newCcuc);
            }
        }
        newSchedulingSubpart.setDatePattern(this.getDatePattern());
        newSchedulingSubpart.setItype(this.getItype());
        newSchedulingSubpart.setMinutesPerWk(this.getMinutesPerWk());
        newSchedulingSubpart.setStudentAllowOverlap(this.isStudentAllowOverlap());
        return newSchedulingSubpart;
    }

    public Object cloneWithPreferences() {
        SchedulingSubpart newSchedulingSubpart = (SchedulingSubpart)this.clone();
        if (this.getPreferences() != null) {
            Preference p2 = null;
            Preference newPref = null;
            for (Preference p2 : this.getPreferences()) {
                if (p2 instanceof DistributionPref) continue;
                newPref = (Preference)p2.clone();
                newPref.setOwner(newSchedulingSubpart);
                newSchedulingSubpart.addTopreferences(newPref);
            }
        }
        return newSchedulingSubpart;
    }

    public Object cloneDeep() {
        SchedulingSubpart newSchedulingSubpart = (SchedulingSubpart)this.cloneWithPreferences();
        HashMap<Long, Class_> childClassToParentClass = new HashMap<Long, Class_>();
        if (this.getClasses() != null) {
            Class_ origClass2 = null;
            Class_ newClass = null;
            for (Class_ origClass2 : this.getClasses()) {
                newClass = (Class_)origClass2.cloneWithPreferences();
                newClass.setSchedulingSubpart(newSchedulingSubpart);
                newSchedulingSubpart.addToclasses(newClass);
                newClass.setSectionNumberCache(origClass2.getSectionNumberCache());
                newClass.setUniqueIdRolledForwardFrom(origClass2.getUniqueId());
                if (origClass2.getChildClasses() == null) continue;
                Class_ childClass2 = null;
                for (Class_ childClass2 : origClass2.getChildClasses()) {
                    childClassToParentClass.put(childClass2.getUniqueId(), newClass);
                }
            }
        }
        if (this.getChildSubparts() != null) {
            SchedulingSubpart origChildSubpart2 = null;
            SchedulingSubpart newChildSubpart = null;
            for (SchedulingSubpart origChildSubpart2 : this.getChildSubparts()) {
                newChildSubpart = (SchedulingSubpart)origChildSubpart2.cloneDeep();
                newChildSubpart.setParentSubpart(newSchedulingSubpart);
                newSchedulingSubpart.addTochildSubparts(newChildSubpart);
                if (newChildSubpart.getClasses() == null) continue;
                Class_ newChildClass2 = null;
                Class_ newParentClass = null;
                for (Class_ newChildClass2 : newChildSubpart.getClasses()) {
                    newParentClass = (Class_)childClassToParentClass.get(newChildClass2.getUniqueIdRolledForwardFrom());
                    newChildClass2.setParentClass(newParentClass);
                    newParentClass.addTochildClasses(newChildClass2);
                    newChildClass2.setUniqueIdRolledForwardFrom(null);
                }
            }
        }
        if (newSchedulingSubpart.getClasses() != null && this.getParentSubpart() == null) {
            Class_ newClass2 = null;
            for (Class_ newClass2 : this.getClasses()) {
                newClass2.setUniqueIdRolledForwardFrom(null);
            }
        }
        return newSchedulingSubpart;
    }

    public static SchedulingSubpart findByIdRolledForwardFrom(Long sessionId, Long uniqueIdRolledForwardFrom) {
        return (SchedulingSubpart)new SchedulingSubpartDAO().getSession().createQuery("select ss from SchedulingSubpart ss where ss.instrOfferingConfig.instructionalOffering.session.uniqueId=:sessionId and ss.uniqueIdRolledForwardFrom=:uniqueIdRolledForwardFrom").setLong("sessionId", sessionId.longValue()).setLong("uniqueIdRolledForwardFrom", uniqueIdRolledForwardFrom.longValue()).setCacheable(true).uniqueResult();
    }

    @Override
    public Department getDepartment() {
        return this.getManagingDept();
    }

    public boolean isValidCombination(DatePattern datePattern, TimePattern timePattern) {
        return this.getInstrOfferingConfig().getDurationModel().isValidCombination(this.getMinutesPerWk(), datePattern, timePattern);
    }

    public Set<Integer> getDayCodes(DatePattern datePattern, TimePattern timePattern) {
        return this.getInstrOfferingConfig().getDurationModel().getDayCodes(this.getMinutesPerWk(), datePattern, timePattern);
    }

    public List<Date> getDates(DatePattern datePattern, int dayCode, int minutesPerMeeting) {
        return this.getInstrOfferingConfig().getDurationModel().getDates(this.getMinutesPerWk(), datePattern, dayCode, minutesPerMeeting);
    }

    public boolean isParentOf(SchedulingSubpart subpart) {
        SchedulingSubpart parent = subpart.getParentSubpart();
        return parent != null && (this.equals(parent) || this.isParentOf(parent));
    }

    @Override
    public boolean isInstructorAssignmentNeeded() {
        for (Class_ c : this.getClasses()) {
            if (!c.isInstructorAssignmentNeeded()) continue;
            return true;
        }
        return false;
    }

    public int getNbrInstructors() {
        int instructors = 0;
        for (Class_ c : this.getClasses()) {
            for (TeachingClassRequest tcr : c.getTeachingRequests()) {
                if (!tcr.isAssignInstructor().booleanValue()) continue;
                instructors += tcr.getTeachingRequest().getNbrInstructors().intValue();
            }
        }
        return instructors;
    }

    public float getTeachingLoad() {
        int instructors = 0;
        float totalLoad = 0.0f;
        for (Class_ c : this.getClasses()) {
            for (TeachingClassRequest tcr : c.getTeachingRequests()) {
                if (!tcr.isAssignInstructor().booleanValue()) continue;
                instructors += tcr.getTeachingRequest().getNbrInstructors().intValue();
                totalLoad += (float)tcr.getTeachingRequest().getNbrInstructors().intValue() * tcr.getTeachingRequest().getTeachingLoad().floatValue();
            }
        }
        return totalLoad / (float)instructors;
    }
}

