/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import org.cpsolver.ifs.util.ToolBox;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseRoomPref;

public class RoomPref
extends BaseRoomPref {
    private static final long serialVersionUID = 1L;

    public RoomPref() {
    }

    public RoomPref(Long uniqueId) {
        super(uniqueId);
    }

    @Override
    public String preferenceText() {
        return this.getRoom().getLabel();
    }

    @Override
    public int compareTo(Object o) {
        try {
            RoomPref p = (RoomPref)o;
            int cmp = this.getRoom().getLabel().compareTo(p.getRoom().getLabel());
            if (cmp != 0) {
                return cmp;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.compareTo(o);
    }

    @Override
    public Object clone() {
        RoomPref pref = new RoomPref();
        pref.setPrefLevel(this.getPrefLevel());
        pref.setRoom(this.getRoom());
        return pref;
    }

    @Override
    public boolean isSame(Preference other) {
        if (other == null || !(other instanceof RoomPref)) {
            return false;
        }
        return ToolBox.equals((Object)this.getRoom(), (Object)((RoomPref)other).getRoom());
    }

    @Override
    public String preferenceHtml(String nameFormat, boolean highlightClassPrefs) {
        StringBuffer sb = new StringBuffer("<span ");
        String style = "font-weight:bold;";
        if (this.getPrefLevel().getPrefId() != 4) {
            style = style + "color:" + this.getPrefLevel().prefcolor() + ";";
        }
        if (this.getOwner() != null && this.getOwner() instanceof Class_ && highlightClassPrefs) {
            style = style + "background: #ffa;";
        }
        sb.append("style='" + style + "' ");
        String owner = "";
        if (this.getOwner() != null && this.getOwner() instanceof Class_) {
            owner = ", " + MSG.prefOwnerClass();
        } else if (this.getOwner() != null && this.getOwner() instanceof SchedulingSubpart) {
            owner = ", " + MSG.prefOwnerSchedulingSubpart();
        } else if (this.getOwner() != null && this.getOwner() instanceof DepartmentalInstructor) {
            owner = ", " + MSG.prefOwnerInstructor();
        } else if (this.getOwner() != null && this.getOwner() instanceof Exam) {
            owner = ", " + MSG.prefOwnerExamination();
        } else if (this.getOwner() != null && this.getOwner() instanceof Department) {
            owner = ", " + MSG.prefOwnerDepartment();
        } else if (this.getOwner() != null && this.getOwner() instanceof Session) {
            owner = ", " + MSG.prefOwnerSession();
        }
        sb.append("onmouseover=\"showGwtRoomHint(this, '" + this.getRoom().getUniqueId() + "', '" + this.getPrefLevel().getPrefName() + " " + MSG.prefRoom() + " {0} ({1}" + owner + ")');\" onmouseout=\"hideGwtRoomHint();\">");
        sb.append(this.preferenceAbbv());
        sb.append("</span>");
        return sb.toString();
    }

    @Override
    public String preferenceTitle() {
        return MSG.prefTitleRoom(this.getPrefLevel().getPrefName(), this.getRoom().getLabel());
    }

    @Override
    public Preference.Type getType() {
        return Preference.Type.ROOM;
    }
}

