/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import org.unitime.timetable.model.base.BasePitClassInstructor;

public class PitClassInstructor
extends BasePitClassInstructor {
    private static final long serialVersionUID = -3620357334196646777L;
    private float allWeeklyContactHours = -1.0f;
    private float allWeeklyStudentContactHours = -1.0f;
    private float organizedWeeklyContactHours = -1.0f;
    private float organizedWeeklyStudentContactHours = -1.0f;

    public float getAllWeeklyContactHours(Float standardMinutesInReportingHour, Float standardWeeksInReportingTerm) {
        if (this.allWeeklyContactHours < 0.0f) {
            this.allWeeklyContactHours = this.calculateAllWCH(standardMinutesInReportingHour, standardWeeksInReportingTerm);
        }
        return this.allWeeklyContactHours;
    }

    public float getOrganizedWeeklyContactHours(Float standardMinutesInReportingHour, Float standardWeeksInReportingTerm) {
        if (this.organizedWeeklyContactHours < 0.0f) {
            this.organizedWeeklyContactHours = this.calculateOrganizedWCH(standardMinutesInReportingHour, standardWeeksInReportingTerm);
        }
        return this.organizedWeeklyContactHours;
    }

    private float calculateAllWCH(Float standardMinutesInReportingHour, Float standardWeeksInReportingTerm) {
        if (this.getNormalizedPercentShare() > 0) {
            return this.getPitClassInstructing().getAllWeeklyClassHours(standardMinutesInReportingHour, standardWeeksInReportingTerm) * (float)this.getNormalizedPercentShare().intValue() / 100.0f;
        }
        return 0.0f;
    }

    private float calculateOrganizedWCH(Float standardMinutesInReportingHour, Float standardWeeksInReportingTerm) {
        if (this.getNormalizedPercentShare() > 0) {
            return this.getPitClassInstructing().getOrganizedWeeklyClassHours(standardMinutesInReportingHour, standardWeeksInReportingTerm) * (float)this.getNormalizedPercentShare().intValue() / 100.0f;
        }
        return 0.0f;
    }

    private float calculateAllWSCH(Float standardMinutesInReportingHour, Float standardWeeksInReportingTerm) {
        return this.getAllWeeklyContactHours(standardMinutesInReportingHour, standardWeeksInReportingTerm) * (float)this.getPitClassInstructing().getEnrollment().intValue();
    }

    private float calculateOrganizedWSCH(Float standardMinutesInReportingHour, Float standardWeeksInReportingTerm) {
        return this.getOrganizedWeeklyContactHours(standardMinutesInReportingHour, standardWeeksInReportingTerm) * (float)this.getPitClassInstructing().getEnrollment().intValue();
    }

    public float getAllWeeklyStudentContactHours(Float standardMinutesInReportingHour, Float standardWeeksInReportingTerm) {
        if (this.allWeeklyStudentContactHours < 0.0f) {
            this.allWeeklyStudentContactHours = this.calculateAllWSCH(standardMinutesInReportingHour, standardWeeksInReportingTerm);
        }
        return this.allWeeklyStudentContactHours;
    }

    public float getOrganizedWeeklyStudentContactHours(Float standardMinutesInReportingHour, Float standardWeeksInReportingTerm) {
        if (this.organizedWeeklyStudentContactHours < 0.0f) {
            this.organizedWeeklyStudentContactHours = this.calculateOrganizedWSCH(standardMinutesInReportingHour, standardWeeksInReportingTerm);
        }
        return this.organizedWeeklyStudentContactHours;
    }
}

