/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.unitime.timetable.model.base.BaseAcademicArea;
import org.unitime.timetable.model.dao.AcademicAreaDAO;

public class AcademicArea
extends BaseAcademicArea {
    private static final long serialVersionUID = 1L;
    public static final String ACAD_AREA_REQUEST_ATTR = "academicAreas";

    public AcademicArea() {
    }

    public AcademicArea(Long uniqueId) {
        super(uniqueId);
    }

    public static ArrayList getAll() throws HibernateException {
        return (ArrayList)new AcademicAreaDAO().findAll();
    }

    public static List getAcademicAreaList(Long sessionId) throws HibernateException {
        AcademicAreaDAO adao = new AcademicAreaDAO();
        Session hibSession = adao.getSession();
        List l = hibSession.createQuery("select a from AcademicArea as a where a.session.uniqueId=:sessionId order by a.academicAreaAbbreviation").setLong("sessionId", sessionId.longValue()).setCacheable(true).list();
        return l;
    }

    public String getLabelAbbrTitle() {
        return this.getAcademicAreaAbbreviation() + " : " + this.getTitle();
    }

    public String getLabelTitleAbbr() {
        return this.getTitle() + " : " + this.getAcademicAreaAbbreviation();
    }

    public Long getSessionId() {
        if (this.getSession() != null) {
            return this.getSession().getUniqueId();
        }
        return null;
    }

    public static AcademicArea findByAbbv(Long sessionId, String abbv) {
        return AcademicArea.findByAbbv(new AcademicAreaDAO().getSession(), sessionId, abbv);
    }

    public static AcademicArea findByAbbv(Session hibSession, Long sessionId, String abbv) {
        return (AcademicArea)hibSession.createQuery("select a from AcademicArea a where a.session.uniqueId=:sessionId and a.academicAreaAbbreviation=:abbv").setLong("sessionId", sessionId.longValue()).setString("abbv", abbv).setCacheable(true).uniqueResult();
    }

    public static AcademicArea findByExternalId(Long sessionId, String externalId) {
        return AcademicArea.findByExternalId(new AcademicAreaDAO().getSession(), sessionId, externalId);
    }

    public static AcademicArea findByExternalId(Session hibSession, Long sessionId, String externalId) {
        return (AcademicArea)hibSession.createQuery("select a from AcademicArea a where a.session.uniqueId=:sessionId and a.externalUniqueId=:externalId").setLong("sessionId", sessionId.longValue()).setString("externalId", externalId).setCacheable(true).uniqueResult();
    }

    public Object clone() {
        AcademicArea area = new AcademicArea();
        area.setExternalUniqueId(this.getExternalUniqueId());
        area.setAcademicAreaAbbreviation(this.getAcademicAreaAbbreviation());
        area.setTitle(this.getTitle());
        return area;
    }

    public boolean isUsed(Session hibSession) {
        return ((Number)(hibSession == null ? AcademicAreaDAO.getInstance().getSession() : hibSession).createQuery("select count(c) from Curriculum c inner join c.academicArea a where a.uniqueId = :areaId").setLong("areaId", this.getUniqueId().longValue()).setCacheable(true).uniqueResult()).intValue() > 0;
    }
}

