/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.user.client.Cookies;

public class SectioningCookie {
    private boolean iCourseDetails = false;
    private boolean iShowClassNumbers = false;
    private int iRelatedSortBy = 0;
    private EnrollmentFilter iEnrollmentFilter = EnrollmentFilter.ALL;
    private int iEnrollmentSortBy = 0;
    private String iEnrollmentSortBySubpart = "";
    private boolean iAllChoices = false;
    private boolean iShowAllChanges = false;
    private boolean iRequestOverridesOpened = true;
    private int iSolutionsSortBy = 0;
    private String iEnrollmentSortByGroup = "";
    private boolean iWaitListsOpened = true;
    private static SectioningCookie sInstance = null;

    private SectioningCookie() {
        try {
            String cookie = Cookies.getCookie((String)"UniTime:Sectioning");
            if (cookie != null && cookie.length() > 0) {
                String[] values = cookie.split(":");
                this.iCourseDetails = "T".equals(values[0]);
                this.iShowClassNumbers = "T".equals(values.length >= 2 ? values[1] : "F");
                this.iRelatedSortBy = Integer.parseInt(values[2]);
                this.iEnrollmentFilter = EnrollmentFilter.values()[Integer.parseInt(values[3])];
                this.iEnrollmentSortBy = Integer.parseInt(values[4]);
                this.iEnrollmentSortBySubpart = values[5];
                this.iAllChoices = "T".equals(values[6]);
                this.iShowAllChanges = "T".equals(values[7]);
                this.iRequestOverridesOpened = "T".equals(values[8]);
                this.iSolutionsSortBy = Integer.parseInt(values[9]);
                this.iEnrollmentSortByGroup = values[10];
                this.iWaitListsOpened = "T".equals(values[11]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void save() {
        String cookie = (this.iCourseDetails ? "T" : "F") + ":" + (this.iShowClassNumbers ? "T" : "F") + ":" + this.iRelatedSortBy + ":" + this.iEnrollmentFilter.ordinal() + ":" + this.iEnrollmentSortBy + ":" + this.iEnrollmentSortBySubpart + ":" + (this.iAllChoices ? "T" : "F") + ":" + (this.iShowAllChanges ? "T" : "F") + ":" + (this.iRequestOverridesOpened ? "T" : "F") + ":" + this.iSolutionsSortBy + ":" + this.iEnrollmentSortByGroup + ":" + (this.iWaitListsOpened ? "T" : "F");
        Cookies.setCookie((String)"UniTime:Sectioning", (String)cookie);
    }

    public static SectioningCookie getInstance() {
        if (sInstance == null) {
            sInstance = new SectioningCookie();
        }
        return sInstance;
    }

    public boolean getEnrollmentCoursesDetails() {
        return this.iCourseDetails;
    }

    public void setEnrollmentCoursesDetails(boolean details) {
        this.iCourseDetails = details;
        this.save();
    }

    public boolean getShowClassNumbers() {
        return this.iShowClassNumbers;
    }

    public void setShowClassNumbers(boolean showClassNumbers) {
        this.iShowClassNumbers = showClassNumbers;
        this.save();
    }

    public int getRelatedSortBy() {
        return this.iRelatedSortBy;
    }

    public void setRelatedSortBy(int sort) {
        this.iRelatedSortBy = sort;
        this.save();
    }

    public EnrollmentFilter getEnrollmentFilter() {
        return this.iEnrollmentFilter;
    }

    public void setEnrollmentFilter(EnrollmentFilter enrollmentFilter) {
        this.iEnrollmentFilter = enrollmentFilter;
        this.save();
    }

    public int getEnrollmentSortBy() {
        return this.iEnrollmentSortBy;
    }

    public void setEnrollmentSortBy(int sort, String group) {
        this.iEnrollmentSortBy = sort;
        this.iEnrollmentSortBySubpart = "";
        this.iEnrollmentSortByGroup = group;
        this.save();
    }

    public String getEnrollmentSortBySubpart() {
        return this.iEnrollmentSortBySubpart;
    }

    public String getEnrollmentSortByGroup() {
        return this.iEnrollmentSortByGroup;
    }

    public void setEnrollmentSortBySubpart(String subpart) {
        this.iEnrollmentSortBy = 0;
        this.iEnrollmentSortBySubpart = subpart;
        this.save();
    }

    public boolean isAllChoices() {
        return this.iAllChoices;
    }

    public void setAllChoices(boolean allChoices) {
        this.iAllChoices = allChoices;
        this.save();
    }

    public boolean isShowAllChanges() {
        return this.iShowAllChanges;
    }

    public void setShowAllChanges(boolean showAllChanges) {
        this.iShowAllChanges = showAllChanges;
        this.save();
    }

    public boolean isRequestOverridesOpened() {
        return this.iRequestOverridesOpened;
    }

    public void setRequestOverridesOpened(boolean requestOverridesOpened) {
        this.iRequestOverridesOpened = requestOverridesOpened;
        this.save();
    }

    public int getSolutionsSortBy() {
        return this.iSolutionsSortBy;
    }

    public void setSolutionsSortBy(int solutionsSortBy) {
        this.iSolutionsSortBy = solutionsSortBy;
        this.save();
    }

    public boolean isWaitListsOpened() {
        return this.iWaitListsOpened;
    }

    public void setWaitListsOpened(boolean waitListsOpened) {
        this.iWaitListsOpened = waitListsOpened;
        this.save();
    }

    public static enum EnrollmentFilter {
        ALL,
        ENROLLED,
        NOT_ENROLLED,
        WAIT_LISTED;

    }
}

