/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.rooms;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.unitime.timetable.gwt.client.GwtHint;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.RoomInterface;

public class RoomHint {
    private static long sLastLocationId = -1L;
    private static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    private static boolean sShowHint = false;
    private static Timer sLastSwapper = null;

    public static Widget content(RoomInterface.RoomHintResponse room, String prefix, String distance) {
        Iterator<RoomInterface.RoomPropertyInterface> i;
        if (sLastSwapper != null) {
            sLastSwapper.cancel();
            sLastSwapper = null;
        }
        SimpleForm form = new SimpleForm();
        form.removeStyleName("unitime-NotPrintableBottomLine");
        if (prefix != null && prefix.contains("{0}")) {
            String label = prefix.replace("{0}", room.getLabel());
            if (prefix.contains("{1}")) {
                label = label.replace("{1}", room.hasDisplayName() ? room.getDisplayName() : (room.hasRoomTypeLabel() ? room.getRoomTypeLabel() : ""));
            }
            form.addRow((Widget)new Label(label, false));
        } else {
            form.addRow((Widget)new Label((prefix == null || prefix.isEmpty() ? "" : prefix + " ") + (room.hasDisplayName() || room.hasRoomTypeLabel() ? MESSAGES.label(room.getLabel(), room.hasDisplayName() ? room.getDisplayName() : room.getRoomTypeLabel()) : room.getLabel()), false));
        }
        ArrayList<String> urls = new ArrayList<String>();
        if (room.hasMiniMapUrl()) {
            urls.add(room.getMiniMapUrl());
        }
        if (room.hasPictures()) {
            for (RoomInterface.RoomPictureInterface picture : room.getPictures()) {
                urls.add(GWT.getHostPageBaseURL() + "picture?id=" + picture.getUniqueId());
            }
        }
        if (!urls.isEmpty()) {
            Image image = new Image((String)urls.get(0));
            image.setStyleName("minimap");
            form.addRow((Widget)image);
            if (urls.size() > 1) {
                sLastSwapper = new ImageSwapper(image, urls);
                sLastSwapper.scheduleRepeating(3000);
            }
        }
        if (room.hasCapacity()) {
            if (room.hasExamCapacity()) {
                if (room.hasExamType()) {
                    form.addRow(MESSAGES.propRoomCapacity(), (Widget)new Label(MESSAGES.capacityWithExamType(room.getCapacity().toString(), room.getExamCapacity().toString(), room.getExamType()), false));
                } else {
                    form.addRow(MESSAGES.propRoomCapacity(), (Widget)new Label(MESSAGES.capacityWithExam(room.getCapacity().toString(), room.getExamCapacity().toString()), false));
                }
            } else {
                form.addRow(MESSAGES.propRoomCapacity(), (Widget)new Label(MESSAGES.capacity(room.getCapacity().toString()), false));
            }
        }
        if (room.hasArea()) {
            form.addRow(MESSAGES.propRoomArea(), (Widget)new HTML(room.getArea(), false));
        }
        if (room.hasRoomTypeLabel()) {
            form.addRow(MESSAGES.propRoomType(), (Widget)new HTML(room.getRoomTypeLabel(), false));
        }
        if (room.hasFeatures(null)) {
            Object features = new P("features");
            i = room.getFeatures(null).iterator();
            while (i.hasNext()) {
                RoomInterface.FeatureInterface feature = i.next();
                P f = new P(new String[0]);
                if (feature.hasDescription()) {
                    f.setText(MESSAGES.hintRoomFeatureWithDescription(feature.getLabel(), feature.getDescription()));
                    f.addStyleName("feature-des");
                } else {
                    f.setText(feature.getLabel() + (i.hasNext() ? CONSTANTS.itemSeparator() : ""));
                    f.addStyleName("feature");
                }
                features.add((Widget)f);
            }
            form.addRow(MESSAGES.propFeatures(), (Widget)features);
        }
        for (String type : room.getFeatureTypes()) {
            P features = new P("features");
            Iterator<RoomInterface.FeatureInterface> i2 = room.getFeatures(type).iterator();
            while (i2.hasNext()) {
                RoomInterface.FeatureInterface feature = i2.next();
                P f = new P(new String[0]);
                if (feature.hasDescription()) {
                    f.setText(MESSAGES.hintRoomFeatureWithDescription(feature.getLabel(), feature.getDescription()));
                    f.addStyleName("feature-des");
                } else {
                    f.setText(feature.getLabel() + (i2.hasNext() ? CONSTANTS.itemSeparator() : ""));
                    f.addStyleName("feature");
                }
                features.add((Widget)f);
            }
            form.addRow(type, (Widget)features);
        }
        if (room.hasGroups()) {
            P groups = new P("groups");
            i = room.getGroups().iterator();
            while (i.hasNext()) {
                RoomInterface.GroupInterface group = (RoomInterface.GroupInterface)i.next();
                P g = new P(new String[0]);
                if (group.hasDescription()) {
                    g.setText(MESSAGES.hintRoomFeatureWithDescription(group.getLabel(), group.getDescription()));
                    g.addStyleName("group-des");
                } else {
                    g.setText(group.getLabel() + (i.hasNext() ? CONSTANTS.itemSeparator() : ""));
                    g.addStyleName("group");
                }
                groups.add((Widget)g);
            }
            form.addRow(MESSAGES.propRoomGroups(), (Widget)groups);
        }
        if (room.hasEventStatus()) {
            form.addRow(MESSAGES.propRoomEventStatus(), (Widget)new Label(room.getEventStatus()));
        }
        if (room.hasEventDepartment()) {
            form.addRow(MESSAGES.propRoomEventDepartment(), (Widget)new Label(room.getEventDepartment()));
        }
        if (room.hasBreakTime()) {
            form.addRow(MESSAGES.propRoomBreakTime(), (Widget)new Label(MESSAGES.breakTime(room.getBreakTime().toString())));
        }
        if (room.hasNote()) {
            HTML note = new HTML(room.getNote());
            note.addStyleName("note");
            form.addRow((Widget)note);
        }
        if (room.hasServices()) {
            form.addRow(MESSAGES.propAvailableServices(), (Widget)new Label(room.getServices(CONSTANTS.itemSeparator())));
        }
        if (room.isIgnoreRoomCheck()) {
            form.addRow((Widget)new HTML(MESSAGES.ignoreRoomCheck()));
        }
        if (distance != null && !distance.isEmpty() && !"0".equals(distance)) {
            form.addRow(MESSAGES.propRoomDistance(), (Widget)new Label(MESSAGES.roomDistance(distance), false));
        }
        SimplePanel panel = new SimplePanel((Widget)form);
        panel.setStyleName("unitime-RoomHint");
        return panel;
    }

    public static void _showRoomHint(JavaScriptObject source, String locationId, String prefix, String distance, String note) {
        if (locationId == null || locationId.isEmpty() || "null".equals(locationId)) {
            return;
        }
        RoomHint.showHint((Element)source.cast(), Long.valueOf(locationId), prefix, distance, note, true);
    }

    public static void showHint(Element relativeObject, long locationId, String prefix, String distance, boolean showRelativeToTheObject) {
        RoomHint.showHint(relativeObject, locationId, prefix, distance, null, showRelativeToTheObject);
    }

    public static void showHint(final Element relativeObject, final long locationId, final String prefix, final String distance, final String note, final boolean showRelativeToTheObject) {
        sLastLocationId = locationId;
        sShowHint = true;
        RPC.execute(RoomInterface.RoomHintRequest.load(locationId), new AsyncCallback<RoomInterface.RoomHintResponse>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(RoomInterface.RoomHintResponse result) {
                if (result != null && locationId == sLastLocationId && sShowHint) {
                    if (note != null) {
                        result.setNote(note);
                    }
                    GwtHint.showHint(relativeObject, RoomHint.content(result, prefix, distance), showRelativeToTheObject);
                }
            }
        });
    }

    public static void hideHint() {
        sShowHint = false;
        if (sLastSwapper != null) {
            sLastSwapper.cancel();
            sLastSwapper = null;
        }
        GwtHint.hideHint();
    }

    public static native void createTriggers();

    private static class ImageSwapper
    extends Timer {
        Image iImage;
        List<String> iUrls;
        int iIndex;

        ImageSwapper(Image image, List<String> urls) {
            this.iImage = image;
            this.iUrls = urls;
            this.iIndex = 0;
        }

        public void run() {
            ++this.iIndex;
            this.iImage.setUrl(this.iUrls.get(this.iIndex % this.iUrls.size()));
            if (!this.iImage.isAttached()) {
                this.cancel();
            }
        }
    }
}

