/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.reservations;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.ValueBoxBase;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.unitime.timetable.gwt.client.Lookup;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.events.SingleDateSelector;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.page.UniTimePageLabel;
import org.unitime.timetable.gwt.client.reservations.ReservationCourseSelectionBox;
import org.unitime.timetable.gwt.client.reservations.RestrictionsTable;
import org.unitime.timetable.gwt.client.widgets.CourseSelectionEvent;
import org.unitime.timetable.gwt.client.widgets.CourseSelectionHandler;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTextBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeWidget;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.services.ReservationService;
import org.unitime.timetable.gwt.services.ReservationServiceAsync;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.PersonInterface;
import org.unitime.timetable.gwt.shared.ReservationException;
import org.unitime.timetable.gwt.shared.ReservationInterface;

public class ReservationEdit
extends Composite {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    public static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    private static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private List<EditFinishedHandler> iEditFinishedHandlers = new ArrayList<EditFinishedHandler>();
    private SimpleForm iPanel;
    private UniTimeHeaderPanel iTitleAndButtons;
    private UniTimeWidget<UniTimeTextBox> iLimit;
    private UniTimeWidget<SingleDateSelector> iStartDate;
    private UniTimeWidget<SingleDateSelector> iExpirationDate;
    private RestrictionsTable iRestrictions;
    private HashMap<Long, ReservationInterface.Area> iAreas = new HashMap();
    private HashMap<Long, ReservationInterface.Curriculum> iCurricula = new HashMap();
    private ListBox iClassifications;
    private ListBox iMajors;
    private ListBox iMinors;
    private ListBox iConcentrations;
    private int iMinorRow = 0;
    private int iConcentrationRow = 0;
    private UniTimeWidget<ListBox> iType;
    private UniTimeWidget<ListBox> iArea;
    private UniTimeWidget<ListBox> iCourse;
    private UniTimeWidget<ListBox> iGroup;
    private UniTimeWidget<ListBox> iCurriculum;
    private UniTimeWidget<TextArea> iStudents;
    private ReservationInterface iReservation;
    private ReservationCourseSelectionBox iCourseBox;
    private Lookup iLookup;
    private ReservationInterface.DefaultExpirationDates iExpirations = null;
    private final ReservationServiceAsync iReservationService = (ReservationServiceAsync)GWT.create(ReservationService.class);
    private int iStartDateLine;
    private int iExpirationLine;
    private int iReservedSpaceLine;
    private int iGroupLine;
    private int iCourseLine;
    private int iAreaLine;
    private int iStudentsLine;
    private int iCurriculumLine;
    private int iInclusionLine;
    private CheckBox iCanOverlap;
    private CheckBox iMustBeUsed;
    private CheckBox iOverLimit;
    private CheckBox iAlwaysExpired;
    private ListBox iInclusive;
    private int iOverrideLine;
    private ReservationInterface.Offering iOffering = null;

    public ReservationEdit(boolean standAlone) {
        if (standAlone) {
            this.addEditFinishedHandler(new EditFinishedHandler(){

                @Override
                public void onSave(EditFinishedEvent evt) {
                    ToolBox.open(GWT.getHostPageBaseURL() + "instructionalOfferingDetail.action?io=" + ReservationEdit.this.iOffering.getId() + "#reservations");
                }

                @Override
                public void onDelete(EditFinishedEvent evt) {
                    ToolBox.open(GWT.getHostPageBaseURL() + "instructionalOfferingDetail.action?io=" + ReservationEdit.this.iOffering.getId() + "#reservations");
                }

                @Override
                public void onBack(EditFinishedEvent evt) {
                    ToolBox.open(GWT.getHostPageBaseURL() + "instructionalOfferingDetail.action?io=" + ReservationEdit.this.iOffering.getId() + "#reservations");
                }

                @Override
                public void onFailure(Throwable caught) {
                    new Timer(){

                        public void run() {
                            ToolBox.open(GWT.getHostPageBaseURL() + "instructionalOfferingDetail.action?io=" + ReservationEdit.this.iOffering.getId() + "#reservations");
                        }
                    }.schedule(5000);
                }

                @Override
                public boolean hasNext(EditFinishedEvent evt) {
                    String ids = Window.Location.getParameter((String)"reservations");
                    if (ids != null) {
                        String[] arr = ids.split(",");
                        for (int i = 0; i < arr.length - 1; ++i) {
                            if (!evt.getReservationId().toString().equals(arr[i])) continue;
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public boolean hasPrevious(EditFinishedEvent evt) {
                    String ids = Window.Location.getParameter((String)"reservations");
                    if (ids != null) {
                        String[] arr = ids.split(",");
                        for (int i = 1; i < arr.length; ++i) {
                            if (!evt.getReservationId().toString().equals(arr[i])) continue;
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public void onNext(EditFinishedEvent evt) {
                    String ids = Window.Location.getParameter((String)"reservations");
                    if (ids != null) {
                        String[] arr = ids.split(",");
                        for (int i = 0; i < arr.length - 1; ++i) {
                            if (!evt.getReservationId().toString().equals(arr[i])) continue;
                            ReservationEdit.this.load(arr[i + 1]);
                            return;
                        }
                    }
                    this.onSave(evt);
                }

                @Override
                public void onPrevious(EditFinishedEvent evt) {
                    String ids = Window.Location.getParameter((String)"reservations");
                    if (ids != null) {
                        String[] arr = ids.split(",");
                        for (int i = 1; i < arr.length; ++i) {
                            if (!evt.getReservationId().toString().equals(arr[i])) continue;
                            ReservationEdit.this.load(arr[i - 1]);
                            return;
                        }
                    }
                    this.onSave(evt);
                }
            });
            if (Window.Location.getParameter((String)"id") == null && Window.Location.getParameter((String)"offering") == null) {
                throw new ReservationException(MESSAGES.errorReservationOrOfferingIdNotProvided());
            }
        }
        this.iPanel = new SimpleForm();
        this.initWidget((Widget)this.iPanel);
        this.iTitleAndButtons = new UniTimeHeaderPanel(MESSAGES.sectReservationDetails());
        this.iTitleAndButtons.addButton("save", MESSAGES.buttonSave(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                ReservationEdit.this.iTitleAndButtons.clearMessage();
                ReservationInterface r = ReservationEdit.this.validate();
                if (r == null) {
                    ReservationEdit.this.iTitleAndButtons.setErrorMessage(MESSAGES.failedValidationCheckForm());
                } else {
                    LoadingWidget.getInstance().show(MESSAGES.waitSavingReservation());
                    ReservationEdit.this.iReservationService.save(r, new AsyncCallback<Long>(){

                        public void onFailure(Throwable caught) {
                            LoadingWidget.getInstance().hide();
                            ReservationEdit.this.iTitleAndButtons.setErrorMessage(caught.getMessage());
                        }

                        public void onSuccess(Long result) {
                            LoadingWidget.getInstance().hide();
                            EditFinishedEvent e = new EditFinishedEvent(result);
                            for (EditFinishedHandler h : ReservationEdit.this.iEditFinishedHandlers) {
                                h.onSave(e);
                            }
                        }
                    });
                }
            }
        });
        this.iTitleAndButtons.addButton("previous", MESSAGES.buttonPrevious(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                ReservationEdit.this.iTitleAndButtons.clearMessage();
                ReservationInterface r = ReservationEdit.this.validate();
                if (r == null) {
                    ReservationEdit.this.iTitleAndButtons.setErrorMessage(MESSAGES.failedValidationCheckForm());
                } else {
                    LoadingWidget.getInstance().show(MESSAGES.waitSavingReservation());
                    ReservationEdit.this.iReservationService.save(r, new AsyncCallback<Long>(){

                        public void onFailure(Throwable caught) {
                            LoadingWidget.getInstance().hide();
                            ReservationEdit.this.iTitleAndButtons.setErrorMessage(caught.getMessage());
                        }

                        public void onSuccess(Long result) {
                            LoadingWidget.getInstance().hide();
                            EditFinishedEvent e = new EditFinishedEvent(result);
                            for (EditFinishedHandler h : ReservationEdit.this.iEditFinishedHandlers) {
                                h.onPrevious(e);
                            }
                        }
                    });
                }
            }
        });
        this.iTitleAndButtons.setEnabled("previous", false);
        this.iTitleAndButtons.addButton("next", MESSAGES.buttonNext(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                ReservationEdit.this.iTitleAndButtons.clearMessage();
                ReservationInterface r = ReservationEdit.this.validate();
                if (r == null) {
                    ReservationEdit.this.iTitleAndButtons.setErrorMessage(MESSAGES.failedValidationCheckForm());
                } else {
                    LoadingWidget.getInstance().show(MESSAGES.waitSavingReservation());
                    ReservationEdit.this.iReservationService.save(r, new AsyncCallback<Long>(){

                        public void onFailure(Throwable caught) {
                            LoadingWidget.getInstance().hide();
                            ReservationEdit.this.iTitleAndButtons.setErrorMessage(caught.getMessage());
                        }

                        public void onSuccess(Long result) {
                            LoadingWidget.getInstance().hide();
                            EditFinishedEvent e = new EditFinishedEvent(result);
                            for (EditFinishedHandler h : ReservationEdit.this.iEditFinishedHandlers) {
                                h.onNext(e);
                            }
                        }
                    });
                }
            }
        });
        this.iTitleAndButtons.setEnabled("next", false);
        this.iTitleAndButtons.addButton("delete", MESSAGES.buttonDelete(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (ReservationEdit.this.iReservation == null) {
                    ReservationEdit.this.iTitleAndButtons.setErrorMessage(MESSAGES.errorCannotDeleteUnsavedReservation());
                } else {
                    if (!Window.confirm((String)MESSAGES.confirmDeleteReservation())) {
                        return;
                    }
                    LoadingWidget.getInstance().show(MESSAGES.waitDeletingReservation());
                    ReservationEdit.this.iReservationService.delete(ReservationEdit.this.iReservation.getId(), new AsyncCallback<Boolean>(){

                        public void onFailure(Throwable caught) {
                            LoadingWidget.getInstance().hide();
                            ReservationEdit.this.iTitleAndButtons.setErrorMessage(caught.getMessage());
                        }

                        public void onSuccess(Boolean result) {
                            LoadingWidget.getInstance().hide();
                            EditFinishedEvent e = new EditFinishedEvent(ReservationEdit.this.iReservation == null ? null : ReservationEdit.this.iReservation.getId());
                            for (EditFinishedHandler h : ReservationEdit.this.iEditFinishedHandlers) {
                                h.onDelete(e);
                            }
                        }
                    });
                }
            }
        });
        this.iTitleAndButtons.setEnabled("delete", false);
        this.iTitleAndButtons.addButton("back", MESSAGES.buttonBack(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                EditFinishedEvent e = new EditFinishedEvent(ReservationEdit.this.iReservation == null ? null : ReservationEdit.this.iReservation.getId());
                for (EditFinishedHandler h : ReservationEdit.this.iEditFinishedHandlers) {
                    h.onBack(e);
                }
            }
        });
        this.iPanel.addHeaderRow((Widget)this.iTitleAndButtons);
        this.iCourseBox = new ReservationCourseSelectionBox();
        this.iCourseBox.setWidth("130px");
        this.iPanel.addRow(MESSAGES.propInstructionalOffering(), (Widget)this.iCourseBox);
        this.iPanel.getCellFormatter().getElement(this.iPanel.getRowCount() - 1, 0).getStyle().setWidth(100.0, Style.Unit.PX);
        this.iType = new UniTimeWidget<ListBox>(new ListBox());
        this.iType.getWidget().setStyleName("unitime-TextBox");
        this.iType.getWidget().addItem(MESSAGES.itemSelect(), "");
        this.iType.getWidget().addItem(MESSAGES.reservationIndividual(), "individual");
        this.iType.getWidget().addItem(MESSAGES.reservationStudentGroup(), "group");
        this.iType.getWidget().addItem(MESSAGES.reservationCurriculum(), "curriculum");
        this.iType.getWidget().addItem(MESSAGES.reservationCourse(), "course");
        this.iType.getWidget().addItem(MESSAGES.reservationLearningCommunity(), "lc");
        for (ReservationInterface.OverrideType t : ReservationInterface.OverrideType.values()) {
            if (!t.isEditable()) continue;
            if (CONSTANTS.reservationOverrideTypeName()[t.ordinal()] != null) {
                this.iType.getWidget().addItem(CONSTANTS.reservationOverrideTypeName()[t.ordinal()], t.getReference());
                continue;
            }
            this.iType.getWidget().addItem("Override: " + t.name(), t.getReference());
        }
        this.iType.getWidget().addItem(MESSAGES.reservationIndividualOverride(), "individual-override");
        this.iType.getWidget().addItem(MESSAGES.reservationStudentGroupOverride(), "group-override");
        this.iType.getWidget().addItem(MESSAGES.reservationCurriculumOverride(), "curriculum-override");
        this.iType.getWidget().setSelectedIndex(0);
        this.iType.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ReservationEdit.this.iType.clearHint();
            }
        });
        this.iPanel.addRow(MESSAGES.propType(), (Widget)this.iType);
        this.iType.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ReservationEdit.this.typeChanged(true);
            }
        });
        this.iLimit = new UniTimeWidget<UniTimeTextBox>(new UniTimeTextBox(4, ValueBoxBase.TextAlignment.RIGHT));
        this.iReservedSpaceLine = this.iPanel.addRow(MESSAGES.propReservedSpace(), (Widget)this.iLimit);
        P properties = new P("unitime-OverrideProperties");
        this.iCanOverlap = new CheckBox(MESSAGES.checkCanOverlap());
        this.iOverLimit = new CheckBox(MESSAGES.checkCanOverLimit());
        this.iMustBeUsed = new CheckBox(MESSAGES.checkMustBeUsed());
        this.iAlwaysExpired = new CheckBox(MESSAGES.checkAllwaysExpired());
        this.iAlwaysExpired.setValue(Boolean.valueOf(true));
        properties.add((Widget)this.iCanOverlap);
        properties.add((Widget)this.iOverLimit);
        properties.add((Widget)this.iMustBeUsed);
        properties.add((Widget)this.iAlwaysExpired);
        this.iAlwaysExpired.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                ReservationEdit.this.iPanel.getRowFormatter().setVisible(ReservationEdit.this.iExpirationLine, (Boolean)event.getValue() == false);
                ReservationEdit.this.iPanel.getRowFormatter().setVisible(ReservationEdit.this.iStartDateLine, (Boolean)event.getValue() == false);
                ReservationEdit.this.iPanel.getRowFormatter().setVisible(ReservationEdit.this.iInclusionLine, (Boolean)event.getValue() == false);
            }
        });
        this.iOverrideLine = this.iPanel.addRow(MESSAGES.propOverrideProperties(), (Widget)properties);
        this.iStartDate = new UniTimeWidget<SingleDateSelector>(new SingleDateSelector());
        this.iStartDate.getWidget().addValueChangeHandler(new ValueChangeHandler<Date>(){

            public void onValueChange(ValueChangeEvent<Date> event) {
                ReservationEdit.this.iStartDate.clearHint();
            }
        });
        this.iStartDateLine = this.iPanel.addRow(MESSAGES.propStartDate(), (Widget)this.iStartDate);
        this.iExpirationDate = new UniTimeWidget<SingleDateSelector>(new SingleDateSelector());
        this.iExpirationDate.getWidget().addValueChangeHandler(new ValueChangeHandler<Date>(){

            public void onValueChange(ValueChangeEvent<Date> event) {
                ReservationEdit.this.iExpirationDate.clearHint();
            }
        });
        this.iExpirationLine = this.iPanel.addRow(MESSAGES.propExpirationDate(), (Widget)this.iExpirationDate);
        this.iRestrictions = new RestrictionsTable(this.iLimit);
        this.iPanel.addRow(MESSAGES.propRestrictions(), (Widget)this.iRestrictions);
        this.iPanel.getCellFormatter().setVerticalAlignment(this.iPanel.getRowCount() - 1, 0, HasVerticalAlignment.ALIGN_TOP);
        this.iInclusive = new ListBox();
        this.iInclusive.addItem(MESSAGES.reservationInclusiveNotSet(), "");
        this.iInclusive.addItem(MESSAGES.reservationInclusiveTrue(), "true");
        this.iInclusive.addItem(MESSAGES.reservationInclusiveFalse(), "false");
        this.iInclusionLine = this.iPanel.addRow(MESSAGES.propInclusive(), (Widget)this.iInclusive);
        this.iStudents = new UniTimeWidget<TextArea>(new TextArea());
        this.iStudents.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ReservationEdit.this.iStudents.clearHint();
                ((UniTimeTextBox)ReservationEdit.this.iLimit.getWidget()).setValue(String.valueOf(((TextArea)ReservationEdit.this.iStudents.getWidget()).getText().split("\n").length), true);
            }
        });
        this.iStudents.getWidget().setStyleName("unitime-TextArea");
        this.iStudents.getWidget().setVisibleLines(10);
        this.iStudents.getWidget().setCharacterWidth(80);
        VerticalPanel students = new VerticalPanel();
        students.add(this.iStudents);
        Button lookup = new Button(MESSAGES.buttonLookup());
        lookup.setAccessKey('l');
        this.iLookup = new Lookup();
        lookup.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ReservationEdit.this.iLookup.center();
            }
        });
        this.iLookup.setOptions("mustHaveExternalId,source=students");
        this.iLookup.addValueChangeHandler(new ValueChangeHandler<PersonInterface>(){

            public void onValueChange(ValueChangeEvent<PersonInterface> event) {
                PersonInterface student = (PersonInterface)event.getValue();
                if (student != null) {
                    ((TextArea)ReservationEdit.this.iStudents.getWidget()).setValue((Object)(((TextArea)ReservationEdit.this.iStudents.getWidget()).getValue() + (((TextArea)ReservationEdit.this.iStudents.getWidget()).getValue().isEmpty() ? "" : "\n") + student.getId() + " " + student.getLastName() + ", " + student.getFirstName() + (student.getMiddleName() == null ? "" : " " + student.getMiddleName())), true);
                    ((UniTimeTextBox)ReservationEdit.this.iLimit.getWidget()).setValue(String.valueOf(((TextArea)ReservationEdit.this.iStudents.getWidget()).getText().split("\n").length), true);
                }
            }
        });
        students.add((Widget)lookup);
        students.setCellHorizontalAlignment((Widget)lookup, HasHorizontalAlignment.ALIGN_RIGHT);
        this.iPanel.addRow(MESSAGES.propStudents(), (Widget)students);
        this.iPanel.getCellFormatter().setVerticalAlignment(this.iPanel.getRowCount() - 1, 0, HasVerticalAlignment.ALIGN_TOP);
        this.iStudentsLine = this.iPanel.getRowCount() - 1;
        this.iGroup = new UniTimeWidget<ListBox>(new ListBox());
        this.iGroup.getWidget().setStyleName("unitime-TextBox");
        this.iGroup.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ReservationEdit.this.iGroup.clearHint();
            }
        });
        this.iGroup.getWidget().addItem(MESSAGES.itemSelect(), "");
        this.iGroup.getWidget().setSelectedIndex(0);
        this.iPanel.addRow(MESSAGES.propStudentGroup(), (Widget)this.iGroup);
        this.iGroupLine = this.iPanel.getRowCount() - 1;
        this.iCourse = new UniTimeWidget<ListBox>(new ListBox());
        this.iCourse.getWidget().setStyleName("unitime-TextBox");
        this.iCourse.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ReservationEdit.this.iCourse.clearHint();
                String cid = ((ListBox)ReservationEdit.this.iCourse.getWidget()).getValue(((ListBox)ReservationEdit.this.iCourse.getWidget()).getSelectedIndex());
                String val = ((ListBox)ReservationEdit.this.iType.getWidget()).getValue(((ListBox)ReservationEdit.this.iType.getWidget()).getSelectedIndex());
                if ("course".equals(val)) {
                    for (ReservationInterface.Course course : ReservationEdit.this.iOffering.getCourses()) {
                        if (!course.getId().toString().equals(cid)) continue;
                        ((UniTimeTextBox)ReservationEdit.this.iLimit.getWidget()).setValue(course.getLimit() == null ? "" : course.getLimit().toString(), true);
                    }
                }
            }
        });
        this.iPanel.addRow(MESSAGES.propCourse(), (Widget)this.iCourse);
        this.iCourseLine = this.iPanel.getRowCount() - 1;
        this.iCurriculum = new UniTimeWidget<ListBox>(new ListBox());
        this.iCurriculum.getWidget().setStyleName("unitime-TextBox");
        this.iCurriculum.getWidget().addItem(MESSAGES.itemNone(), "");
        this.iCurriculum.getWidget().setSelectedIndex(0);
        this.iPanel.addRow("Curriculum:", (Widget)this.iCurriculum);
        this.iCurriculumLine = this.iPanel.getRowCount() - 1;
        this.iArea = new UniTimeWidget<ListBox>(new ListBox());
        this.iArea.getWidget().setStyleName("unitime-TextBox");
        this.iArea.getWidget().setWidth("300px");
        this.iArea.getWidget().setMultipleSelect(true);
        this.iArea.getWidget().setVisibleItemCount(3);
        this.iArea.getWidget().setHeight("100px");
        this.iPanel.addRow(MESSAGES.propAcademicArea(), (Widget)this.iArea);
        this.iAreaLine = this.iPanel.getRowCount() - 1;
        this.iClassifications = new ListBox();
        this.iClassifications.setMultipleSelect(true);
        this.iClassifications.setWidth("300px");
        this.iClassifications.setStyleName("unitime-TextBox");
        this.iClassifications.setVisibleItemCount(3);
        this.iClassifications.setHeight("100px");
        this.iPanel.addRow(MESSAGES.propClassifications(), (Widget)this.iClassifications);
        this.iMajors = new ListBox();
        this.iMajors.setMultipleSelect(true);
        this.iMajors.setWidth("300px");
        this.iMajors.setStyleName("unitime-TextBox");
        this.iMajors.setVisibleItemCount(3);
        this.iMajors.setHeight("100px");
        this.iPanel.addRow(MESSAGES.propMajors(), (Widget)this.iMajors);
        this.iConcentrations = new ListBox();
        this.iConcentrations.setMultipleSelect(true);
        this.iConcentrations.setWidth("300px");
        this.iConcentrations.setStyleName("unitime-TextBox");
        this.iConcentrations.setVisibleItemCount(3);
        this.iConcentrations.setHeight("100px");
        this.iConcentrationRow = this.iPanel.addRow(MESSAGES.propConcentrations(), (Widget)this.iConcentrations);
        this.iMinors = new ListBox();
        this.iMinors.setMultipleSelect(true);
        this.iMinors.setWidth("300px");
        this.iMinors.setStyleName("unitime-TextBox");
        this.iMinors.setVisibleItemCount(3);
        this.iMinors.setHeight("100px");
        this.iMinorRow = this.iPanel.addRow(MESSAGES.propMinors(), (Widget)this.iMinors);
        this.iCurriculum.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ReservationEdit.this.curriculumChanged();
                ReservationEdit.this.iCurriculum.clearHint();
            }
        });
        this.iArea.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ReservationEdit.this.areaChangedKeepSelection();
                ReservationEdit.this.iArea.clearHint();
            }
        });
        this.iClassifications.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                String curId;
                String string = curId = ((ListBox)ReservationEdit.this.iCurriculum.getWidget()).getSelectedIndex() < 0 ? "" : ((ListBox)ReservationEdit.this.iCurriculum.getWidget()).getValue(((ListBox)ReservationEdit.this.iCurriculum.getWidget()).getSelectedIndex());
                if (!curId.isEmpty()) {
                    ReservationInterface.Curriculum c = (ReservationInterface.Curriculum)ReservationEdit.this.iCurricula.get(Long.valueOf(curId));
                    int limit = 0;
                    boolean noneSelected = true;
                    block0: for (int i = 0; i < ReservationEdit.this.iClassifications.getItemCount(); ++i) {
                        if (!ReservationEdit.this.iClassifications.isItemSelected(i)) continue;
                        for (ReservationInterface.IdName f : c.getClassifications()) {
                            if (!f.getId().toString().equals(ReservationEdit.this.iClassifications.getValue(i))) continue;
                            limit += f.getLimit().intValue();
                            noneSelected = false;
                            continue block0;
                        }
                    }
                    if (noneSelected) {
                        limit = c.getLimit();
                    }
                    ((UniTimeTextBox)ReservationEdit.this.iLimit.getWidget()).setValue(limit == 0 ? "" : String.valueOf(limit), true);
                }
            }
        });
        this.iMajors.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ((ListBox)ReservationEdit.this.iCurriculum.getWidget()).setSelectedIndex(0);
                ReservationEdit.this.majorChangedKeepSelection();
            }
        });
        this.iConcentrations.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ((ListBox)ReservationEdit.this.iCurriculum.getWidget()).setSelectedIndex(0);
            }
        });
        this.iMinors.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ((ListBox)ReservationEdit.this.iCurriculum.getWidget()).setSelectedIndex(0);
            }
        });
        this.iPanel.addNotPrintableBottomRow((Widget)this.iTitleAndButtons.clonePanel(null));
        if (standAlone) {
            this.load(Window.Location.getParameter((String)"id"));
        } else {
            new InitializationChain(new InitStudentGroups(), new InitCurricula(), new InitExpirationDates()).execute(new AsyncCallback<Boolean>(){

                public void onFailure(Throwable caught) {
                    ReservationEdit.this.iTitleAndButtons.setErrorMessage(MESSAGES.failedLoadData(caught.getMessage()));
                }

                public void onSuccess(Boolean result) {
                }
            });
        }
        this.iCourseBox.addCourseSelectionHandler(new CourseSelectionHandler(){

            @Override
            public void onCourseSelection(CourseSelectionEvent event) {
                if (event.getValue() != null && event.getValue().isCourse()) {
                    ReservationEdit.this.iReservationService.getOfferingByCourseName(event.getValue().getCourseName(), new AsyncCallback<ReservationInterface.Offering>(){

                        public void onFailure(Throwable caught) {
                            ReservationEdit.this.iCourseBox.setError(caught.getMessage());
                        }

                        public void onSuccess(ReservationInterface.Offering result) {
                            ReservationEdit.this.setOffering(result);
                        }
                    });
                } else {
                    ReservationEdit.this.setOffering(null);
                }
            }
        });
    }

    protected void load(String id) {
        LoadingWidget.getInstance().show(MESSAGES.waitLoadingReservation());
        if (id == null) {
            new InitializationChain(new InitStudentGroups(), new InitCurricula(), new InitExpirationDates()).execute(new AsyncCallback<Boolean>(){

                public void onFailure(Throwable caught) {
                    ReservationEdit.this.loadingFailed(caught);
                }

                public void onSuccess(Boolean result) {
                    ReservationEdit.this.setReservation(null);
                    LoadingWidget.getInstance().hide();
                }
            });
        } else {
            this.iReservationService.getReservation(Long.valueOf(id), new AsyncCallback<ReservationInterface>(){

                public void onFailure(Throwable caught) {
                    ReservationEdit.this.loadingFailed(caught);
                }

                public void onSuccess(final ReservationInterface reservation) {
                    if (reservation instanceof ReservationInterface.CurriculumReservation) {
                        new InitializationChain(new InitCurricula(), new InitExpirationDates()).execute(new AsyncCallback<Boolean>(){

                            public void onFailure(Throwable caught) {
                                ReservationEdit.this.loadingFailed(caught);
                            }

                            public void onSuccess(Boolean result) {
                                ReservationEdit.this.setReservation(reservation);
                                LoadingWidget.getInstance().hide();
                            }
                        });
                    } else if (reservation instanceof ReservationInterface.GroupReservation) {
                        new InitializationChain(new InitStudentGroups(), new InitExpirationDates()).execute(new AsyncCallback<Boolean>(){

                            public void onFailure(Throwable caught) {
                                ReservationEdit.this.loadingFailed(caught);
                            }

                            public void onSuccess(Boolean result) {
                                ReservationEdit.this.setReservation(reservation);
                                LoadingWidget.getInstance().hide();
                            }
                        });
                    } else if (reservation instanceof ReservationInterface.LCReservation) {
                        new InitializationChain(new InitStudentGroups(), new InitExpirationDates()).execute(new AsyncCallback<Boolean>(){

                            public void onFailure(Throwable caught) {
                                ReservationEdit.this.loadingFailed(caught);
                            }

                            public void onSuccess(Boolean result) {
                                ReservationEdit.this.setReservation(reservation);
                                LoadingWidget.getInstance().hide();
                            }
                        });
                    } else {
                        ReservationEdit.this.setReservation(reservation);
                        LoadingWidget.getInstance().hide();
                    }
                }
            });
        }
    }

    private void loadingFailed(Throwable caught) {
        LoadingWidget.getInstance().hide();
        UniTimeNotifications.error(MESSAGES.failedLoadData(caught.getMessage()));
        this.iTitleAndButtons.setErrorMessage(MESSAGES.failedLoadData(caught.getMessage()));
        for (EditFinishedHandler h : this.iEditFinishedHandlers) {
            h.onFailure(caught);
        }
    }

    public void setReservation(ReservationInterface r) {
        this.iReservation = r;
        UniTimePageLabel.getInstance().setPageName(this.iReservation == null ? MESSAGES.pageAddReservation() : MESSAGES.pageEditReservation());
        this.iTitleAndButtons.setEnabled("delete", this.iReservation != null);
        this.iTitleAndButtons.clearMessage();
        this.iLimit.clearHint();
        this.iType.clearHint();
        this.iAlwaysExpired.setValue(Boolean.valueOf(true));
        Long offeringId = this.iReservation == null ? null : this.iReservation.getOffering().getId();
        Long courseId = null;
        if (this.iReservation != null && this.iReservation instanceof ReservationInterface.CourseReservation) {
            ReservationInterface.CourseReservation cr = (ReservationInterface.CourseReservation)this.iReservation;
            Long l = courseId = cr.getCourse() == null ? null : cr.getCourse().getId();
        }
        if (this.iReservation != null && this.iReservation instanceof ReservationInterface.LCReservation) {
            ReservationInterface.LCReservation lc = (ReservationInterface.LCReservation)this.iReservation;
            Long l = courseId = lc.getCourse() == null ? null : lc.getCourse().getId();
        }
        if (offeringId == null && Window.Location.getParameter((String)"offering") != null) {
            offeringId = Long.valueOf(Window.Location.getParameter((String)"offering"));
        }
        if (offeringId == null) {
            this.iOffering = null;
            this.iCourseBox.setEnabled(true);
            this.iCourseBox.setValue((CourseRequestInterface.RequestedCourse)null, false);
            this.iCourseBox.setError(null);
            this.iLimit.getWidget().setValue("", true);
            this.iExpirationDate.getWidget().setValue(null);
            this.iStartDate.getWidget().setValue(null);
            this.iRestrictions.clear();
            this.iType.getWidget().setSelectedIndex(0);
            this.iGroup.getWidget().setSelectedIndex(0);
            for (int i = 0; i < this.iArea.getWidget().getItemCount(); ++i) {
                this.iArea.getWidget().setItemSelected(i, false);
            }
            this.iClassifications.clear();
            this.iStudents.getWidget().setText("");
            this.iCourse.getWidget().clear();
            this.iMajors.clear();
            this.iConcentrations.clear();
            this.iMinors.clear();
            this.iType.setReadOnly(false);
            this.iCurricula.clear();
            this.iCurriculum.getWidget().clear();
            this.iCurriculum.getWidget().addItem(MESSAGES.itemNone(), "");
            this.iCurriculum.getWidget().setSelectedIndex(0);
            this.iInclusive.setSelectedIndex(0);
            this.areaChanged();
            this.typeChanged(true);
        } else {
            this.iCourseBox.setEnabled(false);
            LoadingWidget.getInstance().show(MESSAGES.waitLoadingReservation());
            this.iReservationService.getOffering(offeringId, courseId, new AsyncCallback<ReservationInterface.Offering>(){

                public void onFailure(Throwable caught) {
                    ReservationEdit.this.loadingFailed(caught);
                }

                public void onSuccess(ReservationInterface.Offering result) {
                    ReservationEdit.this.setOffering(result);
                    LoadingWidget.getInstance().hide();
                }
            });
        }
        if (this.iReservation == null) {
            this.iTitleAndButtons.setEnabled("previous", false);
            this.iTitleAndButtons.setEnabled("next", false);
        } else {
            EditFinishedEvent e = new EditFinishedEvent(this.iReservation.getId());
            for (EditFinishedHandler h : this.iEditFinishedHandlers) {
                this.iTitleAndButtons.setEnabled("previous", h.hasPrevious(e));
                this.iTitleAndButtons.setEnabled("next", h.hasNext(e));
            }
        }
    }

    public void setOffering(ReservationInterface.Offering offering) {
        this.iOffering = offering;
        this.iCourseBox.setError(null);
        if (this.iOffering == null) {
            return;
        }
        if (this.iOffering.isUnlockNeeded()) {
            this.iCourseBox.setError(MESSAGES.hintOfferingIsLocked(this.iOffering.getAbbv()));
        }
        if (!this.iCourseBox.isEnabled()) {
            ReservationInterface.LCReservation lc;
            ReservationInterface.CourseReservation cr;
            CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse();
            ReservationInterface.Course course = this.iOffering.getControllingCourse();
            if (this.iReservation != null && this.iReservation instanceof ReservationInterface.CourseReservation && (cr = (ReservationInterface.CourseReservation)this.iReservation).getCourse() != null) {
                course = cr.getCourse();
            }
            if (this.iReservation != null && this.iReservation instanceof ReservationInterface.LCReservation && (lc = (ReservationInterface.LCReservation)this.iReservation).getCourse() != null) {
                course = lc.getCourse();
            }
            if (course != null) {
                rc.setCourseId(course.getId());
                rc.setCourseName(course.getAbbv());
            } else {
                rc.setCourseName(this.iOffering.getAbbv());
            }
            this.iCourseBox.setValue(rc, false);
        }
        this.iRestrictions.setOffering(this.iOffering);
        this.iCourse.getWidget().clear();
        this.iCourse.getWidget().addItem(MESSAGES.itemSelect(), "");
        for (ReservationInterface.Course course : this.iOffering.getCourses()) {
            this.iCourse.getWidget().addItem(course.getAbbv() + (course.getName() == null || course.getName().isEmpty() ? "" : " - " + course.getName()), course.getId().toString());
        }
        this.typeChanged(true);
        this.populate();
        this.iCurricula.clear();
        this.iCurriculum.getWidget().clear();
        this.iCurriculum.getWidget().addItem(MESSAGES.itemNone(), "");
        this.iCurriculum.getWidget().setSelectedIndex(0);
        this.iReservationService.getCurricula(this.iOffering.getId(), new AsyncCallback<List<ReservationInterface.Curriculum>>(){

            public void onFailure(Throwable caught) {
                ReservationEdit.this.loadingFailed(caught);
            }

            public void onSuccess(List<ReservationInterface.Curriculum> result) {
                int nrAreasSelected = 0;
                String lastSelectedAreaId = null;
                for (int i = 0; i < ((ListBox)ReservationEdit.this.iArea.getWidget()).getItemCount(); ++i) {
                    if (!((ListBox)ReservationEdit.this.iArea.getWidget()).isItemSelected(i)) continue;
                    ++nrAreasSelected;
                    lastSelectedAreaId = ((ListBox)ReservationEdit.this.iArea.getWidget()).getValue(i);
                }
                block1: for (ReservationInterface.Curriculum curriculum : result) {
                    ReservationEdit.this.iCurricula.put(curriculum.getId(), curriculum);
                    ((ListBox)ReservationEdit.this.iCurriculum.getWidget()).addItem(curriculum.getAbbv() + " - " + curriculum.getName() + " (" + curriculum.getLimit() + ")", curriculum.getId().toString());
                    if (nrAreasSelected != 1 || !curriculum.getArea().getId().toString().equals(lastSelectedAreaId)) continue;
                    block2: for (int i = 0; i < ReservationEdit.this.iMajors.getItemCount(); ++i) {
                        if (ReservationEdit.this.iMajors.isItemSelected(i)) {
                            for (ReservationInterface.IdName m : curriculum.getMajors()) {
                                if (!m.getId().toString().equals(ReservationEdit.this.iMajors.getValue(i))) continue;
                                continue block2;
                            }
                            continue block1;
                        }
                        for (ReservationInterface.IdName m : curriculum.getMajors()) {
                            if (!m.getId().toString().equals(ReservationEdit.this.iMajors.getValue(i))) continue;
                            continue block1;
                        }
                    }
                    ((ListBox)ReservationEdit.this.iCurriculum.getWidget()).setSelectedIndex(((ListBox)ReservationEdit.this.iCurriculum.getWidget()).getItemCount() - 1);
                }
                String val = ((ListBox)ReservationEdit.this.iType.getWidget()).getValue(((ListBox)ReservationEdit.this.iType.getWidget()).getSelectedIndex());
                ReservationEdit.this.iPanel.getRowFormatter().setVisible(ReservationEdit.this.iCurriculumLine, "curriculum".equals(val) && ((ListBox)ReservationEdit.this.iCurriculum.getWidget()).getItemCount() > 1);
            }
        });
    }

    private ReservationInterface.OverrideType getOverrideType(String ref) {
        for (ReservationInterface.OverrideType t : ReservationInterface.OverrideType.values()) {
            if (!t.getReference().equals(ref)) continue;
            return t;
        }
        return null;
    }

    private void typeChanged(boolean setExpiration) {
        String val = this.iType.getWidget().getValue(this.iType.getWidget().getSelectedIndex());
        this.iPanel.getRowFormatter().setVisible(this.iStudentsLine, "individual".equals(val) || "individual-override".equals(val) || this.getOverrideType(val) != null);
        this.iPanel.getRowFormatter().setVisible(this.iCourseLine, "course".equals(val) || "lc".equals(val));
        this.iPanel.getRowFormatter().setVisible(this.iGroupLine, "group".equals(val) || "group-override".equals(val) || "lc".equals(val));
        this.iPanel.getRowFormatter().setVisible(this.iCurriculumLine, ("curriculum".equals(val) || "curriculum-override".equals(val)) && this.iCurriculum.getWidget().getItemCount() > 1);
        this.iPanel.getRowFormatter().setVisible(this.iAreaLine, "curriculum".equals(val) || "curriculum-override".equals(val));
        this.iPanel.getRowFormatter().setVisible(1 + this.iAreaLine, "curriculum".equals(val) || "curriculum-override".equals(val));
        this.iPanel.getRowFormatter().setVisible(2 + this.iAreaLine, "curriculum".equals(val) || "curriculum-override".equals(val));
        this.iPanel.getRowFormatter().setVisible(this.iConcentrationRow, ("curriculum".equals(val) || "curriculum-override".equals(val)) && this.iConcentrations.getItemCount() > 0);
        this.iPanel.getRowFormatter().setVisible(this.iMinorRow, ("curriculum".equals(val) || "curriculum-override".equals(val)) && this.iMinors.getItemCount() > 0);
        this.iPanel.getRowFormatter().setVisible(this.iExpirationLine, this.getOverrideType(val) == null || this.getOverrideType(val).isCanHaveExpirationDate());
        this.iPanel.getRowFormatter().setVisible(this.iStartDateLine, this.getOverrideType(val) == null || this.getOverrideType(val).isCanHaveExpirationDate());
        this.iPanel.getRowFormatter().setVisible(this.iInclusionLine, this.getOverrideType(val) == null || this.getOverrideType(val).isCanHaveExpirationDate());
        if (("individual-override".equals(val) || "group-override".equals(val) || "curriculum-override".equals(val)) && this.iAlwaysExpired.getValue().booleanValue()) {
            this.iPanel.getRowFormatter().setVisible(this.iExpirationLine, false);
            this.iPanel.getRowFormatter().setVisible(this.iStartDateLine, false);
            this.iPanel.getRowFormatter().setVisible(this.iInclusionLine, false);
        }
        this.iPanel.getRowFormatter().setVisible(this.iReservedSpaceLine, this.getOverrideType(val) == null || this.getOverrideType(val).isCanHaveExpirationDate() || this.getOverrideType(val).isExpired() == false);
        this.iPanel.getRowFormatter().setVisible(this.iOverrideLine, "individual-override".equals(val) || "group-override".equals(val) || "curriculum-override".equals(val));
        if ("course".equals(val)) {
            this.iLimit.getWidget().setReadOnly(true);
            this.iLimit.getWidget().setValue("", true);
            if (this.iOffering != null) {
                String cid = this.iCourse.getWidget().getValue(this.iCourse.getWidget().getSelectedIndex());
                for (ReservationInterface.Course course : this.iOffering.getCourses()) {
                    if (!course.getId().toString().equals(cid)) continue;
                    this.iLimit.getWidget().setValue(course.getLimit() == null ? "" : course.getLimit().toString(), true);
                }
            }
        } else if ("individual".equals(val) || this.getOverrideType(val) != null || "individual-override".equals(val)) {
            this.iLimit.getWidget().setReadOnly(true);
            this.iLimit.getWidget().setValue(String.valueOf(this.iStudents.getWidget().getText().split("\n").length), true);
        } else {
            this.iLimit.getWidget().setReadOnly(false);
        }
        if (setExpiration && this.iExpirations != null) {
            this.iExpirationDate.getWidget().setValueInServerTimeZone(this.iExpirations.getExpirationDate(val));
            this.iStartDate.getWidget().setValueInServerTimeZone(this.iExpirations.getStartDate(val));
        }
    }

    private void areaChanged() {
        String curId;
        int i;
        this.iMajors.clear();
        this.iMinors.clear();
        this.iClassifications.clear();
        int nrAreasSelected = 0;
        String lastSelectedArea = "";
        for (i = 0; i < this.iArea.getWidget().getItemCount(); ++i) {
            if (!this.iArea.getWidget().isItemSelected(i)) continue;
            ++nrAreasSelected;
        }
        for (i = 0; i < this.iArea.getWidget().getItemCount(); ++i) {
            if (!this.iArea.getWidget().isItemSelected(i)) continue;
            String id = this.iArea.getWidget().getValue(i);
            ReservationInterface.Area c = this.iAreas.get(Long.valueOf(id));
            for (ReservationInterface.IdName major : c.getMajors()) {
                this.iMajors.addItem((nrAreasSelected > 1 ? c.getAbbv() + "/" : "") + major.getAbbv() + " - " + major.getName(), major.getId().toString());
            }
            for (ReservationInterface.IdName minor : c.getMinors()) {
                this.iMinors.addItem((nrAreasSelected > 1 ? c.getAbbv() + "/" : "") + minor.getAbbv() + " - " + minor.getName(), minor.getId().toString());
            }
            if (this.iClassifications.getItemCount() == 0) {
                for (ReservationInterface.IdName clasf : c.getClassifications()) {
                    this.iClassifications.addItem(clasf.getAbbv() + " - " + clasf.getName(), clasf.getId().toString());
                }
            }
            lastSelectedArea = id;
        }
        this.iPanel.getRowFormatter().setVisible(this.iMinorRow, this.iMinors.getItemCount() > 0);
        String string = curId = this.iCurriculum.getWidget().getSelectedIndex() < 0 ? "" : this.iCurriculum.getWidget().getValue(this.iCurriculum.getWidget().getSelectedIndex());
        if (!curId.isEmpty()) {
            if (nrAreasSelected != 1) {
                this.iCurriculum.getWidget().setSelectedIndex(0);
            } else {
                ReservationInterface.Curriculum c = this.iCurricula.get(Long.valueOf(curId));
                if (!c.getArea().getId().toString().equals(lastSelectedArea)) {
                    this.iCurriculum.getWidget().setSelectedIndex(0);
                }
            }
        }
        this.majorChanged();
    }

    protected ReservationInterface.Area getSelectedArea(Long majorId) {
        for (int i = 0; i < this.iArea.getWidget().getItemCount(); ++i) {
            String id;
            ReservationInterface.Area c;
            if (!this.iArea.getWidget().isItemSelected(i) || (c = this.iAreas.get(Long.valueOf(id = this.iArea.getWidget().getValue(i)))).getMajor(majorId) == null) continue;
            return c;
        }
        return null;
    }

    private void majorChanged() {
        int i;
        this.iConcentrations.clear();
        int nrMajorsSelected = 0;
        for (i = 0; i < this.iMajors.getItemCount(); ++i) {
            if (!this.iMajors.isItemSelected(i)) continue;
            ++nrMajorsSelected;
        }
        for (i = 0; i < this.iMajors.getItemCount(); ++i) {
            if (!this.iMajors.isItemSelected(i)) continue;
            Long majorId = Long.valueOf(this.iMajors.getValue(i));
            ReservationInterface.Area c = this.getSelectedArea(majorId);
            ReservationInterface.IdName m = c.getMajor(majorId);
            for (ReservationInterface.IdName conc : c.getConcentrations()) {
                if (!conc.getParentId().equals(majorId)) continue;
                this.iConcentrations.addItem((nrMajorsSelected > 1 ? c.getAbbv() + "/" + m.getAbbv() + "-" : "") + conc.getAbbv() + " - " + conc.getName(), conc.getId().toString());
            }
        }
        this.iPanel.getRowFormatter().setVisible(this.iConcentrationRow, this.iConcentrations.getItemCount() > 0);
    }

    private void curriculumChanged() {
        String id = this.iCurriculum.getWidget().getValue(this.iCurriculum.getWidget().getSelectedIndex());
        if (!id.isEmpty()) {
            int i;
            this.iMajors.clear();
            this.iMinors.clear();
            this.iClassifications.clear();
            ReservationInterface.Curriculum c = this.iCurricula.get(Long.valueOf(id));
            for (i = 0; i < this.iArea.getWidget().getItemCount(); ++i) {
                this.iArea.getWidget().setItemSelected(i, c.getArea().getId().toString().equals(this.iArea.getWidget().getValue(i)));
            }
            this.areaChanged();
            for (i = 0; i < this.iMajors.getItemCount(); ++i) {
                String majorId = this.iMajors.getValue(i);
                boolean hasMajor = false;
                for (ReservationInterface.IdName m : c.getMajors()) {
                    if (!m.getId().toString().equals(majorId)) continue;
                    hasMajor = true;
                    break;
                }
                this.iMajors.setItemSelected(i, hasMajor);
            }
            for (i = 0; i < this.iMinors.getItemCount(); ++i) {
                this.iMinors.setItemSelected(i, false);
            }
            for (i = 0; i < this.iClassifications.getItemCount(); ++i) {
                String clasfId = this.iClassifications.getValue(i);
                boolean hasClasf = false;
                for (ReservationInterface.IdName m : c.getClassifications()) {
                    if (!m.getId().toString().equals(clasfId)) continue;
                    hasClasf = true;
                    break;
                }
                this.iClassifications.setItemSelected(i, hasClasf);
            }
            this.iLimit.getWidget().setValue(c.getLimit() == null ? "" : c.getLimit().toString(), true);
            this.majorChanged();
        }
    }

    private void areaChangedKeepSelection() {
        int i;
        ReservationInterface.Areas areas;
        int i2;
        HashSet<String> majors = new HashSet<String>();
        for (int i3 = 0; i3 < this.iMajors.getItemCount(); ++i3) {
            if (!this.iMajors.isItemSelected(i3)) continue;
            majors.add(this.iMajors.getValue(i3));
        }
        HashSet<String> minors = new HashSet<String>();
        for (int i4 = 0; i4 < this.iMinors.getItemCount(); ++i4) {
            if (!this.iMinors.isItemSelected(i4)) continue;
            minors.add(this.iMinors.getValue(i4));
        }
        HashSet<String> classifications = new HashSet<String>();
        for (i2 = 0; i2 < this.iClassifications.getItemCount(); ++i2) {
            if (!this.iClassifications.isItemSelected(i2)) continue;
            classifications.add(this.iClassifications.getValue(i2));
        }
        this.areaChanged();
        if (!majors.isEmpty()) {
            for (i2 = 0; i2 < this.iMajors.getItemCount(); ++i2) {
                if (!majors.contains(this.iMajors.getValue(i2))) continue;
                this.iMajors.setItemSelected(i2, true);
            }
        }
        if (this.iMajors.getSelectedIndex() < 0 && this.iReservation != null && this.iReservation instanceof ReservationInterface.CurriculumReservation && (areas = ((ReservationInterface.CurriculumReservation)this.iReservation).getCurriculum()) != null && areas.getMajors() != null) {
            block4: for (ReservationInterface.IdName id : areas.getMajors()) {
                for (i = 0; i < this.iMajors.getItemCount(); ++i) {
                    if (!id.getId().toString().equals(this.iMajors.getValue(i))) continue;
                    this.iMajors.setItemSelected(i, true);
                    continue block4;
                }
            }
        }
        if (!minors.isEmpty()) {
            for (int i5 = 0; i5 < this.iMinors.getItemCount(); ++i5) {
                if (!minors.contains(this.iMinors.getValue(i5))) continue;
                this.iMinors.setItemSelected(i5, true);
            }
        }
        if (this.iMinors.getSelectedIndex() < 0 && this.iReservation != null && this.iReservation instanceof ReservationInterface.CurriculumReservation && (areas = ((ReservationInterface.CurriculumReservation)this.iReservation).getCurriculum()) != null && areas.getMinors() != null) {
            block7: for (ReservationInterface.IdName id : areas.getMinors()) {
                for (i = 0; i < this.iMinors.getItemCount(); ++i) {
                    if (!id.getId().toString().equals(this.iMinors.getValue(i))) continue;
                    this.iMinors.setItemSelected(i, true);
                    continue block7;
                }
            }
        }
        if (!classifications.isEmpty()) {
            for (int i6 = 0; i6 < this.iClassifications.getItemCount(); ++i6) {
                if (!classifications.contains(this.iClassifications.getValue(i6))) continue;
                this.iClassifications.setItemSelected(i6, true);
            }
        }
        if (this.iClassifications.getSelectedIndex() < 0 && this.iReservation != null && this.iReservation instanceof ReservationInterface.CurriculumReservation && (areas = ((ReservationInterface.CurriculumReservation)this.iReservation).getCurriculum()) != null && areas.getClassifications() != null) {
            block10: for (ReservationInterface.IdName id : areas.getClassifications()) {
                for (i = 0; i < this.iClassifications.getItemCount(); ++i) {
                    if (!id.getId().toString().equals(this.iClassifications.getValue(i))) continue;
                    this.iClassifications.setItemSelected(i, true);
                    continue block10;
                }
            }
        }
        this.majorChangedKeepSelection();
    }

    protected void majorChangedKeepSelection() {
        ReservationInterface.Areas areas;
        int i;
        HashSet<String> concentrations = new HashSet<String>();
        for (i = 0; i < this.iConcentrations.getItemCount(); ++i) {
            if (!this.iConcentrations.isItemSelected(i)) continue;
            concentrations.add(this.iConcentrations.getValue(i));
        }
        this.majorChanged();
        if (!concentrations.isEmpty()) {
            for (i = 0; i < this.iConcentrations.getItemCount(); ++i) {
                if (!concentrations.contains(this.iConcentrations.getValue(i))) continue;
                this.iConcentrations.setItemSelected(i, true);
            }
        }
        if (this.iConcentrations.getSelectedIndex() < 0 && this.iReservation != null && this.iReservation instanceof ReservationInterface.CurriculumReservation && (areas = ((ReservationInterface.CurriculumReservation)this.iReservation).getCurriculum()) != null && areas.getConcentrations() != null) {
            block2: for (ReservationInterface.IdName id : areas.getConcentrations()) {
                for (int i2 = 0; i2 < this.iConcentrations.getItemCount(); ++i2) {
                    if (!id.getId().toString().equals(this.iConcentrations.getValue(i2))) continue;
                    this.iConcentrations.setItemSelected(i2, true);
                    continue block2;
                }
            }
        }
    }

    public void populate() {
        if (this.iReservation == null) {
            return;
        }
        this.iLimit.getWidget().setValue(this.iReservation.getLimit() == null ? "" : this.iReservation.getLimit().toString());
        this.iInclusive.setSelectedIndex(this.iReservation.hasInclusive() ? (this.iReservation.isInclusive().booleanValue() ? 1 : 2) : 0);
        this.iCanOverlap.setValue(Boolean.valueOf(this.iReservation.isAllowOverlaps()));
        this.iAlwaysExpired.setValue(Boolean.valueOf(this.iReservation.isAlwaysExpired()));
        this.iOverLimit.setValue(Boolean.valueOf(this.iReservation.isOverLimit()));
        this.iMustBeUsed.setValue(Boolean.valueOf(this.iReservation.isMustBeUsed()));
        this.iExpirationDate.getWidget().setValueInServerTimeZone(this.iReservation.getExpirationDate());
        this.iStartDate.getWidget().setValueInServerTimeZone(this.iReservation.getStartDate());
        this.iRestrictions.populate(this.iReservation);
        if (this.iReservation instanceof ReservationInterface.OverrideReservation) {
            this.select(this.iType.getWidget(), ((ReservationInterface.OverrideReservation)this.iReservation).getType().getReference());
            String students = "";
            for (ReservationInterface.IdName student : ((ReservationInterface.OverrideReservation)this.iReservation).getStudents()) {
                students = students + (students.isEmpty() ? "" : "\n") + student.getAbbv() + " " + student.getName();
            }
            this.iStudents.getWidget().setText(students);
        } else if (this.iReservation instanceof ReservationInterface.IndividualReservation) {
            this.select(this.iType.getWidget(), this.iReservation.isOverride() ? "individual-override" : "individual");
            String students = "";
            for (ReservationInterface.IdName student : ((ReservationInterface.IndividualReservation)this.iReservation).getStudents()) {
                students = students + (students.isEmpty() ? "" : "\n") + student.getAbbv() + " " + student.getName();
            }
            this.iStudents.getWidget().setText(students);
        } else if (this.iReservation instanceof ReservationInterface.GroupReservation) {
            this.select(this.iType.getWidget(), this.iReservation.isOverride() ? "group-override" : "group");
            this.select(this.iGroup.getWidget(), ((ReservationInterface.GroupReservation)this.iReservation).getGroup().getId().toString());
        } else if (this.iReservation instanceof ReservationInterface.CourseReservation) {
            this.select(this.iType.getWidget(), "course");
            this.select(this.iCourse.getWidget(), ((ReservationInterface.CourseReservation)this.iReservation).getCourse().getId().toString());
        } else if (this.iReservation instanceof ReservationInterface.LCReservation) {
            this.select(this.iType.getWidget(), "lc");
            this.select(this.iGroup.getWidget(), ((ReservationInterface.LCReservation)this.iReservation).getGroup().getId().toString());
            this.select(this.iCourse.getWidget(), ((ReservationInterface.LCReservation)this.iReservation).getCourse().getId().toString());
        } else if (this.iReservation instanceof ReservationInterface.CurriculumReservation) {
            boolean selected;
            Long id;
            int i;
            this.select(this.iType.getWidget(), this.iReservation.isOverride() ? "curriculum-override" : "curriculum");
            ReservationInterface.Areas curriculum = ((ReservationInterface.CurriculumReservation)this.iReservation).getCurriculum();
            for (i = 0; i < this.iArea.getWidget().getItemCount(); ++i) {
                id = Long.valueOf(this.iArea.getWidget().getValue(i));
                selected = false;
                for (ReservationInterface.IdName aa : curriculum.getAreas()) {
                    if (!aa.getId().equals(id)) continue;
                    selected = true;
                }
                this.iArea.getWidget().setItemSelected(i, selected);
            }
            this.areaChanged();
            for (i = 0; i < this.iMajors.getItemCount(); ++i) {
                id = Long.valueOf(this.iMajors.getValue(i));
                selected = false;
                for (ReservationInterface.IdName mj : curriculum.getMajors()) {
                    if (!mj.getId().equals(id)) continue;
                    selected = true;
                }
                this.iMajors.setItemSelected(i, selected);
            }
            for (i = 0; i < this.iMinors.getItemCount(); ++i) {
                id = Long.valueOf(this.iMinors.getValue(i));
                selected = false;
                for (ReservationInterface.IdName mj : curriculum.getMinors()) {
                    if (!mj.getId().equals(id)) continue;
                    selected = true;
                }
                this.iMinors.setItemSelected(i, selected);
            }
            for (i = 0; i < this.iClassifications.getItemCount(); ++i) {
                id = Long.valueOf(this.iClassifications.getValue(i));
                selected = false;
                for (ReservationInterface.IdName clasf : curriculum.getClassifications()) {
                    if (!clasf.getId().equals(id)) continue;
                    selected = true;
                }
                this.iClassifications.setItemSelected(i, selected);
            }
            this.majorChanged();
            for (i = 0; i < this.iConcentrations.getItemCount(); ++i) {
                id = Long.valueOf(this.iConcentrations.getValue(i));
                selected = false;
                for (ReservationInterface.IdName mj : curriculum.getConcentrations()) {
                    if (!mj.getId().equals(id)) continue;
                    selected = true;
                }
                this.iConcentrations.setItemSelected(i, selected);
            }
        }
        this.typeChanged(false);
        this.iType.setReadOnly(true);
        this.iType.setText(this.iType.getWidget().getItemText(this.iType.getWidget().getSelectedIndex()));
    }

    private void select(ListBox l, String value) {
        for (int i = 0; i < l.getItemCount(); ++i) {
            if (!l.getValue(i).equals(value)) continue;
            l.setSelectedIndex(i);
            return;
        }
    }

    public ReservationInterface validate() {
        String gid;
        ReservationInterface r;
        boolean ok = true;
        String type = this.iType.getWidget().getValue(this.iType.getWidget().getSelectedIndex());
        if (type.isEmpty()) {
            this.iType.setErrorHint(MESSAGES.hintReservationTypeNotSelected());
            ok = false;
        } else {
            this.iType.clearHint();
        }
        if ("individual".equals(type) || "individual-override".equals(type) || this.getOverrideType(type) != null) {
            if ("individual".equals(type) || "individual-override".equals(type)) {
                r = new ReservationInterface.IndividualReservation();
                r.setOverride("individual-override".equals(type));
            } else {
                r = new ReservationInterface.OverrideReservation(this.getOverrideType(type));
            }
            if (this.iStudents.getWidget().getText().isEmpty()) {
                this.iStudents.setErrorHint(MESSAGES.hintNoStudentsProvided());
                ok = false;
            } else {
                RegExp rx = RegExp.compile((String)"^([a-zA-Z0-9]+)[ ,;\\|]?(.*)$");
                for (String student : this.iStudents.getWidget().getText().split("\\n")) {
                    if (student.trim().isEmpty()) continue;
                    try {
                        MatchResult m = rx.exec(student.trim());
                        if (m == null) {
                            this.iStudents.setErrorHint(MESSAGES.hintLineXIsNotValidStudent(student));
                            ok = false;
                            break;
                        }
                        ReservationInterface.IdName s = new ReservationInterface.IdName();
                        s.setAbbv(m.getGroup(1));
                        s.setName(m.getGroupCount() <= 2 ? "" : m.getGroup(2).trim());
                        ((ReservationInterface.IndividualReservation)r).getStudents().add(s);
                        if (!((ReservationInterface.IndividualReservation)r).getStudents().isEmpty()) continue;
                        this.iStudents.setErrorHint(MESSAGES.hintNoStudentsProvided());
                        ok = false;
                    }
                    catch (Exception e) {
                        this.iStudents.setErrorHint(MESSAGES.hintLineXIsNotValidStudentException(student, e.getMessage()));
                        ok = false;
                    }
                }
            }
        } else if ("group".equals(type) || "group-override".equals(type)) {
            r = new ReservationInterface.GroupReservation();
            r.setOverride("group-override".equals(type));
            gid = this.iGroup.getWidget().getValue(this.iGroup.getWidget().getSelectedIndex());
            if (gid.isEmpty()) {
                this.iGroup.setErrorHint(MESSAGES.hintStudentGroupNotProvided());
                ok = false;
            } else {
                ReservationInterface.IdName group = new ReservationInterface.IdName();
                group.setId(Long.valueOf(gid));
                group.setName(this.iGroup.getWidget().getItemText(this.iGroup.getWidget().getSelectedIndex()));
                ((ReservationInterface.GroupReservation)r).setGroup(group);
            }
        } else if ("lc".equals(type)) {
            r = new ReservationInterface.LCReservation();
            gid = this.iGroup.getWidget().getValue(this.iGroup.getWidget().getSelectedIndex());
            if (gid.isEmpty()) {
                this.iGroup.setErrorHint(MESSAGES.hintStudentGroupNotProvided());
                ok = false;
            } else {
                ReservationInterface.IdName group = new ReservationInterface.IdName();
                group.setId(Long.valueOf(gid));
                group.setName(this.iGroup.getWidget().getItemText(this.iGroup.getWidget().getSelectedIndex()));
                ((ReservationInterface.LCReservation)r).setGroup(group);
            }
            String cid = this.iCourse.getWidget().getValue(this.iCourse.getWidget().getSelectedIndex());
            if (cid.isEmpty()) {
                this.iCourse.setErrorHint(MESSAGES.hintCourseNotProvided());
                ok = false;
            } else {
                ReservationInterface.Course course = new ReservationInterface.Course();
                course.setId(Long.valueOf(cid));
                course.setName(this.iCourse.getWidget().getItemText(this.iCourse.getWidget().getSelectedIndex()));
                ((ReservationInterface.LCReservation)r).setCourse(course);
            }
        } else if ("course".equals(type)) {
            r = new ReservationInterface.CourseReservation();
            String cid = this.iCourse.getWidget().getValue(this.iCourse.getWidget().getSelectedIndex());
            if (cid.isEmpty()) {
                this.iCourse.setErrorHint(MESSAGES.hintCourseNotProvided());
                ok = false;
            } else {
                ReservationInterface.Course course = new ReservationInterface.Course();
                course.setId(Long.valueOf(cid));
                course.setName(this.iCourse.getWidget().getItemText(this.iCourse.getWidget().getSelectedIndex()));
                ((ReservationInterface.CourseReservation)r).setCourse(course);
            }
        } else if ("curriculum".equals(type) || "curriculum-override".equals(type)) {
            int i;
            r = new ReservationInterface.CurriculumReservation();
            r.setOverride("curriculum-override".equals(type));
            ReservationInterface.Areas curriculum = new ReservationInterface.Areas();
            for (i = 0; i < this.iArea.getWidget().getItemCount(); ++i) {
                if (!this.iArea.getWidget().isItemSelected(i)) continue;
                ReservationInterface.Area area = new ReservationInterface.Area();
                area.setId(Long.valueOf(this.iArea.getWidget().getValue(i)));
                area.setName(this.iArea.getWidget().getItemText(i));
                curriculum.getAreas().add(area);
            }
            if (curriculum.getAreas().isEmpty()) {
                this.iArea.setErrorHint(MESSAGES.hintAcademicAreaNotProvided());
                ok = false;
            } else {
                ReservationInterface.IdName mj;
                for (i = 0; i < this.iMajors.getItemCount(); ++i) {
                    if (!this.iMajors.isItemSelected(i)) continue;
                    mj = new ReservationInterface.IdName();
                    mj.setId(Long.valueOf(this.iMajors.getValue(i)));
                    mj.setName(this.iMajors.getItemText(i));
                    curriculum.getMajors().add(mj);
                }
                for (i = 0; i < this.iMinors.getItemCount(); ++i) {
                    if (!this.iMinors.isItemSelected(i)) continue;
                    mj = new ReservationInterface.IdName();
                    mj.setId(Long.valueOf(this.iMinors.getValue(i)));
                    mj.setName(this.iMinors.getItemText(i));
                    curriculum.getMinors().add(mj);
                }
                for (i = 0; i < this.iClassifications.getItemCount(); ++i) {
                    if (!this.iClassifications.isItemSelected(i)) continue;
                    ReservationInterface.IdName clasf = new ReservationInterface.IdName();
                    clasf.setId(Long.valueOf(this.iClassifications.getValue(i)));
                    clasf.setName(this.iClassifications.getItemText(i));
                    curriculum.getClassifications().add(clasf);
                }
                for (i = 0; i < this.iConcentrations.getItemCount(); ++i) {
                    if (!this.iConcentrations.isItemSelected(i)) continue;
                    ReservationInterface.IdName cc = new ReservationInterface.IdName();
                    cc.setId(Long.valueOf(this.iConcentrations.getValue(i)));
                    cc.setName(this.iConcentrations.getItemText(i));
                    curriculum.getConcentrations().add(cc);
                }
                ((ReservationInterface.CurriculumReservation)r).setCurriculum(curriculum);
            }
        } else {
            if ("".equals(type)) {
                this.iType.setErrorHint(MESSAGES.hintReservationTypeNotSelected());
                return null;
            }
            this.iType.setErrorHint(MESSAGES.hintReservationTypeNotSupported(type));
            return null;
        }
        if (this.iExpirationDate.getWidget().getValue() == null && !this.iExpirationDate.getWidget().getText().isEmpty()) {
            this.iExpirationDate.setErrorHint(MESSAGES.hintExpirationDateNotValid());
            ok = false;
        } else {
            r.setExpirationDate(this.iExpirationDate.getWidget().getValueInServerTimeZone());
            this.iExpirationDate.clearHint();
        }
        if (this.iStartDate.getWidget().getValue() == null && !this.iStartDate.getWidget().getText().isEmpty()) {
            this.iStartDate.setErrorHint(MESSAGES.hintStartDateNotValid());
            ok = false;
        } else {
            r.setStartDate(this.iStartDate.getWidget().getValueInServerTimeZone());
            this.iStartDate.clearHint();
        }
        if (r.getStartDate() != null && r.getExpirationDate() != null && r.getExpirationDate().before(r.getStartDate())) {
            this.iExpirationDate.setErrorHint(MESSAGES.hintExpirationDateNotAfterStartDate());
            ok = false;
        }
        if (!"individual".equals(type) && !"individual-override".equals(type) && this.getOverrideType(type) == null) {
            if (this.iLimit.getWidget().getText().isEmpty()) {
                r.setLimit(null);
            } else {
                try {
                    r.setLimit(Integer.parseInt(this.iLimit.getWidget().getText()));
                }
                catch (Exception e) {
                    this.iLimit.setErrorHint(MESSAGES.hintReservationLimitNotValid());
                    ok = false;
                }
            }
        }
        if (r.isOverride()) {
            r.setMustBeUsed(this.iMustBeUsed.getValue());
            r.setAlwaysExpired(this.iAlwaysExpired.getValue());
            r.setOverLimit(this.iOverLimit.getValue());
            r.setAllowOverlaps(this.iCanOverlap.getValue());
        }
        if (this.iPanel.getRowFormatter().isVisible(this.iInclusionLine)) {
            r.setInclusive(this.iInclusive.getSelectedIndex() == 0 ? null : (this.iInclusive.getSelectedIndex() == 1 ? Boolean.TRUE : Boolean.FALSE));
        } else {
            r.setInclusive(null);
        }
        if (this.iReservation != null) {
            r.setId(this.iReservation.getId());
        }
        ReservationInterface.Offering o = new ReservationInterface.Offering();
        if (this.iOffering == null) {
            this.iCourseBox.setError(MESSAGES.hintOfferingNotProvided());
            ok = false;
        } else if (this.iOffering.isUnlockNeeded()) {
            this.iCourseBox.setError(MESSAGES.hintOfferingIsLocked(this.iOffering.getAbbv()));
            ok = false;
        } else {
            o.setId(this.iOffering.getId());
            o.setName(this.iOffering.getName());
        }
        r.setOffering(o);
        this.iRestrictions.validate(r);
        return ok ? r : null;
    }

    public void addEditFinishedHandler(EditFinishedHandler h) {
        this.iEditFinishedHandlers.add(h);
    }

    public static class InitializationChain
    implements Initialization {
        private Initialization[] iInitializations;

        public InitializationChain(Initialization ... initializations) {
            this.iInitializations = initializations;
        }

        @Override
        public void execute(AsyncCallback<Boolean> callback) {
            this.execute(0, callback);
        }

        private void execute(final int index, final AsyncCallback<Boolean> callback) {
            if (index >= this.iInitializations.length) {
                callback.onSuccess((Object)true);
            } else {
                this.iInitializations[index].execute(new AsyncCallback<Boolean>(){

                    public void onFailure(Throwable caught) {
                        callback.onFailure(caught);
                    }

                    public void onSuccess(Boolean result) {
                        if (result.booleanValue()) {
                            this.execute(1 + index, (AsyncCallback<Boolean>)callback);
                        } else {
                            callback.onSuccess((Object)false);
                        }
                    }
                });
            }
        }
    }

    public class InitCurricula
    implements Initialization {
        @Override
        public void execute(final AsyncCallback<Boolean> callback) {
            ReservationEdit.this.iReservationService.getAreas(new AsyncCallback<List<ReservationInterface.Area>>(){

                public void onFailure(Throwable caught) {
                    callback.onFailure(caught);
                }

                public void onSuccess(List<ReservationInterface.Area> result) {
                    for (ReservationInterface.Area c : result) {
                        ((ListBox)ReservationEdit.this.iArea.getWidget()).addItem(c.getAbbv() + " - " + c.getName(), c.getId().toString());
                        ReservationEdit.this.iAreas.put(c.getId(), c);
                    }
                    callback.onSuccess((Object)true);
                }
            });
        }
    }

    public class InitStudentGroups
    implements Initialization {
        @Override
        public void execute(final AsyncCallback<Boolean> callback) {
            ReservationEdit.this.iReservationService.getStudentGroups(new AsyncCallback<List<ReservationInterface.IdName>>(){

                public void onFailure(Throwable caught) {
                    ((ListBox)ReservationEdit.this.iType.getWidget()).removeItem(2);
                    callback.onFailure(caught);
                }

                public void onSuccess(List<ReservationInterface.IdName> result) {
                    if (result.isEmpty()) {
                        ((ListBox)ReservationEdit.this.iType.getWidget()).removeItem(2);
                    } else {
                        for (ReservationInterface.IdName group : result) {
                            ((ListBox)ReservationEdit.this.iGroup.getWidget()).addItem(group.getAbbv() + " - " + group.getName() + " (" + group.getLimit() + ")", group.getId().toString());
                        }
                    }
                    callback.onSuccess((Object)true);
                }
            });
        }
    }

    public class InitExpirationDates
    implements Initialization {
        @Override
        public void execute(final AsyncCallback<Boolean> callback) {
            RPC.execute(new ReservationInterface.ReservationDefaultExpirationDatesRpcRequest(), new AsyncCallback<ReservationInterface.DefaultExpirationDates>(){

                public void onFailure(Throwable caught) {
                    callback.onFailure(caught);
                }

                public void onSuccess(ReservationInterface.DefaultExpirationDates result) {
                    ReservationEdit.this.iExpirations = result;
                    if (ReservationEdit.this.iExpirations.hasInclusive()) {
                        ReservationEdit.this.iInclusive.setItemText(0, ReservationEdit.this.iExpirations.isInclusive() != false ? MESSAGES.reservationInclusiveDefaultTrue() : MESSAGES.reservationInclusiveDefaultFalse());
                    }
                    callback.onSuccess((Object)true);
                }
            });
        }
    }

    public static interface Initialization {
        public void execute(AsyncCallback<Boolean> var1);
    }

    public static interface EditFinishedHandler {
        public void onBack(EditFinishedEvent var1);

        public void onDelete(EditFinishedEvent var1);

        public void onSave(EditFinishedEvent var1);

        public void onFailure(Throwable var1);

        public boolean hasNext(EditFinishedEvent var1);

        public boolean hasPrevious(EditFinishedEvent var1);

        public void onNext(EditFinishedEvent var1);

        public void onPrevious(EditFinishedEvent var1);
    }

    public static class EditFinishedEvent {
        private Long iReservationId;

        public EditFinishedEvent(Long reservationId) {
            this.iReservationId = reservationId;
        }

        public Long getReservationId() {
            return this.iReservationId;
        }
    }
}

