/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.page;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.StackPanel;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.page.UniTimeMenu;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.page.UniTimePageLabel;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.UniTimeFrameDialog;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.MenuInterface;

public class UniTimeMobileMenu
extends UniTimeMenu {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    protected static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private Button iMenuButton = new Button(MESSAGES.mobileMenuSymbol());
    private MyStackPanel iStackPanel = null;
    private boolean iLoaded = false;
    private HandlerRegistration iPageLabelRegistration = null;

    public UniTimeMobileMenu() {
        this.iMenuButton.addStyleName("unitime-MobileMenuButton");
        this.iMenuButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (UniTimeMobileMenu.this.iStackPanel.isVisible()) {
                    UniTimeMobileMenu.this.hideMenu();
                } else {
                    UniTimeMobileMenu.this.showMenu();
                }
            }
        });
        this.iStackPanel = new MyStackPanel();
        this.iStackPanel.setVisible(false);
        this.initWidget((Widget)this.iMenuButton);
    }

    private void showMenuPopup() {
        this.iStackPanel.setVisible(true);
    }

    public void hideMenu() {
        this.iStackPanel.setVisible(false);
    }

    public void showMenu() {
        if (this.iLoaded) {
            this.showMenuPopup();
        } else {
            RPC.execute(new MenuInterface.MenuRpcRequest(), new AsyncCallback<GwtRpcResponseList<MenuInterface>>(){

                public void onSuccess(GwtRpcResponseList<MenuInterface> result) {
                    UniTimeMobileMenu.this.initMenu(result);
                    UniTimeMobileMenu.this.showMenuPopup();
                }

                public void onFailure(Throwable caught) {
                    UniTimeNotifications.error(caught.getMessage(), caught);
                }
            });
        }
    }

    @Override
    public void reload() {
        this.iLoaded = false;
    }

    private void attach(RootPanel rootPanel) {
        rootPanel.add((Widget)this);
    }

    public void insert(RootPanel panel) {
        if ("hide".equals(Window.Location.getParameter((String)"menu"))) {
            panel.setVisible(false);
        } else {
            this.attach(panel);
            RootPanel.get((String)"UniTimeGWT:MobileMenuPanel").add((Widget)this.iStackPanel);
        }
    }

    private void openedNodes(List<String> ret, TreeItem item, String prefix) {
        if (item.getState()) {
            ret.add((prefix == null ? "" : prefix + " ") + item.getText());
        }
        for (int i = 0; i < item.getChildCount(); ++i) {
            this.openedNodes(ret, item.getChild(i), (prefix == null ? "" : prefix + " ") + item.getText());
        }
    }

    public void saveState() {
        ArrayList<String> nodes = new ArrayList<String>();
        nodes.add(this.iStackPanel.getStackText(this.iStackPanel.getSelectedIndex()));
        for (int i = 0; i < this.iStackPanel.getWidgetCount(); ++i) {
            if (!(this.iStackPanel.getWidget(i) instanceof Tree)) continue;
            Tree t = (Tree)this.iStackPanel.getWidget(i);
            for (int j = 0; j < t.getItemCount(); ++j) {
                this.openedNodes(nodes, t.getItem(j), this.iStackPanel.getStackText(i));
            }
        }
        String sideBarCookie = "";
        for (String node : nodes) {
            if (!sideBarCookie.isEmpty()) {
                sideBarCookie = sideBarCookie + "|";
            }
            sideBarCookie = sideBarCookie + node;
        }
        Cookies.setCookie((String)"UniTime:MobileMenu", (String)sideBarCookie);
    }

    private void openNodes(Set<String> nodes, TreeItem item, String prefix) {
        if (nodes.contains((prefix == null ? "" : prefix + " ") + item.getText())) {
            item.setState(true);
        }
        for (int i = 0; i < item.getChildCount(); ++i) {
            this.openNodes(nodes, item.getChild(i), (prefix == null ? "" : prefix + " ") + item.getText());
        }
    }

    public void restoreState() {
        HashSet<String> nodes = new HashSet<String>();
        String sideBarCookie = Cookies.getCookie((String)"UniTime:MobileMenu");
        if (sideBarCookie != null) {
            for (String node : sideBarCookie.split("\\|")) {
                nodes.add(node);
            }
        }
        for (int i = 0; i < this.iStackPanel.getWidgetCount(); ++i) {
            if (nodes.contains(this.iStackPanel.getStackText(i))) {
                this.iStackPanel.showStack(i);
            }
            if (!(this.iStackPanel.getWidget(i) instanceof Tree)) continue;
            Tree t = (Tree)this.iStackPanel.getWidget(i);
            for (int j = 0; j < t.getItemCount(); ++j) {
                this.openNodes(nodes, t.getItem(j), this.iStackPanel.getStackText(i));
            }
        }
    }

    private TreeItem generateItem(final MenuInterface item) {
        final MenuInterface.ValueEncoder encoder = new MenuInterface.ValueEncoder(){

            @Override
            public String encode(String value) {
                return URL.encodeQueryString((String)value);
            }
        };
        Label label = new Label(item.getName(), false);
        final TreeItem treeItem = new TreeItem((Widget)label);
        if ("PAGE_HELP".equals(item.getPage())) {
            label.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    MenuInterface.PageNameInterface name = UniTimePageLabel.getInstance().getValue();
                    if (name.hasHelpUrl()) {
                        UniTimeMobileMenu.this.openUrl(MESSAGES.pageHelp(name.getName()), name.getHelpUrl(), item.getTarget());
                    }
                }
            });
            treeItem.setVisible(UniTimePageLabel.getInstance().getValue().hasHelpUrl());
            this.iPageLabelRegistration = UniTimePageLabel.getInstance().addValueChangeHandler(new ValueChangeHandler<MenuInterface.PageNameInterface>(){

                public void onValueChange(ValueChangeEvent<MenuInterface.PageNameInterface> event) {
                    treeItem.setVisible(((MenuInterface.PageNameInterface)event.getValue()).hasHelpUrl());
                }
            });
        } else if (item.hasPage()) {
            label.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    UniTimeMobileMenu.this.openUrl(item.getName(), item.getURL(encoder), item.getTarget());
                }
            });
        }
        if (item.hasSubMenus()) {
            for (final MenuInterface subItem : item.getSubMenus()) {
                if (subItem.isSeparator()) continue;
                if (subItem.getName().equals(item.getName()) && !item.hasPage() && subItem.hasPage() && !"PAGE_HELP".equals(subItem.getPage())) {
                    label.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            UniTimeMobileMenu.this.openUrl(subItem.getName(), subItem.getURL(encoder), subItem.getTarget());
                        }
                    });
                    continue;
                }
                treeItem.addItem(this.generateItem(subItem));
            }
        }
        return treeItem;
    }

    private void initMenu(List<MenuInterface> items) {
        this.iStackPanel.setActive(false);
        this.iStackPanel.clear();
        if (this.iPageLabelRegistration != null) {
            this.iPageLabelRegistration.removeHandler();
            this.iPageLabelRegistration = null;
        }
        final MenuInterface.ValueEncoder encoder = new MenuInterface.ValueEncoder(){

            @Override
            public String encode(String value) {
                return URL.encodeQueryString((String)value);
            }
        };
        for (final MenuInterface item : items) {
            if (item.isSeparator()) continue;
            if (item.hasSubMenus()) {
                Tree tree = new Tree((Tree.Resources)RESOURCES, true);
                for (MenuInterface subItem : item.getSubMenus()) {
                    if (subItem.isSeparator()) continue;
                    tree.addItem(this.generateItem(subItem));
                }
                this.iStackPanel.add((Widget)tree, item.getName());
                tree.addOpenHandler((OpenHandler)new OpenHandler<TreeItem>(){

                    public void onOpen(OpenEvent<TreeItem> event) {
                        UniTimeMobileMenu.this.saveState();
                    }
                });
                tree.addCloseHandler((CloseHandler)new CloseHandler<TreeItem>(){

                    public void onClose(CloseEvent<TreeItem> event) {
                        UniTimeMobileMenu.this.saveState();
                    }
                });
                continue;
            }
            if ("PAGE_HELP".equals(item.getPage())) {
                this.iStackPanel.add(new Command(){

                    public void execute() {
                        MenuInterface.PageNameInterface name = UniTimePageLabel.getInstance().getValue();
                        if (name.hasHelpUrl()) {
                            UniTimeMobileMenu.this.openUrl(MESSAGES.pageHelp(name.getName()), name.getHelpUrl(), item.getTarget());
                        }
                    }
                }, item.getName());
                continue;
            }
            this.iStackPanel.add(new Command(){

                public void execute() {
                    if (item.hasPage()) {
                        UniTimeMobileMenu.this.openUrl(item.getName(), item.getURL(encoder), item.getTarget());
                    }
                }
            }, item.getName());
        }
        this.restoreState();
        this.iStackPanel.setActive(true);
        this.iLoaded = true;
    }

    protected void openUrl(String name, String url, String target) {
        if (target == null) {
            LoadingWidget.getInstance().show();
        }
        if ("dialog".equals(target)) {
            UniTimeFrameDialog.openDialog(name, url);
        } else if ("download".equals(target)) {
            ToolBox.open(url);
        } else if ("eval".equals(target)) {
            ToolBox.eval(url);
        } else if ("tab".equals(target)) {
            Window.open((String)url, (String)"_blank", (String)"");
        } else {
            ToolBox.open(GWT.getHostPageBaseURL() + url);
        }
    }

    public class MyStackPanel
    extends StackPanel {
        private Element body = DOM.getFirstChild((Element)this.getElement());
        private boolean iActive = false;

        public String getStackText(int index) {
            if (index >= this.getWidgetCount()) {
                return null;
            }
            com.google.gwt.user.client.Element tdWrapper = DOM.getChild((Element)DOM.getChild((Element)this.body, (int)(index * 2)), (int)0);
            return DOM.getFirstChild((Element)tdWrapper).getInnerText();
        }

        public void add(Command cmd, String text) {
            this.add((Widget)new DummyWidget(cmd), text);
        }

        public void showStack(int index) {
            if (this.iActive) {
                if (this.getWidget(index) instanceof DummyWidget) {
                    ((DummyWidget)this.getWidget(index)).getClickCommand().execute();
                } else {
                    super.showStack(index);
                    UniTimeMobileMenu.this.saveState();
                }
            } else {
                super.showStack(index);
            }
        }

        public void setActive(boolean active) {
            this.iActive = active;
        }

        public class DummyWidget
        extends SimplePanel {
            private Command iClickCommand = null;

            public DummyWidget(Command cmd) {
                this.getElement().getStyle().setDisplay(Style.Display.NONE);
                this.iClickCommand = cmd;
            }

            public Command getClickCommand() {
                return this.iClickCommand;
            }
        }
    }
}

