/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.instructor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.unitime.timetable.gwt.client.instructor.AttributesCell;
import org.unitime.timetable.gwt.client.instructor.InstructorExternalIdCell;
import org.unitime.timetable.gwt.client.instructor.InstructorNameCell;
import org.unitime.timetable.gwt.client.instructor.ObjectivesCell;
import org.unitime.timetable.gwt.client.instructor.PreferenceCell;
import org.unitime.timetable.gwt.client.instructor.TimePreferenceCell;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.InstructorInterface;

public class TeachingRequestDetails
extends SimpleForm
implements HasValue<Integer> {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    protected static final StudentSectioningMessages SECTMSG = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    protected static NumberFormat sTeachingLoadFormat = NumberFormat.getFormat((String)CONSTANTS.teachingLoadFormat());
    protected InstructorInterface.TeachingRequestsPagePropertiesResponse iProperties;
    private Label iCourseLabel;
    private Label iRequestLoad;
    private PreferenceCell iAttributePrefs;
    private PreferenceCell iInstructorPrefs;
    private ObjectivesCell iObjectives;
    private UniTimeTable<InstructorInterface.SectionInfo> iSectionsTable;
    private UniTimeTable<InstructorInterface.InstructorInfo> iInstructorsTable;
    private int iAttributePrefsRow;
    private int iInstructorPrefsRow;
    private int iObjectivesRow;

    public TeachingRequestDetails(InstructorInterface.TeachingRequestsPagePropertiesResponse properties) {
        this.iProperties = properties;
        this.removeStyleName("unitime-NotPrintableBottomLine");
        this.addHeaderRow(MESSAGES.headerTeachingRequest());
        this.iCourseLabel = new Label();
        this.addRow(MESSAGES.propCourse(), (Widget)this.iCourseLabel);
        this.iSectionsTable = new UniTimeTable();
        this.iSectionsTable.addStyleName("sections");
        ArrayList<UniTimeTableHeader> sectionHeader = new ArrayList<UniTimeTableHeader>();
        sectionHeader.add(new UniTimeTableHeader(MESSAGES.colSection()));
        sectionHeader.add(new UniTimeTableHeader(MESSAGES.colTime()));
        sectionHeader.add(new UniTimeTableHeader(MESSAGES.colDate()));
        sectionHeader.add(new UniTimeTableHeader(MESSAGES.colRoom()));
        this.iSectionsTable.addRow(null, sectionHeader);
        this.addRow(MESSAGES.propSections(), (Widget)this.iSectionsTable);
        this.iRequestLoad = new Label();
        this.addRow(MESSAGES.propRequestLoad(), (Widget)this.iRequestLoad);
        this.iAttributePrefs = new PreferenceCell(properties);
        this.iAttributePrefsRow = this.addRow(MESSAGES.propAttributePrefs(), (Widget)this.iAttributePrefs);
        this.iInstructorPrefs = new PreferenceCell(properties);
        this.iInstructorPrefsRow = this.addRow(MESSAGES.propInstructorPrefs(), (Widget)this.iInstructorPrefs);
        this.iObjectives = new ObjectivesCell(properties);
        this.iObjectivesRow = this.addRow(MESSAGES.propObjectives(), (Widget)this.iObjectives);
        this.iInstructorsTable = new UniTimeTable();
        this.iInstructorsTable.addStyleName("instructors");
        ArrayList<UniTimeTableHeader> instructorsHeader = new ArrayList<UniTimeTableHeader>();
        instructorsHeader.add(new UniTimeTableHeader(MESSAGES.colIndex()));
        instructorsHeader.add(new UniTimeTableHeader(MESSAGES.colExternalId()));
        instructorsHeader.add(new UniTimeTableHeader(MESSAGES.colNamePerson()));
        instructorsHeader.add(new UniTimeTableHeader(MESSAGES.colAssignedLoad()));
        instructorsHeader.add(new UniTimeTableHeader(MESSAGES.colAttributes()));
        instructorsHeader.add(new UniTimeTableHeader(MESSAGES.colCoursePreferences()));
        instructorsHeader.add(new UniTimeTableHeader(MESSAGES.colTimePreferences()));
        instructorsHeader.add(new UniTimeTableHeader(MESSAGES.colDistributionPreferences()));
        instructorsHeader.add(new UniTimeTableHeader(MESSAGES.colObjectives()));
        this.iInstructorsTable.addRow(null, instructorsHeader);
        this.addRow(MESSAGES.propAssignedInstructors(), (Widget)this.iInstructorsTable);
        this.iInstructorsTable.setAllowSelection(true);
        this.iInstructorsTable.setAllowMultiSelect(false);
        this.iInstructorsTable.addMouseClickListener(new UniTimeTable.MouseClickListener<InstructorInterface.InstructorInfo>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<InstructorInterface.InstructorInfo> event) {
                if (event.getRow() > 0) {
                    TeachingRequestDetails.this.iInstructorsTable.setSelected(event.getRow(), true);
                    ValueChangeEvent.fire((HasValueChangeHandlers)TeachingRequestDetails.this, (Object)(event.getRow() - 1));
                }
            }
        });
    }

    public void setRequest(InstructorInterface.TeachingRequestInfo request, Integer index) {
        this.iCourseLabel.setText(request.getCourse().getCourseName());
        this.iRequestLoad.setText(sTeachingLoadFormat.format((double)request.getLoad()));
        this.iSectionsTable.clearTable(1);
        for (InstructorInterface.SectionInfo s : request.getSections()) {
            ArrayList<Object> sectionLine = new ArrayList<Object>();
            sectionLine.add(new Label(s.getSectionType() + (s.getExternalId() == null ? "" : " " + s.getExternalId())));
            sectionLine.add(new HTML(s.getTime() == null ? SECTMSG.arrangeHours() : s.getTime()));
            sectionLine.add(new HTML(s.getDate() == null ? SECTMSG.noDate() : s.getDate()));
            sectionLine.add(new HTML(s.getRoom() == null ? SECTMSG.noRoom() : s.getRoom()));
            if (s.isCommon()) {
                for (Widget widget : sectionLine) {
                    widget.addStyleName("common");
                }
            }
            this.iSectionsTable.addRow(s, sectionLine);
        }
        this.iAttributePrefs.setValue(request.getAttributePreferences());
        this.getRowFormatter().setVisible(this.iAttributePrefsRow, !request.getAttributePreferences().isEmpty());
        this.iInstructorPrefs.setValue(request.getInstructorPreferences());
        this.getRowFormatter().setVisible(this.iInstructorPrefsRow, !request.getInstructorPreferences().isEmpty());
        this.iObjectives.setValue(request.getValues());
        this.getRowFormatter().setVisible(this.iObjectivesRow, !request.getValues().isEmpty());
        this.iInstructorsTable.clearTable(1);
        for (int i = 0; i < request.getNrInstructors(); ++i) {
            ArrayList<Object> instructorLine;
            InstructorInterface.InstructorInfo instructor = request.getInstructor(i);
            if (instructor != null) {
                instructorLine = new ArrayList<Object>();
                instructorLine.add(new Label(1 + i + "."));
                instructorLine.add((Object)new InstructorExternalIdCell(this.iProperties, instructor));
                instructorLine.add((Object)new InstructorNameCell(this.iProperties, instructor));
                instructorLine.add(new Label(sTeachingLoadFormat.format((double)instructor.getAssignedLoad()) + " / " + sTeachingLoadFormat.format((double)instructor.getMaxLoad())));
                instructorLine.add((Object)new AttributesCell(instructor.getAttributes()));
                instructorLine.add((Object)new PreferenceCell(this.iProperties, instructor.getCoursePreferences()));
                instructorLine.add(new TimePreferenceCell(this.iProperties, instructor));
                instructorLine.add((Object)new PreferenceCell(this.iProperties, instructor.getDistributionPreferences()));
                instructorLine.add((Object)new ObjectivesCell(this.iProperties, instructor.getValues()));
                this.iInstructorsTable.addRow(instructor, instructorLine);
                continue;
            }
            instructorLine = new ArrayList();
            instructorLine.add(new Label(1 + i + "."));
            instructorLine.add(new NotAssignedInstructor(8));
            this.iInstructorsTable.addRow(null, instructorLine);
        }
        if (request.getNrInstructors() <= 1) {
            this.iInstructorsTable.setColumnVisible(0, false);
        }
        if (request.getNrInstructors() == 1) {
            this.iInstructorsTable.setSelected(1, true);
        } else if (index != null) {
            this.iInstructorsTable.setSelected(1 + index, true);
        }
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Integer> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public Integer getValue() {
        int row = this.iInstructorsTable.getSelectedRow();
        if (row < 1) {
            return null;
        }
        return row - 1;
    }

    public void setValue(Integer value) {
        this.setValue(value, false);
    }

    public void setValue(Integer value, boolean fireEvents) {
        if (value == null) {
            int row = this.iInstructorsTable.getSelectedRow();
            if (row >= 0) {
                this.iInstructorsTable.setSelected(row, false);
            }
        } else {
            this.iInstructorsTable.setSelected(value + 1, true);
        }
        if (fireEvents) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.getValue());
        }
    }

    public class NotAssignedInstructor
    extends P
    implements UniTimeTable.HasColSpan {
        int iColSpan;

        NotAssignedInstructor(int colspan) {
            super("not-assigned");
            this.iColSpan = colspan;
            this.setText(MESSAGES.notAssignedInstructor());
        }

        @Override
        public int getColSpan() {
            return this.iColSpan;
        }
    }
}

