/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.List;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Roles;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.TimetableManager;

public class TimetableManagerForm
implements UniTimeForm {
    private static final long serialVersionUID = 3763101881496582452L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private String op;
    private Long uniqueId;
    private String externalId;
    private String lookupResult;
    private String firstName;
    private String middleName;
    private String lastName;
    private String title;
    private Long primaryRole;
    private String email;
    private Long role;
    private Long dept;
    private Long solverGr;
    private List<Long> depts;
    private List<String> deptLabels;
    private List<Long> roles;
    private List<String> roleRefs;
    private List<Boolean> roleReceiveEmailFlags;
    private List<Long> solverGrs;
    private List<String> solverGrLabels;
    private Boolean lookupEnabled;

    public TimetableManagerForm() {
        this.reset();
    }

    @Override
    public void reset() {
        this.op = "";
        this.uniqueId = null;
        this.externalId = "";
        this.firstName = "";
        this.middleName = "";
        this.lastName = "";
        this.title = "";
        this.primaryRole = null;
        this.role = null;
        this.dept = null;
        this.solverGr = null;
        this.lookupEnabled = null;
        this.depts = new ArrayList<Long>();
        this.deptLabels = new ArrayList<String>();
        this.roles = new ArrayList<Long>();
        this.roleRefs = new ArrayList<String>();
        this.roleReceiveEmailFlags = new ArrayList<Boolean>();
        this.solverGrs = new ArrayList<Long>();
        this.solverGrLabels = new ArrayList<String>();
    }

    @Override
    public void validate(UniTimeAction action) {
        if (MSG.actionAddRole().equals(this.op) && (this.role == null || this.role < 0L)) {
            action.addFieldError("form.role", MSG.errorRequiredField(MSG.fieldRole()));
        }
        if (MSG.actionAddDepartment().equals(this.op) && (this.dept == null || this.dept < 0L)) {
            action.addFieldError("form.dept", MSG.errorRequiredField(MSG.columnDepartment()));
        }
        if (MSG.actionAddSolverGroup().equals(this.op) && (this.solverGr == null || this.solverGr < 0L)) {
            action.addFieldError("form.solverGr", MSG.errorRequiredField(MSG.columnSolverGroup()));
        }
        if (MSG.actionSaveManager().equals(this.op) || MSG.actionUpdateManager().equals(this.op)) {
            TimetableManager mgr;
            if (this.externalId == null || this.externalId.trim().isEmpty()) {
                action.addFieldError("form.externalId", MSG.errorRequiredField(MSG.columnExternalId()));
            }
            if (this.email == null || this.email.trim().isEmpty()) {
                action.addFieldError("form.email", MSG.errorRequiredField(MSG.columnEmailAddress()));
            }
            if (this.primaryRole == null || this.primaryRole < 0L) {
                action.addFieldError("form.primaryRole", MSG.errorRequiredField(MSG.fieldPrimaryRole()));
            }
            if (this.roles.size() == 0) {
                action.addFieldError("form.roles", MSG.errorManagerHasNoRoles());
            }
            if (this.externalId != null && this.externalId.trim().length() > 0 && (mgr = TimetableManager.findByExternalId(this.externalId)) != null && !mgr.getUniqueId().equals(this.getUniqueId())) {
                action.addFieldError("form.externalId", MSG.errorManagerDuplicate());
            }
            if (!this.lookupEnabled.booleanValue()) {
                if (this.firstName == null || this.firstName.isEmpty()) {
                    action.addFieldError("form.firstName", MSG.errorRequiredField(MSG.fieldFirstName()));
                }
                if (this.lastName == null || this.lastName.isEmpty()) {
                    action.addFieldError("form.lastName", MSG.errorRequiredField(MSG.fieldLastName()));
                }
            }
        }
    }

    public void addToRoles(Roles role) {
        this.roles.add(role.getRoleId());
        this.roleRefs.add(role.getAbbv());
    }

    public void removeFromRoles(int index) {
        this.roles.remove(index);
        this.roleRefs.remove(index);
        if (index < this.roleReceiveEmailFlags.size()) {
            this.roleReceiveEmailFlags.remove(index);
        }
    }

    public void addToDepts(Department dept) {
        this.depts.add(dept.getUniqueId());
        this.deptLabels.add(dept.getLabel());
    }

    public void removeFromDepts(int index) {
        this.depts.remove(index);
        this.deptLabels.remove(index);
    }

    public void addToSolverGrs(SolverGroup sg) {
        this.solverGrs.add(sg.getUniqueId());
        this.solverGrLabels.add(sg.getName());
    }

    public void removeFromSolverGrs(int index) {
        this.solverGrs.remove(index);
        this.solverGrLabels.remove(index);
    }

    public String getLookupResult() {
        return this.lookupResult;
    }

    public void setLookupResult(String lookupResult) {
        this.lookupResult = lookupResult;
    }

    public Long getDept() {
        return this.dept;
    }

    public void setDept(Long dept) {
        this.dept = dept;
    }

    public Long getSolverGr() {
        return this.solverGr;
    }

    public void setSolverGr(Long solverGr) {
        this.solverGr = solverGr;
    }

    public List getDepts() {
        return this.depts;
    }

    public Long getDepts(int key) {
        return this.depts.get(key);
    }

    public void setDepts(int key, Long value) {
        this.depts.set(key, value);
    }

    public void setDepts(List<Long> depts) {
        this.depts = depts;
    }

    public List<String> getDeptLabels() {
        return this.deptLabels;
    }

    public String getDeptLabels(int key) {
        return this.deptLabels.get(key);
    }

    public void setDeptLabels(int key, String value) {
        this.deptLabels.set(key, value);
    }

    public void setDeptLabels(List<String> deptLabels) {
        this.deptLabels = deptLabels;
    }

    public List<Long> getSolverGrs() {
        return this.solverGrs;
    }

    public Long getSolverGrs(int key) {
        return this.solverGrs.get(key);
    }

    public void setSolverGrs(int key, Long value) {
        this.solverGrs.set(key, value);
    }

    public void setSolverGrs(List<Long> solverGrs) {
        this.solverGrs = solverGrs;
    }

    public List<String> getSolverGrLabels() {
        return this.solverGrLabels;
    }

    public String getSolverGrLabels(int key) {
        return this.solverGrLabels.get(key);
    }

    public void setSolverGrLabels(int key, String value) {
        this.solverGrLabels.set(key, value);
    }

    public void setSolverGrLabels(List<String> solverGrLabels) {
        this.solverGrLabels = solverGrLabels;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public Long getPrimaryRole() {
        return this.primaryRole;
    }

    public void setPrimaryRole(Long primaryRole) {
        this.primaryRole = primaryRole;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public List<Long> getRoles() {
        return this.roles;
    }

    public Long getRoles(int key) {
        return this.roles.get(key);
    }

    public void setRoles(int key, Long value) {
        this.roles.set(key, value);
    }

    public void setRoles(List<Long> roles) {
        this.roles = roles;
    }

    public List<String> getRoleRefs() {
        return this.roleRefs;
    }

    public String getRoleRefs(int key) {
        return this.roleRefs.get(key);
    }

    public void setRoleRefs(int key, String value) {
        this.roleRefs.set(key, value);
    }

    public void setRoleRefs(List<String> roleRefs) {
        this.roleRefs = roleRefs;
    }

    public Long getRole() {
        return this.role;
    }

    public void setRole(Long role) {
        this.role = role;
    }

    public Long getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.uniqueId = uniqueId;
    }

    public Boolean getLookupEnabled() {
        return this.lookupEnabled;
    }

    public void setLookupEnabled(Boolean lookupEnabled) {
        this.lookupEnabled = lookupEnabled;
    }

    public List<Boolean> getRoleReceiveEmailFlags() {
        return this.roleReceiveEmailFlags;
    }

    public Boolean getRoleReceiveEmailFlags(int key) {
        return this.roleReceiveEmailFlags.get(key);
    }

    public void setRoleReceiveEmailFlags(int key, Boolean value) {
        this.roleReceiveEmailFlags.set(key, value);
    }

    public void setRoleReceiveEmailFlags(List<Boolean> roleReceiveEmailFlags) {
        this.roleReceiveEmailFlags = roleReceiveEmailFlags;
    }
}

