/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.util.IdValue;

public class ExamDistributionPrefsForm
implements UniTimeForm {
    private static final long serialVersionUID = -822886662425670241L;
    protected static ExaminationMessages MSG = Localization.create(ExaminationMessages.class);
    private String op;
    private String distPrefId;
    private String distType;
    private String prefLevel;
    private String description;
    private List<Long> subjectArea;
    private List<Long> courseNbr;
    private List<Long> exam;
    private Long iExamType;
    private String filterSubjectAreaId;
    private Collection<SubjectArea> filterSubjectAreas;
    private List<IdValue> subjectAreas;
    private String filterCourseNbr;

    public ExamDistributionPrefsForm() {
        this.reset();
    }

    @Override
    public void validate(UniTimeAction action) {
        if (this.distType == null || this.distType.equals("-")) {
            action.addFieldError("distType", MSG.errorSelectDistributionType());
        }
        if (this.prefLevel == null || this.prefLevel.equals("-")) {
            action.addFieldError("prefLevel", MSG.errorSelectPreferenceLevel());
        }
    }

    @Override
    public void reset() {
        this.op = "";
        this.distPrefId = null;
        this.distType = "-";
        this.prefLevel = "-";
        this.subjectArea = new ArrayList<Long>();
        this.courseNbr = new ArrayList<Long>();
        this.exam = new ArrayList<Long>();
        this.filterSubjectAreaId = null;
        this.filterCourseNbr = null;
        this.filterSubjectAreas = new ArrayList<SubjectArea>();
        this.iExamType = null;
    }

    public String getDistPrefId() {
        return this.distPrefId;
    }

    public void setDistPrefId(String distPrefId) {
        this.distPrefId = distPrefId;
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public String getPrefLevel() {
        return this.prefLevel;
    }

    public void setPrefLevel(String prefLevel) {
        this.prefLevel = prefLevel;
    }

    public String getDistType() {
        return this.distType;
    }

    public void setDistType(String distType) {
        this.distType = distType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Long> getSubjectAreaList() {
        return this.subjectArea;
    }

    public List<Long> getSubjectArea() {
        return this.subjectArea;
    }

    public Long getSubjectArea(int key) {
        return this.subjectArea.get(key);
    }

    public void setSubjectArea(int key, Long value) {
        this.subjectArea.set(key, value);
    }

    public void setSubjectArea(List<Long> subjectArea) {
        this.subjectArea = subjectArea;
    }

    public List<Long> getCourseNbr() {
        return this.courseNbr;
    }

    public Long getCourseNbr(int key) {
        return this.courseNbr.get(key);
    }

    public void setCourseNbr(int key, Long value) {
        this.courseNbr.set(key, value);
    }

    public void setCourseNbr(List courseNbr) {
        this.courseNbr = courseNbr;
    }

    public List<Long> getExam() {
        return this.exam;
    }

    public Long getExam(int key) {
        return this.exam.get(key);
    }

    public void setExam(int key, Long value) {
        this.exam.set(key, value);
    }

    public void setExam(List itype) {
        this.exam = itype;
    }

    public void deleteExam(int key) {
        this.subjectArea.remove(key);
        this.courseNbr.remove(key);
        this.exam.remove(key);
    }

    public void swapExams(int i1, int i2) {
        Long objSa1 = this.subjectArea.get(i1);
        Long objCo1 = this.courseNbr.get(i1);
        Long objEx1 = this.exam.get(i1);
        Long objSa2 = this.subjectArea.get(i2);
        Long objCo2 = this.courseNbr.get(i2);
        Long objEx2 = this.exam.get(i2);
        this.subjectArea.set(i1, objSa2);
        this.subjectArea.set(i2, objSa1);
        this.courseNbr.set(i1, objCo2);
        this.courseNbr.set(i2, objCo1);
        this.exam.set(i1, objEx2);
        this.exam.set(i2, objEx1);
    }

    public String getFilterSubjectAreaId() {
        return this.filterSubjectAreaId;
    }

    public void setFilterSubjectAreaId(String filterSubjectAreaId) {
        this.filterSubjectAreaId = filterSubjectAreaId;
    }

    public String getFilterCourseNbr() {
        return this.filterCourseNbr;
    }

    public void setFilterCourseNbr(String filterCourseNbr) {
        this.filterCourseNbr = filterCourseNbr;
    }

    public Collection<SubjectArea> getFilterSubjectAreas() {
        return this.filterSubjectAreas;
    }

    public void setFilterSubjectAreas(Collection<SubjectArea> filterSubjectAreas) {
        this.filterSubjectAreas = filterSubjectAreas;
    }

    public List<IdValue> getSubjectAreas() {
        return this.subjectAreas;
    }

    public void setSubjectAreas(List<IdValue> subjectAreas) {
        this.subjectAreas = subjectAreas;
    }

    public Collection<IdValue> getCourseNbrs(int idx) {
        Vector<IdValue> ret = new Vector<IdValue>();
        boolean contains = false;
        if (this.getSubjectArea(idx) >= 0L) {
            Iterator i = new CourseOfferingDAO().getSession().createQuery("select co.uniqueId, co.courseNbr, co.title from CourseOffering co where co.subjectArea.uniqueId = :subjectAreaId and co.instructionalOffering.notOffered = false order by co.courseNbr ").setFetchSize(200).setCacheable(true).setLong("subjectAreaId", this.getSubjectArea(idx).longValue()).iterate();
            while (i.hasNext()) {
                Object[] o = (Object[])i.next();
                ret.add(new IdValue((Long)o[0], (String)o[1] + " - " + (String)o[2]));
                if (!o[0].equals(this.getCourseNbr(idx))) continue;
                contains = true;
            }
        }
        if (!contains) {
            this.setCourseNbr(idx, -1L);
        }
        if (ret.size() == 1) {
            this.setCourseNbr(idx, ((IdValue)ret.firstElement()).getId());
        } else {
            ret.insertElementAt(new IdValue(-1L, "-"), 0);
        }
        return ret;
    }

    public Collection<IdValue> getExams(int idx) {
        Vector<IdValue> ret = new Vector<IdValue>();
        boolean contains = false;
        if (this.getCourseNbr(idx) >= 0L) {
            TreeSet exams = new TreeSet(Exam.findExamsOfCourseOffering(this.getCourseNbr(idx), this.getExamType()));
            for (Exam exam : exams) {
                ret.add(new IdValue(exam.getUniqueId(), exam.getLabel()));
                if (!exam.getUniqueId().equals(this.getExam(idx))) continue;
                contains = true;
            }
        }
        if (!contains) {
            this.setExam(idx, -1L);
        }
        if (ret.size() == 1) {
            this.setCourseNbr(idx, ((IdValue)ret.firstElement()).getId());
        } else {
            ret.insertElementAt(new IdValue(-1L, "-"), 0);
        }
        return ret;
    }

    public Long getExamType() {
        return this.iExamType;
    }

    public void setExamType(Long type) {
        this.iExamType = type;
    }
}

