/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.ExamPdfReportForm;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.reports.AbstractReport;
import org.unitime.timetable.reports.enrollment.EnrollmentsViolatingCourseStructureAuditReport;
import org.unitime.timetable.reports.enrollment.MissingCourseEnrollmentsAuditReport;
import org.unitime.timetable.reports.enrollment.MultipleConfigEnrollmentsAuditReport;
import org.unitime.timetable.reports.enrollment.MultipleCourseEnrollmentsAuditReport;
import org.unitime.timetable.reports.enrollment.PdfEnrollmentAuditReport;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.util.ComboBoxLookup;

public class EnrollmentAuditPdfReportForm
implements UniTimeForm {
    private static final long serialVersionUID = -4537752846296511516L;
    protected static Log sLog = LogFactory.getLog(EnrollmentAuditPdfReportForm.class);
    protected static final ExaminationMessages MSG = Localization.create(ExaminationMessages.class);
    private String iOp = null;
    private Long iSubjectArea = null;
    private Collection iSubjectAreas = null;
    private String[] iReports = null;
    private String iMode = null;
    private boolean iAll = false;
    private String[] iSubjects = null;
    private boolean iExternalId = false;
    private boolean iStudentName = false;
    private boolean iEmail = false;
    private String iAddr;
    private String iCc;
    private String iBcc = null;
    private String iReport = null;
    private String iMessage = null;
    private String iSubject = null;

    public String getReportName(RegisteredReport report) {
        switch (report) {
            case EnrollmentsViolatingCourseStructureAuditReport: {
                return MSG.reportEnrollmentsViolatingCourseStructureAudit();
            }
            case MissingCourseEnrollmentsAuditReport: {
                return MSG.reportMissingCourseEnrollmentsAudit();
            }
            case MultipleCourseEnrollmentsAuditReport: {
                return MSG.reportMultipleCourseEnrollmentsAudit();
            }
            case MultipleConfigEnrollmentsAuditReport: {
                return MSG.reportMultipleConfigEnrollmentsAudit();
            }
        }
        return report.name();
    }

    @Override
    public void validate(UniTimeAction action) {
        if (this.iReports == null || this.iReports.length == 0) {
            action.addFieldError("reports", MSG.errorNoReportSelected());
        }
        if (!(this.iAll || this.iSubjects != null && this.iSubjects.length != 0)) {
            action.addFieldError("reports", MSG.errorNoSubjectAreaSelected());
        }
    }

    @Override
    public void reset() {
        this.iOp = null;
        this.iReports = null;
        this.iMode = this.getModes().get(0).getValue();
        this.iAll = false;
        this.iEmail = false;
        this.iExternalId = false;
        this.iStudentName = false;
        this.iAddr = null;
        this.iCc = null;
        this.iBcc = null;
        this.iSubject = MSG.subjectEnrollmentAuditReport();
        this.iMessage = null;
        this.iReport = null;
    }

    public void load(SessionContext context) {
        this.setSubjectArea(context.getAttribute("EnrollmentAuditPdfReport.subjectArea") == null ? null : (Long)context.getAttribute("EnrollmentAuditPdfReport.subjectArea"));
        try {
            this.iSubjectAreas = new TreeSet(new SubjectAreaDAO().getSession().createQuery("select distinct co.subjectArea from CourseOffering co where co.subjectArea.session.uniqueId=:sessionId").setLong("sessionId", context.getUser().getCurrentAcademicSessionId().longValue()).setCacheable(true).list());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setAll(context.getAttribute("EnrollmentAuditPdfReport.all") == null ? true : (Boolean)context.getAttribute("EnrollmentAuditPdfReport.all"));
        this.setReports((String[])context.getAttribute("EnrollmentAuditPdfReport.reports"));
        this.setMode(context.getAttribute("EnrollmentAuditPdfReport.mode") == null ? this.getModes().get(0).getValue() : (String)context.getAttribute("EnrollmentAuditPdfReport.mode"));
        this.setSubjects((String[])context.getAttribute("EnrollmentAuditPdfReport.subjects"));
        this.setExternalId("1".equals(context.getUser().getProperty("EnrollmentAuditPdfReport.externalId", "0")));
        this.setStudentName("1".equals(context.getUser().getProperty("EnrollmentAuditPdfReport.studentName", "0")));
        this.setEmail("1".equals(context.getUser().getProperty("EnrollmentAuditPdfReport.email", "0")));
        this.setAddress(context.getUser().getProperty("EnrollmentAuditPdfReport.addr", context.getUser().getEmail()));
        this.setCc(context.getUser().getProperty("EnrollmentAuditPdfReport.cc"));
        this.setBcc(context.getUser().getProperty("EnrollmentAuditPdfReport.bcc"));
        this.setMessage(context.getUser().getProperty("EnrollmentAuditPdfReport.message"));
        this.setSubject(context.getUser().getProperty("EnrollmentAuditPdfReport.subject", "Enrollment Audit"));
    }

    public void save(SessionContext context) {
        context.setAttribute("EnrollmentAuditPdfReport.reports.subjectArea", (Object)this.getSubjectArea());
        context.setAttribute("EnrollmentAuditPdfReport.reports", (Object)this.getReports());
        context.setAttribute("EnrollmentAuditPdfReport.mode", (Object)this.getMode());
        context.setAttribute("EnrollmentAuditPdfReport.all", (Object)this.getAll());
        context.setAttribute("EnrollmentAuditPdfReport.subjects", (Object)this.getSubjects());
        context.getUser().setProperty("EnrollmentAuditPdfReport.externalId", this.getExternalId() ? "1" : "0");
        context.getUser().setProperty("EnrollmentAuditPdfReport.studentName", this.getStudentName() ? "1" : "0");
        context.getUser().setProperty("EnrollmentAuditPdfReport.email", this.getEmail() ? "1" : "0");
        context.getUser().setProperty("EnrollmentAuditPdfReport.addr", this.getAddress());
        context.getUser().setProperty("EnrollmentAuditPdfReport.cc", this.getCc());
        context.getUser().setProperty("EnrollmentAuditPdfReport.bcc", this.getBcc());
        context.getUser().setProperty("EnrollmentAuditPdfReport.message", this.getMessage());
        context.getUser().setProperty("EnrollmentAuditPdfReport.subject", this.getSubject());
    }

    public String[] getReports() {
        return this.iReports;
    }

    public void setReports(String[] reports) {
        this.iReports = reports;
    }

    public String getMode() {
        return this.iMode;
    }

    public void setMode(String mode) {
        this.iMode = mode;
    }

    public boolean getAll() {
        return this.iAll;
    }

    public void setAll(boolean all) {
        this.iAll = all;
    }

    public String[] getSubjects() {
        return this.iSubjects;
    }

    public void setSubjects(String[] subjects) {
        this.iSubjects = subjects;
    }

    public boolean getEmail() {
        return this.iEmail;
    }

    public void setEmail(boolean email) {
        this.iEmail = email;
    }

    public String getAddress() {
        return this.iAddr;
    }

    public void setAddress(String addr) {
        this.iAddr = addr;
    }

    public String getCc() {
        return this.iCc;
    }

    public void setCc(String cc) {
        this.iCc = cc;
    }

    public String getBcc() {
        return this.iBcc;
    }

    public void setBcc(String bcc) {
        this.iBcc = bcc;
    }

    public boolean getCanEmail() {
        return true;
    }

    public String getReport() {
        return this.iReport;
    }

    public void setReport(String report) {
        this.iReport = report;
    }

    public void log(String message) {
        sLog.info((Object)message);
        this.iReport = this.iReport + message + "<br>";
    }

    public String getMessage() {
        return this.iMessage;
    }

    public void setMessage(String message) {
        this.iMessage = message;
    }

    public String getSubject() {
        return this.iSubject;
    }

    public void setSubject(String subject) {
        this.iSubject = subject;
    }

    public List<ComboBoxLookup> getAllReports() {
        ArrayList<ComboBoxLookup> ret = new ArrayList<ComboBoxLookup>();
        for (RegisteredReport r : RegisteredReport.values()) {
            ret.add(new ComboBoxLookup(this.getReportName(r), r.name()));
        }
        return ret;
    }

    public List<ComboBoxLookup> getModes() {
        ArrayList<ComboBoxLookup> ret = new ArrayList<ComboBoxLookup>();
        for (AbstractReport.Mode m : AbstractReport.Mode.values()) {
            ret.add(new ComboBoxLookup(ExamPdfReportForm.getModeLabel(m), m.name()));
        }
        return ret;
    }

    public AbstractReport.Mode getReportMode() {
        try {
            return AbstractReport.Mode.valueOf(this.getMode());
        }
        catch (Exception e) {
            return AbstractReport.Mode.LegacyPdfLetter;
        }
    }

    public String getOp() {
        return this.iOp;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public Long getSubjectArea() {
        return this.iSubjectArea;
    }

    public void setSubjectArea(Long subjectArea) {
        this.iSubjectArea = subjectArea;
    }

    public Collection getSubjectAreas() {
        return this.iSubjectAreas;
    }

    public void setSubjectAreas(Collection subjectAreas) {
        this.iSubjectAreas = subjectAreas;
    }

    public boolean getExternalId() {
        return this.iExternalId;
    }

    public void setExternalId(boolean externalId) {
        this.iExternalId = externalId;
    }

    public boolean getStudentName() {
        return this.iStudentName;
    }

    public void setStudentName(boolean studentName) {
        this.iStudentName = studentName;
    }

    public static enum RegisteredReport {
        EnrollmentsViolatingCourseStructureAuditReport(EnrollmentsViolatingCourseStructureAuditReport.class),
        MissingCourseEnrollmentsAuditReport(MissingCourseEnrollmentsAuditReport.class),
        MultipleCourseEnrollmentsAuditReport(MultipleCourseEnrollmentsAuditReport.class),
        MultipleConfigEnrollmentsAuditReport(MultipleConfigEnrollmentsAuditReport.class);

        private Class<? extends PdfEnrollmentAuditReport> implementation;

        private RegisteredReport(Class<? extends PdfEnrollmentAuditReport> implementation) {
            this.implementation = implementation;
        }

        public Class<? extends PdfEnrollmentAuditReport> getImplementation() {
            return this.implementation;
        }
    }
}

