/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class JavaScriptCacheFilter
implements Filter {
    public void init(FilterConfig cfg) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.setDateHeader("Date", System.currentTimeMillis());
            httpResponse.setDateHeader("Expires", System.currentTimeMillis() + 86400000L);
            if (httpRequest.getRequestURI().endsWith(".nocache.js")) {
                httpResponse.setHeader("Pragma", "no-cache");
                httpResponse.setHeader("Cache-control", "no-cache, no-store, must-revalidate");
                chain.doFilter(request, response);
            } else {
                httpResponse.setHeader("Cache-control", "private, max-age=86400, must-revalidate");
                chain.doFilter(request, (ServletResponse)new HttpServletResponseWrapper(httpResponse){

                    public void addHeader(String name, String value) {
                        if (!"Pragma".equalsIgnoreCase(name)) {
                            super.addHeader(name, value);
                        }
                    }

                    public void setHeader(String name, String value) {
                        if (!"Pragma".equalsIgnoreCase(name)) {
                            super.setHeader(name, value);
                        }
                    }
                });
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

