/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.rooms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;
import org.unitime.timetable.export.CSVPrinter;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.rooms.RoomsExporter;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.security.rights.Right;

@Service(value="org.unitime.timetable.export.Exporter:rooms.csv")
public class RoomsExportCSV
extends RoomsExporter {
    @Override
    public String reference() {
        return "rooms.csv";
    }

    @Override
    protected void print(ExportHelper helper, List<RoomInterface.RoomDetailInterface> rooms, RoomsExporter.ExportContext context) throws IOException {
        helper.getSessionContext().hasPermission(Right.RoomsExportCsv);
        ArrayList<RoomsExporter.Column> columns = new ArrayList<RoomsExporter.Column>();
        for (RoomInterface.RoomsColumn column : RoomInterface.RoomsColumn.values()) {
            int nrCells = this.getNbrCells(column, context);
            for (int idx = 0; idx < nrCells; ++idx) {
                RoomsExporter.Column c = new RoomsExporter.Column(column, idx);
                if (!this.isColumnVisible(c, context)) continue;
                columns.add(c);
            }
        }
        CSVPrinter printer = new CSVPrinter(helper, false);
        helper.setup(printer.getContentType(), this.reference(), false);
        String[] header = new String[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            header[i] = this.getColumnName((RoomsExporter.Column)columns.get(i), context).replace("<br>", "\n");
        }
        printer.printHeader(header);
        printer.flush();
        for (RoomInterface.RoomDetailInterface room : rooms) {
            String[] row = new String[columns.size()];
            for (int i = 0; i < columns.size(); ++i) {
                row[i] = this.getCell(room, (RoomsExporter.Column)columns.get(i), context);
            }
            printer.printLine(row);
            printer.flush();
        }
        printer.close();
    }

    @Override
    protected int getNbrCells(RoomInterface.RoomsColumn column, RoomsExporter.ExportContext ec) {
        switch (column) {
            case COORDINATES: {
                return 2;
            }
            case PICTURES: 
            case MAP: {
                return 0;
            }
        }
        return super.getNbrCells(column, ec);
    }

    protected int getNbrColumns(RoomsExporter.ExportContext context) {
        int ret = 0;
        for (RoomInterface.RoomsColumn rc : RoomInterface.RoomsColumn.values()) {
            ret += this.getNbrCells(rc, context);
        }
        return ret;
    }

    @Override
    protected String getColumnName(RoomsExporter.Column column, RoomsExporter.ExportContext context) {
        switch (column.getColumn()) {
            case COORDINATES: {
                if (column.getIndex() == 0) {
                    return MESSAGES.colCoordinateX();
                }
                return MESSAGES.colCoordinateY();
            }
        }
        return super.getColumnName(column, context).replace("<br>", "\n");
    }

    protected String getCell(RoomInterface.RoomDetailInterface room, RoomsExporter.Column column, RoomsExporter.ExportContext context) {
        switch (column.getColumn()) {
            case NAME: {
                return room.hasDisplayName() ? MESSAGES.label(room.getLabel(), room.getDisplayName()) : room.getLabel();
            }
            case EXTERNAL_ID: {
                return room.hasExternalId() ? room.getExternalId() : "";
            }
            case TYPE: {
                return room.getRoomType().getLabel();
            }
            case CAPACITY: {
                return room.getCapacity() == null ? "0" : room.getCapacity().toString();
            }
            case EXAM_CAPACITY: {
                return room.getExamCapacity() == null ? "" : room.getExamCapacity().toString();
            }
            case AREA: {
                return room.getArea() == null ? "" : room.getArea().toString();
            }
            case COORDINATES: {
                if (column.getIndex() == 0) {
                    return room.getX() == null ? "" : room.getX().toString();
                }
                return room.getY() == null ? "" : room.getY().toString();
            }
            case ROOM_CHECK: {
                return room.isIgnoreRoomCheck() ? MESSAGES.exportFalse() : MESSAGES.exportTrue();
            }
            case DISTANCE_CHECK: {
                return room.isIgnoreTooFar() ? MESSAGES.exportFalse() : MESSAGES.exportTrue();
            }
            case PREFERENCE: {
                return context.pref2string(room.getDepartments());
            }
            case AVAILABILITY: {
                return room.getAvailability();
            }
            case DEPARTMENTS: {
                return context.dept2string(room.getDepartments(), true);
            }
            case CONTROL_DEPT: {
                return context.dept2string(room.getControlDepartment(), true);
            }
            case EXAM_TYPES: {
                return context.examTypes2string(room.getExamTypes());
            }
            case PERIOD_PREF: {
                return room.getPeriodPreference();
            }
            case EVENT_DEPARTMENT: {
                return context.dept2string(room.getEventDepartment(), false);
            }
            case EVENT_STATUS: {
                return (room.getEventStatus() != null ? CONSTANTS.eventStatusAbbv()[room.getEventStatus()] : (room.getDefaultEventStatus() != null ? CONSTANTS.eventStatusAbbv()[room.getDefaultEventStatus()] : "")).replace("<br>", "\n");
            }
            case EVENT_AVAILABILITY: {
                return room.getEventAvailability();
            }
            case EVENT_MESSAGE: {
                return room.getEventNote() != null ? room.getEventNote() : room.getDefaultEventNote();
            }
            case BREAK_TIME: {
                return room.getBreakTime() != null ? room.getBreakTime().toString() : (room.getDefaultBreakTime() != null ? room.getDefaultBreakTime().toString() : "");
            }
            case GROUPS: {
                return context.groups2string(room.getGroups());
            }
            case FEATURES: {
                if (column.getIndex() == 0) {
                    return context.features2string(room.getFeatures(), null);
                }
                return context.features2string(room.getFeatures(), context.getRoomFeatureTypes().get(column.getIndex() - 1));
            }
            case SERVICES: {
                return context.services2string(room.getServices(), room.getEventDepartment());
            }
            case PARTITION: {
                if (room.getParent() == null) {
                    return null;
                }
                return room.getParent().hasDisplayName() ? MESSAGES.label(room.getParent().getLabel(), room.getParent().getDisplayName()) : room.getParent().getLabel();
            }
        }
        return null;
    }
}

