/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernate.NonUniqueResultException;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.PositionType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Staff;

public class StaffImport
extends BaseImport {
    boolean trimLeadingZerosFromExternalId = false;

    public void loadFromXML(String filename) throws Exception {
        try (FileInputStream fis = null;){
            fis = new FileInputStream(filename);
            this.loadFromStream(fis);
        }
    }

    public void loadFromStream(FileInputStream fis) throws Exception {
        Document document = new SAXReader().read((InputStream)fis);
        Element root = document.getRootElement();
        this.loadXml(root);
    }

    @Override
    public void loadXml(Element root) throws Exception {
        this.trimLeadingZerosFromExternalId = ApplicationProperty.DataExchangeTrimLeadingZerosFromExternalIds.isTrue();
        if (!root.getName().equalsIgnoreCase("staff")) {
            throw new Exception("Given XML file is not a Staff load file.");
        }
        String campus = root.attributeValue("campus");
        String year = root.attributeValue("year");
        String term = root.attributeValue("term");
        String created = root.attributeValue("created");
        String elementName = "staffMember";
        boolean incremental = "true".equalsIgnoreCase(root.attributeValue("incremental", "true"));
        boolean posCodeWarning = false;
        try {
            this.beginTransaction();
            Session session = Session.getSessionUsingInitiativeYearTerm(campus, year, term);
            if (session != null && created != null) {
                ChangeLog.addChange(this.getHibSession(), this.getManager(), session, session, created, ChangeLog.Source.DATA_IMPORT_STAFF, ChangeLog.Operation.UPDATE, null, null);
            }
            if (!incremental) {
                this.info("Incremental mode disabled, deleting all Staff content.");
                this.getHibSession().createQuery("delete Staff").executeUpdate();
            }
            Iterator it = root.elementIterator();
            while (it.hasNext()) {
                String email;
                Staff staff;
                String dept;
                String externalId;
                Element element;
                block18: {
                    element = (Element)it.next();
                    externalId = this.getRequiredStringAttribute(element, "externalId", elementName);
                    dept = this.getOptionalStringAttribute(element, "department");
                    staff = null;
                    if (externalId != null && externalId.length() > 0) {
                        if (this.trimLeadingZerosFromExternalId) {
                            try {
                                Integer num = Integer.valueOf(externalId);
                                externalId = num.toString();
                            }
                            catch (Exception num) {
                                // empty catch block
                            }
                        }
                        try {
                            if (!incremental) break block18;
                            staff = this.findByExternalId(externalId, dept);
                        }
                        catch (NonUniqueResultException e) {
                            this.error("Multiple staff members exist for the external id " + externalId + ", please provide department code.");
                            continue;
                        }
                    }
                }
                if ("T".equalsIgnoreCase(element.attributeValue("delete")) || "Y".equalsIgnoreCase(element.attributeValue("delete")) || "true".equalsIgnoreCase(element.attributeValue("delete"))) {
                    if (staff == null) continue;
                    this.getHibSession().delete(staff);
                    continue;
                }
                if (staff == null) {
                    staff = new Staff();
                }
                staff.setFirstName(this.getOptionalStringAttribute(element, "firstName"));
                staff.setMiddleName(this.getOptionalStringAttribute(element, "middleName"));
                staff.setLastName(this.getRequiredStringAttribute(element, "lastName", elementName));
                staff.setAcademicTitle(this.getOptionalStringAttribute(element, "acadTitle"));
                PositionType posType = null;
                String positionType = this.getOptionalStringAttribute(element, "positionType");
                if (positionType != null) {
                    posType = PositionType.findByRef(positionType);
                }
                if (!posCodeWarning && this.getOptionalStringAttribute(element, "positionCode") != null) {
                    this.warn("Attribute positionCode is no longer supported, please use positionType attribute instead.");
                    posCodeWarning = true;
                }
                staff.setPositionType(posType);
                staff.setExternalUniqueId(externalId);
                staff.setCampus(campus);
                if (dept != null) {
                    staff.setDept(dept);
                }
                if ((email = this.getOptionalStringAttribute(element, "email")) != null) {
                    staff.setEmail(email);
                }
                this.getHibSession().saveOrUpdate((Object)staff);
                this.flushIfNeeded(true);
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
    }

    private Staff findByExternalId(String externalId, String deptCode) {
        if (deptCode != null) {
            return (Staff)this.getHibSession().createQuery("select distinct a from Staff as a where a.externalUniqueId=:externalId and a.dept=:deptCode").setString("externalId", externalId).setString("deptCode", deptCode).setCacheable(true).uniqueResult();
        }
        return (Staff)this.getHibSession().createQuery("select distinct a from Staff as a where a.externalUniqueId=:externalId").setString("externalId", externalId).setCacheable(true).uniqueResult();
    }
}

