/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.io.StringWriter;
import java.util.List;
import java.util.Set;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.unitime.commons.Debug;
import org.unitime.timetable.action.InstructionalOfferingSearchAction;
import org.unitime.timetable.action.PreferencesAction2;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.SchedulingSubpartEditForm;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseCreditUnitConfig;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.DistributionPrefsTableBuilder;
import org.unitime.timetable.webutil.WebClassListTableBuilder;

@Action(value="schedulingSubpartDetail", results={@Result(name={"displaySchedulingSubpart"}, type="tiles", location="schedulingSubpartDetail.tiles"), @Result(name={"instructionalOfferingSearch"}, type="redirect", location="/instructionalOfferingSearch.action"), @Result(name={"addDistributionPrefs"}, type="redirect", location="/distributionPrefs.action", params={"subpartId", "${form.schedulingSubpartId}", "op", "${op}"})})
@TilesDefinition(name="schedulingSubpartDetail.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Scheduling Subpart Detail"), @TilesPutAttribute(name="body", value="/user/schedulingSubpartDetail.jsp"), @TilesPutAttribute(name="showNavigation", value="true"), @TilesPutAttribute(name="showSolverWarnings", value="assignment")})
public class SchedulingSubpartDetailAction
extends PreferencesAction2<SchedulingSubpartEditForm> {
    private static final long serialVersionUID = 4649492548245480462L;
    protected String subpartId = null;
    protected String op2 = null;

    public String getSsuid() {
        return this.subpartId;
    }

    public void setSsuid(String subpartId) {
        this.subpartId = subpartId;
    }

    public String getOp2() {
        return this.op2;
    }

    public void setOp2(String op2) {
        this.op2 = op2;
    }

    @Override
    public String execute() throws Exception {
        if (this.form == null) {
            this.form = new SchedulingSubpartEditForm();
        }
        super.execute();
        if (this.subpartId == null && this.request.getAttribute("ssuid") != null) {
            this.subpartId = (String)this.request.getAttribute("ssuid");
        }
        if (this.op == null) {
            this.op = ((SchedulingSubpartEditForm)this.form).getOp();
        }
        if (this.op2 != null && !this.op2.isEmpty()) {
            this.op = this.op2;
        }
        super.execute();
        if (MSG.actionEditSubpart().equals(this.op) || MSG.actionAddDistributionPreference().equals(this.op) || MSG.actionNextSubpart().equals(this.op) || MSG.actionPreviousSubpart().equals(this.op) || MSG.actionClearClassPreferencesOnSubpart().equals(this.op) || MSG.actionEditSubpartInstructorAssignmentPreferences().equals(this.op)) {
            this.subpartId = ((SchedulingSubpartEditForm)this.form).getSchedulingSubpartId();
        } else {
            ((SchedulingSubpartEditForm)this.form).reset();
        }
        Debug.debug("op: " + this.op);
        Debug.debug("subpart: " + this.subpartId);
        if (this.subpartId == null || this.subpartId.trim().isEmpty()) {
            throw new Exception(MSG.errorSubpartInfoNotSupplied());
        }
        this.sessionContext.checkPermission((Serializable)((Object)this.subpartId), "SchedulingSubpart", Right.SchedulingSubpartDetail);
        boolean timeVertical = CommonValues.VerticalGrid.eq(this.sessionContext.getUser().getProperty(UserProperty.GridOrientation));
        SchedulingSubpartDAO sdao = new SchedulingSubpartDAO();
        SchedulingSubpart ss = (SchedulingSubpart)sdao.get(Long.valueOf(this.subpartId));
        if (MSG.actionEditSubpart().equals(this.op)) {
            this.response.sendRedirect(this.response.encodeURL("schedulingSubpartEdit.action?ssuid=" + ss.getUniqueId().toString()));
            return null;
        }
        if (MSG.actionEditSubpartInstructorAssignmentPreferences().equals(this.op)) {
            this.response.sendRedirect(this.response.encodeURL("schedulingSubpartInstrAssgnEdit.do?ssuid=" + ss.getUniqueId().toString()));
            return null;
        }
        if (MSG.actionAddDistributionPreference().equals(this.op)) {
            this.sessionContext.checkPermission(ss, Right.DistributionPreferenceSubpart);
            return "addDistributionPrefs";
        }
        if (MSG.actionNextSubpart().equals(this.op)) {
            this.response.sendRedirect(this.response.encodeURL("schedulingSubpartDetail.action?ssuid=" + ((SchedulingSubpartEditForm)this.form).getNextId()));
            return null;
        }
        if (MSG.actionClearClassPreferencesOnSubpart().equals(this.op)) {
            this.sessionContext.checkPermission(ss, Right.SchedulingSubpartDetailClearClassPreferences);
            Class_DAO cdao = new Class_DAO();
            for (Class_ c : ss.getClasses()) {
                c.getPreferences().clear();
                cdao.saveOrUpdate(c);
            }
            ChangeLog.addChange(null, this.sessionContext, ss, ChangeLog.Source.SCHEDULING_SUBPART_EDIT, ChangeLog.Operation.CLEAR_ALL_PREF, ss.getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering().getSubjectArea(), ss.getManagingDept());
        }
        if (MSG.actionPreviousSubpart().equals(this.op)) {
            this.response.sendRedirect(this.response.encodeURL("schedulingSubpartDetail.action?ssuid=" + ((SchedulingSubpartEditForm)this.form).getPreviousId()));
            return null;
        }
        this.doLoad(ss, this.subpartId);
        Set timePatterns = null;
        ((SchedulingSubpartEditForm)this.form).setAvailableTimePatterns(TimePattern.findApplicable(this.sessionContext.getUser(), ss.getMinutesPerWk(), ss.effectiveDatePattern(), ss.getInstrOfferingConfig().getDurationModel(), false, ss.getManagingDept()));
        this.initPrefs(ss, null, false);
        timePatterns = ss.getTimePatterns();
        DistributionPrefsTableBuilder tbl = new DistributionPrefsTableBuilder();
        String html = tbl.getDistPrefsTableForSchedulingSubpart(this.request, this.sessionContext, ss);
        if (html != null) {
            this.request.setAttribute("distPrefs", (Object)html);
        }
        this.processPrefAction();
        this.setupDatePatterns(ss);
        super.generateTimePatternGrids(ss, ss.getMinutesPerWk(), ss.getInstrOfferingConfig().getDurationModel(), ss.effectiveDatePattern(), timePatterns, "init", timeVertical, false, null);
        LookupTables.setupDatePatterns(this.request, this.sessionContext.getUser(), MSG.dropDefaultDatePattern(), ss.getSession().getDefaultDatePatternNotNull(), ss.getManagingDept(), ss.effectiveDatePattern());
        LookupTables.setupRooms(this.request, ss);
        LookupTables.setupBldgs(this.request, ss);
        LookupTables.setupRoomFeatures(this.request, ss);
        LookupTables.setupRoomGroups(this.request, ss);
        LookupTables.setupInstructorAttributes(this.request, ss);
        LookupTables.setupInstructors(this.request, this.sessionContext, ss.getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering().getSubjectArea().getDepartment().getUniqueId());
        BackTracker.markForBack(this.request, "schedulingSubpartDetail.action?ssuid=" + ((SchedulingSubpartEditForm)this.form).getSchedulingSubpartId(), MSG.backSubpart(ss.getSchedulingSubpartLabel()), true, false);
        StringWriter out = new StringWriter();
        WebClassListTableBuilder subpartClsTableBuilder = new WebClassListTableBuilder();
        subpartClsTableBuilder.setDisplayDistributionPrefs(false);
        subpartClsTableBuilder.setDisplayConflicts(true);
        subpartClsTableBuilder.setDisplayDatePatternDifferentWarning(true);
        subpartClsTableBuilder.htmlTableForSubpartClasses(this.sessionContext, this.getClassAssignmentService().getAssignment(), this.getExaminationSolverService().getSolver(), Long.valueOf(((SchedulingSubpartEditForm)this.form).getSchedulingSubpartId()), out, this.request.getParameter("backType"), this.request.getParameter("backId"));
        out.flush();
        out.close();
        this.request.setAttribute("classTable", (Object)out.toString());
        return "displaySchedulingSubpart";
    }

    private void doLoad(SchedulingSubpart ss, String subpartId) {
        SchedulingSubpart parentSS;
        CourseOffering co = ss.getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering();
        InstructionalOfferingSearchAction.setLastInstructionalOffering(this.sessionContext, ss.getInstrOfferingConfig().getInstructionalOffering());
        InstrOfferingConfig ioc = ss.getInstrOfferingConfig();
        InstructionalOffering io = ioc.getInstructionalOffering();
        ((SchedulingSubpartEditForm)this.form).setInstrOfferingId(io.getUniqueId().toString());
        ((SchedulingSubpartEditForm)this.form).setSchedulingSubpartId(subpartId);
        ((SchedulingSubpartEditForm)this.form).setInstructionalType(ss.getItype().getItype().toString());
        String label = ss.getItype().getAbbv();
        if (io.hasMultipleConfigurations()) {
            label = label + " [" + ioc.getName() + "]";
        }
        ((SchedulingSubpartEditForm)this.form).setInstructionalTypeLabel(label);
        ((SchedulingSubpartEditForm)this.form).setUnlimitedEnroll(ioc.isUnlimitedEnrollment());
        ((SchedulingSubpartEditForm)this.form).setItypeBasic(ss.getItype() == null || ss.getItype().getBasic() != false);
        if (!((SchedulingSubpartEditForm)this.form).getItypeBasic()) {
            LookupTables.setupItypes(this.request, false);
        }
        ((SchedulingSubpartEditForm)this.form).setSubjectArea(co.getSubjectAreaAbbv());
        ((SchedulingSubpartEditForm)this.form).setSubjectAreaId(co.getSubjectArea().getUniqueId().toString());
        ((SchedulingSubpartEditForm)this.form).setCourseNbr(co.getCourseNbr());
        ((SchedulingSubpartEditForm)this.form).setCourseTitle(co.getTitle());
        ((SchedulingSubpartEditForm)this.form).setAutoSpreadInTime(ss.isAutoSpreadInTime());
        ((SchedulingSubpartEditForm)this.form).setStudentAllowOverlap(ss.isStudentAllowOverlap());
        ((SchedulingSubpartEditForm)this.form).setDatePattern(ss.getDatePattern() == null ? Long.valueOf(-1L) : ss.getDatePattern().getUniqueId());
        ((SchedulingSubpartEditForm)this.form).setDatePatternEditable(ApplicationProperty.WaitListCanChangeDatePattern.isTrue() || ioc.getEnrollment() == 0 || !io.effectiveReScheduleNow());
        if ((((SchedulingSubpartEditForm)this.form).getCreditText() == null || ((SchedulingSubpartEditForm)this.form).getCreditText().length() == 0) && ss.getCredit() != null) {
            CourseCreditUnitConfig credit = ss.getCredit();
            ((SchedulingSubpartEditForm)this.form).setCreditText(credit.creditText());
        }
        if (ss.getParentSubpart() != null && ss.getItype().equals(ss.getParentSubpart().getItype())) {
            ((SchedulingSubpartEditForm)this.form).setSameItypeAsParent(true);
        } else {
            ((SchedulingSubpartEditForm)this.form).setSameItypeAsParent(false);
        }
        SchedulingSubpart next = ss.getNextSchedulingSubpart(this.sessionContext, Right.SchedulingSubpartDetail);
        ((SchedulingSubpartEditForm)this.form).setNextId(next == null ? null : next.getUniqueId().toString());
        SchedulingSubpart previous = ss.getPreviousSchedulingSubpart(this.sessionContext, Right.SchedulingSubpartDetail);
        ((SchedulingSubpartEditForm)this.form).setPreviousId(previous == null ? null : previous.getUniqueId().toString());
        String parentSubpart = "";
        ((SchedulingSubpartEditForm)this.form).setParentSubpartId(parentSS == null || !this.sessionContext.hasPermission(parentSS, Right.SchedulingSubpartDetail) ? null : parentSS.getUniqueId().toString());
        ((SchedulingSubpartEditForm)this.form).setParentSubpartLabel(parentSS == null ? null : parentSS.getSchedulingSubpartLabel());
        for (parentSS = ss.getParentSubpart(); parentSS != null; parentSS = parentSS.getParentSubpart()) {
            parentSubpart = parentSS.getItype().getAbbv() + " - " + parentSubpart;
        }
        ((SchedulingSubpartEditForm)this.form).setParentSubpart(parentSubpart);
        ((SchedulingSubpartEditForm)this.form).setManagingDeptName(ss.getManagingDept() == null ? null : ss.getManagingDept().getManagingDeptLabel());
        ((SchedulingSubpartEditForm)this.form).setControllingDept(ss.getControllingDept().getUniqueId());
    }

    private void setupDatePatterns(SchedulingSubpart ss) throws Exception {
        DatePattern selectedDatePattern = ss.effectiveDatePattern();
        if (selectedDatePattern != null) {
            List<DatePattern> children = selectedDatePattern.findChildren();
            for (DatePattern dp : children) {
                if (((SchedulingSubpartEditForm)this.form).getDatePatternPrefs().contains(dp.getUniqueId().toString())) continue;
                ((SchedulingSubpartEditForm)this.form).addToDatePatternPrefs(dp.getUniqueId().toString(), PreferenceLevel.PREF_LEVEL_NEUTRAL);
            }
            ((SchedulingSubpartEditForm)this.form).sortDatePatternPrefs(((SchedulingSubpartEditForm)this.form).getDatePatternPrefs(), ((SchedulingSubpartEditForm)this.form).getDatePatternPrefLevels(), children);
        }
    }
}

