/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.servlet.ServletRequest;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.ExamEditForm;
import org.unitime.timetable.form.InstructionalOfferingListForm;
import org.unitime.timetable.form.PreferencesForm;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DatePatternPref;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamPeriodPref;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.InstructorAttribute;
import org.unitime.timetable.model.InstructorAttributePref;
import org.unitime.timetable.model.InstructorCoursePref;
import org.unitime.timetable.model.InstructorPref;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.MidtermPeriodPreferenceModel;
import org.unitime.timetable.model.PeriodPreferenceModel;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.base.BaseDatePatternPref;
import org.unitime.timetable.model.dao.BuildingDAO;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.DatePatternDAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.DistributionTypeDAO;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao.InstructorAttributeDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.RoomFeatureDAO;
import org.unitime.timetable.model.dao.RoomGroupDAO;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.TimePatternDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.rooms.PeriodPreferencesBackend;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.WebSolver;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.interactive.ClassAssignmentDetails;
import org.unitime.timetable.solver.interactive.Hint;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.util.NameFormat;
import org.unitime.timetable.util.duration.DurationModel;
import org.unitime.timetable.webutil.RequiredTimeTable;

public abstract class PreferencesAction2<T extends PreferencesForm>
extends UniTimeAction<T> {
    private static final long serialVersionUID = 1693039471914780672L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    public static final String TIME_PATTERN_GRID_ATTR = "timePatternGrid";
    public static final String HASH_ATTR = "hash";
    public final String HASH_TIME_PREF = "TimePref";
    public final String HASH_RM_GROUP = "RoomGroupPref";
    public final String HASH_RM_PREF = "RoomPref";
    public final String HASH_RM_FEAT_PREF = "RoomFeatPref";
    public final String HASH_BLDG_PREF = "BldgPref";
    public final String HASH_DIST_PREF = "DistPref";
    public final String HASH_PERIOD_PREF = "PeriodPref";
    public final String HASH_DATE_PATTERN_PREF = "DatePatternPref";
    public final String HASH_COURSE_PREF = "CoursePref";
    public final String HASH_INSTRUCTOR_PREF = "InstructorPref";
    public final String HASH_ATTRIBUTE_PREF = "AttributePref";

    public String execute() throws Exception {
        LookupTables.setupItypes(this.request, true);
        LookupTables.setupPrefLevels(this.request);
        this.request.setAttribute("prefLevelsSoftList", PreferenceLevel.getPreferenceLevelListSoftOnly());
        return null;
    }

    protected void processPrefAction() {
        if (this.op == null) {
            this.op = ((PreferencesForm)this.form).getOp();
        }
        if (this.op == null) {
            return;
        }
        if (MSG.actionAddRoomGroupPreference().equals(this.op)) {
            this.addRoomGroup();
        }
        if (MSG.actionAddRoomPreference().equals(this.op)) {
            this.addRoomPref();
        }
        if (MSG.actionAddBuildingPreference().equals(this.op)) {
            this.addBldgPref();
        }
        if (MSG.actionAddDistributionPreference().equals(this.op)) {
            this.addDistPref();
        }
        if (MSG.actionAddRoomFeaturePreference().equals(this.op)) {
            this.addRoomFeatPref();
        }
        if (MSG.actionAddTimePreference().equals(this.op)) {
            this.addTimePattern();
        }
        if (MSG.actionAddCoursePreference().equals(this.op)) {
            this.addCoursePref();
        }
        if (MSG.actionAddInstructorPreference().equals(this.op)) {
            this.addInstructorPref();
        }
        if (MSG.actionAddAttributePreference().equals(this.op)) {
            this.addAttributePref();
        }
        if (MSG.actionRemoveBuildingPreference().equals(this.op) || MSG.actionRemoveDistributionPreference().equals(this.op) || MSG.actionRemoveRoomFeaturePreference().equals(this.op) || MSG.actionRemoveRoomGroupPreference().equals(this.op) || MSG.actionRemoveRoomPreference().equals(this.op) || MSG.actionRemoveTimePattern().equals(this.op) || MSG.actionRemoveInstructor().equals(this.op) || MSG.actionRemoveCoursePreference().equals(this.op) || MSG.actionRemoveAttributePreference().equals(this.op) || MSG.actionRemoveInstructorPreference().equals(this.op)) {
            this.doDelete();
        }
    }

    private void addRoomGroup() {
        List<String> lst = ((PreferencesForm)this.form).getRoomGroups();
        if (((PreferencesForm)this.form).checkPrefs(lst)) {
            for (int i = 0; i < 2; ++i) {
                ((PreferencesForm)this.form).addToRoomGroups("-", "-");
            }
            this.request.setAttribute(HASH_ATTR, (Object)"RoomGroupPref");
        } else {
            this.addFieldError("roomGroup", MSG.errorInvalidRoomGroup());
        }
    }

    protected void addBldgPref() {
        List<String> lst = ((PreferencesForm)this.form).getBldgPrefs();
        if (((PreferencesForm)this.form).checkPrefs(lst)) {
            for (int i = 0; i < 2; ++i) {
                ((PreferencesForm)this.form).addToBldgPrefs("-", "-");
            }
            this.request.setAttribute(HASH_ATTR, (Object)"BldgPref");
        } else {
            this.addFieldError("bldgPrefs", MSG.errorInvalidBuildingPreference());
        }
    }

    protected void addDistPref() {
        List<String> lst = ((PreferencesForm)this.form).getDistPrefs();
        if (((PreferencesForm)this.form).checkPrefs(lst)) {
            for (int i = 0; i < 2; ++i) {
                ((PreferencesForm)this.form).addToDistPrefs("-", "-");
            }
            this.request.setAttribute(HASH_ATTR, (Object)"DistPref");
        } else {
            this.addFieldError("distPrefs", MSG.errorInvalidDistributionPreference());
        }
    }

    protected void addCoursePref() {
        List<String> lst = ((PreferencesForm)this.form).getCoursePrefs();
        if (((PreferencesForm)this.form).checkPrefs(lst)) {
            for (int i = 0; i < 2; ++i) {
                ((PreferencesForm)this.form).addToCoursePrefs("-", "-");
            }
            this.request.setAttribute(HASH_ATTR, (Object)"CoursePref");
        } else {
            this.addFieldError("coursePrefs", MSG.errorInvalidCoursePreference());
        }
    }

    protected void addInstructorPref() {
        List<String> lst = ((PreferencesForm)this.form).getInstructorPrefs();
        if (((PreferencesForm)this.form).checkPrefs(lst)) {
            for (int i = 0; i < 2; ++i) {
                ((PreferencesForm)this.form).addToInstructorPrefs("-", "-");
            }
            this.request.setAttribute(HASH_ATTR, (Object)"InstructorPref");
        } else {
            this.addFieldError("instructorPrefs", MSG.errorInvalidAttributePreference());
        }
    }

    protected void addAttributePref() {
        List<String> lst = ((PreferencesForm)this.form).getAttributePrefs();
        if (((PreferencesForm)this.form).checkPrefs(lst)) {
            for (int i = 0; i < 2; ++i) {
                ((PreferencesForm)this.form).addToAttributePrefs("-", "-");
            }
            this.request.setAttribute(HASH_ATTR, (Object)"AttributePref");
        } else {
            this.addFieldError("attributePrefs", MSG.errorInvalidAttributePreference());
        }
    }

    protected void addRoomFeatPref() {
        List<String> lst = ((PreferencesForm)this.form).getRoomFeaturePrefs();
        if (((PreferencesForm)this.form).checkPrefs(lst)) {
            for (int i = 0; i < 2; ++i) {
                ((PreferencesForm)this.form).addToRoomFeatPrefs("-", "-");
            }
            this.request.setAttribute(HASH_ATTR, (Object)"RoomFeatPref");
        } else {
            this.addFieldError("roomFeaturePrefs", MSG.errorInvalidRoomFeaturePreference());
        }
    }

    protected void addTimePattern() {
        if ("-".equals(((PreferencesForm)this.form).getTimePattern())) {
            this.addFieldError("timePrefs", MSG.errorTimePatternNotSelected());
        } else {
            if (((PreferencesForm)this.form).getTimePatterns() == null) {
                ((PreferencesForm)this.form).setTimePatterns(new Vector<String>());
            }
            ((PreferencesForm)this.form).getTimePatterns().add(((PreferencesForm)this.form).getTimePattern());
            TimePattern tp = (TimePattern)new TimePatternDAO().get(Long.valueOf(((PreferencesForm)this.form).getTimePattern()));
            if (tp.getTimePatternModel().isExactTime()) {
                Iterator<String> i = ((PreferencesForm)this.form).getTimePatterns().iterator();
                while (i.hasNext()) {
                    String patternId = i.next();
                    TimePattern tpx = (TimePattern)new TimePatternDAO().get(Long.valueOf(patternId));
                    if (tpx.getTimePatternModel().isExactTime()) continue;
                    i.remove();
                }
            } else {
                Iterator<String> i = ((PreferencesForm)this.form).getTimePatterns().iterator();
                while (i.hasNext()) {
                    String patternId = i.next();
                    TimePattern tpx = (TimePattern)new TimePatternDAO().get(Long.valueOf(patternId));
                    if (!tpx.getTimePatternModel().isExactTime()) continue;
                    i.remove();
                }
            }
            this.request.setAttribute(HASH_ATTR, (Object)"TimePref");
        }
    }

    protected void addRoomPref() {
        List<String> lst = ((PreferencesForm)this.form).getRoomPrefs();
        if (((PreferencesForm)this.form).checkPrefs(lst)) {
            for (int i = 0; i < 2; ++i) {
                ((PreferencesForm)this.form).addToRoomPrefs("-", "-");
            }
            this.request.setAttribute(HASH_ATTR, (Object)"RoomPref");
        } else {
            this.addFieldError("roomPrefs", MSG.errorInvalidRoomPreference());
        }
    }

    protected void doCancel(String subpartId) {
        SchedulingSubpartDAO sdao = new SchedulingSubpartDAO();
        SchedulingSubpart ss = (SchedulingSubpart)sdao.get(Long.valueOf(subpartId));
        InstructionalOffering io = ss.getInstrOfferingConfig().getInstructionalOffering();
        CourseOffering co = io.getControllingCourseOffering();
        InstructionalOfferingListForm frm2 = new InstructionalOfferingListForm();
        frm2.setSubjectAreaIds(new String[]{co.getSubjectArea().getUniqueId().toString()});
        frm2.setSubjectAreaAbbv(co.getSubjectAreaAbbv());
        frm2.setCourseNbr(co.getCourseNbr());
        frm2.setCtrlInstrOfferingId(co.getUniqueId().toString());
        frm2.setIsControl(co.isIsControl());
        this.request.setAttribute("subjectAreaId", (Object)co.getSubjectArea().getUniqueId().toString());
        this.request.setAttribute("instructionalOfferingListForm", (Object)frm2);
    }

    protected void doDelete() {
        String deleteType = this.request.getParameter("deleteType");
        int deleteId = -1;
        try {
            deleteId = Integer.parseInt(this.request.getParameter("deleteId"));
        }
        catch (Exception e) {
            deleteId = -1;
        }
        if (deleteType != null && deleteId >= 0) {
            List<String> lstL;
            List<String> lst;
            if (deleteType.equals("roomPref")) {
                lst = ((PreferencesForm)this.form).getRoomPrefs();
                lstL = ((PreferencesForm)this.form).getRoomPrefLevels();
                lst.remove(deleteId);
                lstL.remove(deleteId);
                ((PreferencesForm)this.form).setRoomPrefs(lst);
                ((PreferencesForm)this.form).setRoomPrefLevels(lstL);
                this.request.setAttribute(HASH_ATTR, (Object)"RoomPref");
            }
            if (deleteType.equals("rgPref")) {
                lst = ((PreferencesForm)this.form).getRoomGroups();
                lstL = ((PreferencesForm)this.form).getRoomGroupLevels();
                lst.remove(deleteId);
                lstL.remove(deleteId);
                ((PreferencesForm)this.form).setRoomGroups(lst);
                ((PreferencesForm)this.form).setRoomGroupLevels(lstL);
                this.request.setAttribute(HASH_ATTR, (Object)"RoomGroupPref");
            }
            if (deleteType.equals("bldgPref")) {
                lst = ((PreferencesForm)this.form).getBldgPrefs();
                lstL = ((PreferencesForm)this.form).getBldgPrefLevels();
                lst.remove(deleteId);
                lstL.remove(deleteId);
                ((PreferencesForm)this.form).setBldgPrefs(lst);
                ((PreferencesForm)this.form).setBldgPrefLevels(lstL);
                this.request.setAttribute(HASH_ATTR, (Object)"BldgPref");
            }
            if (deleteType.equals("distPref")) {
                lst = ((PreferencesForm)this.form).getDistPrefs();
                lstL = ((PreferencesForm)this.form).getDistPrefLevels();
                lst.remove(deleteId);
                lstL.remove(deleteId);
                ((PreferencesForm)this.form).setDistPrefs(lst);
                ((PreferencesForm)this.form).setDistPrefLevels(lstL);
                this.request.setAttribute(HASH_ATTR, (Object)"DistPref");
            }
            if (deleteType.equals("roomFeaturePref")) {
                lst = ((PreferencesForm)this.form).getRoomFeaturePrefs();
                lstL = ((PreferencesForm)this.form).getRoomFeaturePrefLevels();
                lst.remove(deleteId);
                lstL.remove(deleteId);
                ((PreferencesForm)this.form).setRoomFeaturePrefs(lst);
                ((PreferencesForm)this.form).setRoomFeaturePrefLevels(lstL);
                this.request.setAttribute(HASH_ATTR, (Object)"RoomFeatPref");
            }
            if (deleteType.equals("timePattern")) {
                List<String> tps = ((PreferencesForm)this.form).getTimePatterns();
                tps.remove(deleteId);
                ((PreferencesForm)this.form).setTimePatterns(tps);
                this.request.setAttribute(HASH_ATTR, (Object)"TimePref");
            }
            if (deleteType.equals("dpPref")) {
                lst = ((PreferencesForm)this.form).getDatePatternPrefs();
                lstL = ((PreferencesForm)this.form).getDatePatternPrefLevels();
                lst.remove(deleteId);
                lstL.remove(deleteId);
                ((PreferencesForm)this.form).setDatePatternPrefs(lst);
                ((PreferencesForm)this.form).setDatePatternPrefLevels(lstL);
                this.request.setAttribute(HASH_ATTR, (Object)"RoomGroupPref");
            }
            if (deleteType.equals("coursePref")) {
                lst = ((PreferencesForm)this.form).getCoursePrefs();
                lstL = ((PreferencesForm)this.form).getCoursePrefLevels();
                lst.remove(deleteId);
                lstL.remove(deleteId);
                ((PreferencesForm)this.form).setCoursePrefs(lst);
                ((PreferencesForm)this.form).setCoursePrefLevels(lstL);
                this.request.setAttribute(HASH_ATTR, (Object)"CoursePref");
            }
            if (deleteType.equals("attributePref")) {
                lst = ((PreferencesForm)this.form).getAttributePrefs();
                lstL = ((PreferencesForm)this.form).getAttributePrefLevels();
                lst.remove(deleteId);
                lstL.remove(deleteId);
                ((PreferencesForm)this.form).setAttributePrefs(lst);
                ((PreferencesForm)this.form).setAttributePrefLevels(lstL);
                this.request.setAttribute(HASH_ATTR, (Object)"AttributePref");
            }
            if (deleteType.equals("instructorPref")) {
                lst = ((PreferencesForm)this.form).getInstructorPrefs();
                lstL = ((PreferencesForm)this.form).getInstructorPrefLevels();
                lst.remove(deleteId);
                lstL.remove(deleteId);
                ((PreferencesForm)this.form).setInstructorPrefs(lst);
                this.request.setAttribute(HASH_ATTR, (Object)"InstructorPref");
            }
        }
    }

    protected void doClear(Set s, Preference.Type ... typesArray) {
        int types = Preference.Type.toInt(typesArray);
        Iterator i = s.iterator();
        while (i.hasNext()) {
            Preference p = (Preference)i.next();
            if (!p.getType().in(types)) continue;
            i.remove();
        }
    }

    protected void doUpdate(PreferenceGroup pg, Set s, boolean timeVertical, Preference.Type ... typesArray) throws Exception {
        Preference ap;
        Preference sameParentAp;
        Preference gp;
        Comparable dp2;
        String pref;
        Preference rp;
        Preference p;
        Iterator j;
        String pref2;
        String id;
        List<String> lstL;
        List<String> lst;
        int i;
        pg.setPreferences(s);
        int types = Preference.Type.toInt(typesArray);
        Iterator i2 = s.iterator();
        while (i2.hasNext()) {
            Preference p2 = (Preference)i2.next();
            if (!p2.getType().in(types)) continue;
            i2.remove();
        }
        if (Preference.Type.TIME.in(types)) {
            if (pg instanceof DepartmentalInstructor) {
                if (((PreferencesForm)this.form).getAvailability() != null && (((PreferencesForm)this.form).getAvailability().length() == 336 || ((PreferencesForm)this.form).getAvailability().length() == 2016)) {
                    TimePref tp = new TimePref();
                    tp.setOwner(pg);
                    tp.setPreference(((PreferencesForm)this.form).getAvailability());
                    tp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
                    tp.setTimePattern(null);
                    s.add(tp);
                }
            } else {
                Set parentTimePrefs = pg.effectivePreferences(TimePref.class, false);
                List<String> lst2 = ((PreferencesForm)this.form).getTimePatterns();
                for (i = 0; i < lst2.size(); ++i) {
                    String id2 = lst2.get(i);
                    this.addToTimePref(pg, id2, s, i, timeVertical, parentTimePrefs);
                }
                if (parentTimePrefs != null && !parentTimePrefs.isEmpty()) {
                    Iterator i3 = parentTimePrefs.iterator();
                    while (i3.hasNext()) {
                        TimePref tp = (TimePref)((TimePref)i3.next()).clone();
                        tp.setOwner(pg);
                        tp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral));
                        s.add(tp);
                    }
                }
            }
        }
        if (Preference.Type.ROOM.in(types)) {
            lst = ((PreferencesForm)this.form).getRoomPrefs();
            lstL = ((PreferencesForm)this.form).getRoomPrefLevels();
            Set parentRoomPrefs = pg.effectivePreferences(RoomPref.class);
            for (int i4 = 0; i4 < lst.size(); ++i4) {
                id = lst.get(i4);
                if (id == null || id.equals("-")) continue;
                pref2 = lstL.get(i4);
                Debug.debug("Room: " + id + ": " + pref2);
                LocationDAO rdao = new LocationDAO();
                Location room = (Location)rdao.get(Long.valueOf(id));
                RoomPref rp2 = new RoomPref();
                rp2.setOwner(pg);
                rp2.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(pref2)));
                rp2.setRoom(room);
                RoomPref sameParentRp = null;
                j = parentRoomPrefs.iterator();
                while (j.hasNext()) {
                    p = (RoomPref)j.next();
                    if (!((RoomPref)p).isSame(rp2)) continue;
                    if (p.getPrefLevel().equals(rp2.getPrefLevel())) {
                        sameParentRp = rp2;
                    }
                    j.remove();
                    break;
                }
                if (sameParentRp != null) continue;
                s.add(rp2);
            }
            if (parentRoomPrefs != null && !parentRoomPrefs.isEmpty()) {
                Iterator i5 = parentRoomPrefs.iterator();
                while (i5.hasNext()) {
                    rp = (RoomPref)((RoomPref)i5.next()).clone();
                    rp.setOwner(pg);
                    rp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral));
                    s.add(rp);
                }
            }
        }
        if (Preference.Type.BUILDING.in(types)) {
            lst = ((PreferencesForm)this.form).getBldgPrefs();
            lstL = ((PreferencesForm)this.form).getBldgPrefLevels();
            Set parentBuildingPrefs = pg.effectivePreferences(BuildingPref.class);
            for (int i6 = 0; i6 < lst.size(); ++i6) {
                id = lst.get(i6);
                if (id == null || id.equals("-")) continue;
                pref2 = lstL.get(i6);
                Debug.debug("Bldg: " + id + ": " + pref2);
                BuildingDAO bdao = new BuildingDAO();
                Building bldg = (Building)bdao.get(Long.valueOf(id));
                BuildingPref bp = new BuildingPref();
                bp.setOwner(pg);
                bp.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(pref2)));
                bp.setBuilding(bldg);
                BuildingPref sameParentBp = null;
                j = parentBuildingPrefs.iterator();
                while (j.hasNext()) {
                    p = (BuildingPref)j.next();
                    if (!((BuildingPref)p).isSame(bp)) continue;
                    if (p.getPrefLevel().equals(bp.getPrefLevel())) {
                        sameParentBp = bp;
                    }
                    j.remove();
                    break;
                }
                if (sameParentBp != null) continue;
                s.add(bp);
            }
            if (parentBuildingPrefs != null && !parentBuildingPrefs.isEmpty()) {
                Iterator i7 = parentBuildingPrefs.iterator();
                while (i7.hasNext()) {
                    BuildingPref bp = (BuildingPref)((BuildingPref)i7.next()).clone();
                    bp.setOwner(pg);
                    bp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral));
                    s.add(bp);
                }
            }
        }
        if (Preference.Type.DISTRIBUTION.in(types)) {
            lst = ((PreferencesForm)this.form).getDistPrefs();
            lstL = ((PreferencesForm)this.form).getDistPrefLevels();
            for (i = 0; i < lst.size(); ++i) {
                String id3 = lst.get(i);
                if (id3 == null || id3.equals("-")) continue;
                pref = lstL.get(i);
                Debug.debug("Dist: " + id3 + ": " + pref);
                DistributionTypeDAO ddao = new DistributionTypeDAO();
                DistributionType dist = (DistributionType)ddao.get(Long.valueOf(id3));
                dp2 = new DistributionPref();
                dp2.setOwner(pg);
                dp2.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(pref)));
                dp2.setDistributionType(dist);
                dp2.setStructure(DistributionPref.Structure.AllClasses);
                s.add(dp2);
            }
        }
        if (Preference.Type.PERIOD.in(types) && pg instanceof Exam) {
            Exam exam = (Exam)pg;
            if (ApplicationProperty.LegacyPeriodPreferences.isTrue()) {
                ExamSolverProxy solver = WebSolver.getExamSolver(this.request.getSession());
                ExamAssignment assignment = null;
                if (solver != null && exam != null && exam.getUniqueId() != null) {
                    assignment = solver.getAssignment(exam.getUniqueId());
                } else if (exam.getAssignedPeriod() != null) {
                    assignment = new ExamAssignment(exam);
                }
                if (1 == exam.getExamType().getType()) {
                    MidtermPeriodPreferenceModel epx = new MidtermPeriodPreferenceModel(exam.getSession(), exam.getExamType(), assignment);
                    epx.load(exam);
                    epx.load(this.request);
                    epx.save(s, exam);
                } else {
                    PeriodPreferenceModel px = new PeriodPreferenceModel(exam.getSession(), assignment, exam.getExamType().getUniqueId());
                    px.load(exam);
                    RequiredTimeTable rtt = new RequiredTimeTable(px);
                    rtt.setName("PeriodPref");
                    rtt.update((ServletRequest)this.request);
                    px.save(s, exam);
                }
            } else {
                String pattern = this.request.getParameter("periodPrefs");
                if (pattern.indexOf(58) >= 0) {
                    pattern = pattern.substring(pattern.lastIndexOf(58) + 1);
                }
                int idx = 0;
                String defaultPref = exam.getExamType().getType() == 1 ? PreferenceLevel.sProhibited : PreferenceLevel.sNeutral;
                for (ExamPeriod period : ExamPeriod.findAll(exam.getSession().getUniqueId(), exam.getExamType().getUniqueId())) {
                    String pref3;
                    char ch = exam.getExamType().getType() == 1 ? (char)'P' : '2';
                    try {
                        ch = pattern.charAt(idx++);
                    }
                    catch (IndexOutOfBoundsException dp2) {
                        // empty catch block
                    }
                    if (defaultPref.equals(pref3 = PreferenceLevel.char2prolog(ch))) continue;
                    ExamPeriodPref p3 = new ExamPeriodPref();
                    p3.setOwner(pg);
                    p3.setExamPeriod(period);
                    p3.setPrefLevel(PreferenceLevel.getPreferenceLevel(pref3));
                    s.add(p3);
                }
            }
        }
        if (Preference.Type.ROOM_FEATURE.in(types)) {
            lst = ((PreferencesForm)this.form).getRoomFeaturePrefs();
            lstL = ((PreferencesForm)this.form).getRoomFeaturePrefLevels();
            Set parentRoomFeaturePrefs = pg.effectivePreferences(RoomFeaturePref.class);
            for (int i8 = 0; i8 < lst.size(); ++i8) {
                id = lst.get(i8);
                if (id == null || id.equals("-")) continue;
                pref2 = lstL.get(i8);
                Debug.debug("Room Feat: " + id + ": " + pref2);
                RoomFeatureDAO rfdao = new RoomFeatureDAO();
                RoomFeature rf = (RoomFeature)rfdao.get(Long.valueOf(id));
                RoomFeaturePref rfp = new RoomFeaturePref();
                rfp.setOwner(pg);
                rfp.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(pref2)));
                rfp.setRoomFeature(rf);
                RoomFeaturePref sameParentRfp = null;
                j = parentRoomFeaturePrefs.iterator();
                while (j.hasNext()) {
                    p = (RoomFeaturePref)j.next();
                    if (!((RoomFeaturePref)p).isSame(rfp)) continue;
                    if (p.getPrefLevel().equals(rfp.getPrefLevel())) {
                        sameParentRfp = rfp;
                    }
                    j.remove();
                    break;
                }
                if (sameParentRfp != null) continue;
                s.add(rfp);
            }
            if (parentRoomFeaturePrefs != null && !parentRoomFeaturePrefs.isEmpty()) {
                Iterator i9 = parentRoomFeaturePrefs.iterator();
                while (i9.hasNext()) {
                    rp = (RoomFeaturePref)((RoomFeaturePref)i9.next()).clone();
                    rp.setOwner(pg);
                    rp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral));
                    s.add(rp);
                }
            }
        }
        if (Preference.Type.ROOM_GROUP.in(types)) {
            lst = ((PreferencesForm)this.form).getRoomGroups();
            lstL = ((PreferencesForm)this.form).getRoomGroupLevels();
            Set parentRoomGroupPrefs = pg.effectivePreferences(RoomGroupPref.class);
            for (int i10 = 0; i10 < lst.size(); ++i10) {
                id = lst.get(i10);
                if (id == null || id.equals("-")) continue;
                pref2 = lstL.get(i10);
                Debug.debug("Roomgr: " + id + ": " + pref2);
                RoomGroupDAO gdao = new RoomGroupDAO();
                RoomGroup gr = (RoomGroup)gdao.get(Long.valueOf(id));
                RoomGroupPref gp2 = new RoomGroupPref();
                gp2.setOwner(pg);
                gp2.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(pref2)));
                gp2.setRoomGroup(gr);
                RoomGroupPref sameParentGp = null;
                j = parentRoomGroupPrefs.iterator();
                while (j.hasNext()) {
                    p = (RoomGroupPref)j.next();
                    if (!((RoomGroupPref)p).isSame(gp2)) continue;
                    if (p.getPrefLevel().equals(gp2.getPrefLevel())) {
                        sameParentGp = gp2;
                    }
                    j.remove();
                    break;
                }
                if (sameParentGp != null) continue;
                s.add(gp2);
            }
            if (parentRoomGroupPrefs != null && !parentRoomGroupPrefs.isEmpty()) {
                Iterator i11 = parentRoomGroupPrefs.iterator();
                while (i11.hasNext()) {
                    gp = (RoomGroupPref)((RoomGroupPref)i11.next()).clone();
                    gp.setOwner(pg);
                    gp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral));
                    s.add(gp);
                }
            }
        }
        if (Preference.Type.DATE.in(types)) {
            lst = ((PreferencesForm)this.form).getDatePatternPrefs();
            lstL = ((PreferencesForm)this.form).getDatePatternPrefLevels();
            Set parentDatePatternPrefs = pg.effectivePreferences(DatePatternPref.class);
            for (int i12 = 0; i12 < lst.size(); ++i12) {
                id = lst.get(i12);
                if (id == null || id.equals("-") || lstL.get(i12).equals(PreferenceLevel.PREF_LEVEL_NEUTRAL)) continue;
                pref2 = lstL.get(i12);
                Debug.debug("Datepattern: " + id + ": " + pref2);
                DatePatternDAO dpdao = new DatePatternDAO();
                dp2 = (DatePattern)dpdao.get(Long.valueOf(id));
                DatePatternPref dpp = new DatePatternPref();
                dpp.setOwner(pg);
                dpp.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(pref2)));
                dpp.setDatePattern((DatePattern)dp2);
                DatePatternPref sameParentDp = null;
                j = parentDatePatternPrefs.iterator();
                while (j.hasNext()) {
                    p = (DatePatternPref)j.next();
                    if (!((DatePatternPref)p).isSame(dpp)) continue;
                    if (p.getPrefLevel().equals(dpp.getPrefLevel())) {
                        sameParentDp = dpp;
                    }
                    j.remove();
                    break;
                }
                if (sameParentDp != null) continue;
                s.add(dpp);
            }
            if (parentDatePatternPrefs != null && !parentDatePatternPrefs.isEmpty()) {
                Iterator i13 = parentDatePatternPrefs.iterator();
                while (i13.hasNext()) {
                    gp = (DatePatternPref)((DatePatternPref)i13.next()).clone();
                    if (!pg.effectiveDatePattern().findChildren().contains(((BaseDatePatternPref)gp).getDatePattern())) continue;
                    gp.setOwner(pg);
                    gp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral));
                    s.add(gp);
                }
            }
        }
        if (Preference.Type.COURSE.in(types)) {
            lst = ((PreferencesForm)this.form).getCoursePrefs();
            lstL = ((PreferencesForm)this.form).getCoursePrefLevels();
            for (int i14 = 0; i14 < lst.size(); ++i14) {
                String id4 = lst.get(i14);
                if (id4 == null || id4.equals("-")) continue;
                pref = lstL.get(i14);
                Debug.debug("Course: " + id4 + ": " + pref);
                CourseOfferingDAO cdao = new CourseOfferingDAO();
                CourseOffering course = (CourseOffering)cdao.get(Long.valueOf(id4));
                InstructorCoursePref cp = new InstructorCoursePref();
                cp.setOwner(pg);
                cp.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(pref)));
                cp.setCourse(course);
                s.add(cp);
            }
        }
        if (Preference.Type.ATTRIBUTE.in(types)) {
            lst = ((PreferencesForm)this.form).getAttributePrefs();
            lstL = ((PreferencesForm)this.form).getAttributePrefLevels();
            Set parentAttributePrefs = pg.effectivePreferences(InstructorAttributePref.class);
            for (int i15 = 0; i15 < lst.size(); ++i15) {
                id = lst.get(i15);
                if (id == null || id.equals("-")) continue;
                pref2 = lstL.get(i15);
                Debug.debug("Attribute: " + id + ": " + pref2);
                InstructorAttributeDAO adao = new InstructorAttributeDAO();
                InstructorAttribute attribute = (InstructorAttribute)adao.get(Long.valueOf(id));
                InstructorAttributePref ap2 = new InstructorAttributePref();
                ap2.setOwner(pg);
                ap2.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(pref2)));
                ap2.setAttribute(attribute);
                sameParentAp = null;
                j = parentAttributePrefs.iterator();
                while (j.hasNext()) {
                    p = (InstructorAttributePref)j.next();
                    if (!((InstructorAttributePref)p).isSame(ap2)) continue;
                    if (p.getPrefLevel().equals(ap2.getPrefLevel())) {
                        sameParentAp = p;
                    }
                    j.remove();
                    break;
                }
                if (sameParentAp != null) continue;
                s.add(ap2);
            }
            if (parentAttributePrefs != null && !parentAttributePrefs.isEmpty()) {
                Iterator i16 = parentAttributePrefs.iterator();
                while (i16.hasNext()) {
                    ap = (InstructorAttributePref)((InstructorAttributePref)i16.next()).clone();
                    ap.setOwner(pg);
                    ap.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral));
                    s.add(ap);
                }
            }
        }
        if (Preference.Type.INSTRUCTOR.in(types)) {
            lst = ((PreferencesForm)this.form).getInstructorPrefs();
            lstL = ((PreferencesForm)this.form).getInstructorPrefLevels();
            Set parentInstructorPrefs = pg.effectivePreferences(InstructorPref.class);
            for (int i17 = 0; i17 < lst.size(); ++i17) {
                id = lst.get(i17);
                if (id == null || id.equals("-")) continue;
                pref2 = lstL.get(i17);
                Debug.debug("Instructor: " + id + ": " + pref2);
                DepartmentalInstructorDAO idao = new DepartmentalInstructorDAO();
                DepartmentalInstructor instructor = (DepartmentalInstructor)idao.get(Long.valueOf(id));
                InstructorPref ip = new InstructorPref();
                ip.setOwner(pg);
                ip.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(pref2)));
                ip.setInstructor(instructor);
                sameParentAp = null;
                j = parentInstructorPrefs.iterator();
                while (j.hasNext()) {
                    p = (InstructorPref)j.next();
                    if (!((InstructorPref)p).isSame(ip)) continue;
                    if (p.getPrefLevel().equals(ip.getPrefLevel())) {
                        sameParentAp = p;
                    }
                    j.remove();
                    break;
                }
                if (sameParentAp != null) continue;
                s.add(ip);
            }
            if (parentInstructorPrefs != null && !parentInstructorPrefs.isEmpty()) {
                Iterator i18 = parentInstructorPrefs.iterator();
                while (i18.hasNext()) {
                    ap = (InstructorPref)((InstructorPref)i18.next()).clone();
                    ap.setOwner(pg);
                    ap.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral));
                    s.add(ap);
                }
            }
        }
        pg.setPreferences(s);
    }

    protected void updateInstructorCoursePreferences(org.hibernate.Session hibSession, PreferenceGroup pg, CourseOffering course) {
        HashMap<Long, InstructorCoursePref> prefs = new HashMap<Long, InstructorCoursePref>();
        for (InstructorCoursePref pref : hibSession.createQuery("from InstructorCoursePref where course.uniqueId = :courseId").setLong("courseId", course.getUniqueId().longValue()).setCacheable(true).list()) {
            prefs.put(pref.getOwner().getUniqueId(), pref);
        }
        List<String> lst = ((PreferencesForm)this.form).getCoursePrefs();
        List<String> lstL = ((PreferencesForm)this.form).getCoursePrefLevels();
        for (int i = 0; i < lst.size(); ++i) {
            String id = lst.get(i);
            if (id == null || id.equals("-")) continue;
            String pref = lstL.get(i);
            Debug.debug("Course: " + id + ": " + pref);
            InstructorCoursePref cp = (InstructorCoursePref)prefs.remove(Long.valueOf(id));
            if (cp == null) {
                DepartmentalInstructor instructor = (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(Long.valueOf(id), hibSession);
                cp = new InstructorCoursePref();
                cp.setOwner(instructor);
                cp.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(pref)));
                cp.setCourse(course);
                instructor.getPreferences().add(cp);
                hibSession.saveOrUpdate((Object)instructor);
                continue;
            }
            if (cp.getPrefLevel().getPrefId().equals(Integer.valueOf(pref))) continue;
            cp.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(pref)));
            hibSession.saveOrUpdate((Object)cp);
        }
        for (InstructorCoursePref cp : prefs.values()) {
            cp.getOwner().getPreferences().remove(cp);
            hibSession.saveOrUpdate((Object)cp.getOwner());
        }
    }

    protected void addToTimePref(PreferenceGroup owner, String tpat, Set prefs, int idx, boolean timeVertical, Set parentTimePrefs) throws Exception {
        TimePatternDAO timePatternDao = new TimePatternDAO();
        TimePattern timePattern = tpat.equals("-1") ? null : (TimePattern)timePatternDao.get(Long.valueOf(tpat));
        boolean canUseHardTimePrefs = this.sessionContext.hasPermission(owner, Right.CanUseHardTimePrefs);
        RequiredTimeTable rtt = timePattern == null ? TimePattern.getDefaultRequiredTimeTable() : timePattern.getRequiredTimeTable(canUseHardTimePrefs);
        rtt.getModel().setDefaultSelection(RequiredTimeTable.getTimeGridSize(this.sessionContext.getUser()));
        rtt.setName("p" + idx);
        rtt.update((ServletRequest)this.request);
        TimePref tp = new TimePref();
        tp.setOwner(owner);
        tp.setPreference(rtt.getModel().getPreferences());
        tp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
        tp.setTimePattern(timePattern);
        TimePref sameParentTimePref = null;
        if (parentTimePrefs != null && !parentTimePrefs.isEmpty()) {
            Iterator i = parentTimePrefs.iterator();
            while (i.hasNext()) {
                TimePref parentTimePref = (TimePref)i.next();
                if (!parentTimePref.isSame(tp)) continue;
                if (parentTimePref.getPreference().equals(tp.getPreference()) && parentTimePref.getPrefLevel().equals(tp.getPrefLevel())) {
                    sameParentTimePref = parentTimePref;
                }
                i.remove();
                break;
            }
        }
        if (sameParentTimePref == null) {
            prefs.add(tp);
        }
    }

    protected void generateExamPeriodGrid(Exam exam, String op, boolean timeVertical, boolean editable) throws Exception {
        if (ApplicationProperty.LegacyPeriodPreferences.isTrue()) {
            ExamType type;
            ExamSolverProxy solver = WebSolver.getExamSolver(this.request.getSession());
            ExamAssignment assignment = null;
            if (solver != null && exam != null) {
                assignment = solver.getAssignment(exam.getUniqueId());
            } else if (exam != null && exam.getAssignedPeriod() != null) {
                assignment = new ExamAssignment(exam);
            }
            ExamType examType = type = exam == null ? (ExamType)ExamTypeDAO.getInstance().get(((ExamEditForm)this.form).getExamType()) : exam.getExamType();
            if (1 == type.getType()) {
                MidtermPeriodPreferenceModel epx = new MidtermPeriodPreferenceModel(exam == null ? (Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId()) : exam.getSession(), type, assignment);
                if (exam != null) {
                    epx.load(exam);
                }
                ((PreferencesForm)this.form).setHasNotAvailable(true);
                if (!"init".equals(op)) {
                    epx.load(this.request);
                }
                this.request.setAttribute("ExamPeriodGrid", (Object)epx.print(editable, editable ? 0 : exam.getLength()));
            } else {
                PeriodPreferenceModel px = new PeriodPreferenceModel(exam == null ? (Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId()) : exam.getSession(), assignment, type.getUniqueId());
                if (exam != null) {
                    px.load(exam);
                }
                px.setAllowHard(this.sessionContext.hasPermission(exam, Right.CanUseHardTimePrefs));
                ((PreferencesForm)this.form).setHasNotAvailable(px.hasNotAvailable());
                RequiredTimeTable rtt = new RequiredTimeTable(px);
                rtt.setName("PeriodPref");
                if (!"init".equals(op)) {
                    rtt.update((ServletRequest)this.request);
                }
                this.request.setAttribute("ExamPeriodGrid", (Object)rtt.print(editable, timeVertical, editable, false));
            }
        } else {
            RoomInterface.PeriodPreferenceModel model = new PeriodPreferencesBackend().loadExamPeriodPreferences(WebSolver.getExamSolver(this.request.getSession()), exam, exam == null ? (ExamType)ExamTypeDAO.getInstance().get(((ExamEditForm)this.form).getExamType()) : exam.getExamType(), this.sessionContext);
            if (!op.equals("init") && this.request.getParameter("periodPrefs") != null) {
                model.setPattern(this.request.getParameter("periodPrefs"));
            }
            ((PreferencesForm)this.form).setHasNotAvailable(model.hasNotAvailable());
            if (editable) {
                this.request.setAttribute("ExamPeriodGrid", (Object)("<div id='UniTimeGWT:PeriodPreferences'><input type=\"hidden\" name=\"periodPrefs\" value=\"" + model.getPattern() + "\"></div>"));
            } else {
                this.request.setAttribute("ExamPeriodGrid", (Object)("<div id='UniTimeGWT:PeriodPreferences' style='display: none;'>" + model.getPattern() + "</div>"));
            }
        }
    }

    protected void generateTimePatternGrids(PreferenceGroup pg, int minutes, DurationModel dmod, DatePattern dpat, Set tpat, String op, boolean timeVertical, boolean editable, Vector leadInstructors) throws Exception {
        Vector timePrefs = null;
        List<String> tps = null;
        if ("init".equals(op)) {
            Set tp = pg.effectivePreferences(TimePref.class, leadInstructors, !editable);
            if (tp.size() > 0) {
                timePrefs = new Vector(tp);
                Collections.sort(timePrefs);
                tps = new Vector<String>();
                Enumeration e = timePrefs.elements();
                while (e.hasMoreElements()) {
                    TimePref timePref = (TimePref)e.nextElement();
                    if (timePref.getTimePatternModel().hasNotAvailablePreference()) {
                        ((PreferencesForm)this.form).setHasNotAvailable(true);
                    }
                    tps.add(timePref.getTimePattern() == null ? "-1" : timePref.getTimePattern().getUniqueId().toString());
                }
            } else if (tpat.size() > 0 && editable) {
                Vector x = new Vector(tpat);
                Collections.sort(x);
                tps = new Vector<String>();
                Enumeration e = x.elements();
                while (e.hasMoreElements()) {
                    TimePattern pat = (TimePattern)e.nextElement();
                    tps.add(pat.getUniqueId().toString());
                }
            }
            ((PreferencesForm)this.form).setTimePatterns(tps);
        } else {
            tps = ((PreferencesForm)this.form).getTimePatterns();
        }
        Assignment assignment = null;
        if (pg instanceof Class_ && this.sessionContext.hasPermission(Right.ClassAssignments)) {
            ClassAssignmentDetails ca = ClassAssignmentDetails.createClassAssignmentDetails(this.sessionContext, this.getCourseTimetablingSolverService().getSolver(), pg.getUniqueId(), true);
            if (ca != null) {
                String assignmentTable = PreferencesAction2.getAssignmentTable(this.sessionContext, this.getCourseTimetablingSolverService().getSolver(), ca, false, null, true);
                if (assignmentTable != null) {
                    this.request.setAttribute("assignmentInfo", (Object)assignmentTable);
                }
            } else {
                String assignmentTable;
                ClassAssignmentProxy cap = this.getClassAssignmentService().getAssignment();
                if (cap != null && (assignment = cap.getAssignment((Class_)pg)) != null && assignment.getUniqueId() != null && (ca = ClassAssignmentDetails.createClassAssignmentDetailsFromAssignment(this.sessionContext, assignment.getUniqueId(), true)) != null && (assignmentTable = PreferencesAction2.getAssignmentTable(this.sessionContext, this.getCourseTimetablingSolverService().getSolver(), ca, false, null, true)) != null) {
                    this.request.setAttribute("assignmentInfo", (Object)assignmentTable);
                }
            }
        }
        if (tps == null || tps.isEmpty()) {
            this.request.setAttribute(TIME_PATTERN_GRID_ATTR, (Object)MSG.errorTimePatternNotSelected());
        } else {
            int idx = 0;
            int deletedTimePatternIdx = -1;
            if ("timePattern".equals(this.request.getParameter("deleteType"))) {
                try {
                    deletedTimePatternIdx = Integer.parseInt(this.request.getParameter("deleteId"));
                }
                catch (Exception assignmentTable) {
                    // empty catch block
                }
            }
            for (String tp : tps) {
                TimePattern timePattern;
                TimePatternDAO timePatternDao = new TimePatternDAO();
                TimePattern timePattern2 = timePattern = tp.equals("-1") ? null : (TimePattern)timePatternDao.get(Long.valueOf(tp));
                RequiredTimeTable rtt = timePattern == null ? TimePattern.getDefaultRequiredTimeTable() : timePattern.getRequiredTimeTable(assignment == null ? null : assignment.getTimeLocation(), this.sessionContext.hasPermission(pg, Right.CanUseHardTimePrefs));
                rtt.getModel().setDefaultSelection(this.sessionContext.getUser().getProperty(UserProperty.GridSize));
                rtt.setName("p" + idx);
                if (!"init".equals(op)) {
                    if (deletedTimePatternIdx >= 0 && idx >= deletedTimePatternIdx) {
                        rtt.setName("p" + (idx + 1));
                        rtt.update((ServletRequest)this.request);
                        rtt.setName("p" + idx);
                    } else {
                        rtt.update((ServletRequest)this.request);
                    }
                }
                if (timePrefs != null && timePrefs.size() > 0 && "init".equals(op)) {
                    rtt.getModel().setPreferences(((TimePref)timePrefs.elementAt(idx)).getPreference());
                }
                String name = null;
                if (timePattern != null && !rtt.getModel().isExactTime()) {
                    if (dpat == null) {
                        name = timePattern.getName() + " <font color=\\'red\\'>" + MSG.warnNoMatchingDatePattern() + "</font>";
                    } else if (dpat.isPatternSet()) {
                        boolean allPatterns = true;
                        String matching = "";
                        for (DatePattern dch : dpat.findChildren()) {
                            if (dmod.isValidCombination(minutes, dch, timePattern)) {
                                matching = matching + (matching.isEmpty() ? "" : ", ") + dch.getName();
                                continue;
                            }
                            allPatterns = false;
                        }
                        if (matching.isEmpty()) {
                            name = timePattern.getName() + " <font color=\\'red\\'>" + MSG.warnNoMatchingDatePattern() + "</font>";
                        } else if (!allPatterns) {
                            name = timePattern.getName() + " (" + matching + ")";
                        }
                    } else if (!dmod.isValidCombination(minutes, dpat, timePattern)) {
                        name = timePattern.getName() + " <font color=\\'red\\'>" + MSG.warnNoMatchingDatePattern() + "</font>";
                    }
                }
                this.request.setAttribute("timePatternGrid_" + idx, (Object)rtt.print(editable, timeVertical, editable, false, name));
                ++idx;
            }
        }
    }

    protected void initPrefs(PreferenceGroup pg, Vector leadInstructors, boolean addBlankRows) {
        if (pg == null) {
            if (addBlankRows) {
                ((PreferencesForm)this.form).addBlankPrefRows();
            }
            return;
        }
        ((PreferencesForm)this.form).getRoomPrefs().clear();
        ((PreferencesForm)this.form).getRoomPrefLevels().clear();
        Set roomPrefs = pg.effectivePreferences(RoomPref.class, leadInstructors);
        for (RoomPref rp : roomPrefs) {
            Debug.debug("Adding room pref ... " + rp.getRoom().getUniqueId().toString());
            ((PreferencesForm)this.form).addToRoomPrefs(rp.getRoom().getUniqueId().toString(), rp.getPrefLevel().getUniqueId().toString());
        }
        ((PreferencesForm)this.form).getRoomFeaturePrefs().clear();
        ((PreferencesForm)this.form).getRoomFeaturePrefLevels().clear();
        Set roomFeatPrefs = pg.effectivePreferences(RoomFeaturePref.class, leadInstructors);
        for (RoomFeaturePref rfp : roomFeatPrefs) {
            Debug.debug("Adding room feature pref ... " + rfp.getRoomFeature().getUniqueId().toString());
            ((PreferencesForm)this.form).addToRoomFeatPrefs(rfp.getRoomFeature().getUniqueId().toString(), rfp.getPrefLevel().getUniqueId().toString());
        }
        ((PreferencesForm)this.form).getBldgPrefs().clear();
        ((PreferencesForm)this.form).getBldgPrefLevels().clear();
        Set bldgPrefs = pg.effectivePreferences(BuildingPref.class, leadInstructors);
        for (BuildingPref bp : bldgPrefs) {
            Debug.debug("Adding building pref ... " + bp.getBuilding().getUniqueId().toString());
            ((PreferencesForm)this.form).addToBldgPrefs(bp.getBuilding().getUniqueId().toString(), bp.getPrefLevel().getUniqueId().toString());
        }
        ((PreferencesForm)this.form).getDistPrefs().clear();
        ((PreferencesForm)this.form).getDistPrefLevels().clear();
        Set distPrefs = pg.effectivePreferences(DistributionPref.class, leadInstructors);
        for (DistributionPref dp : distPrefs) {
            Debug.debug("Adding distribution pref ... " + dp.getDistributionType().getUniqueId().toString());
            ((PreferencesForm)this.form).addToDistPrefs(dp.getDistributionType().getUniqueId().toString(), dp.getPrefLevel().getUniqueId().toString());
        }
        ((PreferencesForm)this.form).getRoomGroups().clear();
        ((PreferencesForm)this.form).getRoomGroupLevels().clear();
        Set rgPrefs = pg.effectivePreferences(RoomGroupPref.class, leadInstructors);
        for (RoomGroupPref bp : rgPrefs) {
            Debug.debug("Adding room group pref ... " + bp.getRoomGroup().getUniqueId().toString());
            ((PreferencesForm)this.form).addToRoomGroups(bp.getRoomGroup().getUniqueId().toString(), bp.getPrefLevel().getUniqueId().toString());
        }
        Set datePatternPrefs = pg.effectivePreferences(DatePatternPref.class);
        ((PreferencesForm)this.form).getDatePatternPrefs().clear();
        ((PreferencesForm)this.form).getDatePatternPrefLevels().clear();
        for (DatePatternPref dp : datePatternPrefs) {
            if (!dp.appliesTo(pg)) continue;
            Debug.debug("Adding date pattern pref ... " + dp.getDatePattern().getUniqueId().toString());
            ((PreferencesForm)this.form).addToDatePatternPrefs(dp.getDatePattern().getUniqueId().toString(), dp.getPrefLevel().getUniqueId().toString());
        }
        ((PreferencesForm)this.form).getCoursePrefs().clear();
        ((PreferencesForm)this.form).getCoursePrefLevels().clear();
        Set coursePrefs = pg.effectivePreferences(InstructorCoursePref.class, leadInstructors);
        for (InstructorCoursePref cp : coursePrefs) {
            Debug.debug("Adding course pref ... " + cp.getCourse().getCourseName());
            if (pg instanceof DepartmentalInstructor) {
                ((PreferencesForm)this.form).addToCoursePrefs(cp.getCourse().getUniqueId().toString(), cp.getPrefLevel().getUniqueId().toString());
                continue;
            }
            ((PreferencesForm)this.form).addToCoursePrefs(cp.getOwner().getUniqueId().toString(), cp.getPrefLevel().getUniqueId().toString());
        }
        ((PreferencesForm)this.form).getAttributePrefs().clear();
        ((PreferencesForm)this.form).getAttributePrefLevels().clear();
        Set attributePrefs = pg.effectivePreferences(InstructorAttributePref.class, leadInstructors);
        for (InstructorAttributePref ap : attributePrefs) {
            Debug.debug("Adding attribute pref ... " + ap.getAttribute().getName());
            ((PreferencesForm)this.form).addToAttributePrefs(ap.getAttribute().getUniqueId().toString(), ap.getPrefLevel().getUniqueId().toString());
        }
        ((PreferencesForm)this.form).getInstructorPrefs().clear();
        ((PreferencesForm)this.form).getInstructorPrefLevels().clear();
        Set instructorPrefs = pg.effectivePreferences(InstructorPref.class, leadInstructors);
        for (InstructorPref ap : instructorPrefs) {
            Debug.debug("Adding instructor pref ... " + ap.getInstructor().getName(NameFormat.LAST_FIRST_MIDDLE.reference()));
            ((PreferencesForm)this.form).addToInstructorPrefs(ap.getInstructor().getUniqueId().toString(), ap.getPrefLevel().getUniqueId().toString());
        }
        if (addBlankRows) {
            ((PreferencesForm)this.form).addBlankPrefRows();
        }
    }

    protected void clearPrefs() {
        ((PreferencesForm)this.form).clearPrefs();
    }

    public static String getAssignmentTable(SessionContext context, SolverProxy solver, ClassAssignmentDetails ca, boolean dispLinks, Hint selection, boolean dispDate) {
        int i;
        StringBuffer sb = new StringBuffer();
        if (ca.getTime() == null) {
            sb.append("<TR><TD colspan='2'><I>" + MSG.messageNotAssigned() + "</I></TD></TR>");
        } else {
            if (dispDate) {
                sb.append("<TR><TD>" + MSG.propertyDate() + "</TD><TD>" + ca.getAssignedTime().getDatePatternHtml() + "</TD></TR>");
            }
            sb.append("<TR><TD>" + MSG.propertyTime() + "</TD><TD>" + ca.getAssignedTime().toHtml(false, false, true, true) + "</TD></TR>");
            if (ca.getAssignedRoom() != null) {
                sb.append("<TR><TD>" + MSG.propertyRoom() + "</TD><TD>");
                for (i = 0; i < ca.getAssignedRoom().length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(ca.getAssignedRoom()[i].toHtml(false, false, true));
                }
                sb.append("</TD></TR>");
            }
        }
        if (ca.getInstructor() != null) {
            sb.append("<TR><TD>" + MSG.propertyInstructor() + "</TD><TD>" + ca.getInstructorHtml() + "</TD></TR>");
            if (!ca.getBtbInstructors().isEmpty()) {
                sb.append("<TR><TD></TD><TD>");
                Enumeration e = ca.getBtbInstructors().elements();
                while (e.hasMoreElements()) {
                    ClassAssignmentDetails.BtbInstructorInfo btb = (ClassAssignmentDetails.BtbInstructorInfo)e.nextElement();
                    sb.append(btb.toHtml(context, solver));
                    if (!e.hasMoreElements()) continue;
                    sb.append("<br>");
                }
                sb.append("</TD></TR>");
            }
        }
        if (ca.getInitialTime() != null) {
            sb.append("<TR><TD nowrap>" + MSG.propertyInitialAssignment() + "</TD><TD>");
            if (ca.isInitial()) {
                sb.append("<I>" + MSG.messageThisOne() + "</I>");
            } else {
                sb.append(ca.getInitialTime().toHtml(false, false, true, true) + " ");
                for (i = 0; i < ca.getInitialRoom().length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(ca.getInitialRoom()[i].toHtml(false, false, true));
                }
                sb.append("</TD></TR>");
            }
            sb.append("</TD></TR>");
        }
        if (!ca.getStudentConflicts().isEmpty()) {
            sb.append("<TR><TD nowrap>" + MSG.propertyStudentConflicts() + "</TD><TD>");
            Collections.sort(ca.getStudentConflicts(), new ClassAssignmentDetails.StudentConflictInfoComparator(context, solver));
            Enumeration e = ca.getStudentConflicts().elements();
            while (e.hasMoreElements()) {
                ClassAssignmentDetails.StudentConflictInfo std = (ClassAssignmentDetails.StudentConflictInfo)e.nextElement();
                sb.append(std.toHtml(context, solver, dispLinks));
                if (!e.hasMoreElements()) continue;
                sb.append("<BR>");
            }
            sb.append("</TD></TR>");
        }
        if (ca.hasViolatedGroupConstraint()) {
            sb.append("<TR><TD>" + MSG.propertyViolatedConstraints() + "</TD><TD>");
            Enumeration e = ca.getGroupConstraints().elements();
            while (e.hasMoreElements()) {
                ClassAssignmentDetails.DistributionInfo gc = (ClassAssignmentDetails.DistributionInfo)e.nextElement();
                if (gc.getInfo().isSatisfied()) continue;
                sb.append(gc.toHtml(context, solver, dispLinks));
                if (!e.hasMoreElements()) continue;
                sb.append("<BR>");
            }
            sb.append("</TD></TR>");
        }
        if (dispLinks) {
            if (!ca.getRooms().isEmpty()) {
                sb.append("<TR><TD nowrap>" + MSG.propertyRoomLocations() + "</TD><TD>" + ca.getRooms().toHtml(true, true, selection) + "</TD></TR>");
            } else {
                sb.append("<input type='hidden' name='nrRooms' value='0'/>");
                sb.append("<input type='hidden' name='roomState' value='0'/>");
            }
            if (!ca.getTimes().isEmpty()) {
                sb.append("<TR><TD nowrap>" + MSG.propertyTimeLocations() + "</TD><TD>" + ca.getTimes().toHtml(true, true, selection) + "</TD></TR>");
                sb.append("<TR" + (ca.getTimes().getNrDates() <= 1 ? " style='display:none;'" : "") + "><TD nowrap>" + MSG.propertyDatePatterns() + "</TD><TD>" + ca.getTimes().toDatesHtml(true, true, selection) + "</TD></TR>");
            }
        }
        if (dispLinks && ca.getClazz() != null && ca.getClazz().getRoomCapacity() >= 0 && ca.getClazz().getRoomCapacity() < Integer.MAX_VALUE && ca.getClazz().nrRooms() > 0) {
            sb.append("<TR><TD>" + MSG.propertyMinimumRoomSize() + "</TD><TD>" + ca.getClazz().getRoomCapacity() + "</TD></TR>");
        }
        if (dispLinks && ca.getClazz() != null && ca.getClazz().getNote() != null) {
            sb.append("<TR><TD>" + MSG.propertyNote() + "</TD><TD>" + ca.getClazz().getNote().replaceAll("\n", "<BR>") + "</TD></TR>");
        }
        return sb.toString();
    }
}

