/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.InstructionalOfferingModifyForm;
import org.unitime.timetable.interfaces.ExternalInstrOffrConfigChangeAction;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.LearningManagementSystemInfo;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.base.BaseClass_;
import org.unitime.timetable.model.base.BaseDatePattern;
import org.unitime.timetable.model.base.BaseDepartment;
import org.unitime.timetable.model.base.BasePreferenceGroup;
import org.unitime.timetable.model.base.BaseRefTableEntry;
import org.unitime.timetable.model.base.BaseSchedulingSubpart;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.DatePatternDAO;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.InstrOfferingConfigDAO;
import org.unitime.timetable.model.dao.InstructionalMethodDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.LearningManagementSystemInfoDAO;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;
import org.unitime.timetable.security.permissions.Permission;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.spring.SpringApplicationContextHolder;
import org.unitime.timetable.util.LookupTables;

@Action(value="instructionalOfferingModify", results={@Result(name={"instructionalOfferingModify"}, type="tiles", location="instructionalOfferingModify.tiles"), @Result(name={"instructionalOfferingDetail"}, type="redirect", location="/instructionalOfferingDetail.action", params={"io", "${form.instrOfferingId}", "op", "view"})})
@TilesDefinition(name="instructionalOfferingModify.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Multiple Class Setup"), @TilesPutAttribute(name="body", value="/user/instructionalOfferingModify.jsp"), @TilesPutAttribute(name="showNavigation", value="true")})
public class InstructionalOfferingModifyAction
extends UniTimeAction<InstructionalOfferingModifyForm> {
    private static final long serialVersionUID = 4233368454875113999L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    protected String op2 = null;
    private String uid;
    private String id;

    public String getHdnOp() {
        return this.op2;
    }

    public void setHdnOp(String hdnOp) {
        this.op2 = hdnOp;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String execute() throws Exception {
        InstructionalOffering io;
        if (this.form == null) {
            this.form = new InstructionalOfferingModifyForm();
        }
        if (this.op == null) {
            this.op = ((InstructionalOfferingModifyForm)this.form).getOp();
        }
        if (this.op2 != null && !this.op2.isEmpty()) {
            this.op = this.op2;
        }
        if (this.op == null || this.op.trim().length() == 0) {
            throw new Exception(MSG.errorOperationNotInterpreted() + this.op);
        }
        ((InstructionalOfferingModifyForm)this.form).setOp(this.op);
        if (this.op.equalsIgnoreCase(MSG.actionClassSetup())) {
            this.doLoad(this.uid);
        }
        if (MSG.actionBackToIODetail().equals(this.op)) {
            return "instructionalOfferingDetail";
        }
        LookupTables.setupExternalDepts(this.request, this.sessionContext.getUser().getCurrentAcademicSessionId());
        Department contrDept = ((InstrOfferingConfig)InstrOfferingConfigDAO.getInstance().get(((InstructionalOfferingModifyForm)this.form).getInstrOffrConfigId())).getInstructionalOffering().getControllingCourseOffering().getSubjectArea().getDepartment();
        TreeSet<Department> ts = new TreeSet<Department>();
        for (Department d : (TreeSet)this.request.getAttribute(Department.EXTERNAL_DEPT_ATTR_NAME)) {
            if (!this.sessionContext.hasPermission(d, Right.MultipleClassSetupDepartment) || !this.getPermissionDepartment().check(this.sessionContext.getUser(), contrDept, DepartmentStatusType.Status.OwnerEdit, d, DepartmentStatusType.Status.ManagerEdit)) continue;
            ts.add(d);
        }
        this.request.setAttribute(Department.EXTERNAL_DEPT_ATTR_NAME + "list", ts);
        LookupTables.setupLearningManagementSystemInfos(this.request, this.sessionContext.getUser(), true, MSG.dropDefaultLearningManagementSystem(), LearningManagementSystemInfo.getDefaultIfExists(this.sessionContext.getUser().getCurrentAcademicSessionId()));
        if ("add".equals(this.op) && this.id != null && !this.id.trim().isEmpty()) {
            ((InstructionalOfferingModifyForm)this.form).addNewClassesBasedOnTemplate(this.id);
        }
        if ("moveUp".equals(this.op) && this.id != null && !this.id.trim().isEmpty()) {
            ((InstructionalOfferingModifyForm)this.form).moveClassUp(this.id);
        }
        if ("moveDown".equals(this.op) && this.id != null && !this.id.trim().isEmpty()) {
            ((InstructionalOfferingModifyForm)this.form).moveClassDown(this.id);
        }
        if ("delete".equals(this.op) && this.id != null && !this.id.trim().isEmpty()) {
            ((InstructionalOfferingModifyForm)this.form).removeFromClasses(this.id);
        }
        if ("cancel".equals(this.op) && this.id != null && !this.id.trim().isEmpty()) {
            ((InstructionalOfferingModifyForm)this.form).setCancelled(this.id, true);
        }
        if ("reopen".equals(this.op) && this.id != null && !this.id.trim().isEmpty()) {
            ((InstructionalOfferingModifyForm)this.form).setCancelled(this.id, false);
        }
        if ("multipleLimits".equals(this.op)) {
            ((InstructionalOfferingModifyForm)this.form).setDisplayMaxLimit(((InstructionalOfferingModifyForm)this.form).getDisplayMaxLimit() == false);
            if (!((InstructionalOfferingModifyForm)this.form).getDisplayMaxLimit().booleanValue() && !((InstructionalOfferingModifyForm)this.form).maxLimitCanBeHidden()) {
                ((InstructionalOfferingModifyForm)this.form).setDisplayMaxLimit(true);
                ((InstructionalOfferingModifyForm)this.form).setDisplayOptionForMaxLimit(true);
            }
        }
        if (this.op.equalsIgnoreCase(MSG.actionUpdateMultipleClassSetup())) {
            ((InstructionalOfferingModifyForm)this.form).validate(this);
            if (!this.hasFieldErrors()) {
                this.doUpdate();
                return "instructionalOfferingDetail";
            }
        }
        if (((InstructionalOfferingModifyForm)this.form).getInstrOfferingId() != null && (io = (InstructionalOffering)new InstructionalOfferingDAO().get(((InstructionalOfferingModifyForm)this.form).getInstrOfferingId())) != null) {
            LookupTables.setupDatePatterns(this.request, this.sessionContext.getUser(), MSG.dropDefaultDatePattern(), null, io.getDepartment(), io.getSession().getDefaultDatePatternNotNull());
        }
        ((InstructionalOfferingModifyForm)this.form).setDirectionsClassesCanMove();
        ((InstructionalOfferingModifyForm)this.form).initalizeSubpartSubtotalsAndDisplayFlags();
        ((InstructionalOfferingModifyForm)this.form).initializeEnableAllClassesForStudentScheduling();
        ((InstructionalOfferingModifyForm)this.form).initializeDisplayAllClassInstructors();
        return "instructionalOfferingModify";
    }

    private void doLoad(String instrOffrConfigId) throws Exception {
        if (instrOffrConfigId == null || instrOffrConfigId.trim().length() == 0) {
            throw new Exception(MSG.errorMissingIOConfig());
        }
        this.sessionContext.checkPermission((Serializable)((Object)instrOffrConfigId), "InstrOfferingConfig", Right.MultipleClassSetup);
        InstrOfferingConfigDAO iocDao = new InstrOfferingConfigDAO();
        InstrOfferingConfig ioc = (InstrOfferingConfig)iocDao.get(Long.valueOf(instrOffrConfigId));
        InstructionalOffering io = ioc.getInstructionalOffering();
        ((InstructionalOfferingModifyForm)this.form).setDisplayOptionForMaxLimit(CommonValues.Yes.eq(this.sessionContext.getUser().getProperty(UserProperty.VariableClassLimits)));
        ((InstructionalOfferingModifyForm)this.form).setInstrOffrConfigId(ioc.getUniqueId());
        ((InstructionalOfferingModifyForm)this.form).setInstrOffrConfigLimit(ioc.getLimit());
        ((InstructionalOfferingModifyForm)this.form).setInstrOffrConfigUnlimited(ioc.isUnlimitedEnrollment());
        ((InstructionalOfferingModifyForm)this.form).setInstrOfferingId(io.getUniqueId());
        ((InstructionalOfferingModifyForm)this.form).setDisplayDisplayInstructors(ApplicationProperty.ClassSetupDisplayInstructorFlags.isTrue());
        ((InstructionalOfferingModifyForm)this.form).setDisplayEnabledForStudentScheduling(ApplicationProperty.ClassSetupEnabledForStudentScheduling.isTrue());
        ((InstructionalOfferingModifyForm)this.form).setDisplayExternalId(ApplicationProperty.ClassSetupShowExternalIds.isTrue() && !ApplicationProperty.ClassSetupEditExternalIds.isTrue());
        ((InstructionalOfferingModifyForm)this.form).setEditExternalId(ApplicationProperty.ClassSetupEditExternalIds.isTrue());
        ((InstructionalOfferingModifyForm)this.form).setEditSnapshotLimits(ApplicationProperty.ClassSetupEditSnapshotLimits.isTrue() && io.getSnapshotLimitDate() != null && this.sessionContext.hasPermission(Right.MultipleClassSetupSnapshotLimits));
        ((InstructionalOfferingModifyForm)this.form).setInstructionalMethod(ioc.getInstructionalMethod() == null ? -1L : ioc.getInstructionalMethod().getUniqueId());
        ((InstructionalOfferingModifyForm)this.form).setInstructionalMethodDefault(io.getSession().getDefaultInstructionalMethod() == null ? null : io.getSession().getDefaultInstructionalMethod().getLabel());
        ((InstructionalOfferingModifyForm)this.form).setInstructionalMethodEditable(ApplicationProperty.WaitListCanChangeInstructionalMethod.isTrue() || !ioc.getInstructionalOffering().effectiveReScheduleNow() || ioc.getEnrollment() == 0);
        ((InstructionalOfferingModifyForm)this.form).setDisplayLms(this.isLmsInfoDefined());
        String name = io.getCourseNameWithTitle();
        if (io.hasMultipleConfigurations()) {
            name = name + " [" + ioc.getName() + "]";
        }
        ((InstructionalOfferingModifyForm)this.form).setInstrOfferingName(name);
        if (ioc.getSchedulingSubparts() == null || ioc.getSchedulingSubparts().size() == 0) {
            throw new Exception(MSG.errorIOConfigNotDefined());
        }
        ArrayList<SchedulingSubpart> subpartList = new ArrayList<SchedulingSubpart>(ioc.getSchedulingSubparts());
        Collections.sort(subpartList, new SchedulingSubpartComparator());
        ClassAssignmentProxy proxy = this.getClassAssignmentService().getAssignment();
        ((InstructionalOfferingModifyForm)this.form).setInstrOffrConfigUnlimitedReadOnly(false);
        for (SchedulingSubpart ss : subpartList) {
            if (ss.getClasses() == null || ss.getClasses().size() == 0) {
                throw new Exception(MSG.errorInitialIOSetupIncomplete());
            }
            if (ss.getParentSubpart() != null) continue;
            this.loadClasses(ss.getClasses(), true, new String(), proxy);
        }
        ((InstructionalOfferingModifyForm)this.form).initializeOrigSubparts();
        ((InstructionalOfferingModifyForm)this.form).setDirectionsClassesCanMove();
        ((InstructionalOfferingModifyForm)this.form).initalizeSubpartSubtotalsAndDisplayFlags();
        ((InstructionalOfferingModifyForm)this.form).initializeEnableAllClassesForStudentScheduling();
        ((InstructionalOfferingModifyForm)this.form).initializeDisplayAllClassInstructors();
    }

    private boolean isLmsInfoDefined() {
        return LearningManagementSystemInfo.isLmsInfoDefinedForSession(this.sessionContext.getUser().getCurrentAcademicSessionId());
    }

    private void loadClasses(Set classes, Boolean isReadOnly, String indent, ClassAssignmentProxy proxy) {
        if (classes != null && classes.size() > 0) {
            ArrayList classesList = new ArrayList(classes);
            Collections.sort(classesList, new ClassComparator(3));
            Boolean readOnlyClass = false;
            Class_ cls2 = null;
            boolean first = true;
            for (Class_ cls2 : classesList) {
                if (first) {
                    ((InstructionalOfferingModifyForm)this.form).setDisplayEnrollment(StudentClassEnrollment.sessionHasEnrollments(this.sessionContext.getUser().getCurrentAcademicSessionId()));
                    ((InstructionalOfferingModifyForm)this.form).setDisplaySnapshotLimit(cls2.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getSnapshotLimitDate() != null);
                    first = false;
                }
                if ((readOnlyClass = isReadOnly == false ? Boolean.valueOf(isReadOnly) : Boolean.valueOf(!this.sessionContext.hasPermission(cls2, Right.MultipleClassSetupClass))).booleanValue()) {
                    ((InstructionalOfferingModifyForm)this.form).setInstrOffrConfigUnlimitedReadOnly(true);
                }
                ((InstructionalOfferingModifyForm)this.form).addToClasses(cls2, readOnlyClass != false && cls2.isCancelled() == false, indent, proxy, UserProperty.NameFormat.get(this.sessionContext.getUser()), this.sessionContext.hasPermission(cls2, Right.ClassDelete), this.sessionContext.hasPermission(cls2, Right.ClassCancel), readOnlyClass != false && cls2.isCancelled() == false || ApplicationProperty.WaitListCanChangeDatePattern.isFalse() && cls2.getEnrollment() != null && cls2.getEnrollment() > 0 && cls2.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().effectiveReScheduleNow());
                this.loadClasses(cls2.getChildClasses(), true, indent + "&nbsp;&nbsp;&nbsp;&nbsp;", proxy);
            }
        }
    }

    private void doUpdate() throws Exception {
        InstrOfferingConfigDAO iocdao = new InstrOfferingConfigDAO();
        InstrOfferingConfig ioc = (InstrOfferingConfig)iocdao.get(((InstructionalOfferingModifyForm)this.form).getInstrOffrConfigId());
        Session hibSession = iocdao.getSession();
        RoomGroup rg = RoomGroup.getGlobalDefaultRoomGroup(ioc.getSession());
        this.sessionContext.checkPermission(ioc, Right.MultipleClassSetup);
        Transaction tx = null;
        try {
            InstructionalMethod imeth;
            tx = hibSession.beginTransaction();
            if (((InstructionalOfferingModifyForm)this.form).getInstrOffrConfigUnlimited() != ioc.isUnlimitedEnrollment().booleanValue()) {
                ioc.setUnlimitedEnrollment(((InstructionalOfferingModifyForm)this.form).getInstrOffrConfigUnlimited());
                ioc.setLimit(((InstructionalOfferingModifyForm)this.form).getInstrOffrConfigUnlimited() ? 0 : ((InstructionalOfferingModifyForm)this.form).getInstrOffrConfigLimit());
                hibSession.update((Object)ioc);
            } else if (!((InstructionalOfferingModifyForm)this.form).getInstrOffrConfigLimit().equals(ioc.getLimit())) {
                ioc.setLimit(((InstructionalOfferingModifyForm)this.form).getInstrOffrConfigLimit());
                hibSession.update((Object)ioc);
            }
            InstructionalMethod instructionalMethod = imeth = ((InstructionalOfferingModifyForm)this.form).getInstructionalMethod() == null || ((InstructionalOfferingModifyForm)this.form).getInstructionalMethod() < 0L ? null : (InstructionalMethod)InstructionalMethodDAO.getInstance().get(((InstructionalOfferingModifyForm)this.form).getInstructionalMethod(), hibSession);
            if (!ToolBox.equals((Object)ioc.getInstructionalMethod(), imeth)) {
                ioc.setInstructionalMethod(imeth);
                hibSession.update((Object)ioc);
            }
            HashMap<Long, Department> origSubpartManagingDept = new HashMap<Long, Department>();
            if (ioc.getSchedulingSubparts() != null) {
                SchedulingSubpart ss2 = null;
                for (SchedulingSubpart ss2 : ioc.getSchedulingSubparts()) {
                    origSubpartManagingDept.put(ss2.getUniqueId(), ss2.getManagingDept());
                }
            }
            HashMap tmpClassIdsToClasses = this.addClasses(ioc, hibSession);
            this.modifyClasses(ioc, hibSession, rg, tmpClassIdsToClasses);
            this.modifySubparts(ioc, origSubpartManagingDept, rg, hibSession);
            this.deleteClasses(ioc, hibSession, tmpClassIdsToClasses);
            String className = ApplicationProperty.ExternalActionInstrOffrConfigChange.value();
            ExternalInstrOffrConfigChangeAction configChangeAction = null;
            if (className != null && className.trim().length() > 0 && !(configChangeAction = (ExternalInstrOffrConfigChangeAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).validateConfigChangeCanOccur(ioc.getInstructionalOffering(), hibSession)) {
                throw new Exception("Configuration change violates rules for Add On, rolling back the change.");
            }
            ioc.getInstructionalOffering().computeLabels(hibSession);
            ChangeLog.addChange(hibSession, this.sessionContext, ioc, ChangeLog.Source.CLASS_SETUP, ChangeLog.Operation.UPDATE, ioc.getInstructionalOffering().getControllingCourseOffering().getSubjectArea(), null);
            tx.commit();
            hibSession.flush();
            hibSession.refresh((Object)ioc);
            hibSession.refresh((Object)ioc.getInstructionalOffering());
            if (configChangeAction != null) {
                configChangeAction.performExternalInstrOffrConfigChangeAction(ioc.getInstructionalOffering(), hibSession);
            }
        }
        catch (Exception e) {
            Debug.error(e);
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    private void modifySubparts(InstrOfferingConfig ioc, HashMap origSubpartManagingDept, RoomGroup rg, Session hibSession) {
        if (ioc.getSchedulingSubparts() != null) {
            SchedulingSubpart ss2 = null;
            Department origManagingDept = null;
            Department currentManagingDept = null;
            TimePref tp2 = null;
            RoomPref rp2 = null;
            BuildingPref bp2 = null;
            RoomFeaturePref rfp2 = null;
            RoomGroupPref rgp2 = null;
            TimePref ntp = null;
            RoomPref nrp = null;
            BuildingPref nbp = null;
            RoomFeaturePref nrfp = null;
            RoomGroupPref nrgp = null;
            Class_ c2 = null;
            HashSet<Comparable> prefObjs = null;
            Department controllingDept = null;
            PreferenceLevel prefLevel = PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired);
            for (SchedulingSubpart ss2 : ioc.getSchedulingSubparts()) {
                if (controllingDept == null) {
                    controllingDept = ss2.getControllingDept();
                }
                currentManagingDept = ss2.getManagingDept();
                origManagingDept = (Department)origSubpartManagingDept.get(ss2.getUniqueId());
                if (origManagingDept == null || currentManagingDept.getUniqueId().equals(origManagingDept.getUniqueId())) continue;
                if (!origManagingDept.getUniqueId().equals(controllingDept.getUniqueId()) && ss2.getClasses() != null) {
                    for (Class_ c2 : ss2.getClasses()) {
                        boolean classChanged = false;
                        if (!c2.getManagingDept().getUniqueId().equals(origManagingDept.getUniqueId())) continue;
                        prefObjs = c2.getTimePatterns();
                        for (TimePref tp2 : ss2.getTimePreferences()) {
                            if (prefObjs == null || prefObjs.contains(tp2.getTimePattern())) continue;
                            ntp = new TimePref();
                            ntp.setOwner(c2);
                            ntp.setPrefLevel(prefLevel);
                            ntp.setTimePattern(tp2.getTimePattern());
                            ntp.setPreference(tp2.getPreference());
                            c2.addTopreferences(ntp);
                            classChanged = true;
                        }
                        prefObjs = new HashSet<Comparable>();
                        Iterator it3 = c2.getBuildingPreferences().iterator();
                        while (it3.hasNext()) {
                            prefObjs.add(((BuildingPref)it3.next()).getBuilding());
                        }
                        for (BuildingPref bp2 : ss2.getBuildingPreferences()) {
                            if (prefObjs.contains(bp2.getBuilding())) continue;
                            nbp = new BuildingPref();
                            nbp.setOwner(c2);
                            nbp.setPrefLevel(bp2.getPrefLevel());
                            nbp.setBuilding(bp2.getBuilding());
                            nbp.setDistanceFrom(bp2.getDistanceFrom());
                            c2.addTopreferences(nbp);
                            classChanged = true;
                        }
                        prefObjs = new HashSet();
                        it3 = c2.getRoomPreferences().iterator();
                        while (it3.hasNext()) {
                            prefObjs.add(((RoomPref)it3.next()).getRoom());
                        }
                        for (RoomPref rp2 : ss2.getRoomPreferences()) {
                            if (prefObjs.contains(rp2.getRoom())) continue;
                            nrp = new RoomPref();
                            nrp.setOwner(c2);
                            nrp.setPrefLevel(rp2.getPrefLevel());
                            nrp.setRoom(rp2.getRoom());
                            c2.addTopreferences(nrp);
                            classChanged = true;
                        }
                        prefObjs = new HashSet();
                        it3 = c2.getRoomFeaturePreferences().iterator();
                        while (it3.hasNext()) {
                            prefObjs.add(((RoomFeaturePref)it3.next()).getRoomFeature());
                        }
                        for (RoomFeaturePref rfp2 : ss2.getRoomFeaturePreferences()) {
                            if (prefObjs.contains(rfp2.getRoomFeature())) continue;
                            nrfp = new RoomFeaturePref();
                            nrfp.setOwner(c2);
                            nrfp.setPrefLevel(rfp2.getPrefLevel());
                            nrfp.setRoomFeature(rfp2.getRoomFeature());
                            c2.addTopreferences(nrfp);
                            classChanged = true;
                        }
                        prefObjs = new HashSet();
                        it3 = c2.getRoomGroupPreferences().iterator();
                        while (it3.hasNext()) {
                            prefObjs.add(((RoomGroupPref)it3.next()).getRoomGroup());
                        }
                        for (RoomGroupPref rgp2 : ss2.getRoomGroupPreferences()) {
                            if (prefObjs.contains(rgp2.getRoomGroup())) continue;
                            nrgp = new RoomGroupPref();
                            nrgp.setOwner(c2);
                            nrgp.setPrefLevel(rgp2.getPrefLevel());
                            nrgp.setRoomGroup(rgp2.getRoomGroup());
                            c2.addTopreferences(nrgp);
                            classChanged = true;
                        }
                        if (!classChanged) continue;
                        hibSession.update((Object)c2);
                    }
                }
                ss2.deleteAllDistributionPreferences(hibSession);
                boolean weaken = true;
                if (!currentManagingDept.isExternalManager().booleanValue()) {
                    weaken = false;
                }
                if (weaken && currentManagingDept.isAllowReqTime() != null && currentManagingDept.isAllowReqTime().booleanValue()) {
                    weaken = false;
                }
                if (weaken && ss2.getControllingDept().isAllowReqTime() != null && ss2.getControllingDept().isAllowReqTime().booleanValue()) {
                    weaken = false;
                }
                Set timePrefs = ss2.getTimePreferences();
                HashSet<Preference> prefs = new HashSet<Preference>();
                prefs.addAll(ss2.getPreferences());
                ss2.getPreferences().removeAll(ss2.getPreferences());
                for (TimePref timePref : timePrefs) {
                    tp2 = new TimePref();
                    tp2.setOwner(ss2);
                    tp2.setPrefLevel(timePref.getPrefLevel());
                    tp2.setTimePattern(timePref.getTimePattern());
                    tp2.setPreference(timePref.getPreference());
                    if (weaken) {
                        tp2.weakenHardPreferences();
                    }
                    ss2.addTopreferences(tp2);
                }
                if (currentManagingDept.getUniqueId().equals(controllingDept.getUniqueId()) && rg != null) {
                    rgp2 = new RoomGroupPref();
                    rgp2.setOwner(ss2);
                    rgp2.setPrefLevel(prefLevel);
                    rgp2.setRoomGroup(rg);
                    ss2.addTopreferences(rgp2);
                }
                hibSession.update((Object)ss2);
            }
        }
    }

    private void buildClassList(Set classes, ArrayList lst) {
        if (classes != null && classes.size() > 0) {
            ArrayList classesList = new ArrayList(classes);
            Collections.sort(classesList, new ClassComparator(3));
            Class_ c2 = null;
            for (Class_ c2 : classesList) {
                lst.add(c2);
                this.buildClassList(c2.getChildClasses(), lst);
            }
        }
    }

    private void deleteClasses(InstrOfferingConfig ioc, Session hibSession, HashMap tmpClassIdsToRealClasses) {
        if (ioc.getSchedulingSubparts() != null) {
            SchedulingSubpart ss2 = null;
            ArrayList lst = new ArrayList();
            ArrayList<SchedulingSubpart> subpartList = new ArrayList<SchedulingSubpart>(ioc.getSchedulingSubparts());
            Collections.sort(subpartList, new SchedulingSubpartComparator());
            for (SchedulingSubpart ss2 : subpartList) {
                if (ss2.getParentSubpart() != null) continue;
                this.buildClassList(ss2.getClasses(), lst);
            }
            for (int i = lst.size() - 1; i >= 0; --i) {
                Class_ c = (Class_)lst.get(i);
                if (((InstructionalOfferingModifyForm)this.form).getClassIds().contains(c.getUniqueId().toString()) || tmpClassIdsToRealClasses.containsValue(c)) continue;
                if (c.getParentClass() != null) {
                    Class_ parent = c.getParentClass();
                    parent.getChildClasses().remove(c);
                    hibSession.update((Object)parent);
                }
                c.getSchedulingSubpart().getClasses().remove(c);
                if (c.getPreferences() != null) {
                    c.getPreferences().removeAll(c.getPreferences());
                }
                c.deleteAllDependentObjects(hibSession, false);
                hibSession.delete((Object)c);
            }
        }
    }

    private HashMap addClasses(InstrOfferingConfig ioc, Session hibSession) {
        HashMap<Long, Class_> tmpClsToRealClass = new HashMap<Long, Class_>();
        SchedulingSubpartDAO ssdao = new SchedulingSubpartDAO();
        BasePreferenceGroup ss = null;
        Class_DAO cdao = new Class_DAO();
        BasePreferenceGroup parentClass = null;
        DepartmentDAO deptdao = new DepartmentDAO();
        BasePreferenceGroup managingDept = null;
        DatePatternDAO dpdao = new DatePatternDAO();
        BaseDatePattern dp = null;
        LearningManagementSystemInfoDAO lmsdao = new LearningManagementSystemInfoDAO();
        BaseRefTableEntry lms = null;
        ListIterator<String> it1 = ((InstructionalOfferingModifyForm)this.form).getClassIds().listIterator();
        ListIterator<String> it2 = ((InstructionalOfferingModifyForm)this.form).getSubpartIds().listIterator();
        ListIterator<String> it3 = ((InstructionalOfferingModifyForm)this.form).getParentClassIds().listIterator();
        ListIterator<String> it4 = ((InstructionalOfferingModifyForm)this.form).getMinClassLimits().listIterator();
        ListIterator<String> it5 = ((InstructionalOfferingModifyForm)this.form).getDepartments().listIterator();
        ListIterator<String> it6 = ((InstructionalOfferingModifyForm)this.form).getDatePatterns().listIterator();
        ListIterator<String> it7 = ((InstructionalOfferingModifyForm)this.form).getNumberOfRooms().listIterator();
        ListIterator<String> it8 = ((InstructionalOfferingModifyForm)this.form).getMaxClassLimits().listIterator();
        ListIterator<String> it9 = ((InstructionalOfferingModifyForm)this.form).getRoomRatios().listIterator();
        ListIterator<String> it10 = ((InstructionalOfferingModifyForm)this.form).getDisplayInstructors().listIterator();
        ListIterator<String> it11 = ((InstructionalOfferingModifyForm)this.form).getEnabledForStudentScheduling().listIterator();
        ListIterator<String> it12 = ((InstructionalOfferingModifyForm)this.form).getEditExternalId() != false ? ((InstructionalOfferingModifyForm)this.form).getExternalIds().listIterator() : null;
        ListIterator<String> it13 = ((InstructionalOfferingModifyForm)this.form).getEditSnapshotLimits() != false ? ((InstructionalOfferingModifyForm)this.form).getSnapshotLimits().listIterator() : null;
        ListIterator<String> it14 = ((InstructionalOfferingModifyForm)this.form).getDisplayLms() != false ? ((InstructionalOfferingModifyForm)this.form).getLms().listIterator() : null;
        Date timeStamp = new Date();
        while (it1.hasNext()) {
            String suffix;
            Long classId = Long.valueOf(it1.next().toString());
            Long subpartId = Long.valueOf(it2.next().toString());
            String parentId = it3.next().toString();
            Long parentClassId = null;
            if (parentId.length() != 0) {
                parentClassId = Long.valueOf(parentId);
            }
            Integer minClassLimit = Integer.valueOf(it4.next().toString());
            String managingDeptIdString = (String)it5.next();
            Long managingDeptId = null;
            if (managingDeptIdString.length() != 0) {
                managingDeptId = Long.valueOf(managingDeptIdString);
            }
            String datePatternId = it6.next().toString();
            Long datePattern = null;
            if (datePatternId.length() != 0) {
                datePattern = Long.valueOf(datePatternId);
            }
            Integer numberOfRooms = Integer.valueOf(it7.next().toString());
            Integer maxClassLimit = Integer.valueOf(it8.next().toString());
            Float roomRatio = Float.valueOf(it9.next().toString());
            if (((InstructionalOfferingModifyForm)this.form).getInstrOffrConfigUnlimited()) {
                roomRatio = Float.valueOf(1.0f);
                minClassLimit = 0;
                maxClassLimit = 0;
                numberOfRooms = 0;
            }
            String displayInstructorStr = null;
            if (it10.hasNext()) {
                displayInstructorStr = (String)it10.next();
            }
            Boolean displayInstructor = false;
            if (displayInstructorStr != null) {
                displayInstructor = "true".equalsIgnoreCase(displayInstructorStr);
            }
            String enabledForStudentSchedulingStr = null;
            if (it11.hasNext()) {
                enabledForStudentSchedulingStr = (String)it11.next();
            }
            Boolean enabledForStudentScheduling = false;
            if (enabledForStudentSchedulingStr != null) {
                enabledForStudentScheduling = "true".equalsIgnoreCase(enabledForStudentSchedulingStr);
            }
            String string = suffix = it12 == null ? null : it12.next().toString();
            if (suffix != null && suffix.isEmpty()) {
                suffix = null;
            }
            Integer snapshotLimit = null;
            try {
                snapshotLimit = it13 == null ? null : Integer.valueOf(it13.next().toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String lmsStrId = null;
            if (it14 != null) {
                lmsStrId = it14.next().toString();
            }
            Long lmsId = null;
            if (lmsStrId != null && lmsStrId.length() != 0) {
                lmsId = Long.valueOf(lmsStrId);
            }
            if (classId >= 0L) continue;
            Class_ newClass = new Class_();
            if (ss == null || !ss.getUniqueId().equals(subpartId)) {
                ss = (SchedulingSubpart)ssdao.get(subpartId);
            }
            newClass.setSchedulingSubpart((SchedulingSubpart)ss);
            ((BaseSchedulingSubpart)ss).addToclasses(newClass);
            if (parentClassId != null) {
                if (!(parentClassId <= 0L || parentClass != null && parentClass.getUniqueId().equals(parentClassId))) {
                    parentClass = (Class_)cdao.get(parentClassId);
                } else if (parentClassId < 0L) {
                    parentClass = (Class_)tmpClsToRealClass.get(parentClassId);
                }
                newClass.setParentClass((Class_)parentClass);
                ((BaseClass_)parentClass).addTochildClasses(newClass);
            }
            if (managingDept == null || !managingDept.getUniqueId().equals(managingDeptId)) {
                managingDept = (Department)deptdao.get(managingDeptId);
            }
            newClass.setControllingDept(((SchedulingSubpart)ss).getControllingDept());
            newClass.setManagingDept((Department)managingDept, this.sessionContext.getUser(), hibSession);
            if (dp == null || !dp.getUniqueId().equals(datePattern)) {
                dp = (DatePattern)dpdao.get(datePattern);
            }
            newClass.setDatePattern((DatePattern)dp);
            newClass.setExpectedCapacity(minClassLimit);
            newClass.setNbrRooms(numberOfRooms);
            newClass.setMaxExpectedCapacity(maxClassLimit);
            newClass.setRoomRatio(roomRatio);
            newClass.setDisplayInstructor(displayInstructor);
            newClass.setEnabledForStudentScheduling(enabledForStudentScheduling);
            newClass.setClassSuffix(suffix);
            newClass.setSnapshotLimit(snapshotLimit);
            newClass.setSnapshotLimitDate(timeStamp);
            newClass.setCancelled(false);
            if (!(lms != null && lms.getUniqueId().equals(lmsId) || lmsId == null)) {
                lms = (LearningManagementSystemInfo)lmsdao.get(lmsId);
            }
            newClass.setLms((LearningManagementSystemInfo)lms);
            hibSession.save((Object)newClass);
            hibSession.save((Object)ss);
            tmpClsToRealClass.put(classId, newClass);
        }
        return tmpClsToRealClass;
    }

    private void modifyClasses(InstrOfferingConfig ioc, Session hibSession, RoomGroup rg, HashMap tmpClassIdsToRealClasses) {
        Class_DAO cdao = new Class_DAO();
        DepartmentDAO deptdao = new DepartmentDAO();
        BasePreferenceGroup managingDept = null;
        DatePatternDAO dpdao = new DatePatternDAO();
        BaseDatePattern dp = null;
        LearningManagementSystemInfoDAO lmsdao = new LearningManagementSystemInfoDAO();
        BaseRefTableEntry lms = null;
        ListIterator<String> it1 = ((InstructionalOfferingModifyForm)this.form).getClassIds().listIterator();
        ListIterator<String> it2 = ((InstructionalOfferingModifyForm)this.form).getMinClassLimits().listIterator();
        ListIterator<String> it3 = ((InstructionalOfferingModifyForm)this.form).getDepartments().listIterator();
        ListIterator<String> it4 = ((InstructionalOfferingModifyForm)this.form).getDatePatterns().listIterator();
        ListIterator<String> it5 = ((InstructionalOfferingModifyForm)this.form).getNumberOfRooms().listIterator();
        ListIterator<String> it6 = ((InstructionalOfferingModifyForm)this.form).getMaxClassLimits().listIterator();
        ListIterator<String> it7 = ((InstructionalOfferingModifyForm)this.form).getRoomRatios().listIterator();
        ListIterator<String> it8 = ((InstructionalOfferingModifyForm)this.form).getDisplayInstructors().listIterator();
        ListIterator<String> it9 = ((InstructionalOfferingModifyForm)this.form).getEnabledForStudentScheduling().listIterator();
        ListIterator<String> it10 = ((InstructionalOfferingModifyForm)this.form).getParentClassIds().listIterator();
        ListIterator<String> it11 = ((InstructionalOfferingModifyForm)this.form).getEditExternalId() != false ? ((InstructionalOfferingModifyForm)this.form).getExternalIds().listIterator() : null;
        ListIterator<Boolean> it12 = ((InstructionalOfferingModifyForm)this.form).getIsCancelled().listIterator();
        ListIterator<String> it13 = ((InstructionalOfferingModifyForm)this.form).getEditSnapshotLimits() != false ? ((InstructionalOfferingModifyForm)this.form).getSnapshotLimits().listIterator() : null;
        ListIterator<String> it14 = ((InstructionalOfferingModifyForm)this.form).getDisplayLms() != false ? ((InstructionalOfferingModifyForm)this.form).getLms().listIterator() : null;
        Date timeStamp = new Date();
        while (it1.hasNext()) {
            Boolean displayEnabledForStudentScheduling;
            Boolean displayInstructorFlags;
            Long classId = Long.valueOf(it1.next().toString());
            Integer minClassLimit = Integer.valueOf(it2.next().toString());
            Long managingDeptId = Long.valueOf(it3.next().toString());
            String datePatternId = it4.next().toString();
            Long datePattern = null;
            if (datePatternId.length() != 0) {
                datePattern = Long.valueOf(datePatternId);
            }
            Integer numberOfRooms = Integer.valueOf(it5.next().toString());
            Integer maxClassLimit = Integer.valueOf(it6.next().toString());
            Float roomRatio = Float.valueOf(it7.next().toString());
            if (((InstructionalOfferingModifyForm)this.form).getInstrOffrConfigUnlimited()) {
                roomRatio = Float.valueOf(1.0f);
                minClassLimit = 0;
                maxClassLimit = 0;
                numberOfRooms = 0;
            }
            String displayInstructorStr = null;
            if (it8.hasNext()) {
                displayInstructorStr = (String)it8.next();
            }
            Boolean displayInstructor = false;
            if (displayInstructorStr != null) {
                displayInstructor = "true".equalsIgnoreCase(displayInstructorStr);
            }
            String enabledForStudentSchedulingStr = null;
            if (it9.hasNext()) {
                enabledForStudentSchedulingStr = (String)it9.next();
            }
            Boolean enabledForStudentScheduling = false;
            if (enabledForStudentSchedulingStr != null) {
                enabledForStudentScheduling = "true".equalsIgnoreCase(enabledForStudentSchedulingStr);
            }
            String suffix = it11 != null ? it11.next().toString() : null;
            Boolean cancelled = Boolean.TRUE.equals(it12.next());
            Integer snapshotLimit = null;
            try {
                snapshotLimit = it13 == null ? null : Integer.valueOf(it13.next().toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String lmsStrId = null;
            if (it14 != null) {
                lmsStrId = it14.next().toString();
            }
            Long lmsId = null;
            if (lmsStrId != null && lmsStrId.length() != 0) {
                lmsId = Long.valueOf(lmsStrId);
            }
            Long parentClassId = null;
            String parentClassIdString = (String)it10.next();
            if (parentClassIdString != null && parentClassIdString.length() > 0) {
                parentClassId = Long.valueOf(parentClassIdString);
            }
            if (classId <= 0L) continue;
            boolean changed = false;
            Class_ modifiedClass = (Class_)cdao.get(classId);
            if (modifiedClass.getParentClass() != null && parentClassId != null && !modifiedClass.getParentClass().getUniqueId().equals(parentClassId)) {
                Class_ origParent = modifiedClass.getParentClass();
                if (parentClassId < 0L) {
                    modifiedClass.setParentClass((Class_)tmpClassIdsToRealClasses.get(parentClassId));
                } else {
                    modifiedClass.setParentClass((Class_)cdao.get(parentClassId));
                }
                hibSession.update((Object)modifiedClass.getParentClass());
                hibSession.update((Object)origParent);
            }
            if (managingDeptId.equals(-1L)) {
                managingDeptId = modifiedClass.getControllingDept().getUniqueId();
            }
            if (!modifiedClass.getManagingDept().getUniqueId().equals(managingDeptId)) {
                changed = true;
                if (managingDept == null || !managingDept.getUniqueId().equals(managingDeptId)) {
                    managingDept = (Department)deptdao.get(managingDeptId);
                }
                modifiedClass.setManagingDept((Department)managingDept, this.sessionContext.getUser(), hibSession);
                Set timePrefs = modifiedClass.getTimePreferences();
                HashSet<Preference> prefs = new HashSet<Preference>();
                prefs.addAll(modifiedClass.getPreferences());
                modifiedClass.getPreferences().removeAll(prefs);
                boolean weaken = true;
                if (!((BaseDepartment)managingDept).isExternalManager().booleanValue()) {
                    weaken = false;
                }
                if (weaken && ((BaseDepartment)managingDept).isAllowReqTime() != null && ((BaseDepartment)managingDept).isAllowReqTime().booleanValue()) {
                    weaken = false;
                }
                if (weaken && modifiedClass.getControllingDept().isAllowReqTime() != null && modifiedClass.getControllingDept().isAllowReqTime().booleanValue()) {
                    weaken = false;
                }
                for (TimePref timePref : timePrefs) {
                    TimePattern timePattern = timePref.getTimePattern();
                    if (timePattern.isExactTime()) continue;
                    TimePref tp = new TimePref();
                    tp.setOwner(modifiedClass);
                    tp.setPrefLevel(timePref.getPrefLevel());
                    tp.setTimePattern(timePattern);
                    tp.setPreference(timePref.getPreference());
                    if (weaken) {
                        tp.weakenHardPreferences();
                    }
                    modifiedClass.addTopreferences(tp);
                }
                modifiedClass.deleteAllDistributionPreferences(hibSession);
            }
            if (modifiedClass.getDatePattern() == null && datePattern != null || modifiedClass.getDatePattern() != null && !modifiedClass.getDatePattern().getUniqueId().equals(datePattern)) {
                changed = true;
                if (dp == null || !dp.getUniqueId().equals(datePattern)) {
                    dp = (DatePattern)dpdao.get(datePattern);
                }
                modifiedClass.setDatePattern((DatePattern)dp);
            }
            if (modifiedClass.getLms() == null && lmsId != null || modifiedClass.getLms() != null && !modifiedClass.getLms().getUniqueId().equals(lmsId)) {
                if (!(lms != null && lms.getUniqueId().equals(lmsId) || lmsId == null)) {
                    lms = (LearningManagementSystemInfo)lmsdao.get(lmsId);
                }
                changed = true;
                modifiedClass.setLms((LearningManagementSystemInfo)lms);
            }
            if (!modifiedClass.getExpectedCapacity().equals(minClassLimit)) {
                changed = true;
                modifiedClass.setExpectedCapacity(minClassLimit);
            }
            if (!modifiedClass.getNbrRooms().equals(numberOfRooms)) {
                changed = true;
                modifiedClass.setNbrRooms(numberOfRooms);
            }
            if (!modifiedClass.getMaxExpectedCapacity().equals(maxClassLimit)) {
                changed = true;
                modifiedClass.setMaxExpectedCapacity(maxClassLimit);
            }
            if (!modifiedClass.getRoomRatio().equals(roomRatio)) {
                changed = true;
                modifiedClass.setRoomRatio(roomRatio);
            }
            if ((displayInstructorFlags = Boolean.valueOf(ApplicationProperty.ClassSetupDisplayInstructorFlags.isTrue())).booleanValue() && !modifiedClass.isDisplayInstructor().equals(displayInstructor)) {
                changed = true;
                modifiedClass.setDisplayInstructor(displayInstructor);
            }
            if ((displayEnabledForStudentScheduling = Boolean.valueOf(ApplicationProperty.ClassSetupEnabledForStudentScheduling.isTrue())).booleanValue() && !modifiedClass.isEnabledForStudentScheduling().equals(enabledForStudentScheduling)) {
                changed = true;
                modifiedClass.setEnabledForStudentScheduling(enabledForStudentScheduling);
            }
            if (suffix != null) {
                if (suffix.isEmpty()) {
                    suffix = null;
                }
                if (suffix == null ? modifiedClass.getClassSuffix() != null : !suffix.equals(modifiedClass.getClassSuffix())) {
                    modifiedClass.setClassSuffix(suffix);
                    changed = true;
                }
            }
            if (((InstructionalOfferingModifyForm)this.form).getEditSnapshotLimits().booleanValue() && (snapshotLimit == null ? modifiedClass.getSnapshotLimit() != null : !snapshotLimit.equals(modifiedClass.getSnapshotLimit()))) {
                modifiedClass.setSnapshotLimit(snapshotLimit);
                modifiedClass.setSnapshotLimitDate(timeStamp);
                changed = true;
            }
            if (!modifiedClass.isCancelled().equals(cancelled)) {
                modifiedClass.setCancelled(cancelled);
                modifiedClass.cancelEvent(this.sessionContext.getUser(), hibSession, cancelled);
                changed = true;
            }
            if (!changed) continue;
            hibSession.update((Object)modifiedClass);
        }
    }

    protected Permission.PermissionDepartment getPermissionDepartment() {
        return (Permission.PermissionDepartment)SpringApplicationContextHolder.getBean("permissionDepartment");
    }

    public String getCrsNbr() {
        return (String)this.sessionContext.getAttribute(SessionAttribute.OfferingsCourseNumber);
    }
}

