/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesDefinitions;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ConstantsMessages;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.ExamDistributionPrefsForm;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.DistributionPrefDAO;
import org.unitime.timetable.model.dao.DistributionTypeDAO;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.util.IdValue;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.ExamDistributionPrefsTableBuilder;

@Action(value="examDistributionPrefs", results={@Result(name={"list"}, type="tiles", location="examDistributionPrefs.tiles"), @Result(name={"add"}, type="tiles", location="addExamDistributionPref.tiles"), @Result(name={"edit"}, type="tiles", location="editExamDistributionPref.tiles")})
@TilesDefinitions(value={@TilesDefinition(name="examDistributionPrefs.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Examination Distribution Preferences"), @TilesPutAttribute(name="body", value="/user/examDistributionPrefs.jsp"), @TilesPutAttribute(name="showNavigation", value="true")}), @TilesDefinition(name="addExamDistributionPref.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Add Examination Distribution Preference"), @TilesPutAttribute(name="body", value="/user/examDistributionPrefs.jsp"), @TilesPutAttribute(name="showNavigation", value="true")}), @TilesDefinition(name="editExamDistributionPref.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Edit Examination Distribution Preference"), @TilesPutAttribute(name="body", value="/user/examDistributionPrefs.jsp"), @TilesPutAttribute(name="showNavigation", value="true")})})
public class ExamDistributionPrefsAction
extends UniTimeAction<ExamDistributionPrefsForm> {
    private static final long serialVersionUID = -4234228449590216694L;
    protected static ExaminationMessages MSG = Localization.create(ExaminationMessages.class);
    protected static ConstantsMessages CONST = Localization.create(ConstantsMessages.class);
    protected String reloadId;
    protected String reloadCause;
    protected String deleteId;
    protected String deleteType;
    protected String distPrefId;

    public String getReloadId() {
        return this.reloadId;
    }

    public void setReloadId(String reloadId) {
        this.reloadId = reloadId;
    }

    public String getReloadCause() {
        return this.reloadCause;
    }

    public void setReloadCause(String reloadCause) {
        this.reloadCause = reloadCause;
    }

    public String getDeleteId() {
        return this.deleteId;
    }

    public void setDeleteId(String deleteId) {
        this.deleteId = deleteId;
    }

    public String getDeleteType() {
        return this.deleteType;
    }

    public void setDeleteType(String deleteType) {
        this.deleteType = deleteType;
    }

    public String getDp() {
        return this.distPrefId;
    }

    public void setDp(String distPrefId) {
        this.distPrefId = distPrefId;
    }

    public String execute() throws Exception {
        if (this.form == null) {
            this.form = new ExamDistributionPrefsForm();
        }
        this.sessionContext.checkPermission(Right.ExaminationDistributionPreferences);
        if (this.op == null) {
            this.op = ((ExamDistributionPrefsForm)this.form).getOp();
        }
        if (this.op == null || this.op.trim().isEmpty()) {
            this.op = this.deleteType != null && this.deleteType.length() > 0 ? "delete" : "view";
            ((ExamDistributionPrefsForm)this.form).setOp(this.op);
        }
        if (this.reloadCause != null && this.reloadCause.length() > 0) {
            this.op = "reload";
        }
        if (MSG.actionCancel().equals(this.op)) {
            ((ExamDistributionPrefsForm)this.form).reset();
            if (BackTracker.doBack(this.request, this.response)) {
                return null;
            }
            this.op = "view";
        }
        LookupTables.setupExamTypes(this.request, this.sessionContext.getUser(), DepartmentStatusType.Status.ExamTimetable, DepartmentStatusType.Status.ExamView);
        this.request.setAttribute("examTypesAdd", ExamType.findAllUsedApplicable(this.sessionContext.getUser(), DepartmentStatusType.Status.ExamTimetable, DepartmentStatusType.Status.ExamEdit));
        if (MSG.actionSaveNewDistributionPreference().equals(this.op) || MSG.actionUpdateDistributionPreference().equals(this.op)) {
            Debug.debug("Saving distribution pref ...");
            this.sessionContext.setAttribute(SessionAttribute.ExamType, (Object)((ExamDistributionPrefsForm)this.form).getExamType());
            ((ExamDistributionPrefsForm)this.form).validate(this);
            if (!this.hasFieldErrors()) {
                try {
                    this.doAddOrUpdate((ExamDistributionPrefsForm)this.form);
                    if (((ExamDistributionPrefsForm)this.form).getDistPrefId() != null) {
                        this.request.setAttribute("backType", (Object)"PreferenceGroup");
                        this.request.setAttribute("backId", (Object)((ExamDistributionPrefsForm)this.form).getDistPrefId());
                    }
                    ((ExamDistributionPrefsForm)this.form).reset();
                    if (BackTracker.doBack(this.request, this.response)) {
                        return null;
                    }
                    this.op = "view";
                }
                catch (Exception e) {
                    Debug.error(e);
                    this.addFieldError("classes", e.getMessage());
                }
            }
        }
        if (MSG.actionDeleteDistributionPreference().equals(this.op) || "delete".equals(this.op)) {
            if (this.deleteType.equals("distObject")) {
                ((ExamDistributionPrefsForm)this.form).deleteExam(Integer.parseInt(this.deleteId));
            }
            if (this.deleteType.equals("distPref")) {
                this.distPrefId = ((ExamDistributionPrefsForm)this.form).getDistPrefId();
                this.doDelete(this.distPrefId);
                ((ExamDistributionPrefsForm)this.form).reset();
                if (BackTracker.doBack(this.request, this.response)) {
                    return null;
                }
                this.op = "view";
            }
            if (this.deleteType.equals("examType")) {
                this.sessionContext.setAttribute(SessionAttribute.ExamType, (Object)((ExamDistributionPrefsForm)this.form).getExamType());
            }
        }
        if (MSG.actionAddDistributionPreference().equals(this.op)) {
            Debug.debug("Adding new Class via redirect ...");
            ((ExamDistributionPrefsForm)this.form).setDistType("-");
            if (this.request.getAttribute("subjectAreaId") != null) {
                ((ExamDistributionPrefsForm)this.form).setSubjectArea(0, Long.valueOf(this.request.getAttribute("subjectAreaId").toString()));
            }
            if (this.request.getAttribute("courseOffrId") != null) {
                CourseOffering course = (CourseOffering)new CourseOfferingDAO().get(Long.valueOf(this.request.getAttribute("courseOffrId").toString()));
                ((ExamDistributionPrefsForm)this.form).setSubjectArea(0, course.getSubjectArea().getUniqueId());
                ((ExamDistributionPrefsForm)this.form).setCourseNbr(0, course.getUniqueId());
            }
            if (this.request.getParameter("examId") != null) {
                Exam exam = (Exam)new ExamDAO().get(Long.valueOf(this.request.getParameter("examId")));
                ((ExamDistributionPrefsForm)this.form).getExam().add(exam.getUniqueId());
                ((ExamDistributionPrefsForm)this.form).getSubjectArea().add(exam.firstSubjectArea().getUniqueId());
                ((ExamDistributionPrefsForm)this.form).getCourseNbr().add(exam.firstCourseOffering().getUniqueId());
                ((ExamDistributionPrefsForm)this.form).setExamType(exam.getExamType().getUniqueId());
            }
            ((ExamDistributionPrefsForm)this.form).getSubjectArea().add(-1L);
            ((ExamDistributionPrefsForm)this.form).getCourseNbr().add(-1L);
            ((ExamDistributionPrefsForm)this.form).getExam().add(-1L);
        }
        if (MSG.actionAddExamToDistribution().equals(this.op)) {
            Debug.debug("Adding new Class ...");
            ((ExamDistributionPrefsForm)this.form).getSubjectArea().add(-1L);
            ((ExamDistributionPrefsForm)this.form).getCourseNbr().add(-1L);
            ((ExamDistributionPrefsForm)this.form).getExam().add(-1L);
        }
        if (MSG.actionSearchDistributionPreferences().equals(this.op) || MSG.actionExportPdf().equals(this.op) || MSG.actionExportCsv().equals(this.op)) {
            String subjectAreaId = ((ExamDistributionPrefsForm)this.form).getFilterSubjectAreaId();
            String courseNbr = ((ExamDistributionPrefsForm)this.form).getFilterCourseNbr();
            if (subjectAreaId != null && subjectAreaId.length() > 0) {
                this.sessionContext.setAttribute(SessionAttribute.OfferingsSubjectArea, (Object)subjectAreaId);
            } else {
                this.sessionContext.removeAttribute(SessionAttribute.OfferingsSubjectArea);
            }
            if (courseNbr != null && courseNbr.length() > 0) {
                this.sessionContext.setAttribute(SessionAttribute.OfferingsCourseNumber, (Object)courseNbr);
            } else {
                this.sessionContext.removeAttribute(SessionAttribute.OfferingsCourseNumber);
            }
            this.sessionContext.setAttribute(SessionAttribute.ExamType, (Object)((ExamDistributionPrefsForm)this.form).getExamType());
            this.op = MSG.actionExportPdf().equals(this.op) ? "export" : (MSG.actionExportCsv().equals(this.op) ? "export-csv" : "view");
        }
        if (this.op != null && (this.op.equals("view") || this.op.equals("export") || this.op.equals("export-csv")) && this.distPrefId != null && this.distPrefId.trim().length() > 0) {
            Debug.debug("Loading dist pref - " + this.distPrefId);
            ((ExamDistributionPrefsForm)this.form).reset();
            this.doLoad(this.distPrefId);
        }
        if (this.op != null && this.op.equals("reload")) {
            if (this.reloadCause != null && this.reloadCause.equals("moveUp")) {
                int index = Integer.parseInt(this.reloadId);
                Debug.debug("moving up ... " + this.reloadId);
                ((ExamDistributionPrefsForm)this.form).swapExams(index, index - 1);
            }
            if (this.reloadCause != null && this.reloadCause.equals("moveDown")) {
                int index = Integer.parseInt(this.reloadId);
                Debug.debug("moving down ... " + this.reloadId);
                ((ExamDistributionPrefsForm)this.form).swapExams(index, index + 1);
            }
        }
        if (((ExamDistributionPrefsForm)this.form).getDistType() != null && !((ExamDistributionPrefsForm)this.form).getDistType().equals("-")) {
            Vector<PreferenceLevel> prefs = new Vector<PreferenceLevel>();
            DistributionType dist = (DistributionType)new DistributionTypeDAO().get(Long.valueOf(((ExamDistributionPrefsForm)this.form).getDistType()));
            ((ExamDistributionPrefsForm)this.form).setDescription(dist.getDescr());
            boolean containsPref = false;
            for (PreferenceLevel pref : PreferenceLevel.getPreferenceLevelList()) {
                if (!dist.isAllowed(pref)) continue;
                prefs.addElement(pref);
                if (((ExamDistributionPrefsForm)this.form).getPrefLevel() == null || ((ExamDistributionPrefsForm)this.form).getPrefLevel().equals("-") || !pref.getPrefId().equals(Integer.valueOf(((ExamDistributionPrefsForm)this.form).getPrefLevel()))) continue;
                containsPref = true;
            }
            if (!containsPref) {
                ((ExamDistributionPrefsForm)this.form).setPrefLevel("-");
            }
            if (prefs.size() == 1) {
                ((ExamDistributionPrefsForm)this.form).setPrefLevel(((PreferenceLevel)prefs.firstElement()).getPrefId().toString());
            }
            this.request.setAttribute(PreferenceLevel.PREF_LEVEL_ATTR_NAME, prefs);
            LookupTables.setupExamDistribTypes(this.request, this.sessionContext, dist);
        } else {
            this.request.setAttribute(PreferenceLevel.PREF_LEVEL_ATTR_NAME, new Vector(0));
            ((ExamDistributionPrefsForm)this.form).setDescription("");
            LookupTables.setupExamDistribTypes(this.request, this.sessionContext, null);
        }
        if ("export".equals(this.op) && (((ExamDistributionPrefsForm)this.form).getDistPrefId() == null || ((ExamDistributionPrefsForm)this.form).getDistPrefId().length() == 0)) {
            OutputStream out = ExportUtils.getPdfOutputStream(this.response, "distpref");
            new ExamDistributionPrefsTableBuilder().getDistPrefsTableAsPdf(out, this.request, this.sessionContext, Constants.ALL_OPTION_VALUE.equals(((ExamDistributionPrefsForm)this.form).getFilterSubjectAreaId()) || ((ExamDistributionPrefsForm)this.form).getFilterSubjectAreaId().isEmpty() ? null : Long.valueOf(((ExamDistributionPrefsForm)this.form).getFilterSubjectAreaId()), ((ExamDistributionPrefsForm)this.form).getFilterCourseNbr(), ((ExamDistributionPrefsForm)this.form).getExamType());
            out.flush();
            out.close();
            return null;
        }
        if ("export-csv".equals(this.op) && (((ExamDistributionPrefsForm)this.form).getDistPrefId() == null || ((ExamDistributionPrefsForm)this.form).getDistPrefId().length() == 0)) {
            PrintWriter out = ExportUtils.getCsvWriter(this.response, "distpref");
            new ExamDistributionPrefsTableBuilder().getDistPrefsTableAsCsv(out, this.request, this.sessionContext, Constants.ALL_OPTION_VALUE.equals(((ExamDistributionPrefsForm)this.form).getFilterSubjectAreaId()) || ((ExamDistributionPrefsForm)this.form).getFilterSubjectAreaId().isEmpty() ? null : Long.valueOf(((ExamDistributionPrefsForm)this.form).getFilterSubjectAreaId()), ((ExamDistributionPrefsForm)this.form).getFilterCourseNbr(), ((ExamDistributionPrefsForm)this.form).getExamType());
            out.flush();
            out.close();
            return null;
        }
        this.request.setAttribute("listSize", (Object)("" + (((ExamDistributionPrefsForm)this.form).getSubjectArea().size() - 1)));
        if (((ExamDistributionPrefsForm)this.form).getExamType() == null) {
            if (this.sessionContext.getAttribute(SessionAttribute.ExamType) != null) {
                ((ExamDistributionPrefsForm)this.form).setExamType((Long)this.sessionContext.getAttribute(SessionAttribute.ExamType));
            } else {
                TreeSet<ExamType> types = ExamType.findAllUsed(this.sessionContext.getUser().getCurrentAcademicSessionId());
                if (!types.isEmpty()) {
                    ((ExamDistributionPrefsForm)this.form).setExamType(types.first().getUniqueId());
                }
            }
        }
        ((ExamDistributionPrefsForm)this.form).setFilterSubjectAreas(SubjectArea.getUserSubjectAreas(this.sessionContext.getUser(), false));
        ArrayList<IdValue> subjects = new ArrayList<IdValue>();
        subjects.add(new IdValue(null, CONST.select()));
        if (this.sessionContext.hasPermission(Right.DepartmentIndependent)) {
            subjects.add(new IdValue(-1L, CONST.all()));
        }
        for (SubjectArea sa : ((ExamDistributionPrefsForm)this.form).getFilterSubjectAreas()) {
            subjects.add(new IdValue(sa.getUniqueId(), sa.getSubjectAreaAbbreviation()));
        }
        ((ExamDistributionPrefsForm)this.getForm()).setSubjectAreas(subjects);
        if (((ExamDistributionPrefsForm)this.form).getFilterSubjectAreas().size() == 1) {
            SubjectArea firstSubjectArea = ((ExamDistributionPrefsForm)this.form).getFilterSubjectAreas().iterator().next();
            ((ExamDistributionPrefsForm)this.form).setFilterSubjectAreaId(firstSubjectArea.getUniqueId().toString());
        }
        if ("view".equals(this.op) && (((ExamDistributionPrefsForm)this.form).getDistPrefId() == null || ((ExamDistributionPrefsForm)this.form).getDistPrefId().length() == 0)) {
            String subject = (String)this.sessionContext.getAttribute(SessionAttribute.OfferingsSubjectArea);
            if (subject != null && subject.indexOf(44) >= 0) {
                subject = subject.substring(0, subject.indexOf(44));
            }
            ((ExamDistributionPrefsForm)this.form).setFilterSubjectAreaId(subject);
            ((ExamDistributionPrefsForm)this.form).setFilterCourseNbr((String)this.sessionContext.getAttribute(SessionAttribute.OfferingsCourseNumber));
            ExamDistributionPrefsTableBuilder tbl = new ExamDistributionPrefsTableBuilder();
            if (((ExamDistributionPrefsForm)this.form).getFilterSubjectAreaId() == null) {
                if (this.sessionContext.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent)) {
                    ((ExamDistributionPrefsForm)this.form).setFilterSubjectAreaId(Constants.BLANK_OPTION_VALUE);
                } else {
                    ((ExamDistributionPrefsForm)this.form).setFilterSubjectAreaId(Constants.ALL_OPTION_VALUE);
                }
            }
            if (((ExamDistributionPrefsForm)this.form).getFilterSubjectAreaId() != null && ((ExamDistributionPrefsForm)this.form).getFilterSubjectAreaId().length() > 0 && !"null".equals(((ExamDistributionPrefsForm)this.form).getFilterSubjectAreaId())) {
                String html = tbl.getDistPrefsTable(this.request, this.sessionContext, Constants.ALL_OPTION_VALUE.equals(((ExamDistributionPrefsForm)this.form).getFilterSubjectAreaId()) ? null : Long.valueOf(((ExamDistributionPrefsForm)this.form).getFilterSubjectAreaId()), ((ExamDistributionPrefsForm)this.form).getFilterCourseNbr(), ((ExamDistributionPrefsForm)this.form).getExamType());
                if (html != null) {
                    this.request.setAttribute("distPrefs", (Object)html);
                }
            } else {
                this.request.setAttribute("distPrefs", (Object)"");
            }
            BackTracker.markForBack(this.request, "examDistributionPrefs.action", "Exam Distribution Prefs", true, true);
            return "list";
        }
        return ((ExamDistributionPrefsForm)this.form).getDistPrefId() == null || ((ExamDistributionPrefsForm)this.form).getDistPrefId().length() == 0 ? "add" : "edit";
    }

    private void doLoad(String distPrefId) {
        this.sessionContext.checkPermission((Serializable)((Object)distPrefId), "DistributionPref", Right.ExaminationDistributionPreferenceDetail);
        DistributionPref dp = (DistributionPref)new DistributionPrefDAO().get(Long.valueOf(distPrefId));
        ((ExamDistributionPrefsForm)this.form).setDistType(dp.getDistributionType().getUniqueId().toString());
        ((ExamDistributionPrefsForm)this.form).setDescription(dp.getDistributionType().getDescr());
        ((ExamDistributionPrefsForm)this.form).setPrefLevel(dp.getPrefLevel().getPrefId().toString());
        ((ExamDistributionPrefsForm)this.form).setDistPrefId(distPrefId);
        for (DistributionObject distObj : new TreeSet<DistributionObject>(dp.getDistributionObjects())) {
            Exam exam = (Exam)distObj.getPrefGroup();
            ((ExamDistributionPrefsForm)this.form).getSubjectArea().add(exam.firstSubjectArea().getUniqueId());
            ((ExamDistributionPrefsForm)this.form).getCourseNbr().add(exam.firstCourseOffering().getUniqueId());
            ((ExamDistributionPrefsForm)this.form).getExam().add(exam.getUniqueId());
        }
    }

    private void doAddOrUpdate(ExamDistributionPrefsForm form) throws Exception {
        String distPrefId = form.getDistPrefId();
        if (distPrefId != null && !distPrefId.isEmpty()) {
            this.sessionContext.checkPermission((Serializable)((Object)distPrefId), "DistributionPref", Right.ExaminationDistributionPreferenceEdit);
        } else {
            this.sessionContext.checkPermission(Right.ExaminationDistributionPreferenceAdd);
        }
        DistributionPref dp = null;
        DistributionPrefDAO dpDao = new DistributionPrefDAO();
        Transaction tx = null;
        Session hibSession = dpDao.getSession();
        HashSet<PreferenceGroup> relatedExams = new HashSet<PreferenceGroup>();
        try {
            tx = hibSession.beginTransaction();
            if (distPrefId != null && !distPrefId.isEmpty()) {
                dp = (DistributionPref)dpDao.get(Long.valueOf(distPrefId), hibSession);
                Set<DistributionObject> s = dp.getDistributionObjects();
                for (DistributionObject dObj : s) {
                    PreferenceGroup preferenceGroup = dObj.getPrefGroup();
                    relatedExams.add(preferenceGroup);
                    preferenceGroup.getDistributionObjects().remove(dObj);
                    hibSession.saveOrUpdate((Object)preferenceGroup);
                }
                s.clear();
                dp.setDistributionObjects(s);
            } else {
                dp = new DistributionPref();
            }
            dp.setDistributionType((DistributionType)new DistributionTypeDAO().get(Long.valueOf(form.getDistType()), hibSession));
            dp.setGrouping(-1);
            dp.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(form.getPrefLevel())));
            dp.setOwner((PreferenceGroup)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId()));
            HashSet<Exam> addedExams = new HashSet<Exam>();
            int idx = 0;
            for (Long l : form.getExam()) {
                Exam exam;
                Long examId = l instanceof Long ? l : Long.valueOf(((Object)l).toString());
                if (examId < 0L || (exam = (Exam)new ExamDAO().get(examId, hibSession)) == null || !addedExams.add(exam)) continue;
                relatedExams.add(exam);
                DistributionObject dObj = new DistributionObject();
                dObj.setPrefGroup(exam);
                dObj.setDistributionPref(dp);
                dObj.setSequenceNumber(++idx);
                exam.getDistributionObjects().add(dObj);
                dp.addTodistributionObjects(dObj);
            }
            hibSession.saveOrUpdate((Object)dp);
            for (Exam exam : relatedExams) {
                ChangeLog.addChange(hibSession, this.sessionContext, exam, ChangeLog.Source.DIST_PREF_EDIT, distPrefId != null && distPrefId.trim().length() > 0 ? ChangeLog.Operation.UPDATE : ChangeLog.Operation.CREATE, exam.firstSubjectArea(), exam.firstDepartment());
            }
            tx.commit();
            hibSession.flush();
            hibSession.refresh((Object)dp.getOwner());
            form.setDistPrefId(dp.getUniqueId().toString());
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            hibSession.clear();
            throw e;
        }
    }

    private void doDelete(String distPrefId) {
        block6: {
            Transaction tx = null;
            this.sessionContext.checkPermission((Serializable)((Object)distPrefId), "DistributionPref", Right.ExaminationDistributionPreferenceDelete);
            try {
                DistributionPrefDAO dpDao = new DistributionPrefDAO();
                Session hibSession = dpDao.getSession();
                tx = hibSession.getTransaction();
                if (tx == null || !tx.isActive()) {
                    tx = hibSession.beginTransaction();
                }
                HashSet<PreferenceGroup> relatedExams = new HashSet<PreferenceGroup>();
                DistributionPref dp = (DistributionPref)dpDao.get(Long.valueOf(distPrefId));
                PreferenceGroup owner = dp.getOwner();
                owner.getPreferences().remove(dp);
                for (DistributionObject distributionObject : dp.getDistributionObjects()) {
                    PreferenceGroup pg = distributionObject.getPrefGroup();
                    relatedExams.add(pg);
                    pg.getDistributionObjects().remove(distributionObject);
                    hibSession.saveOrUpdate((Object)pg);
                }
                hibSession.delete((Object)dp);
                hibSession.saveOrUpdate((Object)owner);
                for (Exam exam : relatedExams) {
                    ChangeLog.addChange(hibSession, this.sessionContext, exam, ChangeLog.Source.DIST_PREF_EDIT, ChangeLog.Operation.DELETE, exam.firstSubjectArea(), exam.firstDepartment());
                }
                if (tx != null && tx.isActive()) {
                    tx.commit();
                }
                hibSession.flush();
                hibSession.refresh((Object)owner);
            }
            catch (Exception e) {
                Debug.error(e);
                if (tx == null || !tx.isActive()) break block6;
                tx.rollback();
            }
        }
    }
}

