/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.BlankForm;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.ExternalDepartmentStatusType;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.webutil.PdfWebTable;

@Action(value="departmentList", results={@Result(name={"showDepartmentList"}, type="tiles", location="departmentList.tiles"), @Result(name={"add"}, type="redirect", location="/departmentEdit.action", params={"op", "${op}"})})
@TilesDefinition(name="departmentList.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Departments"), @TilesPutAttribute(name="body", value="/admin/departmentList.jsp")})
public class DepartmentListAction
extends UniTimeAction<BlankForm> {
    private static final long serialVersionUID = 1316912229218015591L;
    protected static final GwtMessages MSG = Localization.create(GwtMessages.class);
    private boolean showUnusedDepts = false;
    private String op2 = null;

    public boolean getShowUnusedDepts() {
        return this.showUnusedDepts;
    }

    public void setShowUnusedDepts(boolean showUnusedDepts) {
        this.showUnusedDepts = showUnusedDepts;
    }

    public String getOp2() {
        return this.op2;
    }

    public void setOp2(String op2) {
        this.op2 = op2;
    }

    public String execute() throws Exception {
        String[] stringArray;
        this.sessionContext.checkPermission(Right.Departments);
        if ("Apply".equals(this.op2)) {
            this.sessionContext.getUser().setProperty("Departments.showUnusedDepts", this.showUnusedDepts ? "1" : "0");
        } else {
            this.showUnusedDepts = "1".equals(this.sessionContext.getUser().getProperty("Departments.showUnusedDepts", "0"));
        }
        boolean dispLastChanges = this.isDisplayLastChanges();
        if (DepartmentListAction.stripAccessKey(MSG.buttonAddDepartment()).equals(this.request.getParameter("op"))) {
            this.setOp(DepartmentListAction.stripAccessKey(MSG.buttonAddDepartment()));
            return "add";
        }
        if (DepartmentListAction.stripAccessKey(MSG.buttonExportPDF()).equals(this.request.getParameter("op"))) {
            String[] stringArray2;
            int n = dispLastChanges ? 13 : 12;
            String string = MSG.propDepartmentlist(this.sessionContext.getUser().getCurrentAuthority().getQualifiers("Session").get(0).getQualifierLabel());
            if (dispLastChanges) {
                String[] stringArray3 = new String[13];
                stringArray3[0] = MSG.colCode();
                stringArray3[1] = MSG.colAbbv();
                stringArray3[2] = MSG.colName();
                stringArray3[3] = MSG.colExternalManager().replace("<br>", "\n");
                stringArray3[4] = MSG.colSubjects();
                stringArray3[5] = MSG.colRooms();
                stringArray3[6] = MSG.colStatus();
                stringArray3[7] = MSG.colDistPrefPriority().replace("<br>", "\n");
                stringArray3[8] = MSG.colAllowRequired().replace("<br>", "\n");
                stringArray3[9] = MSG.colInstructorPref().replace("<br>", "\n");
                stringArray3[10] = MSG.colEvents();
                stringArray3[11] = MSG.colStudentScheduling().replace("<br>", "\n");
                stringArray2 = stringArray3;
                stringArray3[12] = MSG.colLastChange();
            } else {
                String[] stringArray4 = new String[12];
                stringArray4[0] = MSG.colCode();
                stringArray4[1] = MSG.colAbbv();
                stringArray4[2] = MSG.colName();
                stringArray4[3] = MSG.colExternalManager().replace("<br>", "\n");
                stringArray4[4] = MSG.colSubjects();
                stringArray4[5] = MSG.colRooms();
                stringArray4[6] = MSG.colStatus();
                stringArray4[7] = MSG.colDistPrefPriority().replace("<br>", "\n");
                stringArray4[8] = MSG.colAllowRequired().replace("<br>", "\n");
                stringArray4[9] = MSG.colInstructorPref().replace("<br>", "\n");
                stringArray4[10] = MSG.colEvents();
                stringArray2 = stringArray4;
                stringArray4[11] = MSG.colStudentScheduling().replace("<br>", "\n");
            }
            PdfWebTable webTable = new PdfWebTable(n, string, "departmentList.action?ord=%%", stringArray2, new String[]{"left", "left", "left", "left", "right", "right", "left", "right", "left", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true, true, true, true, true, true, true, dispLastChanges, false});
            for (Department d : this.getDepartments()) {
                if (!this.getShowUnusedDepts() && d.getSubjectAreas().isEmpty() && d.getTimetableManagers().isEmpty() && !d.isExternalManager().booleanValue()) continue;
                DecimalFormat df5 = new DecimalFormat("####0");
                String lastChangeStr = null;
                Long lastChangeCmp = null;
                if (dispLastChanges) {
                    List<ChangeLog> changes = ChangeLog.findLastNChanges(d.getSession().getUniqueId(), null, null, d.getUniqueId(), 1);
                    ChangeLog lastChange = changes == null || changes.isEmpty() ? null : changes.get(0);
                    lastChangeStr = lastChange == null ? "" : ChangeLog.sDFdate.format(lastChange.getTimeStamp()) + " by " + lastChange.getManager().getShortName();
                    lastChangeCmp = lastChange == null ? 0L : lastChange.getTimeStamp().getTime();
                }
                String allowReq = "";
                int allowReqOrd = 0;
                if (d.isAllowReqRoom() != null && d.isAllowReqRoom().booleanValue()) {
                    if (!allowReq.isEmpty()) {
                        allowReq = allowReq + ", ";
                    }
                    allowReq = allowReq + MSG.colRoom();
                    ++allowReqOrd;
                }
                if (d.isAllowReqTime() != null && d.isAllowReqTime().booleanValue()) {
                    if (!allowReq.isEmpty()) {
                        allowReq = allowReq + ", ";
                    }
                    allowReq = allowReq + MSG.colTime();
                    allowReqOrd += 2;
                }
                if (d.isAllowReqDistribution() != null && d.isAllowReqDistribution().booleanValue()) {
                    if (!allowReq.isEmpty()) {
                        allowReq = allowReq + ", ";
                    }
                    allowReq = allowReq + MSG.colDistribution();
                    allowReqOrd += 4;
                }
                if (allowReqOrd == 7) {
                    allowReq = MSG.colAll();
                }
                String dependentStatuses = null;
                if (d.isExternalManager().booleanValue() && d.getExternalStatusTypes() != null && !d.getExternalStatusTypes().isEmpty()) {
                    TreeSet<ExternalDepartmentStatusType> set = new TreeSet<ExternalDepartmentStatusType>(new Comparator<ExternalDepartmentStatusType>(){

                        @Override
                        public int compare(ExternalDepartmentStatusType e1, ExternalDepartmentStatusType e2) {
                            return e1.getDepartment().compareTo(e2.getDepartment());
                        }
                    });
                    set.addAll(d.getExternalStatusTypes());
                    for (ExternalDepartmentStatusType t : set) {
                        if (dependentStatuses == null) {
                            dependentStatuses = "    " + t.getDepartment().getDeptCode() + ": " + t.getStatusType().getLabel();
                            continue;
                        }
                        dependentStatuses = dependentStatuses + "\n    " + t.getDepartment().getDeptCode() + ": " + t.getStatusType().getLabel();
                    }
                }
                webTable.addLine(null, new String[]{d.getDeptCode(), d.getAbbreviation(), d.getName(), d.isExternalManager() != false ? d.getExternalMgrAbbv() : "", df5.format(d.getSubjectAreas().size()), df5.format(d.getRoomDepts().size()), (d.getStatusType() == null ? "@@ITALIC " : "") + d.effectiveStatusType().getLabel() + (d.getStatusType() == null ? "@@END_ITALIC " : "") + (dependentStatuses == null ? "" : "\n" + dependentStatuses), d.getDistributionPrefPriority() == null && d.getDistributionPrefPriority() != 0 ? "" : d.getDistributionPrefPriority().toString(), allowReq, d.isInheritInstructorPreferences() != false ? MSG.exportTrue() : MSG.exportFalse(), d.isAllowEvents() != false ? MSG.exportTrue() : MSG.exportFalse(), d.isAllowStudentScheduling() != false ? MSG.exportTrue() : MSG.exportFalse(), lastChangeStr}, new Comparable[]{d.getDeptCode(), d.getAbbreviation(), d.getName(), d.isExternalManager() != false ? d.getExternalMgrAbbv() : "", Integer.valueOf(d.getSubjectAreas().size()), Integer.valueOf(d.getRoomDepts().size()), d.effectiveStatusType().getOrd(), d.getDistributionPrefPriority(), Integer.valueOf(allowReqOrd), d.isInheritInstructorPreferences(), d.isAllowEvents(), d.isAllowStudentScheduling(), lastChangeCmp});
            }
            ExportUtils.exportPDF(webTable, WebTable.getOrder(this.sessionContext, "DepartmentList.ord"), this.response, "departments");
            return null;
        }
        int n = dispLastChanges ? 13 : 12;
        if (dispLastChanges) {
            String[] stringArray5 = new String[13];
            stringArray5[0] = MSG.colCode();
            stringArray5[1] = MSG.colAbbreviation();
            stringArray5[2] = MSG.colName();
            stringArray5[3] = MSG.colExternalManager();
            stringArray5[4] = MSG.colSubjects();
            stringArray5[5] = MSG.colRooms();
            stringArray5[6] = MSG.colStatus();
            stringArray5[7] = MSG.colDistPrefPriority();
            stringArray5[8] = MSG.colAllowRequired();
            stringArray5[9] = MSG.colInstructorPref();
            stringArray5[10] = MSG.colEvents();
            stringArray5[11] = MSG.colStudentScheduling();
            stringArray = stringArray5;
            stringArray5[12] = MSG.colLastChange();
        } else {
            String[] stringArray6 = new String[12];
            stringArray6[0] = MSG.colCode();
            stringArray6[1] = MSG.colAbbreviation();
            stringArray6[2] = MSG.colName();
            stringArray6[3] = MSG.colExternalManager();
            stringArray6[4] = MSG.colSubjects();
            stringArray6[5] = MSG.colRooms();
            stringArray6[6] = MSG.colStatus();
            stringArray6[7] = MSG.colDistPrefPriority();
            stringArray6[8] = MSG.colAllowRequired();
            stringArray6[9] = MSG.colInstructorPref();
            stringArray6[10] = MSG.colEvents();
            stringArray = stringArray6;
            stringArray6[11] = MSG.colStudentScheduling();
        }
        WebTable webTable = new WebTable(n, "", "departmentList.action?ord=%%", stringArray, new String[]{"left", "left", "left", "left", "right", "right", "left", "right", "left", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true, true, true, true, true, true, true, dispLastChanges, false});
        WebTable.setOrder(this.sessionContext, "DepartmentList.ord", this.request.getParameter("ord"), 1);
        webTable.enableHR("#9CB0CE");
        webTable.setRowStyle("white-space: nowrap");
        for (Department d : this.getDepartments()) {
            if (!this.getShowUnusedDepts() && d.getSubjectAreas().isEmpty() && d.getTimetableManagers().isEmpty() && !d.isExternalManager().booleanValue()) continue;
            DecimalFormat df5 = new DecimalFormat("####0");
            String lastChangeStr = null;
            Long lastChangeCmp = null;
            if (dispLastChanges) {
                List<ChangeLog> changes = ChangeLog.findLastNChanges(d.getSession().getUniqueId(), null, null, d.getUniqueId(), 1);
                ChangeLog lastChange = changes == null || changes.isEmpty() ? null : changes.get(0);
                lastChangeStr = lastChange == null ? "&nbsp;" : "<span title='" + lastChange.getLabel() + "'>" + ChangeLog.sDFdate.format(lastChange.getTimeStamp()) + " by " + lastChange.getManager().getShortName() + "</span>";
                lastChangeCmp = lastChange == null ? 0L : lastChange.getTimeStamp().getTime();
            }
            String allowReq = "";
            int allowReqOrd = 0;
            if (d.isAllowReqRoom() != null && d.isAllowReqRoom().booleanValue()) {
                if (!allowReq.isEmpty()) {
                    allowReq = allowReq + ", ";
                }
                allowReq = allowReq + MSG.colRoom();
                ++allowReqOrd;
            }
            if (d.isAllowReqTime() != null && d.isAllowReqTime().booleanValue()) {
                if (!allowReq.isEmpty()) {
                    allowReq = allowReq + ", ";
                }
                allowReq = allowReq + MSG.colTime();
                allowReqOrd += 2;
            }
            if (d.isAllowReqDistribution() != null && d.isAllowReqDistribution().booleanValue()) {
                if (!allowReq.isEmpty()) {
                    allowReq = allowReq + ", ";
                }
                allowReq = allowReq + MSG.colDistribution();
                allowReqOrd += 4;
            }
            if (allowReqOrd == 7) {
                allowReq = MSG.colAll();
            }
            if (allowReqOrd == 0) {
                allowReq = "&nbsp;";
            }
            String dependentStatuses = null;
            if (d.isExternalManager().booleanValue() && d.getExternalStatusTypes() != null && !d.getExternalStatusTypes().isEmpty()) {
                TreeSet<ExternalDepartmentStatusType> set = new TreeSet<ExternalDepartmentStatusType>(new Comparator<ExternalDepartmentStatusType>(){

                    @Override
                    public int compare(ExternalDepartmentStatusType e1, ExternalDepartmentStatusType e2) {
                        return e1.getDepartment().compareTo(e2.getDepartment());
                    }
                });
                set.addAll(d.getExternalStatusTypes());
                for (ExternalDepartmentStatusType t : set) {
                    if (dependentStatuses == null) {
                        dependentStatuses = t.getDepartment().getDeptCode() + ": " + t.getStatusType().getLabel();
                        continue;
                    }
                    dependentStatuses = dependentStatuses + "<br>" + t.getDepartment().getDeptCode() + ": " + t.getStatusType().getLabel();
                }
            }
            boolean editable = this.sessionContext.hasPermission(d, Right.DepartmentEdit) || this.sessionContext.hasPermission(d, Right.DepartmentLimitedEdit);
            WebTable.WebTableLine line = webTable.addLine(editable ? "onClick=\"document.location='departmentEdit.action?op=Edit&id=" + d.getUniqueId() + "';\"" : null, new String[]{d.getDeptCode(), d.getAbbreviation() == null ? "&nbsp;" : d.getAbbreviation(), d.getName(), d.isExternalManager() != false ? "<span title='" + d.getExternalMgrLabel() + "'>" + d.getExternalMgrAbbv() + "</span>" : "&nbsp;", df5.format(d.getSubjectAreas().size()), df5.format(d.getRoomDepts().size()), (d.getStatusType() == null ? "<i>" : "&nbsp;") + d.effectiveStatusType().getLabel() + (d.getStatusType() == null ? "</i>" : "") + (dependentStatuses == null ? "" : "<div style='padding-left:30px;'>" + dependentStatuses + "</div>"), d.getDistributionPrefPriority() == null && d.getDistributionPrefPriority() != 0 ? "&nbsp;" : d.getDistributionPrefPriority().toString(), allowReq, d.isInheritInstructorPreferences() != false ? "<IMG border='0' align='absmiddle' src='images/accept.png'>" : "", d.isAllowEvents() != false ? "<IMG border='0' align='absmiddle' src='images/accept.png'>" : "", d.isAllowStudentScheduling() != false ? "<IMG border='0' align='absmiddle' src='images/accept.png'>" : "", lastChangeStr}, new Comparable[]{d.getDeptCode(), d.getAbbreviation() == null ? "&nbsp;" : d.getAbbreviation(), d.getName(), d.isExternalManager() != false ? d.getExternalMgrAbbv() : "", Integer.valueOf(d.getSubjectAreas().size()), Integer.valueOf(d.getRoomDepts().size()), d.effectiveStatusType().getOrd(), d.getDistributionPrefPriority(), Integer.valueOf(allowReqOrd), d.isInheritInstructorPreferences(), d.isAllowEvents(), d.isAllowStudentScheduling(), lastChangeCmp});
            line.setUniqueId(d.getUniqueId().toString());
        }
        this.request.setAttribute("table", (Object)webTable.printTable(WebTable.getOrder(this.sessionContext, "DepartmentList.ord")));
        return "showDepartmentList";
    }

    public TreeSet<Department> getDepartments() {
        return Department.findAll(this.sessionContext.getUser().getCurrentAcademicSessionId());
    }

    public boolean isDisplayLastChanges() {
        return CommonValues.Yes.eq(UserProperty.DisplayLastChanges.get(this.sessionContext.getUser()));
    }

    public String getTitle() {
        return MSG.propDepartmentlist(this.sessionContext.getUser().getCurrentAuthority().getQualifiers("Session").get(0).getQualifierLabel());
    }
}

