/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.criteria;

import java.util.Map;
import java.util.Set;
import org.cpsolver.exam.criteria.ExamCriterion;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;

public class PeriodIndexPenalty
extends ExamCriterion {
    @Override
    public String getWeightName() {
        return "Exams.PeriodIndexWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "periodIndexWeight";
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 1.0E-7;
    }

    @Override
    public double getValue(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value, Set<ExamPlacement> conflicts) {
        return value.getPeriod().getIndex();
    }

    @Override
    public String getName() {
        return "Average Period";
    }

    @Override
    public void getInfo(Assignment<Exam, ExamPlacement> assignment, Map<String, String> info) {
        if (this.getValue(assignment) != 0.0) {
            info.put(this.getName(), sDoubleFormat.format(this.getValue(assignment) / (double)assignment.nrAssignedVariables()));
        }
    }

    @Override
    public String toString(Assignment<Exam, ExamPlacement> assignment) {
        return "PI:" + sDoubleFormat.format(this.getValue(assignment) / (double)assignment.nrAssignedVariables());
    }
}

