/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.text;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.ICalendar;
import biweekly.component.ICalComponent;
import biweekly.component.VTimezone;
import biweekly.io.DataModelConversionException;
import biweekly.io.DataModelConverter;
import biweekly.io.SkipMeException;
import biweekly.io.StreamWriter;
import biweekly.io.scribe.component.ICalComponentScribe;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.parameter.ICalParameters;
import biweekly.property.Daylight;
import biweekly.property.ICalProperty;
import biweekly.property.Timezone;
import biweekly.property.Version;
import biweekly.util.Utf8Writer;
import com.github.mangstadt.vinnie.VObjectParameters;
import com.github.mangstadt.vinnie.io.VObjectWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;

public class ICalWriter
extends StreamWriter
implements Flushable {
    private final VObjectWriter writer;
    private ICalVersion targetVersion;

    public ICalWriter(OutputStream out, ICalVersion targetVersion) {
        this(targetVersion == ICalVersion.V1_0 ? new OutputStreamWriter(out) : new Utf8Writer(out), targetVersion);
    }

    public ICalWriter(File file, ICalVersion targetVersion) throws IOException {
        this(file, false, targetVersion);
    }

    public ICalWriter(File file, boolean append, ICalVersion targetVersion) throws IOException {
        this(targetVersion == ICalVersion.V1_0 ? new FileWriter(file, append) : new Utf8Writer(file, append), targetVersion);
    }

    public ICalWriter(Writer writer, ICalVersion targetVersion) {
        this.writer = new VObjectWriter(writer, targetVersion.getSyntaxStyle());
        this.targetVersion = targetVersion;
    }

    public VObjectWriter getVObjectWriter() {
        return this.writer;
    }

    @Override
    public ICalVersion getTargetVersion() {
        return this.targetVersion;
    }

    public void setTargetVersion(ICalVersion targetVersion) {
        this.targetVersion = targetVersion;
        this.writer.setSyntaxStyle(targetVersion.getSyntaxStyle());
    }

    public boolean isCaretEncodingEnabled() {
        return this.writer.isCaretEncodingEnabled();
    }

    public void setCaretEncodingEnabled(boolean enable) {
        this.writer.setCaretEncodingEnabled(enable);
    }

    @Override
    protected void _write(ICalendar ical) throws IOException {
        this.writeComponent(ical, null);
    }

    private void writeComponent(ICalComponent component, ICalComponent parent) throws IOException {
        Collection<VTimezone> timezones;
        boolean inICalendar = component instanceof ICalendar;
        boolean inVCalRoot = inICalendar && this.getTargetVersion() == ICalVersion.V1_0;
        boolean inICalRoot = inICalendar && this.getTargetVersion() != ICalVersion.V1_0;
        ICalComponentScribe<? extends ICalComponent> componentScribe = this.index.getComponentScribe(component);
        try {
            componentScribe.checkForDataModelConversions(component, parent, this.getTargetVersion());
        }
        catch (DataModelConversionException e) {
            for (ICalComponent c : e.getComponents()) {
                this.writeComponent(c, parent);
            }
            for (ICalProperty p : e.getProperties()) {
                this.writeProperty(p);
            }
            return;
        }
        this.writer.writeBeginComponent(componentScribe.getComponentName());
        List<ICalProperty> propertyObjs = componentScribe.getProperties(component);
        if (inICalendar && component.getProperty(Version.class) == null) {
            propertyObjs.add(0, new Version(this.getTargetVersion()));
        }
        for (ICalProperty propertyObj : propertyObjs) {
            this.context.setParent(component);
            ICalProperty property = propertyObj;
            this.writeProperty(property);
        }
        List<ICalComponent> subComponents = componentScribe.getComponents(component);
        if (inICalRoot) {
            timezones = this.getTimezoneComponents();
            for (VTimezone timezone : timezones) {
                if (subComponents.contains(timezone)) continue;
                subComponents.add(0, timezone);
            }
        }
        timezones = subComponents.iterator();
        while (timezones.hasNext()) {
            Object subComponentObj = timezones.next();
            ICalComponent subComponent = (ICalComponent)subComponentObj;
            this.writeComponent(subComponent, component);
        }
        if (inVCalRoot && !(timezones = this.getTimezoneComponents()).isEmpty()) {
            VTimezone timezone = timezones.iterator().next();
            DataModelConverter.VCalTimezoneProperties props = DataModelConverter.convert(timezone, this.context.getDates());
            Timezone tz = props.getTz();
            if (tz != null) {
                this.writeProperty(tz);
            }
            for (Daylight daylight : props.getDaylights()) {
                this.writeProperty(daylight);
            }
        }
        this.writer.writeEndComponent(componentScribe.getComponentName());
    }

    private void writeProperty(ICalProperty property) throws IOException {
        String value;
        ICalPropertyScribe<? extends ICalProperty> scribe = this.index.getPropertyScribe(property);
        try {
            value = scribe.writeText(property, this.context);
        }
        catch (SkipMeException e) {
            return;
        }
        catch (DataModelConversionException e) {
            for (ICalComponent c : e.getComponents()) {
                this.writeComponent(c, this.context.getParent());
            }
            for (ICalProperty p : e.getProperties()) {
                this.writeProperty(p);
            }
            return;
        }
        ICalParameters parameters = scribe.prepareParameters(property, this.context);
        ICalDataType dataType = scribe.dataType(property, this.targetVersion);
        if (dataType != null && dataType != scribe.defaultDataType(this.targetVersion)) {
            parameters = new ICalParameters(parameters);
            parameters.setValue(dataType);
        }
        String propertyName = scribe.getPropertyName(this.getTargetVersion());
        this.writer.writeProperty(null, propertyName, new VObjectParameters(parameters.getMap()), value);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

