/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.io.DataModelConversionException;
import biweekly.io.ParseContext;
import biweekly.io.WriteContext;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.parameter.ICalParameters;
import biweekly.parameter.ParticipationLevel;
import biweekly.parameter.ParticipationStatus;
import biweekly.parameter.Role;
import biweekly.property.Attendee;
import biweekly.property.Organizer;
import com.github.mangstadt.vinnie.io.VObjectPropertyValues;
import java.util.Iterator;

public class AttendeeScribe
extends ICalPropertyScribe<Attendee> {
    public AttendeeScribe() {
        super(Attendee.class, "ATTENDEE");
    }

    @Override
    protected ICalDataType _defaultDataType(ICalVersion version) {
        switch (version) {
            case V1_0: {
                return null;
            }
        }
        return ICalDataType.CAL_ADDRESS;
    }

    @Override
    protected ICalDataType _dataType(Attendee property, ICalVersion version) {
        if (version == ICalVersion.V1_0 && property.getUri() != null) {
            return ICalDataType.URL;
        }
        return this.defaultDataType(version);
    }

    @Override
    protected ICalParameters _prepareParameters(Attendee property, WriteContext context) {
        String name;
        ParticipationStatus partStat;
        ICalParameters copy = new ICalParameters(property.getParameters());
        Boolean rsvp = property.getRsvp();
        if (rsvp != null) {
            String value;
            switch (context.getVersion()) {
                case V1_0: {
                    value = rsvp != false ? "YES" : "NO";
                    break;
                }
                default: {
                    value = rsvp != false ? "TRUE" : "FALSE";
                }
            }
            copy.put("RSVP", value);
        }
        Role role = property.getRole();
        ParticipationLevel level = property.getParticipationLevel();
        switch (context.getVersion()) {
            case V1_0: {
                if (role != null) {
                    copy.put("ROLE", role.getValue());
                }
                if (level == null) break;
                copy.put("EXPECT", level.getValue(context.getVersion()));
                break;
            }
            default: {
                String value = null;
                if (role == Role.CHAIR) {
                    value = role.getValue();
                } else if (level != null) {
                    value = level.getValue(context.getVersion());
                } else if (role != null) {
                    value = role.getValue();
                }
                if (value == null) break;
                copy.put("ROLE", value);
            }
        }
        if ((partStat = property.getParticipationStatus()) != null) {
            String paramValue;
            String paramName;
            switch (context.getVersion()) {
                case V1_0: {
                    paramName = "STATUS";
                    paramValue = partStat == ParticipationStatus.NEEDS_ACTION ? "NEEDS ACTION" : partStat.getValue();
                    break;
                }
                default: {
                    paramName = "PARTSTAT";
                    paramValue = partStat.getValue();
                }
            }
            copy.put(paramName, paramValue);
        }
        if ((name = property.getCommonName()) != null && context.getVersion() != ICalVersion.V1_0) {
            copy.put("CN", name);
        }
        String uri = property.getUri();
        String email = property.getEmail();
        if (uri != null && email != null && context.getVersion() != ICalVersion.V1_0) {
            copy.put("EMAIL", email);
        }
        return copy;
    }

    @Override
    protected Attendee _parseText(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        String uri = null;
        String name = null;
        String email = null;
        Boolean rsvp = null;
        Role role = null;
        ParticipationLevel participationLevel = null;
        ParticipationStatus participationStatus = null;
        switch (context.getVersion()) {
            case V1_0: {
                String statusStr;
                String expectStr;
                String roleStr;
                Iterator it = parameters.get("RSVP").iterator();
                while (it.hasNext()) {
                    String rsvpStr = (String)it.next();
                    if ("YES".equalsIgnoreCase(rsvpStr)) {
                        rsvp = Boolean.TRUE;
                        it.remove();
                        break;
                    }
                    if (!"NO".equalsIgnoreCase(rsvpStr)) continue;
                    rsvp = Boolean.FALSE;
                    it.remove();
                    break;
                }
                if ((roleStr = (String)parameters.first("ROLE")) != null) {
                    role = Role.get(roleStr);
                    parameters.remove("ROLE", roleStr);
                }
                if ((expectStr = parameters.getExpect()) != null) {
                    participationLevel = ParticipationLevel.get(expectStr);
                    parameters.remove("EXPECT", expectStr);
                }
                if ((statusStr = parameters.getStatus()) != null) {
                    participationStatus = ParticipationStatus.get(statusStr);
                    parameters.remove("STATUS", statusStr);
                }
                int bracketStart = value.lastIndexOf(60);
                int bracketEnd = value.lastIndexOf(62);
                if (bracketStart >= 0 && bracketEnd >= 0 && bracketStart < bracketEnd) {
                    name = value.substring(0, bracketStart).trim();
                    email = value.substring(bracketStart + 1, bracketEnd).trim();
                    break;
                }
                if (dataType == ICalDataType.URL) {
                    uri = value;
                    break;
                }
                email = value;
                break;
            }
            default: {
                String participationStatusStr;
                String roleStr;
                Iterator it = parameters.get("RSVP").iterator();
                while (it.hasNext()) {
                    String rsvpStr = (String)it.next();
                    if ("TRUE".equalsIgnoreCase(rsvpStr)) {
                        rsvp = Boolean.TRUE;
                        it.remove();
                        break;
                    }
                    if (!"FALSE".equalsIgnoreCase(rsvpStr)) continue;
                    rsvp = Boolean.FALSE;
                    it.remove();
                    break;
                }
                if ((roleStr = (String)parameters.first("ROLE")) != null) {
                    if (roleStr.equalsIgnoreCase(Role.CHAIR.getValue())) {
                        role = Role.CHAIR;
                    } else {
                        ParticipationLevel l = ParticipationLevel.find(roleStr);
                        if (l == null) {
                            role = Role.get(roleStr);
                        } else {
                            participationLevel = l;
                        }
                    }
                    parameters.remove("ROLE", roleStr);
                }
                if ((participationStatusStr = parameters.getParticipationStatus()) != null) {
                    participationStatus = ParticipationStatus.get(participationStatusStr);
                    parameters.remove("PARTSTAT", participationStatusStr);
                }
                if ((name = parameters.getCommonName()) != null) {
                    parameters.remove("CN", name);
                }
                if ((email = parameters.getEmail()) == null) {
                    int colon = value.indexOf(58);
                    if (colon == 6) {
                        String scheme = value.substring(0, colon);
                        if (scheme.equalsIgnoreCase("mailto")) {
                            email = value.substring(colon + 1);
                            break;
                        }
                        uri = value;
                        break;
                    }
                    uri = value;
                    break;
                }
                uri = value;
                parameters.remove("EMAIL", email);
            }
        }
        Attendee attendee = new Attendee(name, email, uri);
        attendee.setParticipationStatus(participationStatus);
        attendee.setParticipationLevel(participationLevel);
        attendee.setRole(role);
        attendee.setRsvp(rsvp);
        if (context.getVersion() == ICalVersion.V1_0 && attendee.getRole() == Role.ORGANIZER) {
            Organizer organizer = new Organizer(attendee.getCommonName(), attendee.getEmail());
            organizer.setUri(attendee.getUri());
            organizer.setParameters(parameters);
            attendee.setParameters(parameters);
            DataModelConversionException conversionException = new DataModelConversionException(attendee);
            conversionException.getProperties().add(organizer);
            throw conversionException;
        }
        return attendee;
    }

    @Override
    protected String _writeText(Attendee property, WriteContext context) {
        String uri = property.getUri();
        if (uri != null) {
            return uri;
        }
        String name = property.getCommonName();
        String email = property.getEmail();
        switch (context.getVersion()) {
            case V1_0: {
                if (email == null) break;
                String value = name == null ? email : name + " <" + email + ">";
                return VObjectPropertyValues.escape((String)value);
            }
            default: {
                if (email == null) break;
                return "mailto:" + email;
            }
        }
        return "";
    }
}

