/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.view.client;

import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SetSelectionModel;
import java.util.HashSet;
import java.util.Set;

public class SingleSelectionModel<T>
extends SelectionModel.AbstractSelectionModel<T>
implements SetSelectionModel<T> {
    private Object curKey;
    private T curSelection;
    private boolean newSelected;
    private T newSelectedItem = null;
    private boolean newSelectedPending;

    public SingleSelectionModel() {
        super(null);
    }

    public SingleSelectionModel(ProvidesKey<T> keyProvider) {
        super(keyProvider);
    }

    @Override
    public void clear() {
        this.setSelected(this.getSelectedObject(), false);
    }

    public T getSelectedObject() {
        this.resolveChanges();
        return this.curSelection;
    }

    @Override
    public Set<T> getSelectedSet() {
        HashSet<T> set = new HashSet<T>();
        T item = this.getSelectedObject();
        if (item != null) {
            set.add(item);
        }
        return set;
    }

    @Override
    public boolean isSelected(T item) {
        this.resolveChanges();
        if (this.curSelection == null || this.curKey == null || item == null) {
            return false;
        }
        return this.curKey.equals(this.getKey(item));
    }

    @Override
    public void setSelected(T item, boolean selected) {
        Object newKey;
        Object oldKey;
        if (!selected && !this.equalsOrBothNull(oldKey = this.newSelectedPending ? this.getKey(this.newSelectedItem) : this.curKey, newKey = this.getKey(item))) {
            return;
        }
        this.newSelectedItem = item;
        this.newSelected = selected;
        this.newSelectedPending = true;
        this.scheduleSelectionChangeEvent();
    }

    @Override
    protected void fireSelectionChangeEvent() {
        if (this.isEventScheduled()) {
            this.setEventCancelled(true);
        }
        this.resolveChanges();
    }

    private boolean equalsOrBothNull(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    private void resolveChanges() {
        if (!this.newSelectedPending) {
            return;
        }
        Object key = this.getKey(this.newSelectedItem);
        boolean sameKey = this.equalsOrBothNull(this.curKey, key);
        boolean changed = false;
        if (this.newSelected) {
            changed = !sameKey;
            this.curSelection = this.newSelectedItem;
            this.curKey = key;
        } else if (sameKey) {
            changed = true;
            this.curSelection = null;
            this.curKey = null;
        }
        this.newSelectedItem = null;
        this.newSelectedPending = false;
        if (changed) {
            SelectionChangeEvent.fire(this);
        }
    }
}

