/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.solver;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import org.springframework.stereotype.Service;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.model.SectioningSolutionLog;
import org.unitime.timetable.model.dao.SectioningSolutionLogDAO;
import org.unitime.timetable.security.rights.Right;

@Service(value="org.unitime.timetable.export.Exporter:published-solution.xml.gz")
public class ExportPublishedSectioningSolutionXML
implements Exporter {
    @Override
    public String reference() {
        return "published-solution.xml.gz";
    }

    @Override
    public void export(ExportHelper helper) throws IOException {
        String id = helper.getParameter("id");
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Id parameter was not provided.");
        }
        SectioningSolutionLog solution = (SectioningSolutionLog)SectioningSolutionLogDAO.getInstance().get(Long.valueOf(id));
        if (solution == null) {
            throw new IllegalArgumentException("Solution " + id + " does not exist.");
        }
        helper.getSessionContext().checkPermission(solution.getSession(), Right.StudentSectioningSolverPublish);
        helper.setup("application/x-gzip", "published-solution-" + new SimpleDateFormat("yyyy-MM-dd-HHmm").format(solution.getTimeStamp()) + ".xml.gz", true);
        OutputStream out = helper.getOutputStream();
        out.write(solution.getData());
        out.flush();
        out.close();
    }
}

