/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.BlankForm;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.webutil.PdfWebTable;
import org.unitime.timetable.webutil.TimetableManagerBuilder;

@Action(value="timetableManagerList", results={@Result(name={"success"}, type="tiles", location="timetableManagerList.tiles"), @Result(name={"add"}, type="redirect", location="/timetableManagerEdit.action", params={"op", "${op}"})})
@TilesDefinition(name="timetableManagerList.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Timetable Managers"), @TilesPutAttribute(name="body", value="/admin/timetableManagerList.jsp")})
public class TimetableManagerListAction
extends UniTimeAction<BlankForm> {
    private static final long serialVersionUID = -3335607995044212251L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private Boolean all;

    public Boolean getAll() {
        return this.all;
    }

    public void setAll(Boolean all) {
        this.all = all;
    }

    public String execute() throws Exception {
        this.sessionContext.checkPermission(Right.TimetableManagers);
        WebTable.setOrder(this.sessionContext, "timetableManagerList.ord", this.request.getParameter("order"), 1);
        if (this.all == null) {
            this.all = "1".equals(this.sessionContext.getUser().getProperty("TimetableManagers.showAll", "0"));
        } else {
            this.sessionContext.getUser().setProperty("TimetableManagers.showAll", this.all != false ? "1" : "0");
        }
        if (MSG.actionAddTimetableManager().equals(this.op)) {
            return "add";
        }
        if (MSG.actionExportPdf().equals(this.op)) {
            ExportUtils.exportPDF(new TimetableManagerBuilder().getManagersTable(this.sessionContext, "pdf", this.all), this.getOrder(), this.response, "managers");
            return null;
        }
        if (MSG.actionExportCsv().equals(this.op)) {
            ExportUtils.exportCSV(new TimetableManagerBuilder().getManagersTable(this.sessionContext, "csv", this.all), this.getOrder(), this.response, "managers");
            return null;
        }
        return "success";
    }

    public int getOrder() {
        return WebTable.getOrder(this.sessionContext, "timetableManagerList.ord");
    }

    public String getTable() {
        PdfWebTable table = new TimetableManagerBuilder().getManagersTable(this.sessionContext, "html", this.all);
        return table.printTable(this.getOrder());
    }

    public String getTitle() {
        return MSG.sectManagerList(this.sessionContext.getUser().getCurrentAuthority().getQualifiers("Session").get(0).getQualifierLabel());
    }
}

