/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.security.permissions;

import java.util.HashSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructorAttribute;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.permissions.Permission;
import org.unitime.timetable.security.permissions.PermissionForRight;
import org.unitime.timetable.security.rights.Right;

public class InstructorPermissions {

    @PermissionForRight(value=Right.InstructorGlobalAttributeEdit)
    public static class InstructorGlobalAttributeEdit
    implements Permission<Session> {
        @Autowired
        Permission.PermissionSession permissionSession;

        @Override
        public boolean check(UserContext user, Session source) {
            return this.permissionSession.check(user, source.getSession(), DepartmentStatusType.Status.OwnerEdit);
        }

        @Override
        public Class<Session> type() {
            return Session.class;
        }
    }

    @PermissionForRight(value=Right.InstructorAttributeAssign)
    public static class InstructorAttributeAssign
    implements Permission<InstructorAttribute> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;
        @Autowired
        Permission.PermissionSession permissionSession;

        @Override
        public boolean check(UserContext user, InstructorAttribute source) {
            if (source.getDepartment() != null) {
                return this.permissionDepartment.check(user, source.getDepartment(), DepartmentStatusType.Status.OwnerLimitedEdit);
            }
            return this.permissionSession.check(user, source.getSession(), DepartmentStatusType.Status.OwnerLimitedEdit);
        }

        @Override
        public Class<InstructorAttribute> type() {
            return InstructorAttribute.class;
        }
    }

    @PermissionForRight(value=Right.InstructorAttributeDelete)
    public static class InstructorAttributeDelete
    extends InstructorAttributeEdit {
    }

    @PermissionForRight(value=Right.InstructorAttributeEdit)
    public static class InstructorAttributeEdit
    implements Permission<InstructorAttribute> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;
        @Autowired
        Permission.PermissionSession permissionSession;

        @Override
        public boolean check(UserContext user, InstructorAttribute source) {
            if (source.getDepartment() != null) {
                return this.permissionDepartment.check(user, source.getDepartment(), DepartmentStatusType.Status.OwnerLimitedEdit);
            }
            return user.getCurrentAuthority().hasRight(Right.InstructorGlobalAttributeEdit) && this.permissionSession.check(user, source.getSession(), DepartmentStatusType.Status.OwnerEdit);
        }

        @Override
        public Class<InstructorAttribute> type() {
            return InstructorAttribute.class;
        }
    }

    @PermissionForRight(value=Right.InstructorAttributeAdd)
    public static class InstructorAttributeAdd
    extends InstructorAdd {
    }

    @PermissionForRight(value=Right.InstructorAttributes)
    public static class InstructorAttributes
    extends Instructors {
    }

    @PermissionForRight(value=Right.InstructorClearAssignmentPreferences)
    public static class InstructorClearAssignmentPreferences
    extends InstructorAssignmentPreferences {
    }

    @PermissionForRight(value=Right.InstructorAssignmentPreferences)
    public static class InstructorAssignmentPreferences
    implements Permission<Department> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Department source) {
            return this.permissionDepartment.check(user, source, DepartmentStatusType.Status.OwnerLimitedEdit);
        }

        @Override
        public Class<Department> type() {
            return Department.class;
        }
    }

    @PermissionForRight(value=Right.ManageInstructors)
    public static class ManageInstructors
    implements Permission<Department> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Department source) {
            return this.permissionDepartment.check(user, source, DepartmentStatusType.Status.OwnerLimitedEdit);
        }

        @Override
        public Class<Department> type() {
            return Department.class;
        }
    }

    @PermissionForRight(value=Right.InstructorsExportPdf)
    public static class InstructorsExportPdf
    extends Instructors {
    }

    @PermissionForRight(value=Right.Instructors)
    public static class Instructors
    implements Permission<Department> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Department source) {
            return this.permissionDepartment.check(user, source);
        }

        @Override
        public Class<Department> type() {
            return Department.class;
        }
    }

    @PermissionForRight(value=Right.InstructorAdd)
    public static class InstructorAdd
    implements Permission<Department> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Department source) {
            return this.permissionDepartment.check(user, source, DepartmentStatusType.Status.OwnerLimitedEdit);
        }

        @Override
        public Class<Department> type() {
            return Department.class;
        }
    }

    @PermissionForRight(value=Right.InstructorEditClearPreferences)
    public static class InstructorEditClearPreferences
    extends InstructorPreferences {
    }

    @PermissionForRight(value=Right.InstructorPreferences)
    public static class InstructorPreferences
    implements Permission<DepartmentalInstructor> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, DepartmentalInstructor source) {
            if (!(user.getCurrentAuthority().hasRight(Right.HasRole) || source.getExternalUniqueId() != null && source.getExternalUniqueId().equals(user.getExternalUserId()))) {
                return false;
            }
            return this.permissionDepartment.check(user, source.getDepartment(), DepartmentStatusType.Status.OwnerEdit);
        }

        @Override
        public Class<DepartmentalInstructor> type() {
            return DepartmentalInstructor.class;
        }
    }

    @PermissionForRight(value=Right.InstructorDelete)
    public static class DeleteInstructor
    extends EditInstructor {
        @Override
        public boolean check(UserContext user, DepartmentalInstructor source) {
            if (!source.getClasses().isEmpty()) {
                return false;
            }
            if (!source.getExams().isEmpty()) {
                return false;
            }
            return super.check(user, source);
        }
    }

    @PermissionForRight(value=Right.InstructorEdit)
    public static class EditInstructor
    implements Permission<DepartmentalInstructor> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, DepartmentalInstructor source) {
            if (!(user.getCurrentAuthority().hasRight(Right.HasRole) || source.getExternalUniqueId() != null && source.getExternalUniqueId().equals(user.getExternalUserId()))) {
                return false;
            }
            return this.permissionDepartment.check(user, source.getDepartment(), DepartmentStatusType.Status.OwnerLimitedEdit);
        }

        @Override
        public Class<DepartmentalInstructor> type() {
            return DepartmentalInstructor.class;
        }
    }

    @PermissionForRight(value=Right.InstructorDetail)
    public static class InstructorDetail
    implements Permission<DepartmentalInstructor> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, DepartmentalInstructor source) {
            if (!(user.getCurrentAuthority().hasRight(Right.HasRole) || source.getExternalUniqueId() != null && source.getExternalUniqueId().equals(user.getExternalUserId()))) {
                return false;
            }
            return this.permissionDepartment.check(user, source.getDepartment(), DepartmentStatusType.Status.OwnerView);
        }

        @Override
        public Class<DepartmentalInstructor> type() {
            return DepartmentalInstructor.class;
        }
    }

    @PermissionForRight(value=Right.AssignInstructorsClass)
    public static class AssignInstructorsClass
    implements Permission<Class_> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, Class_ source) {
            return this.permissionDepartment.check(user, source.getControllingDept(), DepartmentStatusType.Status.OwnerLimitedEdit, source.getManagingDept(), DepartmentStatusType.Status.ManagerLimitedEdit);
        }

        @Override
        public Class<Class_> type() {
            return Class_.class;
        }
    }

    @PermissionForRight(value=Right.AssignInstructors)
    public static class AssignInstructors
    implements Permission<InstrOfferingConfig> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, InstrOfferingConfig source) {
            if (this.permissionDepartment.check(user, source.getDepartment(), DepartmentStatusType.Status.OwnerLimitedEdit)) {
                return true;
            }
            HashSet<Department> externals = new HashSet<Department>();
            for (SchedulingSubpart subpart : source.getSchedulingSubparts()) {
                for (Class_ clazz : subpart.getClasses()) {
                    if (clazz.getManagingDept() == null || !clazz.getManagingDept().isExternalManager().booleanValue() || !externals.add(clazz.getManagingDept()) || !this.permissionDepartment.check(user, clazz.getManagingDept(), DepartmentStatusType.Status.ManagerLimitedEdit)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public Class<InstrOfferingConfig> type() {
            return InstrOfferingConfig.class;
        }
    }
}

