/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.Iterator;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesDefinitions;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.DepartmentEditForm;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.security.rights.Right;

@Action(value="departmentEdit", results={@Result(name={"add"}, type="tiles", location="departmentAdd.tiles"), @Result(name={"edit"}, type="tiles", location="departmentEdit.tiles"), @Result(name={"back"}, type="redirect", location="/departmentList.action", params={"anchor", "${form.id}"})})
@TilesDefinitions(value={@TilesDefinition(name="departmentAdd.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Add Department"), @TilesPutAttribute(name="body", value="/admin/departmentEdit.jsp")}), @TilesDefinition(name="departmentEdit.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Edit Department"), @TilesPutAttribute(name="body", value="/admin/departmentEdit.jsp")})})
public class DepartmentEditAction
extends UniTimeAction<DepartmentEditForm> {
    private static final long serialVersionUID = 338267053887154529L;
    protected static final GwtMessages MSG = Localization.create(GwtMessages.class);
    private Long id;
    private Integer deleteId;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getDeleteId() {
        return this.deleteId;
    }

    public void setDeleteId(Integer deleteId) {
        this.deleteId = deleteId;
    }

    public String execute() throws Exception {
        Department department;
        if (this.form == null) {
            this.form = new DepartmentEditForm();
        }
        this.sessionContext.checkPermission(Right.Departments);
        if (this.op == null) {
            this.op = ((DepartmentEditForm)this.form).getOp();
        }
        this.request.setAttribute(Department.DEPT_ATTR_NAME, Department.findAllNonExternal(this.sessionContext.getUser().getCurrentAcademicSessionId()));
        if ("Edit".equalsIgnoreCase(this.op) && (department = (Department)DepartmentDAO.getInstance().get(this.id)) != null) {
            if (this.sessionContext.hasPermission(department, Right.DepartmentLimitedEdit)) {
                ((DepartmentEditForm)this.form).setFullyEditable(false);
            } else {
                ((DepartmentEditForm)this.form).setFullyEditable(true);
                this.sessionContext.checkPermission(department, Right.DepartmentEdit);
            }
            ((DepartmentEditForm)this.form).load(department);
            return "edit";
        }
        if (DepartmentEditAction.stripAccessKey(MSG.buttonAddDepartment()).equalsIgnoreCase(this.op)) {
            ((DepartmentEditForm)this.form).reset();
            ((DepartmentEditForm)this.form).setSessionId(this.sessionContext.getUser().getCurrentAcademicSessionId());
            ((DepartmentEditForm)this.form).setInheritInstructorPreferences(true);
            ((DepartmentEditForm)this.form).setAllowStudentScheduling(true);
            ((DepartmentEditForm)this.form).setFullyEditable(true);
            this.sessionContext.checkPermission(Right.DepartmentAdd);
            return "add";
        }
        if (DepartmentEditAction.stripAccessKey(MSG.buttonUpdate()).equalsIgnoreCase(this.op) || DepartmentEditAction.stripAccessKey(MSG.buttonSave()).equalsIgnoreCase(this.op)) {
            ((DepartmentEditForm)this.form).validate(this);
            if (this.hasFieldErrors()) {
                return ((DepartmentEditForm)this.form).getId() != null ? "edit" : "add";
            }
            if (((DepartmentEditForm)this.form).getId() == null || ((DepartmentEditForm)this.form).getId().equals(0L)) {
                this.sessionContext.checkPermission(Right.DepartmentAdd);
            } else if (!((DepartmentEditForm)this.form).isFullyEditable()) {
                this.sessionContext.checkPermission(((DepartmentEditForm)this.form).getId(), "Department", Right.DepartmentLimitedEdit);
            } else {
                this.sessionContext.checkPermission(((DepartmentEditForm)this.form).getId(), "Department", Right.DepartmentEdit);
            }
            ((DepartmentEditForm)this.form).save(this.sessionContext);
        }
        if (DepartmentEditAction.stripAccessKey(MSG.buttonDependentAddStatus()).equals(this.op)) {
            ((DepartmentEditForm)this.form).addBlankDependentDepartment();
            return ((DepartmentEditForm)this.form).getId() != null ? "edit" : "add";
        }
        if (DepartmentEditAction.stripAccessKey(MSG.buttonDependentDeleteAll()).equals(this.op)) {
            ((DepartmentEditForm)this.form).deleteAllDependentDepartments();
            return ((DepartmentEditForm)this.form).getId() != null ? "edit" : "add";
        }
        if (DepartmentEditAction.stripAccessKey(MSG.buttonDeleteLine()).equals(this.op) && this.deleteId != null) {
            ((DepartmentEditForm)this.form).deleteDependentDepartment(this.deleteId);
            return ((DepartmentEditForm)this.form).getId() != null ? "edit" : "add";
        }
        if (DepartmentEditAction.stripAccessKey(MSG.buttonDelete()).equals(this.op)) {
            this.doDelete();
        }
        return "back";
    }

    private void doDelete() throws Exception {
        this.sessionContext.checkPermission(((DepartmentEditForm)this.form).getId(), "Department", Right.DepartmentDelete);
        Session hibSession = new DepartmentDAO().getSession();
        Transaction tx = null;
        try {
            tx = hibSession.beginTransaction();
            Department department = (Department)new DepartmentDAO().get(((DepartmentEditForm)this.form).getId(), hibSession);
            if (department.isExternalManager().booleanValue()) {
                Iterator i = hibSession.createQuery("select c from Class_ c where c.managingDept.uniqueId=:deptId").setLong("deptId", department.getUniqueId().longValue()).iterate();
                while (i.hasNext()) {
                    Preference pref;
                    Iterator<Preference> j;
                    Class_ clazz = (Class_)i.next();
                    if (clazz.getSchedulingSubpart().getManagingDept().equals(department)) {
                        j = clazz.getSchedulingSubpart().getPreferences().iterator();
                        while (j.hasNext()) {
                            pref = j.next();
                            if (pref instanceof TimePref) continue;
                            j.remove();
                        }
                        clazz.getSchedulingSubpart().deleteAllDistributionPreferences(hibSession);
                        hibSession.saveOrUpdate((Object)clazz.getSchedulingSubpart());
                    }
                    clazz.setManagingDept(clazz.getControllingDept(), this.sessionContext.getUser(), hibSession);
                    j = clazz.getPreferences().iterator();
                    while (j.hasNext()) {
                        pref = j.next();
                        if (pref instanceof TimePref) continue;
                        j.remove();
                    }
                    clazz.deleteAllDistributionPreferences(hibSession);
                    hibSession.saveOrUpdate((Object)clazz);
                }
            } else {
                hibSession.createQuery("delete StudentClassEnrollment e where e.clazz.uniqueId in (select c.uniqueId from Class_ c, CourseOffering co where co.isControl=true and c.schedulingSubpart.instrOfferingConfig.instructionalOffering=co.instructionalOffering and co.subjectArea.department.uniqueId=:deptId)").setLong("deptId", department.getUniqueId().longValue()).executeUpdate();
            }
            ChangeLog.addChange(hibSession, this.sessionContext, department, ChangeLog.Source.DEPARTMENT_EDIT, ChangeLog.Operation.DELETE, null, null);
            hibSession.delete((Object)department);
            tx.commit();
            HibernateUtil.clearCache();
        }
        catch (HibernateException e) {
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public String getSession() {
        return this.sessionContext.getUser().getCurrentAuthority().getQualifiers("Session").get(0).getQualifierLabel();
    }
}

