/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.util;

import com.google.ical.util.Predicate;
import java.io.Serializable;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Predicates {
    private static final Predicate<?> ALWAYS_TRUE = new AlwaysTruePredicate();
    private static final Predicate<?> ALWAYS_FALSE = new AlwaysFalsePredicate();

    private Predicates() {
    }

    public static <T> Predicate<T> alwaysTrue() {
        return ALWAYS_TRUE;
    }

    public static <T> Predicate<T> alwaysFalse() {
        return ALWAYS_FALSE;
    }

    public static <T> Predicate<T> not(Predicate<? super T> predicate) {
        assert (null != predicate);
        return new NotPredicate(predicate);
    }

    public static <T> Predicate<T> and(Predicate<? super T> ... components) {
        assert (null != components);
        components = (Predicate[])components.clone();
        int n = components.length;
        for (int i = 0; i < n; ++i) {
            Predicate<? super T> p = components[i];
            if (p == ALWAYS_FALSE) {
                return Predicates.alwaysFalse();
            }
            if (p != ALWAYS_TRUE) continue;
            components[i] = components[n - 1];
            --i;
            --n;
        }
        if (n == 0) {
            return Predicates.alwaysTrue();
        }
        if (n != components.length) {
            Predicate[] newComponents = new Predicate[n];
            System.arraycopy(newComponents, 0, components, 0, n);
            components = newComponents;
        }
        return new AndPredicate((Predicate[])components);
    }

    public static <T> Predicate<T> and(Collection<Predicate<? super T>> components) {
        int n = components.size();
        Predicate[] arr = new Predicate[n];
        components.toArray(arr);
        return Predicates.and(arr);
    }

    public static <T> Predicate<T> or(Predicate<? super T> ... components) {
        assert (components != null);
        components = (Predicate[])components.clone();
        int n = components.length;
        for (int i = 0; i < n; ++i) {
            Predicate<? super T> p = components[i];
            if (p == ALWAYS_TRUE) {
                return Predicates.alwaysTrue();
            }
            if (p != ALWAYS_FALSE) continue;
            components[i] = components[n - 1];
            --i;
            --n;
        }
        if (components.length == 0) {
            return Predicates.alwaysFalse();
        }
        if (n != components.length) {
            Predicate[] newComponents = new Predicate[n];
            System.arraycopy(newComponents, 0, components, 0, n);
            components = newComponents;
        }
        return new OrPredicate((Predicate[])components);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OrPredicate<T>
    implements Predicate<T>,
    Serializable {
        private static final long serialVersionUID = -7942366790698074803L;
        private final Predicate<? super T>[] components;

        private OrPredicate(Predicate<? super T> ... components) {
            this.components = components;
        }

        @Override
        public boolean apply(T t) {
            for (Predicate<T> predicate : this.components) {
                if (!predicate.apply(t)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AndPredicate<T>
    implements Predicate<T>,
    Serializable {
        private static final long serialVersionUID = 1022358602593297546L;
        private final Predicate<? super T>[] components;

        private AndPredicate(Predicate<? super T> ... components) {
            this.components = components;
        }

        @Override
        public boolean apply(T t) {
            for (Predicate<T> predicate : this.components) {
                if (predicate.apply(t)) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NotPredicate<T>
    implements Predicate<T>,
    Serializable {
        private static final long serialVersionUID = -5113445916422049953L;
        private final Predicate<? super T> predicate;

        private NotPredicate(Predicate<? super T> predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean apply(T t) {
            return !this.predicate.apply(t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AlwaysFalsePredicate<T>
    implements Predicate<T>,
    Serializable {
        private static final long serialVersionUID = -565481022115659695L;

        private AlwaysFalsePredicate() {
        }

        @Override
        public boolean apply(T t) {
            return false;
        }

        public String toString() {
            return "false";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AlwaysTruePredicate<T>
    implements Predicate<T>,
    Serializable {
        private static final long serialVersionUID = 8759914710239461322L;

        private AlwaysTruePredicate() {
        }

        @Override
        public boolean apply(T t) {
            return true;
        }

        public String toString() {
            return "true";
        }
    }
}

