/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.xml;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.ICalendar;
import biweekly.component.ICalComponent;
import biweekly.component.VTimezone;
import biweekly.io.SkipMeException;
import biweekly.io.StreamWriter;
import biweekly.io.scribe.component.ICalComponentScribe;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalQNames;
import biweekly.parameter.ICalParameters;
import biweekly.property.ICalProperty;
import biweekly.property.Version;
import biweekly.property.Xml;
import biweekly.util.IOUtils;
import biweekly.util.StringUtils;
import biweekly.util.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XCalWriter
extends StreamWriter {
    private final Document DOC = XmlUtils.createDocument();
    private final Map<String, ICalDataType> parameterDataTypes = new HashMap<String, ICalDataType>();
    private final Writer writer;
    private final ICalVersion targetVersion;
    private final TransformerHandler handler;
    private final boolean icalendarElementExists;
    private String indent;
    private int level;
    private boolean textNodeJustPrinted;
    private boolean started;

    public XCalWriter(OutputStream out) {
        this(IOUtils.utf8Writer(out));
    }

    public XCalWriter(File file) throws IOException {
        this(IOUtils.utf8Writer(file));
    }

    public XCalWriter(Writer writer) {
        this(writer, null);
    }

    public XCalWriter(Node parent) {
        this(null, parent);
    }

    private XCalWriter(Writer writer, Node parent) {
        Node root;
        this.registerParameterDataType("CN", ICalDataType.TEXT);
        this.registerParameterDataType("ALTREP", ICalDataType.URI);
        this.registerParameterDataType("CUTYPE", ICalDataType.TEXT);
        this.registerParameterDataType("DELEGATED-FROM", ICalDataType.CAL_ADDRESS);
        this.registerParameterDataType("DELEGATED-TO", ICalDataType.CAL_ADDRESS);
        this.registerParameterDataType("DIR", ICalDataType.URI);
        this.registerParameterDataType("ENCODING", ICalDataType.TEXT);
        this.registerParameterDataType("FMTTYPE", ICalDataType.TEXT);
        this.registerParameterDataType("FBTYPE", ICalDataType.TEXT);
        this.registerParameterDataType("LANGUAGE", ICalDataType.TEXT);
        this.registerParameterDataType("MEMBER", ICalDataType.CAL_ADDRESS);
        this.registerParameterDataType("PARTSTAT", ICalDataType.TEXT);
        this.registerParameterDataType("RANGE", ICalDataType.TEXT);
        this.registerParameterDataType("RELATED", ICalDataType.TEXT);
        this.registerParameterDataType("RELTYPE", ICalDataType.TEXT);
        this.registerParameterDataType("ROLE", ICalDataType.TEXT);
        this.registerParameterDataType("RSVP", ICalDataType.BOOLEAN);
        this.registerParameterDataType("SENT-BY", ICalDataType.CAL_ADDRESS);
        this.registerParameterDataType("TZID", ICalDataType.TEXT);
        this.targetVersion = ICalVersion.V2_0;
        this.level = 0;
        this.textNodeJustPrinted = false;
        this.started = false;
        this.writer = writer;
        if (parent instanceof Document && (root = parent.getFirstChild()) != null) {
            parent = root;
        }
        this.icalendarElementExists = this.isICalendarElement(parent);
        try {
            SAXTransformerFactory factory = (SAXTransformerFactory)TransformerFactory.newInstance();
            this.handler = factory.newTransformerHandler();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        Result result = writer == null ? new DOMResult(parent) : new StreamResult(writer);
        this.handler.setResult(result);
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    private boolean isICalendarElement(Node node) {
        if (node == null) {
            return false;
        }
        if (!(node instanceof Element)) {
            return false;
        }
        return XmlUtils.hasQName(node, XCalQNames.ICALENDAR);
    }

    public void registerParameterDataType(String parameterName, ICalDataType dataType) {
        parameterName = parameterName.toLowerCase();
        if (dataType == null) {
            this.parameterDataTypes.remove(parameterName);
        } else {
            this.parameterDataTypes.put(parameterName, dataType);
        }
    }

    protected void _write(ICalendar ical) throws IOException {
        try {
            if (!this.started) {
                this.handler.startDocument();
                if (!this.icalendarElementExists) {
                    this.start(XCalQNames.ICALENDAR);
                    ++this.level;
                }
                this.started = true;
            }
            this.write((ICalComponent)ical);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    protected ICalVersion getTargetVersion() {
        return this.targetVersion;
    }

    private void write(ICalComponent component) throws SAXException {
        ICalComponentScribe<? extends ICalComponent> scribe = this.index.getComponentScribe(component);
        String name = scribe.getComponentName().toLowerCase();
        this.start(name);
        ++this.level;
        List<ICalProperty> properties = scribe.getProperties(component);
        if (component instanceof ICalendar && component.getProperty(Version.class) == null) {
            properties.add(0, new Version(this.targetVersion));
        }
        if (!properties.isEmpty()) {
            this.start(XCalQNames.PROPERTIES);
            ++this.level;
            for (ICalProperty propertyObj : properties) {
                this.context.setParent(component);
                ICalProperty property = propertyObj;
                this.write(property);
            }
            --this.level;
            this.end(XCalQNames.PROPERTIES);
        }
        Collection<ICalComponent> subComponents = scribe.getComponents(component);
        if (component instanceof ICalendar) {
            Collection<VTimezone> tzs = this.tzinfo.getComponents();
            for (VTimezone tz : tzs) {
                if (subComponents.contains(tz)) continue;
                subComponents.add(tz);
            }
        }
        if (!subComponents.isEmpty()) {
            this.start(XCalQNames.COMPONENTS);
            ++this.level;
            Iterator<ICalComponent> i$ = subComponents.iterator();
            while (i$.hasNext()) {
                ICalComponent subComponentObj;
                ICalComponent subComponent = subComponentObj = i$.next();
                this.write(subComponent);
            }
            --this.level;
            this.end(XCalQNames.COMPONENTS);
        }
        --this.level;
        this.end(name);
    }

    private void write(ICalProperty property) throws SAXException {
        Element propertyElement;
        ICalPropertyScribe<? extends ICalProperty> scribe = this.index.getPropertyScribe(property);
        ICalParameters parameters = scribe.prepareParameters(property, this.context);
        if (property instanceof Xml) {
            Xml xml = (Xml)property;
            Document value = (Document)xml.getValue();
            if (value == null) {
                return;
            }
            propertyElement = XmlUtils.getRootElement(value);
        } else {
            QName qname = scribe.getQName();
            propertyElement = this.DOC.createElementNS(qname.getNamespaceURI(), qname.getLocalPart());
            try {
                scribe.writeXml(property, propertyElement, this.context);
            }
            catch (SkipMeException e) {
                return;
            }
        }
        this.start(propertyElement);
        ++this.level;
        this.write(parameters);
        this.write(propertyElement);
        --this.level;
        this.end(propertyElement);
    }

    private void write(Element propertyElement) throws SAXException {
        NodeList children = propertyElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child instanceof Element) {
                Element element = (Element)child;
                if (element.hasChildNodes()) {
                    this.start(element);
                    ++this.level;
                    this.write(element);
                    --this.level;
                    this.end(element);
                    continue;
                }
                this.childless(element);
                continue;
            }
            if (!(child instanceof Text)) continue;
            Text text = (Text)child;
            this.text(text.getTextContent());
        }
    }

    private void write(ICalParameters parameters) throws SAXException {
        if (parameters.isEmpty()) {
            return;
        }
        this.start(XCalQNames.PARAMETERS);
        ++this.level;
        for (Map.Entry parameter : parameters) {
            String parameterName = ((String)parameter.getKey()).toLowerCase();
            this.start(parameterName);
            ++this.level;
            for (String parameterValue : parameter.getValue()) {
                ICalDataType dataType = this.parameterDataTypes.get(parameterName);
                String dataTypeElementName = dataType == null ? "unknown" : dataType.getName().toLowerCase();
                this.start(dataTypeElementName);
                this.text(parameterValue);
                this.end(dataTypeElementName);
            }
            --this.level;
            this.end(parameterName);
        }
        --this.level;
        this.end(XCalQNames.PARAMETERS);
    }

    private void indent() throws SAXException {
        if (this.indent == null) {
            return;
        }
        String str = '\n' + StringUtils.repeat(this.indent, this.level);
        this.handler.ignorableWhitespace(str.toCharArray(), 0, str.length());
    }

    private void childless(Element element) throws SAXException {
        Attributes attributes = this.getElementAttributes(element);
        this.indent();
        this.handler.startElement(element.getNamespaceURI(), "", element.getLocalName(), attributes);
        this.handler.endElement(element.getNamespaceURI(), "", element.getLocalName());
    }

    private void start(Element element) throws SAXException {
        Attributes attributes = this.getElementAttributes(element);
        this.start(element.getNamespaceURI(), element.getLocalName(), attributes);
    }

    private void start(String element) throws SAXException {
        this.start(element, null);
    }

    private void start(QName qname) throws SAXException {
        this.start(qname, null);
    }

    private void start(QName qname, Attributes attributes) throws SAXException {
        this.start(qname.getNamespaceURI(), qname.getLocalPart(), attributes);
    }

    private void start(String element, Attributes attributes) throws SAXException {
        this.start("urn:ietf:params:xml:ns:icalendar-2.0", element, attributes);
    }

    private void start(String namespace, String element, Attributes attributes) throws SAXException {
        this.indent();
        this.handler.startElement(namespace, "", element, attributes);
    }

    private void end(Element element) throws SAXException {
        this.end(element.getNamespaceURI(), element.getLocalName());
    }

    private void end(String element) throws SAXException {
        this.end("urn:ietf:params:xml:ns:icalendar-2.0", element);
    }

    private void end(QName qname) throws SAXException {
        this.end(qname.getNamespaceURI(), qname.getLocalPart());
    }

    private void end(String namespace, String element) throws SAXException {
        if (!this.textNodeJustPrinted) {
            this.indent();
        }
        this.handler.endElement(namespace, "", element);
        this.textNodeJustPrinted = false;
    }

    private void text(String text) throws SAXException {
        this.handler.characters(text.toCharArray(), 0, text.length());
        this.textNodeJustPrinted = true;
    }

    private Attributes getElementAttributes(Element element) {
        AttributesImpl attributes = new AttributesImpl();
        NamedNodeMap attributeNodes = element.getAttributes();
        for (int i = 0; i < attributeNodes.getLength(); ++i) {
            Node node = attributeNodes.item(i);
            attributes.addAttribute(node.getNamespaceURI(), "", node.getLocalName(), "", node.getNodeValue());
        }
        return attributes;
    }

    public void close() throws IOException {
        try {
            if (!this.started) {
                this.handler.startDocument();
                if (!this.icalendarElementExists) {
                    this.start(XCalQNames.ICALENDAR);
                    ++this.level;
                }
            }
            if (!this.icalendarElementExists) {
                --this.level;
                this.end(XCalQNames.ICALENDAR);
            }
            this.handler.endDocument();
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        if (this.writer != null) {
            this.writer.close();
        }
    }
}

