/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.io.CannotParseException;
import biweekly.io.ParseContext;
import biweekly.io.WriteContext;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.ICalProperty;
import biweekly.property.RecurrenceDates;
import biweekly.util.Duration;
import biweekly.util.ICalDate;
import biweekly.util.Period;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecurrenceDatesScribe
extends ICalPropertyScribe<RecurrenceDates> {
    public RecurrenceDatesScribe() {
        super(RecurrenceDates.class, "RDATE", ICalDataType.DATE_TIME);
    }

    @Override
    protected ICalParameters _prepareParameters(RecurrenceDates property, WriteContext context) {
        ICalDataType dataType;
        if (RecurrenceDatesScribe.isInObservance(context)) {
            return property.getParameters();
        }
        List<Period> periods = property.getPeriods();
        List<ICalDate> dates = property.getDates();
        boolean hasTime = periods.isEmpty() && dates.isEmpty() ? false : (dataType = this.dataType(property, context.getVersion())) == ICalDataType.DATE_TIME || dataType == ICalDataType.PERIOD;
        return RecurrenceDatesScribe.handleTzidParameter(property, hasTime, context);
    }

    @Override
    protected ICalDataType _dataType(RecurrenceDates property, ICalVersion version) {
        List<ICalDate> dates = property.getDates();
        if (!dates.isEmpty()) {
            return dates.get(0).hasTime() ? ICalDataType.DATE_TIME : ICalDataType.DATE;
        }
        if (!property.getPeriods().isEmpty()) {
            return ICalDataType.PERIOD;
        }
        return this.defaultDataType(version);
    }

    @Override
    protected String _writeText(final RecurrenceDates property, final WriteContext context) {
        List<ICalDate> dates = property.getDates();
        if (!dates.isEmpty()) {
            final boolean inObservance = RecurrenceDatesScribe.isInObservance(context);
            return RecurrenceDatesScribe.list(dates, new ICalPropertyScribe.ListCallback<ICalDate>(){

                @Override
                public String asString(ICalDate date) {
                    if (inObservance) {
                        return ICalPropertyScribe.date(date).observance(true).extended(false).write();
                    }
                    return ICalPropertyScribe.date(date, (ICalProperty)property, context).extended(false).write();
                }
            });
        }
        List<Period> periods = property.getPeriods();
        if (!periods.isEmpty()) {
            return RecurrenceDatesScribe.list(periods, new ICalPropertyScribe.ListCallback<Period>(){

                @Override
                public String asString(Period period) {
                    StringBuilder sb = new StringBuilder();
                    Date start = period.getStartDate();
                    if (start != null) {
                        String date = ICalPropertyScribe.date(start, (ICalProperty)property, context).extended(false).write();
                        sb.append(date);
                    }
                    sb.append('/');
                    Date end = period.getEndDate();
                    Duration duration = period.getDuration();
                    if (end != null) {
                        String date = ICalPropertyScribe.date(end, (ICalProperty)property, context).extended(false).write();
                        sb.append(date);
                    } else if (duration != null) {
                        sb.append(duration);
                    }
                    return sb.toString();
                }
            });
        }
        return "";
    }

    @Override
    protected RecurrenceDates _parseText(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        return this.parse(RecurrenceDatesScribe.list(value), dataType, parameters, context);
    }

    @Override
    protected void _writeXml(RecurrenceDates property, XCalElement element, WriteContext context) {
        ICalDataType dataType = this.dataType(property, context.getVersion());
        List<ICalDate> dates = property.getDates();
        if (!dates.isEmpty()) {
            boolean inObservance = RecurrenceDatesScribe.isInObservance(context);
            for (ICalDate date : dates) {
                String dateStr = inObservance ? RecurrenceDatesScribe.date(date).observance(true).extended(true).write() : RecurrenceDatesScribe.date(date, (ICalProperty)property, context).extended(true).write();
                element.append(dataType, dateStr);
            }
            return;
        }
        List<Period> periods = property.getPeriods();
        if (!periods.isEmpty()) {
            for (Period period : periods) {
                Duration duration;
                Date end;
                XCalElement periodElement = element.append(dataType);
                Date start = period.getStartDate();
                if (start != null) {
                    String dateStr = RecurrenceDatesScribe.date(start, (ICalProperty)property, context).extended(true).write();
                    periodElement.append("start", dateStr);
                }
                if ((end = period.getEndDate()) != null) {
                    String dateStr = RecurrenceDatesScribe.date(end, (ICalProperty)property, context).extended(true).write();
                    periodElement.append("end", dateStr);
                }
                if ((duration = period.getDuration()) == null) continue;
                periodElement.append("duration", duration.toString());
            }
            return;
        }
        element.append(this.defaultDataType(context.getVersion()), "");
    }

    @Override
    protected RecurrenceDates _parseXml(XCalElement element, ICalParameters parameters, ParseContext context) {
        ICalDate date;
        List<XCalElement> periodElements = element.children(ICalDataType.PERIOD);
        List<String> dateTimeElements = element.all(ICalDataType.DATE_TIME);
        List<String> dateElements = element.all(ICalDataType.DATE);
        if (periodElements.isEmpty() && dateTimeElements.isEmpty() && dateElements.isEmpty()) {
            throw RecurrenceDatesScribe.missingXmlElements(ICalDataType.PERIOD, ICalDataType.DATE_TIME, ICalDataType.DATE);
        }
        RecurrenceDates property = new RecurrenceDates();
        for (XCalElement periodElement : periodElements) {
            ICalDate start;
            String startStr = periodElement.first("start");
            if (startStr == null) {
                throw new CannotParseException(9, new Object[0]);
            }
            try {
                start = RecurrenceDatesScribe.date(startStr).parse();
            }
            catch (IllegalArgumentException e) {
                throw new CannotParseException(10, startStr);
            }
            String endStr = periodElement.first("end");
            if (endStr != null) {
                try {
                    ICalDate end = RecurrenceDatesScribe.date(endStr).parse();
                    property.addPeriod(new Period((Date)start, end));
                    context.addDate(start, property, parameters);
                    context.addDate(end, property, parameters);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new CannotParseException(11, endStr);
                }
            }
            String durationStr = periodElement.first("duration");
            if (durationStr != null) {
                try {
                    Duration duration = Duration.parse(durationStr);
                    property.addPeriod(new Period((Date)start, duration));
                    context.addDate(start, property, parameters);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new CannotParseException(12, durationStr);
                }
            }
            throw new CannotParseException(13, new Object[0]);
        }
        for (String dateTimeStr : dateTimeElements) {
            try {
                date = RecurrenceDatesScribe.date(dateTimeStr).hasTime(true).parse();
                property.addDate(date);
                context.addDate(date, property, parameters);
            }
            catch (IllegalArgumentException e) {
                throw new CannotParseException(15, dateTimeStr);
            }
        }
        for (String dateStr : dateElements) {
            try {
                date = RecurrenceDatesScribe.date(dateStr).hasTime(false).parse();
                property.addDate(date);
            }
            catch (IllegalArgumentException e) {
                throw new CannotParseException(15, dateStr);
            }
        }
        return property;
    }

    @Override
    protected JCalValue _writeJson(RecurrenceDates property, WriteContext context) {
        ArrayList<String> values = new ArrayList<String>();
        List<ICalDate> dates = property.getDates();
        List<Period> periods = property.getPeriods();
        if (!dates.isEmpty()) {
            boolean inObservance = RecurrenceDatesScribe.isInObservance(context);
            for (ICalDate date : dates) {
                String dateStr = inObservance ? RecurrenceDatesScribe.date(date).observance(true).extended(true).write() : RecurrenceDatesScribe.date(date, (ICalProperty)property, context).extended(true).write();
                values.add(dateStr);
            }
        } else if (!periods.isEmpty()) {
            for (Period period : property.getPeriods()) {
                StringBuilder sb = new StringBuilder();
                Date start = period.getStartDate();
                if (start != null) {
                    String dateStr = RecurrenceDatesScribe.date(start, (ICalProperty)property, context).extended(true).write();
                    sb.append(dateStr);
                }
                sb.append('/');
                Date end = period.getEndDate();
                Duration duration = period.getDuration();
                if (end != null) {
                    String dateStr = RecurrenceDatesScribe.date(end, (ICalProperty)property, context).extended(true).write();
                    sb.append(dateStr);
                } else if (duration != null) {
                    sb.append(duration);
                }
                values.add(sb.toString());
            }
        }
        if (values.isEmpty()) {
            values.add("");
        }
        return JCalValue.multi(values);
    }

    @Override
    protected RecurrenceDates _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        return this.parse(value.asMulti(), dataType, parameters, context);
    }

    private RecurrenceDates parse(List<String> valueStrs, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        RecurrenceDates property = new RecurrenceDates();
        if (dataType == ICalDataType.PERIOD) {
            for (String timePeriodStr : valueStrs) {
                ICalDate start;
                String[] timePeriodStrSplit = timePeriodStr.split("/");
                if (timePeriodStrSplit.length < 2) {
                    throw new CannotParseException(13, new Object[0]);
                }
                String startStr = timePeriodStrSplit[0];
                try {
                    start = RecurrenceDatesScribe.date(startStr).parse();
                }
                catch (IllegalArgumentException e) {
                    throw new CannotParseException(10, startStr);
                }
                String endStr = timePeriodStrSplit[1];
                ICalDate end = null;
                try {
                    end = RecurrenceDatesScribe.date(endStr).parse();
                    property.addPeriod(new Period((Date)start, end));
                    context.addDate(start, property, parameters);
                    context.addDate(end, property, parameters);
                }
                catch (IllegalArgumentException e) {
                    try {
                        Duration duration = Duration.parse(endStr);
                        property.addPeriod(new Period((Date)start, duration));
                        context.addDate(start, property, parameters);
                    }
                    catch (IllegalArgumentException e2) {
                        throw new CannotParseException(14, endStr);
                    }
                }
            }
            return property;
        }
        boolean hasTime = dataType == ICalDataType.DATE_TIME;
        for (String valueStr : valueStrs) {
            ICalDate date;
            try {
                date = RecurrenceDatesScribe.date(valueStr).hasTime(hasTime).parse();
            }
            catch (IllegalArgumentException e) {
                throw new CannotParseException(15, valueStr);
            }
            property.addDate(date);
            context.addDate(date, property, parameters);
        }
        return property;
    }
}

