/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.io.ParseContext;
import biweekly.io.WriteContext;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.parameter.ICalParameters;
import biweekly.parameter.ParticipationLevel;
import biweekly.parameter.ParticipationStatus;
import biweekly.parameter.Role;
import biweekly.property.Attendee;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttendeeScribe
extends ICalPropertyScribe<Attendee> {
    public AttendeeScribe() {
        super(Attendee.class, "ATTENDEE");
    }

    @Override
    protected ICalDataType _defaultDataType(ICalVersion version) {
        switch (version) {
            case V1_0: {
                return null;
            }
        }
        return ICalDataType.CAL_ADDRESS;
    }

    @Override
    protected ICalDataType _dataType(Attendee property, ICalVersion version) {
        if (version == ICalVersion.V1_0 && property.getUri() != null) {
            return ICalDataType.URL;
        }
        return this.defaultDataType(version);
    }

    @Override
    protected ICalParameters _prepareParameters(Attendee property, WriteContext context) {
        String name;
        ParticipationStatus partStat;
        ICalParameters copy = new ICalParameters(property.getParameters());
        Boolean rsvp = property.getRsvp();
        if (rsvp != null) {
            String value = null;
            switch (context.getVersion()) {
                case V1_0: {
                    value = rsvp != false ? "YES" : "NO";
                    break;
                }
                default: {
                    value = rsvp != false ? "TRUE" : "FALSE";
                }
            }
            copy.put("RSVP", value);
        }
        Role role = property.getRole();
        ParticipationLevel level = property.getParticipationLevel();
        switch (context.getVersion()) {
            case V1_0: {
                if (role != null) {
                    copy.put("ROLE", role.getValue());
                }
                if (level == null) break;
                copy.put("EXPECT", level.getValue(context.getVersion()));
                break;
            }
            default: {
                String value = null;
                if (role == Role.CHAIR) {
                    value = role.getValue();
                } else if (level != null) {
                    value = level.getValue(context.getVersion());
                } else if (role != null) {
                    value = role.getValue();
                }
                if (value == null) break;
                copy.put("ROLE", value);
            }
        }
        if ((partStat = property.getParticipationStatus()) != null) {
            String paramValue;
            String paramName;
            switch (context.getVersion()) {
                case V1_0: {
                    paramName = "STATUS";
                    paramValue = partStat == ParticipationStatus.NEEDS_ACTION ? "NEEDS ACTION" : partStat.getValue();
                    break;
                }
                default: {
                    paramName = "PARTSTAT";
                    paramValue = partStat.getValue();
                }
            }
            copy.put(paramName, paramValue);
        }
        if ((name = property.getCommonName()) != null && context.getVersion() != ICalVersion.V1_0) {
            copy.put("CN", name);
        }
        return copy;
    }

    @Override
    protected Attendee _parseText(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        String uri = null;
        String name = null;
        String email = null;
        Boolean rsvp = null;
        String rsvpStr = (String)parameters.first("RSVP");
        Role role = null;
        String roleStr = (String)parameters.first("ROLE");
        ParticipationLevel level = null;
        ParticipationStatus status = null;
        switch (context.getVersion()) {
            case V1_0: {
                Pattern p;
                Matcher m;
                String statusStr;
                String expect;
                if (rsvpStr != null) {
                    if ("YES".equalsIgnoreCase(rsvpStr)) {
                        rsvp = Boolean.TRUE;
                    } else if ("NO".equalsIgnoreCase(rsvpStr)) {
                        rsvp = Boolean.FALSE;
                    }
                }
                if (roleStr != null) {
                    role = Role.get(roleStr);
                }
                if ((expect = (String)parameters.first("EXPECT")) != null) {
                    parameters.remove("EXPECT", expect);
                    level = ParticipationLevel.get(expect);
                }
                if ((statusStr = (String)parameters.first("STATUS")) != null) {
                    parameters.remove("STATUS", statusStr);
                    status = ParticipationStatus.get(statusStr);
                }
                if ((m = (p = Pattern.compile("^(.*?)<(.*?)>$")).matcher(value)).find()) {
                    name = m.group(1).trim();
                    email = m.group(2).trim();
                    break;
                }
                if (dataType == ICalDataType.URL) {
                    uri = value;
                    break;
                }
                email = value;
                break;
            }
            default: {
                Pattern p;
                Matcher m;
                String partStat;
                if (rsvpStr != null) {
                    if ("TRUE".equalsIgnoreCase(rsvpStr)) {
                        rsvp = Boolean.TRUE;
                    } else if ("FALSE".equalsIgnoreCase(rsvpStr)) {
                        rsvp = Boolean.FALSE;
                    }
                }
                if (roleStr != null) {
                    if (roleStr.equalsIgnoreCase(Role.CHAIR.getValue())) {
                        role = Role.CHAIR;
                    } else {
                        ParticipationLevel l = ParticipationLevel.find(roleStr);
                        if (l == null) {
                            role = Role.get(roleStr);
                        } else {
                            level = l;
                        }
                    }
                }
                if ((partStat = (String)parameters.first("PARTSTAT")) != null) {
                    parameters.remove("PARTSTAT", partStat);
                    status = ParticipationStatus.get(partStat);
                }
                if ((name = (String)parameters.first("CN")) != null) {
                    parameters.remove("CN", name);
                }
                if ((m = (p = Pattern.compile("^mailto:(.*?)$")).matcher(value)).find()) {
                    email = m.group(1);
                    break;
                }
                uri = value;
            }
        }
        if (rsvp != null) {
            parameters.removeAll("RSVP");
        }
        if (roleStr != null) {
            parameters.remove("ROLE", roleStr);
        }
        Attendee attendee = new Attendee(name, email);
        attendee.setParticipationStatus(status);
        attendee.setParticipationLevel(level);
        attendee.setRole(role);
        attendee.setRsvp(rsvp);
        attendee.setUri(uri);
        return attendee;
    }

    @Override
    protected String _writeText(Attendee property, WriteContext context) {
        String uri = property.getUri();
        if (uri != null) {
            return uri;
        }
        String name = property.getCommonName();
        String email = property.getEmail();
        switch (context.getVersion()) {
            case V1_0: {
                if (name != null && email != null) {
                    return AttendeeScribe.escape(name + " <" + email + ">");
                }
                if (email == null) break;
                return AttendeeScribe.escape(email);
            }
            default: {
                if (email == null) break;
                return "mailto:" + email;
            }
        }
        return "";
    }
}

