/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.json;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.ICalendar;
import biweekly.component.ICalComponent;
import biweekly.component.VTimezone;
import biweekly.io.SkipMeException;
import biweekly.io.StreamWriter;
import biweekly.io.json.JCalRawWriter;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.component.ICalComponentScribe;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.parameter.ICalParameters;
import biweekly.property.ICalProperty;
import biweekly.property.Version;
import biweekly.util.IOUtils;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class JCalWriter
extends StreamWriter
implements Flushable {
    private final JCalRawWriter writer;
    private final ICalVersion targetVersion = ICalVersion.V2_0;

    public JCalWriter(OutputStream out) {
        this(IOUtils.utf8Writer(out));
    }

    public JCalWriter(OutputStream out, boolean wrapInArray) {
        this(IOUtils.utf8Writer(out), wrapInArray);
    }

    public JCalWriter(File file) throws IOException {
        this(IOUtils.utf8Writer(file));
    }

    public JCalWriter(File file, boolean wrapInArray) throws IOException {
        this(IOUtils.utf8Writer(file), wrapInArray);
    }

    public JCalWriter(Writer writer) {
        this(writer, false);
    }

    public JCalWriter(Writer writer, boolean wrapInArray) {
        this.writer = new JCalRawWriter(writer, wrapInArray);
    }

    public boolean isIndent() {
        return this.writer.isIndent();
    }

    public void setIndent(boolean indent) {
        this.writer.setIndent(indent);
    }

    protected void _write(ICalendar ical) throws IOException {
        this.writeComponent(ical);
    }

    protected ICalVersion getTargetVersion() {
        return this.targetVersion;
    }

    private void writeComponent(ICalComponent component) throws IOException {
        ICalComponentScribe<? extends ICalComponent> componentScribe = this.index.getComponentScribe(component);
        this.writer.writeStartComponent(componentScribe.getComponentName().toLowerCase());
        List<ICalProperty> propertyObjs = componentScribe.getProperties(component);
        if (component instanceof ICalendar && component.getProperty(Version.class) == null) {
            propertyObjs.add(0, new Version(this.targetVersion));
        }
        for (ICalProperty propertyObj : propertyObjs) {
            JCalValue value;
            ICalParameters parameters;
            this.context.setParent(component);
            ICalProperty property = propertyObj;
            ICalPropertyScribe<? extends ICalProperty> propertyScribe = this.index.getPropertyScribe(property);
            try {
                parameters = propertyScribe.prepareParameters(property, this.context);
                value = propertyScribe.writeJson(property, this.context);
            }
            catch (SkipMeException e) {
                continue;
            }
            String propertyName = propertyScribe.getPropertyName().toLowerCase();
            ICalDataType dataType = propertyScribe.dataType(property, this.targetVersion);
            this.writer.writeProperty(propertyName, parameters, dataType, value);
        }
        Collection<ICalComponent> subComponents = componentScribe.getComponents(component);
        if (component instanceof ICalendar) {
            Collection<VTimezone> tzs = this.tzinfo.getComponents();
            for (VTimezone tz : tzs) {
                if (subComponents.contains(tz)) continue;
                subComponents.add(tz);
            }
        }
        Iterator<ICalComponent> i$ = subComponents.iterator();
        while (i$.hasNext()) {
            ICalComponent subComponentObj;
            ICalComponent subComponent = subComponentObj = i$.next();
            this.writeComponent(subComponent);
        }
        this.writer.writeEndComponent();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void closeJsonStream() throws IOException {
        this.writer.closeJsonStream();
    }
}

