/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.json;

import biweekly.ICalDataType;
import biweekly.io.json.JCalValue;
import biweekly.io.json.JsonValue;
import biweekly.parameter.ICalParameters;
import biweekly.util.StringUtils;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JCalRawWriter
implements Closeable,
Flushable {
    private final Writer writer;
    private final boolean wrapInArray;
    private final LinkedList<Info> stack = new LinkedList();
    private JsonGenerator generator;
    private boolean indent = false;
    private boolean componentEnded = false;

    public JCalRawWriter(Writer writer, boolean wrapInArray) {
        this.writer = writer;
        this.wrapInArray = wrapInArray;
    }

    public boolean isIndent() {
        return this.indent;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    public void writeStartComponent(String componentName) throws IOException {
        if (this.generator == null) {
            this.init();
        }
        this.componentEnded = false;
        if (!this.stack.isEmpty()) {
            Info parent = this.stack.getLast();
            if (!parent.wroteEndPropertiesArray) {
                this.generator.writeEndArray();
                parent.wroteEndPropertiesArray = true;
            }
            if (!parent.wroteStartSubComponentsArray) {
                this.generator.writeStartArray();
                parent.wroteStartSubComponentsArray = true;
            }
        }
        this.generator.writeStartArray();
        this.indent(this.stack.size() * 2);
        this.generator.writeString(componentName);
        this.generator.writeStartArray();
        this.stack.add(new Info());
    }

    public void writeEndComponent() throws IOException {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("Call \"writeStartComponent\" first.");
        }
        Info cur = this.stack.removeLast();
        if (!cur.wroteEndPropertiesArray) {
            this.generator.writeEndArray();
        }
        if (!cur.wroteStartSubComponentsArray) {
            this.generator.writeStartArray();
        }
        this.generator.writeEndArray();
        this.generator.writeEndArray();
        this.componentEnded = true;
    }

    public void writeProperty(String propertyName, ICalDataType dataType, JCalValue value) throws IOException {
        this.writeProperty(propertyName, new ICalParameters(), dataType, value);
    }

    public void writeProperty(String propertyName, ICalParameters parameters, ICalDataType dataType, JCalValue value) throws IOException {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("Call \"writeStartComponent\" first.");
        }
        if (this.componentEnded) {
            throw new IllegalStateException("Cannot write a property after calling \"writeEndComponent\".");
        }
        this.generator.writeStartArray();
        this.indent(this.stack.size() * 2);
        this.generator.writeString(propertyName);
        this.generator.writeStartObject();
        for (Map.Entry entry : parameters) {
            String name = ((String)entry.getKey()).toLowerCase();
            List values = entry.getValue();
            if (values.isEmpty()) continue;
            if (values.size() == 1) {
                this.generator.writeStringField(name, (String)values.get(0));
                continue;
            }
            this.generator.writeArrayFieldStart(name);
            for (String paramValue : values) {
                this.generator.writeString(paramValue);
            }
            this.generator.writeEndArray();
        }
        this.generator.writeEndObject();
        this.generator.writeString(dataType == null ? "unknown" : dataType.getName().toLowerCase());
        for (JsonValue jsonValue : value.getValues()) {
            this.writeValue(jsonValue);
        }
        this.generator.writeEndArray();
    }

    private void writeValue(JsonValue jsonValue) throws IOException {
        if (jsonValue.isNull()) {
            this.generator.writeNull();
            return;
        }
        Object val = jsonValue.getValue();
        if (val != null) {
            if (val instanceof Byte) {
                this.generator.writeNumber((short)((Byte)val).byteValue());
            } else if (val instanceof Short) {
                this.generator.writeNumber(((Short)val).shortValue());
            } else if (val instanceof Integer) {
                this.generator.writeNumber(((Integer)val).intValue());
            } else if (val instanceof Long) {
                this.generator.writeNumber(((Long)val).longValue());
            } else if (val instanceof Float) {
                this.generator.writeNumber(((Float)val).floatValue());
            } else if (val instanceof Double) {
                this.generator.writeNumber(((Double)val).doubleValue());
            } else if (val instanceof Boolean) {
                this.generator.writeBoolean(((Boolean)val).booleanValue());
            } else {
                this.generator.writeString(val.toString());
            }
            return;
        }
        List<JsonValue> array = jsonValue.getArray();
        if (array != null) {
            this.generator.writeStartArray();
            for (JsonValue element : array) {
                this.writeValue(element);
            }
            this.generator.writeEndArray();
            return;
        }
        Map<String, JsonValue> object = jsonValue.getObject();
        if (object != null) {
            this.generator.writeStartObject();
            for (Map.Entry<String, JsonValue> entry : object.entrySet()) {
                this.generator.writeFieldName(entry.getKey());
                this.writeValue(entry.getValue());
            }
            this.generator.writeEndObject();
            return;
        }
    }

    private void indent(int spaces) throws IOException {
        if (!this.indent) {
            return;
        }
        this.generator.writeRaw(StringUtils.NEWLINE);
        for (int i = 0; i < spaces; ++i) {
            this.generator.writeRaw(' ');
        }
    }

    public void flush() throws IOException {
        if (this.generator == null) {
            return;
        }
        this.generator.flush();
    }

    public void closeJsonStream() throws IOException {
        if (this.generator == null) {
            return;
        }
        while (!this.stack.isEmpty()) {
            this.writeEndComponent();
        }
        if (this.wrapInArray) {
            this.indent(0);
            this.generator.writeEndArray();
        }
        this.generator.close();
    }

    public void close() throws IOException {
        if (this.generator == null) {
            return;
        }
        this.closeJsonStream();
        this.writer.close();
    }

    private void init() throws IOException {
        JsonFactory factory = new JsonFactory();
        factory.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        this.generator = factory.createGenerator(this.writer);
        if (this.wrapInArray) {
            this.generator.writeStartArray();
            this.indent(0);
        }
    }

    private static class Info {
        public boolean wroteEndPropertiesArray = false;
        public boolean wroteStartSubComponentsArray = false;

        private Info() {
        }
    }
}

