/*
 * Decompiled with CFR 0.152.
 */
package biweekly.component;

import biweekly.ICalVersion;
import biweekly.Warning;
import biweekly.component.ICalComponent;
import biweekly.property.Comment;
import biweekly.property.DateStart;
import biweekly.property.ExceptionDates;
import biweekly.property.RecurrenceDates;
import biweekly.property.RecurrenceRule;
import biweekly.property.TimezoneName;
import biweekly.property.TimezoneOffsetFrom;
import biweekly.property.TimezoneOffsetTo;
import biweekly.util.DateTimeComponents;
import biweekly.util.ICalDate;
import biweekly.util.Recurrence;
import biweekly.util.UtcOffset;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Observance
extends ICalComponent {
    public DateStart getDateStart() {
        return this.getProperty(DateStart.class);
    }

    public void setDateStart(DateStart dateStart) {
        this.setProperty(DateStart.class, dateStart);
    }

    public DateStart setDateStart(ICalDate date) {
        DateStart prop = date == null ? null : new DateStart(date);
        this.setDateStart(prop);
        return prop;
    }

    public DateStart setDateStart(DateTimeComponents rawComponents) {
        return this.setDateStart(rawComponents == null ? null : new ICalDate(rawComponents, true));
    }

    public TimezoneOffsetTo getTimezoneOffsetTo() {
        return this.getProperty(TimezoneOffsetTo.class);
    }

    public void setTimezoneOffsetTo(TimezoneOffsetTo timezoneOffsetTo) {
        this.setProperty(TimezoneOffsetTo.class, timezoneOffsetTo);
    }

    public TimezoneOffsetTo setTimezoneOffsetTo(UtcOffset offset) {
        TimezoneOffsetTo prop = new TimezoneOffsetTo(offset);
        this.setTimezoneOffsetTo(prop);
        return prop;
    }

    public TimezoneOffsetFrom getTimezoneOffsetFrom() {
        return this.getProperty(TimezoneOffsetFrom.class);
    }

    public void setTimezoneOffsetFrom(TimezoneOffsetFrom timezoneOffsetFrom) {
        this.setProperty(TimezoneOffsetFrom.class, timezoneOffsetFrom);
    }

    public TimezoneOffsetFrom setTimezoneOffsetFrom(UtcOffset offset) {
        TimezoneOffsetFrom prop = new TimezoneOffsetFrom(offset);
        this.setTimezoneOffsetFrom(prop);
        return prop;
    }

    public RecurrenceRule getRecurrenceRule() {
        return this.getProperty(RecurrenceRule.class);
    }

    public RecurrenceRule setRecurrenceRule(Recurrence recur) {
        RecurrenceRule prop = recur == null ? null : new RecurrenceRule(recur);
        this.setRecurrenceRule(prop);
        return prop;
    }

    public void setRecurrenceRule(RecurrenceRule recurrenceRule) {
        this.setProperty(RecurrenceRule.class, recurrenceRule);
    }

    public List<Comment> getComments() {
        return this.getProperties(Comment.class);
    }

    public void addComment(Comment comment) {
        this.addProperty(comment);
    }

    public Comment addComment(String comment) {
        Comment prop = new Comment(comment);
        this.addComment(prop);
        return prop;
    }

    public List<RecurrenceDates> getRecurrenceDates() {
        return this.getProperties(RecurrenceDates.class);
    }

    public void addRecurrenceDates(RecurrenceDates recurrenceDates) {
        this.addProperty(recurrenceDates);
    }

    public List<TimezoneName> getTimezoneNames() {
        return this.getProperties(TimezoneName.class);
    }

    public void addTimezoneName(TimezoneName timezoneName) {
        this.addProperty(timezoneName);
    }

    public TimezoneName addTimezoneName(String timezoneName) {
        TimezoneName prop = new TimezoneName(timezoneName);
        this.addTimezoneName(prop);
        return prop;
    }

    public List<ExceptionDates> getExceptionDates() {
        return this.getProperties(ExceptionDates.class);
    }

    public void addExceptionDates(ExceptionDates exceptionDates) {
        this.addProperty(exceptionDates);
    }

    @Override
    protected void validate(List<ICalComponent> components, ICalVersion version, List<Warning> warnings) {
        if (version == ICalVersion.V1_0) {
            warnings.add(Warning.validate(48, new Object[]{version}));
        }
        this.checkRequiredCardinality(warnings, DateStart.class, TimezoneOffsetTo.class, TimezoneOffsetFrom.class);
        DateStart dateStart = this.getDateStart();
        RecurrenceRule rrule = this.getRecurrenceRule();
        if (dateStart != null && rrule != null) {
            ICalDate start = (ICalDate)dateStart.getValue();
            Recurrence recur = (Recurrence)rrule.getValue();
            if (!(start == null || recur == null || start.hasTime() || recur.getByHour().isEmpty() && recur.getByMinute().isEmpty() && recur.getBySecond().isEmpty())) {
                warnings.add(Warning.validate(5, new Object[0]));
            }
        }
        if (this.getProperties(RecurrenceRule.class).size() > 1) {
            warnings.add(Warning.validate(6, new Object[0]));
        }
    }
}

