/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.online.selection;

import java.util.Hashtable;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.studentsct.extension.StudentQuality;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.online.OnlineSectioningModel;
import org.cpsolver.studentsct.online.selection.OnlineSectioningCriterion;

public class EqualWeightCriterion
extends OnlineSectioningCriterion {
    public EqualWeightCriterion(Student student, OnlineSectioningModel model, Assignment<Request, Enrollment> assignment, Hashtable<CourseRequest, Set<Section>> preferredSections) {
        super(student, model, assignment, preferredSections);
    }

    @Override
    public int compare(Assignment<Request, Enrollment> assignment, Enrollment[] current, Enrollment[] best) {
        double currentUnavailableSizeFraction;
        int x;
        int bestTimeOverlaps;
        if (best == null) {
            return -1;
        }
        int currentAssignedCourseReq = 0;
        int bestAssignedCourseReq = 0;
        int currentAssignedRequests = 0;
        int bestAssignedRequests = 0;
        int currentAssignedPriority = 0;
        int bestAssignedPriority = 0;
        int currentAssignedAlternativity = 0;
        int bestAssignedAlternativity = 0;
        int currentNotFollowedReservations = 0;
        int bestNotFollowedReservations = 0;
        for (int idx = 0; idx < current.length; ++idx) {
            if (current[idx] != null && current[idx].getAssignments() != null) {
                ++currentAssignedRequests;
                if (current[idx].isCourseRequest()) {
                    ++currentAssignedCourseReq;
                }
                currentAssignedPriority += current[idx].getTruePriority() * current[idx].getTruePriority();
                currentAssignedAlternativity += current[idx].getRequest().isAlternative() ? 1 : 0;
                if (current[idx].getTruePriority() < current[idx].getPriority()) {
                    ++currentNotFollowedReservations;
                }
            }
            if (best[idx] == null || best[idx].getAssignments() == null) continue;
            ++bestAssignedRequests;
            if (best[idx].isCourseRequest()) {
                ++bestAssignedCourseReq;
            }
            bestAssignedPriority += best[idx].getTruePriority() * best[idx].getTruePriority();
            bestAssignedAlternativity += best[idx].getRequest().isAlternative() ? 1 : 0;
            if (best[idx].getTruePriority() >= best[idx].getPriority()) continue;
            ++bestNotFollowedReservations;
        }
        if (currentAssignedCourseReq > bestAssignedCourseReq) {
            return -1;
        }
        if (bestAssignedCourseReq > currentAssignedCourseReq) {
            return 1;
        }
        if (currentAssignedPriority < bestAssignedPriority) {
            return -1;
        }
        if (bestAssignedPriority < currentAssignedPriority) {
            return 1;
        }
        if (currentAssignedAlternativity < bestAssignedAlternativity) {
            return -1;
        }
        if (bestAssignedAlternativity < currentAssignedAlternativity) {
            return 1;
        }
        int bestNotAvailable = 0;
        int currentNotAvailable = 0;
        for (int idx = 0; idx < current.length; ++idx) {
            if (best[idx] != null && best[idx].getAssignments() != null && best[idx].getRequest() instanceof CourseRequest && best[idx].getReservation() != null && best[idx].getReservation().canAssignOverLimit()) {
                for (Section section : best[idx].getSections()) {
                    if (section.getLimit() != 0) continue;
                    ++bestNotAvailable;
                }
            }
            if (current[idx] == null || current[idx].getAssignments() == null || !(current[idx].getRequest() instanceof CourseRequest) || current[idx].getReservation() == null || !current[idx].getReservation().canAssignOverLimit()) continue;
            for (Section section : current[idx].getSections()) {
                if (section.getLimit() != 0) continue;
                ++currentNotAvailable;
            }
        }
        if (bestNotAvailable > currentNotAvailable) {
            return -1;
        }
        if (bestNotAvailable < currentNotAvailable) {
            return 1;
        }
        if (this.getModel().getStudentQuality() != null) {
            int idx;
            bestTimeOverlaps = 0;
            int currentTimeOverlaps = 0;
            for (idx = 0; idx < current.length; ++idx) {
                if (best[idx] != null && best[idx].getAssignments() != null && best[idx].getRequest() instanceof CourseRequest) {
                    for (x = 0; x < idx; ++x) {
                        if (best[x] == null || best[x].getAssignments() == null || !(best[x].getRequest() instanceof CourseRequest)) continue;
                        bestTimeOverlaps += this.getModel().getStudentQuality().penalty(StudentQuality.Type.CourseTimeOverlap, best[x], best[idx]);
                    }
                }
                if (current[idx] == null || current[idx].getAssignments() == null || !(current[idx].getRequest() instanceof CourseRequest)) continue;
                for (x = 0; x < idx; ++x) {
                    if (current[x] == null || current[x].getAssignments() == null || !(current[x].getRequest() instanceof CourseRequest)) continue;
                    currentTimeOverlaps += this.getModel().getStudentQuality().penalty(StudentQuality.Type.CourseTimeOverlap, current[x], current[idx]);
                }
            }
            for (idx = 0; idx < current.length; ++idx) {
                if (best[idx] != null && best[idx].getAssignments() != null && best[idx].isCourseRequest()) {
                    bestTimeOverlaps += this.getModel().getStudentQuality().penalty(StudentQuality.Type.Unavailability, best[idx]);
                }
                if (current[idx] == null || current[idx].getAssignments() == null || !current[idx].isCourseRequest()) continue;
                currentTimeOverlaps += this.getModel().getStudentQuality().penalty(StudentQuality.Type.Unavailability, current[idx]);
            }
            if (currentTimeOverlaps < bestTimeOverlaps) {
                return -1;
            }
            if (bestTimeOverlaps < currentTimeOverlaps) {
                return 1;
            }
        } else if (this.getModel().getTimeOverlaps() != null) {
            int idx;
            bestTimeOverlaps = 0;
            int currentTimeOverlaps = 0;
            for (idx = 0; idx < current.length; ++idx) {
                if (best[idx] != null && best[idx].getAssignments() != null && best[idx].getRequest() instanceof CourseRequest) {
                    for (x = 0; x < idx; ++x) {
                        if (best[x] == null || best[x].getAssignments() == null || !(best[x].getRequest() instanceof CourseRequest)) continue;
                        bestTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(best[x], best[idx]);
                    }
                }
                if (current[idx] == null || current[idx].getAssignments() == null || !(current[idx].getRequest() instanceof CourseRequest)) continue;
                for (x = 0; x < idx; ++x) {
                    if (current[x] == null || current[x].getAssignments() == null || !(current[x].getRequest() instanceof CourseRequest)) continue;
                    currentTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(current[x], current[idx]);
                }
            }
            for (idx = 0; idx < current.length; ++idx) {
                if (best[idx] != null && best[idx].getAssignments() != null && best[idx].isCourseRequest()) {
                    bestTimeOverlaps += this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(best[idx]);
                }
                if (current[idx] == null || current[idx].getAssignments() == null || !current[idx].isCourseRequest()) continue;
                currentTimeOverlaps += this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(current[idx]);
            }
            if (currentTimeOverlaps < bestTimeOverlaps) {
                return -1;
            }
            if (bestTimeOverlaps < currentTimeOverlaps) {
                return 1;
            }
        }
        double bestPenalties = 0.0;
        double currentPenalties = 0.0;
        for (int idx = 0; idx < current.length; ++idx) {
            if (best[idx] != null && best[idx].getAssignments() != null && best[idx].isCourseRequest()) {
                for (Section section : best[idx].getSections()) {
                    bestPenalties += this.getModel().getOverExpected(assignment, best, idx, section, best[idx].getRequest());
                }
            }
            if (current[idx] == null || current[idx].getAssignments() == null || !current[idx].isCourseRequest()) continue;
            for (Section section : current[idx].getSections()) {
                currentPenalties += this.getModel().getOverExpected(assignment, current, idx, section, current[idx].getRequest());
            }
        }
        if (currentPenalties < bestPenalties) {
            return -1;
        }
        if (bestPenalties < currentPenalties) {
            return 1;
        }
        if (currentAssignedRequests > bestAssignedRequests) {
            return -1;
        }
        if (bestAssignedRequests > currentAssignedRequests) {
            return 1;
        }
        int bestSelected = 0;
        int currentSelected = 0;
        for (int idx = 0; idx < current.length; ++idx) {
            Set<Section> preferred = this.getPreferredSections(this.getRequest(idx));
            if (preferred == null || preferred.isEmpty()) continue;
            if (best[idx] != null && best[idx].getAssignments() != null && best[idx].isCourseRequest()) {
                for (Section section : best[idx].getSections()) {
                    if (!preferred.contains(section)) continue;
                    ++bestSelected;
                }
            }
            if (current[idx] == null || current[idx].getAssignments() == null || !current[idx].isCourseRequest()) continue;
            for (Section section : current[idx].getSections()) {
                if (!preferred.contains(section)) continue;
                ++currentSelected;
            }
        }
        if (currentSelected > bestSelected) {
            return -1;
        }
        if (bestSelected > currentSelected) {
            return 1;
        }
        double bestSelectedConfigs = 0.0;
        double currentSelectedConfigs = 0.0;
        double bestSelectedSections = 0.0;
        double currentSelectedSections = 0.0;
        for (int idx = 0; idx < current.length; ++idx) {
            if (best[idx] != null && best[idx].getAssignments() != null && best[idx].isCourseRequest()) {
                bestSelectedSections += best[idx].percentSelectedSameSection();
                bestSelectedConfigs += best[idx].percentSelectedSameConfig();
            }
            if (current[idx] == null || current[idx].getAssignments() == null || !current[idx].isCourseRequest()) continue;
            currentSelectedSections += current[idx].percentSelectedSameSection();
            currentSelectedConfigs += current[idx].percentSelectedSameConfig();
        }
        if (0.3 * currentSelectedConfigs + 0.7 * currentSelectedSections > 0.3 * bestSelectedConfigs + 0.7 * bestSelectedSections) {
            return -1;
        }
        if (0.3 * bestSelectedConfigs + 0.7 * bestSelectedSections > 0.3 * currentSelectedConfigs + 0.7 * currentSelectedSections) {
            return 1;
        }
        if (currentNotFollowedReservations < bestNotFollowedReservations) {
            return -1;
        }
        if (bestNotFollowedReservations < currentNotFollowedReservations) {
            return 1;
        }
        int bestPast = 0;
        int currentPast = 0;
        for (int idx = 0; idx < current.length; ++idx) {
            if (best[idx] != null && best[idx].getAssignments() != null) {
                for (Section section : best[idx].getSections()) {
                    if (!section.isPast()) continue;
                    ++bestPast;
                }
            }
            if (current[idx] == null || current[idx].getAssignments() == null) continue;
            for (Section section : current[idx].getSections()) {
                if (!section.isPast()) continue;
                ++currentPast;
            }
        }
        if (currentPast < bestPast) {
            return -1;
        }
        if (bestPast < currentPast) {
            return 1;
        }
        if (this.getModel().getStudentQuality() != null) {
            double bestQuality = 0.0;
            double currentQuality = 0.0;
            for (StudentQuality.Type type : StudentQuality.Type.values()) {
                for (int idx = 0; idx < current.length; ++idx) {
                    int x2;
                    if (best[idx] != null && best[idx].getAssignments() != null) {
                        bestQuality += this.iQalityWeights[type.ordinal()] * (double)this.getModel().getStudentQuality().penalty(type, best[idx]);
                        for (x2 = 0; x2 < idx; ++x2) {
                            if (best[x2] == null || best[x2].getAssignments() == null) continue;
                            bestQuality += this.iQalityWeights[type.ordinal()] * (double)this.getModel().getStudentQuality().penalty(type, best[x2], best[idx]);
                        }
                    }
                    if (current[idx] == null || current[idx].getAssignments() == null) continue;
                    currentQuality += this.iQalityWeights[type.ordinal()] * (double)this.getModel().getStudentQuality().penalty(type, current[idx]);
                    for (x2 = 0; x2 < idx; ++x2) {
                        if (current[x2] == null || current[x2].getAssignments() == null) continue;
                        currentQuality += this.iQalityWeights[type.ordinal()] * (double)this.getModel().getStudentQuality().penalty(type, current[x2], current[idx]);
                    }
                }
            }
            if (currentQuality < bestQuality) {
                return -1;
            }
            if (bestQuality < currentQuality) {
                return 1;
            }
        } else {
            int x3;
            if (this.getModel().getTimeOverlaps() != null) {
                int idx;
                int bestTimeOverlaps2 = 0;
                int currentTimeOverlaps = 0;
                for (idx = 0; idx < current.length; ++idx) {
                    if (best[idx] != null && best[idx].getAssignments() != null) {
                        for (x3 = 0; x3 < idx; ++x3) {
                            if (best[x3] != null && best[x3].getAssignments() != null) {
                                bestTimeOverlaps2 += this.getModel().getTimeOverlaps().nrConflicts(best[x3], best[idx]);
                                continue;
                            }
                            if (!(this.getStudent().getRequests().get(x3) instanceof FreeTimeRequest)) continue;
                            bestTimeOverlaps2 += this.getModel().getTimeOverlaps().nrConflicts(((FreeTimeRequest)this.getStudent().getRequests().get(x3)).createEnrollment(), best[idx]);
                        }
                    }
                    if (current[idx] == null || current[idx].getAssignments() == null) continue;
                    for (x3 = 0; x3 < idx; ++x3) {
                        if (current[x3] != null && current[x3].getAssignments() != null) {
                            currentTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(current[x3], current[idx]);
                            continue;
                        }
                        if (!(this.getStudent().getRequests().get(x3) instanceof FreeTimeRequest)) continue;
                        currentTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(((FreeTimeRequest)this.getStudent().getRequests().get(x3)).createEnrollment(), current[idx]);
                    }
                }
                for (idx = 0; idx < current.length; ++idx) {
                    if (best[idx] != null && best[idx].getAssignments() != null && best[idx].isCourseRequest()) {
                        bestTimeOverlaps2 += this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(best[idx]);
                    }
                    if (current[idx] == null || current[idx].getAssignments() == null || !current[idx].isCourseRequest()) continue;
                    currentTimeOverlaps += this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(current[idx]);
                }
                if (currentTimeOverlaps < bestTimeOverlaps2) {
                    return -1;
                }
                if (bestTimeOverlaps2 < currentTimeOverlaps) {
                    return 1;
                }
            }
            if (this.getModel().getDistanceConflict() != null) {
                int bestDistanceConf = 0;
                int currentDistanceConf = 0;
                for (int idx = 0; idx < current.length; ++idx) {
                    if (best[idx] != null && best[idx].getAssignments() != null) {
                        bestDistanceConf += this.getModel().getDistanceConflict().nrConflicts(best[idx]);
                        for (x3 = 0; x3 < idx; ++x3) {
                            if (best[x3] == null || best[x3].getAssignments() == null) continue;
                            bestDistanceConf += this.getModel().getDistanceConflict().nrConflicts(best[x3], best[idx]);
                        }
                    }
                    if (current[idx] == null || current[idx].getAssignments() == null) continue;
                    currentDistanceConf += this.getModel().getDistanceConflict().nrConflicts(current[idx]);
                    for (x3 = 0; x3 < idx; ++x3) {
                        if (current[x3] == null || current[x3].getAssignments() == null) continue;
                        currentDistanceConf += this.getModel().getDistanceConflict().nrConflicts(current[x3], current[idx]);
                    }
                }
                if (currentDistanceConf < bestDistanceConf) {
                    return -1;
                }
                if (bestDistanceConf < currentDistanceConf) {
                    return 1;
                }
            }
        }
        int bestNoTime = 0;
        int currentNoTime = 0;
        int bestOnline = 0;
        int currentOnline = 0;
        for (int idx = 0; idx < current.length; ++idx) {
            if (best[idx] != null && best[idx].getAssignments() != null) {
                for (Section section : best[idx].getSections()) {
                    if (section.getTime() == null) {
                        ++bestNoTime;
                    }
                    if (!section.isOnline()) continue;
                    ++bestOnline;
                }
            }
            if (current[idx] == null || current[idx].getAssignments() == null) continue;
            for (Section section : current[idx].getSections()) {
                if (section.getTime() == null) {
                    ++currentNoTime;
                }
                if (!section.isOnline()) continue;
                ++currentOnline;
            }
        }
        if (currentNoTime < bestNoTime) {
            return -1;
        }
        if (bestNoTime < currentNoTime) {
            return 1;
        }
        if (currentOnline < bestOnline) {
            return -1;
        }
        if (bestOnline < currentOnline) {
            return 1;
        }
        double bestUnavailableSize = 0.0;
        double currentUnavailableSize = 0.0;
        int bestAltSectionsWithLimit = 0;
        int currentAltSectionsWithLimit = 0;
        for (int idx = 0; idx < current.length; ++idx) {
            double averageSize;
            Subpart subpart;
            if (best[idx] != null && best[idx].getAssignments() != null) {
                for (Section section : best[idx].getSections()) {
                    subpart = section.getSubpart();
                    if (subpart.getSections().size() <= 1 || subpart.getLimit() <= 0) continue;
                    averageSize = (double)subpart.getLimit() / (double)subpart.getSections().size();
                    if ((double)section.getLimit() < averageSize) {
                        bestUnavailableSize += (averageSize - (double)section.getLimit()) / averageSize;
                    }
                    ++bestAltSectionsWithLimit;
                }
            }
            if (current[idx] == null || current[idx].getAssignments() == null) continue;
            for (Section section : current[idx].getSections()) {
                subpart = section.getSubpart();
                if (subpart.getSections().size() <= 1 || subpart.getLimit() <= 0) continue;
                averageSize = (double)subpart.getLimit() / (double)subpart.getSections().size();
                if ((double)section.getLimit() < averageSize) {
                    currentUnavailableSize += (averageSize - (double)section.getLimit()) / averageSize;
                }
                ++currentAltSectionsWithLimit;
            }
        }
        double bestUnavailableSizeFraction = bestUnavailableSize > 0.0 ? bestUnavailableSize / (double)bestAltSectionsWithLimit : 0.0;
        double d = currentUnavailableSizeFraction = currentUnavailableSize > 0.0 ? currentUnavailableSize / (double)currentAltSectionsWithLimit : 0.0;
        if (currentUnavailableSizeFraction < bestUnavailableSizeFraction) {
            return -1;
        }
        if (bestUnavailableSizeFraction < currentUnavailableSizeFraction) {
            return 1;
        }
        double bestPenalty = 0.0;
        double currentPenalty = 0.0;
        for (int idx = 0; idx < current.length; ++idx) {
            if (best[idx] != null && best[idx].getAssignments() != null) {
                for (Section section : best[idx].getSections()) {
                    bestPenalty += section.getPenalty() / (double)best[idx].getSections().size();
                }
            }
            if (current[idx] == null || current[idx].getAssignments() == null) continue;
            for (Section section : current[idx].getSections()) {
                currentPenalty += section.getPenalty() / (double)current[idx].getSections().size();
            }
        }
        if (currentPenalty < bestPenalty) {
            return -1;
        }
        if (bestPenalty < currentPenalty) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean canImprove(Assignment<Request, Enrollment> assignment, int maxIdx, Enrollment[] current, Enrollment[] best) {
        double currentUnavailableSizeFraction;
        int x;
        int bestTimeOverlaps;
        int currentAssignedCourseReq = 0;
        int bestAssignedCourseReq = 0;
        int currentAssignedRequests = 0;
        int bestAssignedRequests = 0;
        int currentAssignedPriority = 0;
        int bestAssignedPriority = 0;
        int currentAssignedAlternativity = 0;
        int bestAssignedAlternativity = 0;
        int currentNotFollowedReservations = 0;
        int bestNotFollowedReservations = 0;
        int alt = 0;
        for (int idx = 0; idx < current.length; ++idx) {
            if (idx < maxIdx) {
                if (current[idx] != null && current[idx].getAssignments() != null) {
                    ++currentAssignedRequests;
                    if (current[idx].isCourseRequest()) {
                        ++currentAssignedCourseReq;
                    }
                    currentAssignedPriority += current[idx].getTruePriority() * current[idx].getTruePriority();
                    currentAssignedAlternativity += current[idx].getRequest().isAlternative() ? 1 : 0;
                    if (current[idx].getTruePriority() < current[idx].getPriority()) {
                        ++currentNotFollowedReservations;
                    }
                } else if (!this.isFreeTime(idx) && !this.getRequest(idx).isAlternative()) {
                    ++alt;
                }
            } else if (!this.getRequest(idx).isAlternative()) {
                ++currentAssignedRequests;
                if (!this.isFreeTime(idx)) {
                    ++currentAssignedCourseReq;
                }
            } else if (alt > 0) {
                ++currentAssignedRequests;
                ++currentAssignedCourseReq;
                --alt;
                ++currentAssignedAlternativity;
            }
            if (best[idx] == null || best[idx].getAssignments() == null) continue;
            ++bestAssignedRequests;
            if (best[idx].isCourseRequest()) {
                ++bestAssignedCourseReq;
            }
            bestAssignedPriority += best[idx].getTruePriority() * best[idx].getTruePriority();
            bestAssignedAlternativity += best[idx].getRequest().isAlternative() ? 1 : 0;
            if (best[idx].getTruePriority() >= best[idx].getPriority()) continue;
            ++bestNotFollowedReservations;
        }
        if (currentAssignedCourseReq > bestAssignedCourseReq) {
            return true;
        }
        if (bestAssignedCourseReq > currentAssignedCourseReq) {
            return false;
        }
        if (currentAssignedPriority < bestAssignedPriority) {
            return true;
        }
        if (bestAssignedPriority < currentAssignedPriority) {
            return false;
        }
        if (currentAssignedAlternativity < bestAssignedAlternativity) {
            return true;
        }
        if (bestAssignedAlternativity < currentAssignedAlternativity) {
            return false;
        }
        int notAvailable = 0;
        for (int idx = 0; idx < current.length; ++idx) {
            if (best[idx] != null && best[idx].getAssignments() != null && best[idx].getRequest() instanceof CourseRequest && best[idx].getReservation() != null && best[idx].getReservation().canAssignOverLimit()) {
                for (Section section : best[idx].getSections()) {
                    if (section.getLimit() != 0) continue;
                    ++notAvailable;
                }
            }
            if (idx >= maxIdx || current[idx] == null || current[idx].getAssignments() == null || !(current[idx].getRequest() instanceof CourseRequest) || current[idx].getReservation() == null || !current[idx].getReservation().canAssignOverLimit()) continue;
            for (Section section : current[idx].getSections()) {
                if (section.getLimit() != 0) continue;
                --notAvailable;
            }
        }
        if (notAvailable > 0) {
            return true;
        }
        if (this.getModel().getStudentQuality() != null) {
            int idx;
            bestTimeOverlaps = 0;
            int currentTimeOverlaps = 0;
            for (idx = 0; idx < current.length; ++idx) {
                if (best[idx] != null && best[idx].getRequest() instanceof CourseRequest) {
                    for (x = 0; x < idx; ++x) {
                        if (best[x] == null || !(best[x].getRequest() instanceof CourseRequest)) continue;
                        bestTimeOverlaps += this.getModel().getStudentQuality().penalty(StudentQuality.Type.CourseTimeOverlap, best[x], best[idx]);
                    }
                }
                if (current[idx] == null || idx >= maxIdx || !(current[idx].getRequest() instanceof CourseRequest)) continue;
                for (x = 0; x < idx; ++x) {
                    if (current[x] == null || !(current[x].getRequest() instanceof CourseRequest)) continue;
                    currentTimeOverlaps += this.getModel().getStudentQuality().penalty(StudentQuality.Type.CourseTimeOverlap, current[x], current[idx]);
                }
            }
            for (idx = 0; idx < current.length; ++idx) {
                if (best[idx] != null && best[idx].getAssignments() != null && best[idx].isCourseRequest()) {
                    bestTimeOverlaps += this.getModel().getStudentQuality().penalty(StudentQuality.Type.Unavailability, best[idx]);
                }
                if (current[idx] == null || idx >= maxIdx || current[idx].getAssignments() == null || !current[idx].isCourseRequest()) continue;
                currentTimeOverlaps += this.getModel().getStudentQuality().penalty(StudentQuality.Type.Unavailability, current[idx]);
            }
            if (currentTimeOverlaps < bestTimeOverlaps) {
                return true;
            }
            if (bestTimeOverlaps < currentTimeOverlaps) {
                return false;
            }
        } else if (this.getModel().getTimeOverlaps() != null) {
            int idx;
            bestTimeOverlaps = 0;
            int currentTimeOverlaps = 0;
            for (idx = 0; idx < current.length; ++idx) {
                if (best[idx] != null && best[idx].getRequest() instanceof CourseRequest) {
                    for (x = 0; x < idx; ++x) {
                        if (best[x] == null || !(best[x].getRequest() instanceof CourseRequest)) continue;
                        bestTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(best[x], best[idx]);
                    }
                }
                if (current[idx] == null || idx >= maxIdx || !(current[idx].getRequest() instanceof CourseRequest)) continue;
                for (x = 0; x < idx; ++x) {
                    if (current[x] == null || !(current[x].getRequest() instanceof CourseRequest)) continue;
                    currentTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(current[x], current[idx]);
                }
            }
            for (idx = 0; idx < current.length; ++idx) {
                if (best[idx] != null && best[idx].getAssignments() != null && best[idx].isCourseRequest()) {
                    bestTimeOverlaps += this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(best[idx]);
                }
                if (current[idx] == null || idx >= maxIdx || current[idx].getAssignments() == null || !current[idx].isCourseRequest()) continue;
                currentTimeOverlaps += this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(current[idx]);
            }
            if (currentTimeOverlaps < bestTimeOverlaps) {
                return true;
            }
            if (bestTimeOverlaps < currentTimeOverlaps) {
                return false;
            }
        }
        double bestPenalties = 0.0;
        double currentPenalties = 0.0;
        for (int idx = 0; idx < current.length; ++idx) {
            if (best[idx] != null) {
                for (Section section : best[idx].getSections()) {
                    bestPenalties += this.getModel().getOverExpected(assignment, best, idx, section, best[idx].getRequest());
                }
            }
            if (current[idx] == null || idx >= maxIdx) continue;
            for (Section section : current[idx].getSections()) {
                currentPenalties += this.getModel().getOverExpected(assignment, current, idx, section, current[idx].getRequest());
            }
        }
        if (currentPenalties < bestPenalties) {
            return true;
        }
        if (bestPenalties < currentPenalties) {
            return false;
        }
        if (currentAssignedRequests > bestAssignedRequests) {
            return true;
        }
        if (bestAssignedRequests > currentAssignedRequests) {
            return false;
        }
        int bestSelected = 0;
        int currentSelected = 0;
        for (int idx = 0; idx < current.length; ++idx) {
            Set<Section> preferred;
            if (best[idx] != null && best[idx].isCourseRequest() && (preferred = this.getPreferredSections(best[idx].getRequest())) != null && !preferred.isEmpty()) {
                for (Section section : best[idx].getSections()) {
                    if (preferred.contains(section)) {
                        if (idx >= maxIdx) continue;
                        ++bestSelected;
                        continue;
                    }
                    if (idx < maxIdx) continue;
                    --bestSelected;
                }
            }
            if (current[idx] == null || idx >= maxIdx || !current[idx].isCourseRequest() || (preferred = this.getPreferredSections(current[idx].getRequest())) == null || preferred.isEmpty()) continue;
            for (Section section : current[idx].getSections()) {
                if (!preferred.contains(section)) continue;
                ++currentSelected;
            }
        }
        if (currentSelected > bestSelected) {
            return true;
        }
        if (bestSelected > currentSelected) {
            return false;
        }
        double bestSelectedConfigs = 0.0;
        double currentSelectedConfigs = 0.0;
        double bestSelectedSections = 0.0;
        double currentSelectedSections = 0.0;
        for (int idx = 0; idx < current.length; ++idx) {
            if (best[idx] != null && best[idx].getAssignments() != null && best[idx].isCourseRequest()) {
                bestSelectedSections += best[idx].percentSelectedSameSection();
                bestSelectedConfigs += best[idx].percentSelectedSameConfig();
                if (idx >= maxIdx) {
                    bestSelectedSections -= 1.0;
                    bestSelectedConfigs -= 1.0;
                }
            }
            if (current[idx] == null || idx >= maxIdx || current[idx].getAssignments() == null || !current[idx].isCourseRequest()) continue;
            currentSelectedSections += current[idx].percentSelectedSameSection();
            currentSelectedConfigs += current[idx].percentSelectedSameConfig();
        }
        if (0.3 * currentSelectedConfigs + 0.7 * currentSelectedSections > 0.3 * bestSelectedConfigs + 0.7 * bestSelectedSections) {
            return true;
        }
        if (0.3 * bestSelectedConfigs + 0.7 * bestSelectedSections > 0.3 * currentSelectedConfigs + 0.7 * currentSelectedSections) {
            return false;
        }
        if (currentNotFollowedReservations < bestNotFollowedReservations) {
            return true;
        }
        if (bestNotFollowedReservations < currentNotFollowedReservations) {
            return false;
        }
        int bestPast = 0;
        int currentPast = 0;
        for (int idx = 0; idx < current.length; ++idx) {
            if (best[idx] != null && best[idx].getAssignments() != null) {
                for (Section section : best[idx].getSections()) {
                    if (!section.isPast()) continue;
                    ++bestPast;
                }
            }
            if (current[idx] == null || idx >= maxIdx || current[idx].getAssignments() == null) continue;
            for (Section section : current[idx].getSections()) {
                if (!section.isPast()) continue;
                ++currentPast;
            }
        }
        if (currentPast < bestPast) {
            return true;
        }
        if (bestPast < currentPast) {
            return false;
        }
        if (this.getModel().getStudentQuality() != null) {
            double bestQuality = 0.0;
            double currentQuality = 0.0;
            for (StudentQuality.Type type : StudentQuality.Type.values()) {
                for (int idx = 0; idx < current.length; ++idx) {
                    int x2;
                    if (best[idx] != null) {
                        bestQuality += this.iQalityWeights[type.ordinal()] * (double)this.getModel().getStudentQuality().penalty(type, best[idx]);
                        for (x2 = 0; x2 < idx; ++x2) {
                            if (best[x2] == null) continue;
                            bestQuality += this.iQalityWeights[type.ordinal()] * (double)this.getModel().getStudentQuality().penalty(type, best[x2], best[idx]);
                        }
                    }
                    if (current[idx] == null || idx >= maxIdx) continue;
                    currentQuality += this.iQalityWeights[type.ordinal()] * (double)this.getModel().getStudentQuality().penalty(type, current[idx]);
                    for (x2 = 0; x2 < idx; ++x2) {
                        if (current[x2] == null) continue;
                        currentQuality += this.iQalityWeights[type.ordinal()] * (double)this.getModel().getStudentQuality().penalty(type, current[x2], current[idx]);
                    }
                }
            }
            if (currentQuality < bestQuality) {
                return true;
            }
            if (bestQuality < currentQuality) {
                return false;
            }
        } else {
            int x3;
            if (this.getModel().getTimeOverlaps() != null) {
                int idx;
                int bestTimeOverlaps2 = 0;
                int currentTimeOverlaps = 0;
                for (idx = 0; idx < current.length; ++idx) {
                    if (best[idx] != null) {
                        for (x3 = 0; x3 < idx; ++x3) {
                            if (best[x3] != null) {
                                bestTimeOverlaps2 += this.getModel().getTimeOverlaps().nrConflicts(best[x3], best[idx]);
                                continue;
                            }
                            if (!(this.getStudent().getRequests().get(x3) instanceof FreeTimeRequest)) continue;
                            bestTimeOverlaps2 += this.getModel().getTimeOverlaps().nrConflicts(((FreeTimeRequest)this.getStudent().getRequests().get(x3)).createEnrollment(), best[idx]);
                        }
                    }
                    if (current[idx] == null || idx >= maxIdx) continue;
                    for (x3 = 0; x3 < idx; ++x3) {
                        if (current[x3] != null) {
                            currentTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(current[x3], current[idx]);
                            continue;
                        }
                        if (!(this.getStudent().getRequests().get(x3) instanceof FreeTimeRequest)) continue;
                        currentTimeOverlaps += this.getModel().getTimeOverlaps().nrConflicts(((FreeTimeRequest)this.getStudent().getRequests().get(x3)).createEnrollment(), current[idx]);
                    }
                }
                for (idx = 0; idx < current.length; ++idx) {
                    if (best[idx] != null && best[idx].getAssignments() != null && best[idx].isCourseRequest()) {
                        bestTimeOverlaps2 += this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(best[idx]);
                    }
                    if (current[idx] == null || idx >= maxIdx || current[idx].getAssignments() == null || !current[idx].isCourseRequest()) continue;
                    currentTimeOverlaps += this.getModel().getTimeOverlaps().nrNotAvailableTimeConflicts(current[idx]);
                }
                if (currentTimeOverlaps < bestTimeOverlaps2) {
                    return true;
                }
                if (bestTimeOverlaps2 < currentTimeOverlaps) {
                    return false;
                }
            }
            if (this.getModel().getDistanceConflict() != null) {
                int bestDistanceConf = 0;
                int currentDistanceConf = 0;
                for (int idx = 0; idx < current.length; ++idx) {
                    if (best[idx] != null) {
                        bestDistanceConf += this.getModel().getDistanceConflict().nrConflicts(best[idx]);
                        for (x3 = 0; x3 < idx; ++x3) {
                            if (best[x3] == null) continue;
                            bestDistanceConf += this.getModel().getDistanceConflict().nrConflicts(best[x3], best[idx]);
                        }
                    }
                    if (current[idx] == null || idx >= maxIdx) continue;
                    currentDistanceConf += this.getModel().getDistanceConflict().nrConflicts(current[idx]);
                    for (x3 = 0; x3 < idx; ++x3) {
                        if (current[x3] == null) continue;
                        currentDistanceConf += this.getModel().getDistanceConflict().nrConflicts(current[x3], current[idx]);
                    }
                }
                if (currentDistanceConf < bestDistanceConf) {
                    return true;
                }
                if (bestDistanceConf < currentDistanceConf) {
                    return false;
                }
            }
        }
        int bestNoTime = 0;
        int currentNoTime = 0;
        int bestOnline = 0;
        int currentOnline = 0;
        for (int idx = 0; idx < current.length; ++idx) {
            if (best[idx] != null) {
                for (Section section : best[idx].getSections()) {
                    if (section.getTime() == null) {
                        ++bestNoTime;
                    }
                    if (!section.isOnline()) continue;
                    ++bestOnline;
                }
            }
            if (current[idx] == null || idx >= maxIdx) continue;
            for (Section section : current[idx].getSections()) {
                if (section.getTime() == null) {
                    ++currentNoTime;
                }
                if (!section.isOnline()) continue;
                ++currentOnline;
            }
        }
        if (currentNoTime < bestNoTime) {
            return true;
        }
        if (bestNoTime < currentNoTime) {
            return false;
        }
        if (currentOnline < bestOnline) {
            return true;
        }
        if (bestOnline < currentOnline) {
            return false;
        }
        double bestUnavailableSize = 0.0;
        double currentUnavailableSize = 0.0;
        int bestAltSectionsWithLimit = 0;
        int currentAltSectionsWithLimit = 0;
        for (int idx = 0; idx < current.length; ++idx) {
            double averageSize;
            Subpart subpart;
            if (best[idx] != null) {
                for (Section section : best[idx].getSections()) {
                    subpart = section.getSubpart();
                    if (subpart.getSections().size() <= 1 || subpart.getLimit() <= 0) continue;
                    averageSize = (double)subpart.getLimit() / (double)subpart.getSections().size();
                    if ((double)section.getLimit() < averageSize) {
                        bestUnavailableSize += (averageSize - (double)section.getLimit()) / averageSize;
                    }
                    ++bestAltSectionsWithLimit;
                }
            }
            if (current[idx] == null || idx >= maxIdx) continue;
            for (Section section : current[idx].getSections()) {
                subpart = section.getSubpart();
                if (subpart.getSections().size() <= 1 || subpart.getLimit() <= 0) continue;
                averageSize = (double)subpart.getLimit() / (double)subpart.getSections().size();
                if ((double)section.getLimit() < averageSize) {
                    currentUnavailableSize += (averageSize - (double)section.getLimit()) / averageSize;
                }
                ++currentAltSectionsWithLimit;
            }
        }
        double bestUnavailableSizeFraction = bestUnavailableSize > 0.0 ? bestUnavailableSize / (double)bestAltSectionsWithLimit : 0.0;
        double d = currentUnavailableSizeFraction = currentUnavailableSize > 0.0 ? currentUnavailableSize / (double)currentAltSectionsWithLimit : 0.0;
        if (currentUnavailableSizeFraction < bestUnavailableSizeFraction) {
            return true;
        }
        if (bestUnavailableSizeFraction < currentUnavailableSizeFraction) {
            return false;
        }
        double bestPenalty = 0.0;
        double currentPenalty = 0.0;
        for (int idx = 0; idx < current.length; ++idx) {
            if (best[idx] != null) {
                for (Section section : best[idx].getSections()) {
                    bestPenalty += section.getPenalty() / (double)best[idx].getSections().size();
                }
                if (idx >= maxIdx && best[idx].isCourseRequest()) {
                    bestPenalty -= ((CourseRequest)best[idx].getRequest()).getMinPenalty();
                }
            }
            if (current[idx] == null || idx >= maxIdx) continue;
            for (Section section : current[idx].getSections()) {
                currentPenalty += section.getPenalty() / (double)current[idx].getSections().size();
            }
        }
        if (currentPenalty < bestPenalty) {
            return true;
        }
        return !(bestPenalty < currentPenalty);
    }
}

