/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.util;

import org.apache.log4j.Logger;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.termination.TerminationCondition;
import org.cpsolver.ifs.util.Callback;

public abstract class ProblemSaver<V extends Variable<V, T>, T extends Value<V, T>, M extends Model<V, T>>
implements Runnable {
    private Solver<V, T> iSolver = null;
    private Callback iCallback = null;
    private TerminationCondition<V, T> iTermination = null;

    public ProblemSaver(Solver<V, T> solver) {
        this.iSolver = solver;
    }

    public Solver<V, T> getSolver() {
        return this.iSolver;
    }

    protected Solution<V, T> getSolution() {
        return this.iSolver.currentSolution();
    }

    public M getModel() {
        return (M)this.iSolver.currentSolution().getModel();
    }

    public Assignment<V, T> getAssignment() {
        return this.getSolution().getAssignment();
    }

    public abstract void save() throws Exception;

    public void setCallback(Callback callback) {
        this.iCallback = callback;
    }

    public void setTerminationCondition(TerminationCondition<V, T> termination) {
        this.iTermination = termination;
    }

    public TerminationCondition<V, T> getTerminationCondition() {
        return this.iTermination;
    }

    @Override
    public void run() {
        try {
            this.save();
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error(e.getMessage(), e);
        }
        finally {
            if (this.iCallback != null) {
                this.iCallback.execute();
            }
        }
    }
}

