/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.algorithms;

import org.cpsolver.ifs.algorithms.HillClimber;
import org.cpsolver.ifs.algorithms.NeighbourSearch;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.util.DataProperties;

public class StepCountingHillClimber<V extends Variable<V, T>, T extends Value<V, T>>
extends HillClimber<V, T> {
    protected int iCounterLimit = 100;
    protected Mode iCounterMode = Mode.ACCEPTED;
    protected Double[] iCounterLimitAdjusts = null;

    public StepCountingHillClimber(DataProperties properties) {
        super(properties);
        this.iSetHCMode = false;
        this.iCounterLimit = properties.getPropertyInt(this.getParameterBaseName() + ".CounterLimit", this.iCounterLimit);
        this.iCounterMode = Mode.valueOf(properties.getProperty(this.getParameterBaseName() + ".CounterMode", this.iCounterMode.name()).toUpperCase());
        this.iCounterLimitAdjusts = properties.getPropertyDoubleArry(this.getParameterBaseName() + ".CounterLimitAdjustments", null);
    }

    @Override
    public NeighbourSearch.NeighbourSearchContext createAssignmentContext(Assignment<V, T> assignment) {
        return new StepCountingHillClimberContext();
    }

    public class StepCountingHillClimberContext
    extends HillClimber.HillClimberContext {
        protected Double iBound = null;
        protected int iCounter = 0;

        @Override
        public void activate(Solution<V, T> solution) {
            super.activate(solution);
            this.iBound = solution.getModel().getTotalValue(solution.getAssignment());
            this.iCounter = 0;
        }

        protected int getCounterLimit(int idx) {
            if (idx < 0 || StepCountingHillClimber.this.iCounterLimitAdjusts == null || idx >= StepCountingHillClimber.this.iCounterLimitAdjusts.length || StepCountingHillClimber.this.iCounterLimitAdjusts[idx] == null) {
                return StepCountingHillClimber.this.iCounterLimit;
            }
            return (int)Math.round((double)StepCountingHillClimber.this.iCounterLimit * StepCountingHillClimber.this.iCounterLimitAdjusts[idx]);
        }

        @Override
        public void incIteration(Solution<V, T> solution) {
            ++this.iIter;
            if (this.iIter % 10000 == 0) {
                StepCountingHillClimber.this.info("Iter=" + this.iIter / 1000 + "k, NonImpIter=" + StepCountingHillClimber.this.iDF2.format((double)(this.iIter - this.iLastImprovingIter) / 1000.0) + "k, Speed=" + StepCountingHillClimber.this.iDF2.format(1000.0 * (double)this.iIter / (double)this.getTimeMillis()) + " it/s, Bound=" + StepCountingHillClimber.this.iDF2.format(this.iBound));
                StepCountingHillClimber.this.logNeibourStatus();
            }
            if (this.iCounter >= this.getCounterLimit(solution.getAssignment().getIndex() - 1)) {
                this.iBound = solution.getModel().getTotalValue(solution.getAssignment());
                this.iCounter = 0;
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        protected boolean accept(Assignment<V, T> assignment, Model<V, T> model, Neighbour<V, T> neighbour, double value, boolean lazy) {
            if (value <= 0.0) ** GOTO lbl-1000
            v0 = lazy != false ? model.getTotalValue(assignment) : value + model.getTotalValue(assignment);
            if (v0 < this.iBound) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            accept = v1;
            switch (1.$SwitchMap$org$cpsolver$ifs$algorithms$StepCountingHillClimber$Mode[StepCountingHillClimber.this.iCounterMode.ordinal()]) {
                case 1: {
                    ++this.iCounter;
                    break;
                }
                case 2: {
                    if (!accept) break;
                    ++this.iCounter;
                    break;
                }
                case 3: {
                    if (!(value < 0.0)) break;
                    ++this.iCounter;
                }
            }
            return accept;
        }

        @Override
        protected boolean canContinue(Solution<V, T> solution) {
            return super.canContinue(solution) || this.iCounter < this.getCounterLimit(solution.getAssignment().getIndex() - 1) || solution.getModel().getTotalValue(solution.getAssignment()) < this.iBound;
        }
    }

    public static enum Mode {
        ALL,
        ACCEPTED,
        IMPROVING;

    }
}

