/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.reports;

import java.util.ArrayList;
import org.cpsolver.exam.criteria.StudentBackToBackConflicts;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPeriod;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamStudent;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.CSVFile;

public class ExamNbrMeetingsPerDay {
    private ExamModel iModel = null;

    public ExamNbrMeetingsPerDay(ExamModel model) {
        this.iModel = model;
    }

    public CSVFile report(Assignment<Exam, ExamPlacement> assignment) {
        CSVFile csv = new CSVFile();
        ArrayList<CSVFile.CSVField> header = new ArrayList<CSVFile.CSVField>();
        header.add(new CSVFile.CSVField("Date"));
        header.add(new CSVFile.CSVField("None"));
        boolean isDayBreakBackToBack = ((StudentBackToBackConflicts)this.iModel.getCriterion(StudentBackToBackConflicts.class)).isDayBreakBackToBack();
        for (int i = 1; i <= 5; ++i) {
            header.add(new CSVFile.CSVField(i == 5 ? "5+" : String.valueOf(i)));
        }
        header.add(new CSVFile.CSVField("Back-To-Back"));
        csv.setHeader(header);
        int[] nrExamsTotal = new int[6];
        for (int i = 0; i <= 5; ++i) {
            nrExamsTotal[i] = 0;
        }
        int btbTotal = 0;
        for (int d = 0; d < this.iModel.getNrDays(); ++d) {
            ExamPeriod period = null;
            for (ExamPeriod p : this.iModel.getPeriods()) {
                if (p.getDay() != d) continue;
                period = p;
                break;
            }
            int[] nrExams = new int[6];
            for (int i = 0; i <= 5; ++i) {
                nrExams[i] = 0;
            }
            int btb = 0;
            for (ExamStudent student : this.iModel.getStudents()) {
                int ex = student.getExamsADay(assignment, d).size();
                int n = ex <= 5 ? ex : 5;
                nrExams[n] = nrExams[n] + 1;
                ExamPeriod p = period;
                while (p.next() != null && (isDayBreakBackToBack ? p : p.next()).getDay() == d) {
                    btb += student.getExams(assignment, p).size() * student.getExams(assignment, p.next()).size();
                    p = p.next();
                }
            }
            ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
            line.add(new CSVFile.CSVField(period.getDayStr()));
            for (int i = 0; i <= 5; ++i) {
                line.add(new CSVFile.CSVField(nrExams[i]));
                int n = i;
                nrExamsTotal[n] = nrExamsTotal[n] + nrExams[i];
            }
            line.add(new CSVFile.CSVField(btb));
            btbTotal += btb;
            csv.addLine(line);
        }
        ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
        line.add(new CSVFile.CSVField("Total"));
        for (int i = 0; i <= 5; ++i) {
            line.add(new CSVFile.CSVField(nrExamsTotal[i]));
        }
        line.add(new CSVFile.CSVField(btbTotal));
        csv.addLine(line);
        return csv;
    }
}

