/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.constraint;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.constraint.FlexibleConstraint;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.WeakeningConstraint;
import org.cpsolver.ifs.util.ToolBox;

public class MaxHolesFlexibleConstraint
extends FlexibleConstraint
implements WeakeningConstraint<Lecture, Placement> {
    private int iMaxHolesOnADay = 288;

    public MaxHolesFlexibleConstraint(Long id, String owner, String preference, String reference) {
        super(id, owner, preference, reference);
        Matcher matcher = Pattern.compile(FlexibleConstraint.FlexibleConstraintType.MAX_HOLES.getPattern()).matcher(reference);
        if (matcher.find()) {
            this.iMaxHolesOnADay = Integer.parseInt(matcher.group(2)) / Constants.SLOT_LENGTH_MIN;
            this.iConstraintType = FlexibleConstraint.FlexibleConstraintType.MAX_HOLES;
        }
    }

    public int countHoles(Assignment<Lecture, Placement> assignment, int dayCode, Set<Placement> conflicts, Placement value, HashMap<Lecture, Placement> assignments, BitSet week) {
        ArrayList<Placement> placements = new ArrayList<Placement>(this.getRelevantPlacements(assignment, dayCode, conflicts, value, assignments, week));
        Collections.sort(placements, new FlexibleConstraint.PlacementTimeComparator());
        int lastSlot = -1;
        int holes = 0;
        for (Placement placement : placements) {
            if (lastSlot >= 0 && placement.getTimeLocation().getStartSlot() > lastSlot) {
                holes += placement.getTimeLocation().getStartSlot() - lastSlot;
            }
            lastSlot = Math.max(lastSlot, placement.getTimeLocation().getStartSlot() + placement.getTimeLocation().getLength());
        }
        return holes;
    }

    @Override
    public double getNrViolations(Assignment<Lecture, Placement> assignment, Set<Placement> conflicts, HashMap<Lecture, Placement> assignments) {
        double penalty = 0.0;
        for (int dayCode : Constants.DAY_CODES) {
            for (BitSet week : this.getWeeks()) {
                int holes = this.countHoles(assignment, dayCode, conflicts, null, assignments, week);
                if (holes <= this.iMaxHolesOnADay) continue;
                penalty += (double)(holes - this.iMaxHolesOnADay);
            }
        }
        return penalty / (12.0 * (double)this.getWeeks().size());
    }

    @Override
    public void computeConflicts(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts) {
        if (!this.isHard()) {
            return;
        }
        MaxHolesFlexibleConstraintContext context = (MaxHolesFlexibleConstraintContext)this.getContext((Assignment)assignment);
        for (int dayCode : Constants.DAY_CODES) {
            if ((value.getTimeLocation().getDayCode() & dayCode) == 0) continue;
            for (BitSet week : this.getWeeks()) {
                if (week != null && !week.intersects(value.getTimeLocation().getWeekCode())) continue;
                int penalty = this.countHoles(assignment, dayCode, conflicts, value, null, week);
                while (penalty > context.getMaxHoles(dayCode, week)) {
                    ArrayList<Placement> adepts = new ArrayList<Placement>();
                    for (Placement placement : this.getRelevantPlacements(assignment, dayCode, conflicts, value, null, week)) {
                        if (placement.equals(value)) continue;
                        HashMap<Lecture, Placement> assignments = new HashMap<Lecture, Placement>();
                        assignments.put((Lecture)placement.variable(), (Placement)null);
                        int newPenalty = this.countHoles(assignment, dayCode, conflicts, value, assignments, week);
                        if (newPenalty > penalty) continue;
                        adepts.add(placement);
                    }
                    if (adepts.isEmpty()) {
                        conflicts.add(value);
                        return;
                    }
                    conflicts.add((Placement)ToolBox.random(adepts));
                    penalty = this.countHoles(assignment, dayCode, conflicts, value, null, week);
                }
            }
        }
    }

    @Override
    public void weaken(Assignment<Lecture, Placement> assignment) {
    }

    @Override
    public boolean isConsistent(Placement value1, Placement value2) {
        return true;
    }

    @Override
    public void weaken(Assignment<Lecture, Placement> assignment, Placement value) {
        if (this.isHard()) {
            ((MaxHolesFlexibleConstraintContext)this.getContext((Assignment)assignment)).weaken(assignment, value);
        }
    }

    @Override
    public FlexibleConstraint.FlexibleConstraintContext createAssignmentContext(Assignment<Lecture, Placement> assignment) {
        return new MaxHolesFlexibleConstraintContext(assignment);
    }

    public class MaxHolesFlexibleConstraintContext
    extends FlexibleConstraint.FlexibleConstraintContext {
        private Map<Integer, Map<BitSet, Integer>> iMaxHoles;

        public MaxHolesFlexibleConstraintContext(Assignment<Lecture, Placement> assignment) {
            super(MaxHolesFlexibleConstraint.this, assignment);
            this.iMaxHoles = new HashMap<Integer, Map<BitSet, Integer>>();
        }

        public void weaken(Assignment<Lecture, Placement> assignment, Placement value) {
            if (!MaxHolesFlexibleConstraint.this.isHard()) {
                return;
            }
            for (int dayCode : Constants.DAY_CODES) {
                if ((value.getTimeLocation().getDayCode() & dayCode) == 0) continue;
                for (BitSet week : MaxHolesFlexibleConstraint.this.getWeeks()) {
                    Integer oldPenalty;
                    int penalty;
                    if (week != null && !week.intersects(value.getTimeLocation().getWeekCode()) || (penalty = MaxHolesFlexibleConstraint.this.countHoles(assignment, dayCode, null, value, null, week)) <= MaxHolesFlexibleConstraint.this.iMaxHolesOnADay) continue;
                    Map<BitSet, Integer> holes = this.iMaxHoles.get(dayCode);
                    if (holes == null) {
                        holes = new HashMap<BitSet, Integer>();
                        this.iMaxHoles.put(dayCode, holes);
                    }
                    if ((oldPenalty = holes.get(week)) != null && oldPenalty >= penalty) continue;
                    holes.put(week, penalty);
                }
            }
        }

        public int getMaxHoles(int dayCode, BitSet week) {
            Map<BitSet, Integer> holes = this.iMaxHoles.get(dayCode);
            if (holes == null) {
                return MaxHolesFlexibleConstraint.this.iMaxHolesOnADay;
            }
            Integer penalty = holes.get(week);
            if (penalty == null || penalty < MaxHolesFlexibleConstraint.this.iMaxHolesOnADay) {
                return MaxHolesFlexibleConstraint.this.iMaxHolesOnADay;
            }
            return penalty;
        }
    }
}

