/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.TimetableLoader;
import org.cpsolver.coursett.TimetableSaver;
import org.cpsolver.coursett.TimetableXMLLoader;
import org.cpsolver.coursett.TimetableXMLSaver;
import org.cpsolver.coursett.constraint.DepartmentSpreadConstraint;
import org.cpsolver.coursett.constraint.GroupConstraint;
import org.cpsolver.coursett.constraint.InstructorConstraint;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.constraint.RoomConstraint;
import org.cpsolver.coursett.constraint.SpreadConstraint;
import org.cpsolver.coursett.criteria.BackToBackInstructorPreferences;
import org.cpsolver.coursett.criteria.BrokenTimePatterns;
import org.cpsolver.coursett.criteria.DepartmentBalancingPenalty;
import org.cpsolver.coursett.criteria.DistributionPreferences;
import org.cpsolver.coursett.criteria.Perturbations;
import org.cpsolver.coursett.criteria.RoomPreferences;
import org.cpsolver.coursett.criteria.SameSubpartBalancingPenalty;
import org.cpsolver.coursett.criteria.StudentCommittedConflict;
import org.cpsolver.coursett.criteria.StudentConflict;
import org.cpsolver.coursett.criteria.StudentDistanceConflict;
import org.cpsolver.coursett.criteria.StudentHardConflict;
import org.cpsolver.coursett.criteria.TimePreferences;
import org.cpsolver.coursett.criteria.TooBigRooms;
import org.cpsolver.coursett.criteria.UselessHalfHours;
import org.cpsolver.coursett.heuristics.UniversalPerturbationsCounter;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.DefaultParallelAssignment;
import org.cpsolver.ifs.assignment.DefaultSingleAssignment;
import org.cpsolver.ifs.extension.ConflictStatistics;
import org.cpsolver.ifs.extension.Extension;
import org.cpsolver.ifs.extension.MacPropagation;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solution.SolutionListener;
import org.cpsolver.ifs.solver.ParallelSolver;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ProblemLoader;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.ifs.util.ProgressWriter;
import org.cpsolver.ifs.util.ToolBox;

public class Test
implements SolutionListener<Lecture, Placement> {
    private static SimpleDateFormat sDateFormat = new SimpleDateFormat("yyMMdd_HHmmss", Locale.US);
    private static DecimalFormat sDoubleFormat = new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.US));
    private static Logger sLogger = Logger.getLogger(Test.class);
    private PrintWriter iCSVFile = null;
    private MacPropagation<Lecture, Placement> iProp = null;
    private ConflictStatistics<Lecture, Placement> iStat = null;
    private int iLastNotified = -1;
    private boolean initialized = false;
    private Solver<Lecture, Placement> iSolver = null;

    public static String getVersionString() {
        return "IFS Timetable Solver v" + Constants.getVersion() + " build" + Constants.getBuildNumber() + ", " + Constants.getReleaseDate();
    }

    public void init(Solver<Lecture, Placement> solver) {
        this.iSolver = solver;
        solver.currentSolution().addSolutionListener(this);
    }

    public static void setupLogging(File logFile, boolean debug) {
        Logger root = Logger.getRootLogger();
        ConsoleAppender console = new ConsoleAppender(new PatternLayout("[%t] %m%n"));
        console.setThreshold(Level.INFO);
        root.addAppender(console);
        if (logFile != null) {
            try {
                FileAppender file = new FileAppender(new PatternLayout("%d{dd-MMM-yy HH:mm:ss.SSS} [%t] %-5p %c{2}> %m%n"), logFile.getPath(), false);
                file.setThreshold(Level.DEBUG);
                root.addAppender(file);
            }
            catch (IOException e) {
                sLogger.fatal("Unable to configure logging, reason: " + e.getMessage(), e);
            }
        }
        if (!debug) {
            root.setLevel(Level.INFO);
        }
    }

    private String getTimetableLoaderClass(DataProperties properties) {
        String loader = properties.getProperty("TimetableLoader");
        if (loader != null) {
            return loader;
        }
        if (properties.getPropertyInt("General.InputVersion", -1) >= 0) {
            return "org.unitime.timetable.solver.TimetableDatabaseLoader";
        }
        return "org.cpsolver.coursett.TimetableXMLLoader";
    }

    private String getTimetableSaverClass(DataProperties properties) {
        String saver = properties.getProperty("TimetableSaver");
        if (saver != null) {
            return saver;
        }
        if (properties.getPropertyInt("General.InputVersion", -1) >= 0) {
            return "org.unitime.timetable.solver.TimetableDatabaseSaver";
        }
        return "org.cpsolver.coursett.TimetableXMLSaver";
    }

    public Test(String[] args) {
        try {
            DataProperties properties = ToolBox.loadProperties(new File(args[0]));
            properties.putAll((Map<?, ?>)System.getProperties());
            properties.setProperty("General.Output", properties.getProperty("General.Output", ".") + File.separator + sDateFormat.format(new Date()));
            if (args.length > 1) {
                properties.setProperty("General.Input", args[1]);
            }
            if (args.length > 2) {
                properties.setProperty("General.Output", args[2] + File.separator + sDateFormat.format(new Date()));
            }
            System.out.println("Output folder: " + properties.getProperty("General.Output"));
            File outDir = new File(properties.getProperty("General.Output", "."));
            outDir.mkdirs();
            Test.setupLogging(new File(outDir, "debug.log"), "true".equals(System.getProperty("debug", "false")));
            TimetableModel model = new TimetableModel(properties);
            int nrSolvers = properties.getPropertyInt("Parallel.NrSolvers", 1);
            DefaultSingleAssignment<Lecture, Placement> assignment = nrSolvers <= 1 ? new DefaultSingleAssignment() : new DefaultParallelAssignment();
            Progress.getInstance(model).addProgressListener(new ProgressWriter(System.out));
            Solver<Lecture, Placement> solver = nrSolvers == 1 ? new Solver<Lecture, Placement>(properties) : new ParallelSolver(properties);
            TimetableLoader loader = null;
            try {
                loader = (TimetableLoader)Class.forName(this.getTimetableLoaderClass(properties)).getConstructor(TimetableModel.class, Assignment.class).newInstance(model, assignment);
            }
            catch (ClassNotFoundException e) {
                System.err.println(e.getClass().getSimpleName() + ": " + e.getMessage());
                loader = new TimetableXMLLoader(model, (Assignment<Lecture, Placement>)assignment);
            }
            ((ProblemLoader)loader).load();
            solver.setInitalSolution(new Solution<Lecture, Placement>(model, assignment));
            this.init(solver);
            this.iCSVFile = new PrintWriter(new FileWriter(outDir.toString() + File.separator + "stat.csv"));
            String colSeparator = ";";
            this.iCSVFile.println("Assigned" + colSeparator + "Assigned[%]" + colSeparator + "Time[min]" + colSeparator + "Iter" + colSeparator + "IterYield[%]" + colSeparator + "Speed[it/s]" + colSeparator + "AddedPert" + colSeparator + "AddedPert[%]" + colSeparator + "HardStudentConf" + colSeparator + "StudentConf" + colSeparator + "DistStudentConf" + colSeparator + "CommitStudentConf" + colSeparator + "TimePref" + colSeparator + "RoomPref" + colSeparator + "DistInstrPref" + colSeparator + "GrConstPref" + colSeparator + "UselessHalfHours" + colSeparator + "BrokenTimePat" + colSeparator + "TooBigRooms" + (this.iProp != null ? colSeparator + "GoodVars" + colSeparator + "GoodVars[%]" + colSeparator + "GoodVals" + colSeparator + "GoodVals[%]" : ""));
            this.iCSVFile.flush();
            Runtime.getRuntime().addShutdownHook(new ShutdownHook(solver));
            solver.start();
            try {
                solver.getSolverThread().join();
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Throwable t) {
            sLogger.error("Test failed.", t);
        }
    }

    public static void main(String[] args) {
        new Test(args);
    }

    @Override
    public void bestCleared(Solution<Lecture, Placement> solution) {
    }

    @Override
    public void bestRestored(Solution<Lecture, Placement> solution) {
    }

    @Override
    public void bestSaved(Solution<Lecture, Placement> solution) {
        this.notify(solution);
        if (sLogger.isInfoEnabled()) {
            sLogger.info("**BEST[" + solution.getIteration() + "]** " + ((TimetableModel)solution.getModel()).toString(solution.getAssignment()) + (solution.getFailedIterations() > 0L ? ", F:" + sDoubleFormat.format(100.0 * (double)solution.getFailedIterations() / (double)solution.getIteration()) + "%" : ""));
        }
    }

    @Override
    public void getInfo(Solution<Lecture, Placement> solution, Map<String, String> info) {
    }

    @Override
    public void getInfo(Solution<Lecture, Placement> solution, Map<String, String> info, Collection<Lecture> variables) {
    }

    @Override
    public void solutionUpdated(Solution<Lecture, Placement> solution) {
        if (!this.initialized) {
            for (Extension<Lecture, Placement> extension : this.iSolver.getExtensions()) {
                if (MacPropagation.class.isInstance(extension)) {
                    this.iProp = (MacPropagation)extension;
                }
                if (!ConflictStatistics.class.isInstance(extension)) continue;
                this.iStat = (ConflictStatistics)extension;
            }
        }
    }

    public void notify(Solution<Lecture, Placement> solution) {
        String colSeparator = ";";
        Assignment<Lecture, Placement> assignment = solution.getAssignment();
        if (assignment.nrAssignedVariables() < solution.getModel().countVariables() && this.iLastNotified == assignment.nrAssignedVariables()) {
            return;
        }
        this.iLastNotified = assignment.nrAssignedVariables();
        if (this.iCSVFile != null) {
            TimetableModel model = (TimetableModel)solution.getModel();
            this.iCSVFile.print(model.variables().size() - model.nrUnassignedVariables(assignment));
            this.iCSVFile.print(colSeparator);
            this.iCSVFile.print(sDoubleFormat.format(100.0 * (double)assignment.nrAssignedVariables() / (double)model.variables().size()));
            this.iCSVFile.print(colSeparator);
            this.iCSVFile.print(sDoubleFormat.format(solution.getTime() / 60.0));
            this.iCSVFile.print(colSeparator);
            this.iCSVFile.print(solution.getIteration());
            this.iCSVFile.print(colSeparator);
            this.iCSVFile.print(sDoubleFormat.format(100.0 * (double)assignment.nrAssignedVariables() / (double)solution.getIteration()));
            this.iCSVFile.print(colSeparator);
            this.iCSVFile.print(sDoubleFormat.format((double)solution.getIteration() / solution.getTime()));
            this.iCSVFile.print(colSeparator);
            this.iCSVFile.print(model.perturbVariables(assignment).size());
            this.iCSVFile.print(colSeparator);
            this.iCSVFile.print(sDoubleFormat.format(100.0 * (double)model.perturbVariables(assignment).size() / (double)model.variables().size()));
            this.iCSVFile.print(colSeparator);
            this.iCSVFile.print(Math.round(solution.getModel().getCriterion(StudentHardConflict.class).getValue(assignment)));
            this.iCSVFile.print(colSeparator);
            this.iCSVFile.print(Math.round(solution.getModel().getCriterion(StudentConflict.class).getValue(assignment)));
            this.iCSVFile.print(colSeparator);
            this.iCSVFile.print(Math.round(solution.getModel().getCriterion(StudentDistanceConflict.class).getValue(assignment)));
            this.iCSVFile.print(colSeparator);
            this.iCSVFile.print(Math.round(solution.getModel().getCriterion(StudentCommittedConflict.class).getValue(assignment)));
            this.iCSVFile.print(colSeparator);
            this.iCSVFile.print(sDoubleFormat.format(solution.getModel().getCriterion(TimePreferences.class).getValue(assignment)));
            this.iCSVFile.print(colSeparator);
            this.iCSVFile.print(Math.round(solution.getModel().getCriterion(RoomPreferences.class).getValue(assignment)));
            this.iCSVFile.print(colSeparator);
            this.iCSVFile.print(Math.round(solution.getModel().getCriterion(BackToBackInstructorPreferences.class).getValue(assignment)));
            this.iCSVFile.print(colSeparator);
            this.iCSVFile.print(Math.round(solution.getModel().getCriterion(DistributionPreferences.class).getValue(assignment)));
            this.iCSVFile.print(colSeparator);
            this.iCSVFile.print(Math.round(solution.getModel().getCriterion(UselessHalfHours.class).getValue(assignment)));
            this.iCSVFile.print(colSeparator);
            this.iCSVFile.print(Math.round(solution.getModel().getCriterion(BrokenTimePatterns.class).getValue(assignment)));
            this.iCSVFile.print(colSeparator);
            this.iCSVFile.print(Math.round(solution.getModel().getCriterion(TooBigRooms.class).getValue(assignment)));
            if (this.iProp != null) {
                if (solution.getModel().nrUnassignedVariables(assignment) > 0) {
                    int goodVariables = 0;
                    long goodValues = 0L;
                    long allValues = 0L;
                    for (Lecture variable : ((TimetableModel)solution.getModel()).unassignedVariables(assignment)) {
                        goodValues += (long)this.iProp.goodValues(assignment, variable).size();
                        allValues += (long)variable.values(solution.getAssignment()).size();
                        if (this.iProp.goodValues(assignment, variable).isEmpty()) continue;
                        ++goodVariables;
                    }
                    this.iCSVFile.print(colSeparator);
                    this.iCSVFile.print(goodVariables);
                    this.iCSVFile.print(colSeparator);
                    this.iCSVFile.print(sDoubleFormat.format(100.0 * (double)goodVariables / (double)solution.getModel().nrUnassignedVariables(assignment)));
                    this.iCSVFile.print(colSeparator);
                    this.iCSVFile.print(goodValues);
                    this.iCSVFile.print(colSeparator);
                    this.iCSVFile.print(sDoubleFormat.format(100.0 * (double)goodValues / (double)allValues));
                } else {
                    this.iCSVFile.print(colSeparator);
                    this.iCSVFile.print(colSeparator);
                    this.iCSVFile.print(colSeparator);
                    this.iCSVFile.print(colSeparator);
                }
            }
            this.iCSVFile.println();
            this.iCSVFile.flush();
        }
    }

    public static void printRoomInfo(PrintWriter pw, TimetableModel model, Assignment<Lecture, Placement> assignment) {
        pw.println("Room info:");
        pw.println("id, name, size, used_day, used_total");
        int firstDaySlot = model.getProperties().getPropertyInt("General.FirstDaySlot", Constants.DAY_SLOTS_FIRST);
        int lastDaySlot = model.getProperties().getPropertyInt("General.LastDaySlot", Constants.DAY_SLOTS_LAST);
        int firstWorkDay = model.getProperties().getPropertyInt("General.FirstWorkDay", 0);
        int lastWorkDay = model.getProperties().getPropertyInt("General.LastWorkDay", Constants.NR_DAYS_WEEK - 1);
        if (lastWorkDay < firstWorkDay) {
            lastWorkDay += 7;
        }
        for (RoomConstraint rc : model.getRoomConstraints()) {
            int time;
            int day;
            int used_day = 0;
            int used_total = 0;
            for (day = firstWorkDay; day <= lastWorkDay; ++day) {
                for (time = firstDaySlot; time <= lastDaySlot; ++time) {
                    if (((RoomConstraint.RoomConstraintContext)rc.getContext((Assignment)assignment)).getPlacements(day % 7 * 288 + time).isEmpty()) continue;
                    ++used_day;
                }
            }
            for (day = 0; day < Constants.DAY_CODES.length; ++day) {
                for (time = 0; time < 288; ++time) {
                    if (((RoomConstraint.RoomConstraintContext)rc.getContext((Assignment)assignment)).getPlacements(day % 7 * 288 + time).isEmpty()) continue;
                    ++used_total;
                }
            }
            pw.println(rc.getResourceId() + "," + rc.getName() + "," + rc.getCapacity() + "," + used_day + "," + used_total);
        }
    }

    public static void printClassInfo(PrintWriter pw, TimetableModel model) {
        pw.println("Class info:");
        pw.println("id, name, min_class_limit, max_class_limit, room2limit_ratio, half_hours");
        for (Lecture lecture : model.variables()) {
            if (lecture.timeLocations().isEmpty()) {
                pw.println(lecture.getClassId() + "," + lecture.getName() + "," + lecture.minClassLimit() + "," + lecture.maxClassLimit() + "," + lecture.roomToLimitRatio() + ",NO TIMES");
                sLogger.error(lecture.getName() + " has no times.");
                continue;
            }
            TimeLocation time = lecture.timeLocations().get(0);
            pw.println(lecture.getClassId() + "," + lecture.getName() + "," + lecture.minClassLimit() + "," + lecture.maxClassLimit() + "," + lecture.roomToLimitRatio() + "," + time.getNrSlotsPerMeeting() * time.getNrMeetings());
        }
    }

    public static void printSomeStuff(Solution<Lecture, Placement> solution) throws IOException {
        int n;
        TimetableModel model = (TimetableModel)solution.getModel();
        Assignment<Lecture, Placement> assignment = solution.getAssignment();
        File outDir = new File(model.getProperties().getProperty("General.Output", "."));
        PrintWriter pw = new PrintWriter(new FileWriter(outDir.toString() + File.separator + "info.txt"));
        PrintWriter pwi = new PrintWriter(new FileWriter(outDir.toString() + File.separator + "info.csv"));
        String name = new File(model.getProperties().getProperty("General.Input")).getName();
        pwi.println("Instance," + name.substring(0, name.lastIndexOf(46)));
        pw.println("Solution info: " + ToolBox.dict2string(solution.getInfo(), 1));
        pw.println("Bounds: " + ToolBox.dict2string(model.getBounds(assignment), 1));
        Map<String, String> info = solution.getInfo();
        for (String key : new TreeSet<String>(info.keySet())) {
            if (key.equals("Memory usage") || key.equals("Iteration") || key.equals("Time")) continue;
            String value = info.get(key);
            if (value.indexOf(32) > 0) {
                value = value.substring(0, value.indexOf(32));
            }
            pwi.println(key + "," + value);
        }
        Test.printRoomInfo(pw, model, assignment);
        Test.printClassInfo(pw, model);
        long nrValues = 0L;
        long nrTimes = 0L;
        long nrRooms = 0L;
        double totalMaxNormTimePref = 0.0;
        double totalMinNormTimePref = 0.0;
        double totalNormTimePref = 0.0;
        int totalMaxRoomPref = 0;
        int totalMinRoomPref = 0;
        int totalRoomPref = 0;
        long nrStudentEnrls = 0L;
        long nrInevitableStudentConflicts = 0L;
        long nrJenrls = 0L;
        int nrHalfHours = 0;
        int nrMeetings = 0;
        int totalMinLimit = 0;
        int totalMaxLimit = 0;
        long nrReqRooms = 0L;
        int nrSingleValueVariables = 0;
        int nrSingleTimeVariables = 0;
        int nrSingleRoomVariables = 0;
        long totalAvailableMinRoomSize = 0L;
        long totalAvailableMaxRoomSize = 0L;
        long totalRoomSize = 0L;
        long nrOneOrMoreRoomVariables = 0L;
        long nrOneRoomVariables = 0L;
        HashSet<Student> students = new HashSet<Student>();
        HashSet<Long> offerings = new HashSet<Long>();
        HashSet<Long> configs = new HashSet<Long>();
        HashSet<Long> subparts = new HashSet<Long>();
        int[] sizeLimits = new int[]{0, 25, 50, 75, 100, 150, 200, 400};
        int[] nrRoomsOfSize = new int[sizeLimits.length];
        int[] minRoomOfSize = new int[sizeLimits.length];
        int[] maxRoomOfSize = new int[sizeLimits.length];
        int[] totalUsedSlots = new int[sizeLimits.length];
        int[] totalUsedSeats = new int[sizeLimits.length];
        int[] totalUsedSeats2 = new int[sizeLimits.length];
        int firstDaySlot = model.getProperties().getPropertyInt("General.FirstDaySlot", Constants.DAY_SLOTS_FIRST);
        int lastDaySlot = model.getProperties().getPropertyInt("General.LastDaySlot", Constants.DAY_SLOTS_LAST);
        int firstWorkDay = model.getProperties().getPropertyInt("General.FirstWorkDay", 0);
        int lastWorkDay = model.getProperties().getPropertyInt("General.LastWorkDay", Constants.NR_DAYS_WEEK - 1);
        if (lastWorkDay < firstWorkDay) {
            lastWorkDay += 7;
        }
        for (Lecture lecture : model.variables()) {
            if (lecture.getConfiguration() != null) {
                offerings.add(lecture.getConfiguration().getOfferingId());
                configs.add(lecture.getConfiguration().getConfigId());
            }
            subparts.add(lecture.getSchedulingSubpartId());
            nrStudentEnrls += (long)(lecture.students() == null ? 0 : lecture.students().size());
            students.addAll(lecture.students());
            nrValues += (long)lecture.values(solution.getAssignment()).size();
            nrReqRooms += (long)lecture.getNrRooms();
            for (RoomLocation room : lecture.roomLocations()) {
                if (room.getPreference() >= Constants.sPreferenceLevelProhibited / 2) continue;
                ++nrRooms;
            }
            for (TimeLocation time : lecture.timeLocations()) {
                if (time.getPreference() >= Constants.sPreferenceLevelProhibited / 2) continue;
                ++nrTimes;
            }
            totalMinLimit += lecture.minClassLimit();
            totalMaxLimit += lecture.maxClassLimit();
            if (!lecture.values(solution.getAssignment()).isEmpty()) {
                TimeLocation time;
                Placement p = lecture.values(solution.getAssignment()).get(0);
                nrMeetings += p.getTimeLocation().getNrMeetings();
                nrHalfHours += p.getTimeLocation().getNrMeetings() * p.getTimeLocation().getNrSlotsPerMeeting();
                totalMaxNormTimePref += lecture.getMinMaxTimePreference()[1];
                totalMinNormTimePref += lecture.getMinMaxTimePreference()[0];
                totalNormTimePref += Math.abs(lecture.getMinMaxTimePreference()[1] - lecture.getMinMaxTimePreference()[0]);
                totalMaxRoomPref += lecture.getMinMaxRoomPreference()[1];
                totalMinRoomPref += lecture.getMinMaxRoomPreference()[0];
                totalRoomPref += Math.abs(lecture.getMinMaxRoomPreference()[1] - lecture.getMinMaxRoomPreference()[0]);
                time = p.getTimeLocation();
                boolean hasRoomConstraint = false;
                for (RoomLocation roomLocation : lecture.roomLocations()) {
                    if (!roomLocation.getRoomConstraint().getConstraint()) continue;
                    hasRoomConstraint = true;
                }
                if (hasRoomConstraint && lecture.getNrRooms() > 0) {
                    for (int d = firstWorkDay; d <= lastWorkDay; ++d) {
                        if ((time.getDayCode() & Constants.DAY_CODES[d % 7]) == 0) continue;
                        for (int t = Math.max(time.getStartSlot(), firstDaySlot); t <= Math.min(time.getStartSlot() + time.getLength() - 1, lastDaySlot); ++t) {
                            for (int l = 0; l < sizeLimits.length; ++l) {
                                if (sizeLimits[l] > lecture.minRoomSize()) continue;
                                int n2 = l;
                                totalUsedSlots[n2] = totalUsedSlots[n2] + lecture.getNrRooms();
                                int n3 = l;
                                totalUsedSeats[n3] = totalUsedSeats[n3] + lecture.classLimit(assignment);
                                int n4 = l;
                                totalUsedSeats2[n4] = totalUsedSeats2[n4] + lecture.minRoomSize() * lecture.getNrRooms();
                            }
                        }
                    }
                }
            }
            if (lecture.values(solution.getAssignment()).size() == 1) {
                ++nrSingleValueVariables;
            }
            if (lecture.timeLocations().size() == 1) {
                ++nrSingleTimeVariables;
            }
            if (lecture.roomLocations().size() == 1) {
                ++nrSingleRoomVariables;
            }
            if (lecture.getNrRooms() == 1) {
                ++nrOneRoomVariables;
            }
            if (lecture.getNrRooms() > 0) {
                ++nrOneOrMoreRoomVariables;
            }
            if (lecture.roomLocations().isEmpty()) continue;
            int minRoomSize = Integer.MAX_VALUE;
            int maxRoomSize = Integer.MIN_VALUE;
            for (RoomLocation rl : lecture.roomLocations()) {
                minRoomSize = Math.min(minRoomSize, rl.getRoomSize());
                maxRoomSize = Math.max(maxRoomSize, rl.getRoomSize());
                totalRoomSize += (long)rl.getRoomSize();
            }
            totalAvailableMinRoomSize += (long)minRoomSize;
            totalAvailableMaxRoomSize += (long)maxRoomSize;
        }
        for (JenrlConstraint jenrlConstraint : model.getJenrlConstraints()) {
            Placement p2;
            Placement p1;
            TimeLocation t2;
            nrJenrls += jenrlConstraint.getJenrl();
            if (((Lecture)jenrlConstraint.first()).timeLocations().size() != 1 || ((Lecture)jenrlConstraint.second()).timeLocations().size() != 1) continue;
            TimeLocation t1 = ((Lecture)jenrlConstraint.first()).timeLocations().get(0);
            if (t1.hasIntersection(t2 = ((Lecture)jenrlConstraint.second()).timeLocations().get(0))) {
                nrInevitableStudentConflicts += jenrlConstraint.getJenrl();
                pw.println("Inevitable " + jenrlConstraint.getJenrl() + " student conflicts between " + jenrlConstraint.first() + " " + t1 + " and " + jenrlConstraint.second() + " " + t2);
                continue;
            }
            if (((Lecture)jenrlConstraint.first()).values(solution.getAssignment()).size() != 1 || ((Lecture)jenrlConstraint.second()).values(solution.getAssignment()).size() != 1 || !JenrlConstraint.isInConflict(p1 = ((Lecture)jenrlConstraint.first()).values(solution.getAssignment()).get(0), p2 = ((Lecture)jenrlConstraint.second()).values(solution.getAssignment()).get(0), ((TimetableModel)((Lecture)p1.variable()).getModel()).getDistanceMetric(), ((TimetableModel)((Lecture)p1.variable()).getModel()).getStudentWorkDayLimit())) continue;
            nrInevitableStudentConflicts += jenrlConstraint.getJenrl();
            pw.println("Inevitable " + jenrlConstraint.getJenrl() + (p1.getTimeLocation().hasIntersection(p2.getTimeLocation()) ? "" : " distance") + " student conflicts between " + p1 + " and " + p2);
        }
        int totalCommitedPlacements = 0;
        for (Student student : students) {
            if (student.getCommitedPlacements() == null) continue;
            totalCommitedPlacements += student.getCommitedPlacements().size();
        }
        pw.println("Total number of classes: " + model.variables().size());
        pwi.println("Number of classes," + model.variables().size());
        pw.println("Total number of instructional offerings: " + offerings.size() + " (" + sDoubleFormat.format(100.0 * (double)offerings.size() / (double)model.variables().size()) + "%)");
        pw.println("Total number of configurations: " + configs.size() + " (" + sDoubleFormat.format(100.0 * (double)configs.size() / (double)model.variables().size()) + "%)");
        pw.println("Total number of scheduling subparts: " + subparts.size() + " (" + sDoubleFormat.format(100.0 * (double)subparts.size() / (double)model.variables().size()) + "%)");
        pw.println("Average number classes per subpart: " + sDoubleFormat.format(1.0 * (double)model.variables().size() / (double)subparts.size()));
        pwi.println("Avg. classes per instruction," + sDoubleFormat.format(1.0 * (double)model.variables().size() / (double)subparts.size()));
        pw.println("Average number classes per config: " + sDoubleFormat.format(1.0 * (double)model.variables().size() / (double)configs.size()));
        pw.println("Average number classes per offering: " + sDoubleFormat.format(1.0 * (double)model.variables().size() / (double)offerings.size()));
        pw.println("Total number of classes with only one value: " + nrSingleValueVariables + " (" + sDoubleFormat.format(100.0 * (double)nrSingleValueVariables / (double)model.variables().size()) + "%)");
        pw.println("Total number of classes with only one time: " + nrSingleTimeVariables + " (" + sDoubleFormat.format(100.0 * (double)nrSingleTimeVariables / (double)model.variables().size()) + "%)");
        pw.println("Total number of classes with only one room: " + nrSingleRoomVariables + " (" + sDoubleFormat.format(100.0 * (double)nrSingleRoomVariables / (double)model.variables().size()) + "%)");
        pwi.println("Classes with single value," + nrSingleValueVariables);
        pw.println("Total number of classes requesting no room: " + ((long)model.variables().size() - nrOneOrMoreRoomVariables) + " (" + sDoubleFormat.format(100.0 * (double)((long)model.variables().size() - nrOneOrMoreRoomVariables) / (double)model.variables().size()) + "%)");
        pw.println("Total number of classes requesting one room: " + nrOneRoomVariables + " (" + sDoubleFormat.format(100.0 * (double)nrOneRoomVariables / (double)model.variables().size()) + "%)");
        pw.println("Total number of classes requesting one or more rooms: " + nrOneOrMoreRoomVariables + " (" + sDoubleFormat.format(100.0 * (double)nrOneOrMoreRoomVariables / (double)model.variables().size()) + "%)");
        pw.println("Average number of requested rooms: " + sDoubleFormat.format(1.0 * (double)nrReqRooms / (double)model.variables().size()));
        pw.println("Average minimal class limit: " + sDoubleFormat.format(1.0 * (double)totalMinLimit / (double)model.variables().size()));
        pw.println("Average maximal class limit: " + sDoubleFormat.format(1.0 * (double)totalMaxLimit / (double)model.variables().size()));
        pw.println("Average number of placements: " + sDoubleFormat.format(1.0 * (double)nrValues / (double)model.variables().size()));
        pwi.println("Avg. domain size," + sDoubleFormat.format(1.0 * (double)nrValues / (double)model.variables().size()));
        pw.println("Average number of time locations: " + sDoubleFormat.format(1.0 * (double)nrTimes / (double)model.variables().size()));
        pwi.println("Avg. number of avail. times/rooms," + sDoubleFormat.format(1.0 * (double)nrTimes / (double)model.variables().size()) + "/" + sDoubleFormat.format(1.0 * (double)nrRooms / (double)model.variables().size()));
        pw.println("Average number of room locations: " + sDoubleFormat.format(1.0 * (double)nrRooms / (double)model.variables().size()));
        pw.println("Average minimal requested room size: " + sDoubleFormat.format(1.0 * (double)totalAvailableMinRoomSize / (double)nrOneOrMoreRoomVariables));
        pw.println("Average maximal requested room size: " + sDoubleFormat.format(1.0 * (double)totalAvailableMaxRoomSize / (double)nrOneOrMoreRoomVariables));
        pw.println("Average requested room sizes: " + sDoubleFormat.format(1.0 * (double)totalRoomSize / (double)nrRooms));
        pwi.println("Average requested room size," + sDoubleFormat.format(1.0 * (double)totalRoomSize / (double)nrRooms));
        pw.println("Average maximum normalized time preference: " + sDoubleFormat.format(totalMaxNormTimePref / (double)model.variables().size()));
        pw.println("Average minimum normalized time preference: " + sDoubleFormat.format(totalMinNormTimePref / (double)model.variables().size()));
        pw.println("Average normalized time preference," + sDoubleFormat.format(totalNormTimePref / (double)model.variables().size()));
        pw.println("Average maximum room preferences: " + sDoubleFormat.format(1.0 * (double)totalMaxRoomPref / (double)nrOneOrMoreRoomVariables));
        pw.println("Average minimum room preferences: " + sDoubleFormat.format(1.0 * (double)totalMinRoomPref / (double)nrOneOrMoreRoomVariables));
        pw.println("Average room preferences," + sDoubleFormat.format(1.0 * (double)totalRoomPref / (double)nrOneOrMoreRoomVariables));
        pw.println("Total number of students:" + students.size());
        pwi.println("Number of students," + students.size());
        pwi.println("Number of inevitable student conflicts," + nrInevitableStudentConflicts);
        pw.println("Total amount of student enrollments: " + nrStudentEnrls);
        pwi.println("Number of student enrollments," + nrStudentEnrls);
        pw.println("Total amount of joined enrollments: " + nrJenrls);
        pwi.println("Number of joint student enrollments," + nrJenrls);
        pw.println("Average number of students: " + sDoubleFormat.format(1.0 * (double)students.size() / (double)model.variables().size()));
        pw.println("Average number of enrollemnts (per student): " + sDoubleFormat.format(1.0 * (double)nrStudentEnrls / (double)students.size()));
        pwi.println("Avg. number of classes per student," + sDoubleFormat.format(1.0 * (double)nrStudentEnrls / (double)students.size()));
        pwi.println("Avg. number of committed classes per student," + sDoubleFormat.format(1.0 * (double)totalCommitedPlacements / (double)students.size()));
        pw.println("Total amount of inevitable student conflicts: " + nrInevitableStudentConflicts + " (" + sDoubleFormat.format(100.0 * (double)nrInevitableStudentConflicts / (double)nrStudentEnrls) + "%)");
        pw.println("Average number of meetings (per class): " + sDoubleFormat.format(1.0 * (double)nrMeetings / (double)model.variables().size()));
        pw.println("Average number of hours per class: " + sDoubleFormat.format(1.0 * (double)nrHalfHours / (double)model.variables().size() / 12.0));
        pwi.println("Avg. number of meetings per class," + sDoubleFormat.format(1.0 * (double)nrMeetings / (double)model.variables().size()));
        pwi.println("Avg. number of hours per class," + sDoubleFormat.format(1.0 * (double)nrHalfHours / (double)model.variables().size() / 12.0));
        int n5 = Integer.MAX_VALUE;
        int maxRoomSize = Integer.MIN_VALUE;
        int nrDistancePairs = 0;
        double maxRoomDistance = Double.MIN_VALUE;
        double totalRoomDistance = 0.0;
        int[] totalAvailableSlots = new int[sizeLimits.length];
        int[] totalAvailableSeats = new int[sizeLimits.length];
        int nrOfRooms = 0;
        totalRoomSize = 0L;
        for (RoomConstraint roomConstraint : model.getRoomConstraints()) {
            if (roomConstraint.variables().isEmpty()) continue;
            ++nrOfRooms;
            n = Math.min(n, roomConstraint.getCapacity());
            maxRoomSize = Math.max(maxRoomSize, roomConstraint.getCapacity());
            for (int l = 0; l < sizeLimits.length; ++l) {
                if (sizeLimits[l] > roomConstraint.getCapacity() || l + 1 != sizeLimits.length && roomConstraint.getCapacity() >= sizeLimits[l + 1]) continue;
                int n6 = l;
                nrRoomsOfSize[n6] = nrRoomsOfSize[n6] + 1;
                minRoomOfSize[l] = minRoomOfSize[l] == 0 ? roomConstraint.getCapacity() : Math.min(minRoomOfSize[l], roomConstraint.getCapacity());
                maxRoomOfSize[l] = maxRoomOfSize[l] == 0 ? roomConstraint.getCapacity() : Math.max(maxRoomOfSize[l], roomConstraint.getCapacity());
            }
            totalRoomSize += (long)roomConstraint.getCapacity();
            if (roomConstraint.getPosX() != null && roomConstraint.getPosY() != null) {
                for (RoomConstraint rc2 : model.getRoomConstraints()) {
                    if (rc2.getResourceId().compareTo(roomConstraint.getResourceId()) <= 0 || rc2.getPosX() == null || rc2.getPosY() == null) continue;
                    double distance = ((TimetableModel)solution.getModel()).getDistanceMetric().getDistanceInMinutes(roomConstraint.getId(), roomConstraint.getPosX(), roomConstraint.getPosY(), rc2.getId(), rc2.getPosX(), rc2.getPosY()).intValue();
                    totalRoomDistance += distance;
                    ++nrDistancePairs;
                    maxRoomDistance = Math.max(maxRoomDistance, distance);
                }
            }
            for (int d = firstWorkDay; d <= lastWorkDay; ++d) {
                for (int t = firstDaySlot; t <= lastDaySlot; ++t) {
                    if (!roomConstraint.isAvailable(d % 7 * 288 + t)) continue;
                    for (int l = 0; l < sizeLimits.length; ++l) {
                        if (sizeLimits[l] > roomConstraint.getCapacity()) continue;
                        int n7 = l;
                        totalAvailableSlots[n7] = totalAvailableSlots[n7] + 1;
                        int n8 = l;
                        totalAvailableSeats[n8] = totalAvailableSeats[n8] + roomConstraint.getCapacity();
                    }
                }
            }
        }
        pw.println("Total number of rooms: " + nrOfRooms);
        pwi.println("Number of rooms," + nrOfRooms);
        pw.println("Minimal room size: " + n);
        pw.println("Maximal room size: " + maxRoomSize);
        pwi.println("Room size min/max," + n + "/" + maxRoomSize);
        pw.println("Average room size: " + sDoubleFormat.format(1.0 * (double)totalRoomSize / (double)model.getRoomConstraints().size()));
        pw.println("Maximal distance between two rooms: " + sDoubleFormat.format(maxRoomDistance));
        pw.println("Average distance between two rooms: " + sDoubleFormat.format(totalRoomDistance / (double)nrDistancePairs));
        pwi.println("Average distance between two rooms [min]," + sDoubleFormat.format(totalRoomDistance / (double)nrDistancePairs));
        pwi.println("Maximal distance between two rooms [min]," + sDoubleFormat.format(maxRoomDistance));
        for (int l = 0; l < sizeLimits.length; ++l) {
            pwi.println("\"Room frequency (size>=" + sizeLimits[l] + ", used/avaiable times)\"," + sDoubleFormat.format(100.0 * (double)totalUsedSlots[l] / (double)totalAvailableSlots[l]) + "%");
            pwi.println("\"Room utilization (size>=" + sizeLimits[l] + ", used/available seats)\"," + sDoubleFormat.format(100.0 * (double)totalUsedSeats[l] / (double)totalAvailableSeats[l]) + "%");
            pwi.println("\"Number of rooms (size>=" + sizeLimits[l] + ")\"," + nrRoomsOfSize[l]);
            pwi.println("\"Min/max room size (size>=" + sizeLimits[l] + ")\"," + minRoomOfSize[l] + "-" + maxRoomOfSize[l]);
        }
        pw.println("Average hours available: " + sDoubleFormat.format(1.0 * (double)totalAvailableSlots[0] / (double)nrOfRooms / 12.0));
        int totalInstructedClasses = 0;
        for (InstructorConstraint ic : model.getInstructorConstraints()) {
            totalInstructedClasses += ic.variables().size();
        }
        pw.println("Total number of instructors: " + model.getInstructorConstraints().size());
        pwi.println("Number of instructors," + model.getInstructorConstraints().size());
        pw.println("Total class-instructor assignments: " + totalInstructedClasses + " (" + sDoubleFormat.format(100.0 * (double)totalInstructedClasses / (double)model.variables().size()) + "%)");
        pwi.println("Number of class-instructor assignments," + totalInstructedClasses);
        pw.println("Average classes per instructor: " + sDoubleFormat.format(1.0 * (double)totalInstructedClasses / (double)model.getInstructorConstraints().size()));
        pwi.println("Average classes per instructor," + sDoubleFormat.format(1.0 * (double)totalInstructedClasses / (double)model.getInstructorConstraints().size()));
        int n9 = model.getGroupConstraints().size() + model.getSpreadConstraints().size();
        int nrHardGroupConstraints = 0;
        int nrVarsInGroupConstraints = 0;
        for (GroupConstraint gc : model.getGroupConstraints()) {
            if (gc.isHard()) {
                ++nrHardGroupConstraints;
            }
            nrVarsInGroupConstraints += gc.variables().size();
        }
        for (SpreadConstraint sc : model.getSpreadConstraints()) {
            nrVarsInGroupConstraints += sc.variables().size();
        }
        pw.println("Total number of group constraints: " + n9 + " (" + sDoubleFormat.format(100.0 * (double)n9 / (double)model.variables().size()) + "%)");
        pw.println("Total number of hard group constraints: " + nrHardGroupConstraints + " (" + sDoubleFormat.format(100.0 * (double)nrHardGroupConstraints / (double)model.variables().size()) + "%)");
        pw.println("Average classes per group constraint: " + sDoubleFormat.format(1.0 * (double)nrVarsInGroupConstraints / (double)n9));
        pwi.println("Avg. number distribution constraints per class," + sDoubleFormat.format(1.0 * (double)nrVarsInGroupConstraints / (double)model.variables().size()));
        pwi.println("Joint enrollment constraints," + model.getJenrlConstraints().size());
        pw.flush();
        pw.close();
        pwi.flush();
        pwi.close();
    }

    /*
     * WARNING - void declaration
     */
    public static void saveOutputCSV(Solution<Lecture, Placement> s, File file) {
        try {
            void var23_44;
            void var23_45;
            void var23_43;
            void var23_42;
            void var23_41;
            void var23_40;
            void var23_39;
            void var23_38;
            void var23_37;
            void var23_36;
            void var23_35;
            void var23_34;
            void var23_33;
            DecimalFormat dx = new DecimalFormat("000");
            PrintWriter w = new PrintWriter(new FileWriter(file));
            TimetableModel m = (TimetableModel)s.getModel();
            int firstDaySlot = m.getProperties().getPropertyInt("General.FirstDaySlot", Constants.DAY_SLOTS_FIRST);
            int lastDaySlot = m.getProperties().getPropertyInt("General.LastDaySlot", Constants.DAY_SLOTS_LAST);
            int firstWorkDay = m.getProperties().getPropertyInt("General.FirstWorkDay", 0);
            int lastWorkDay = m.getProperties().getPropertyInt("General.LastWorkDay", Constants.NR_DAYS_WEEK - 1);
            if (lastWorkDay < firstWorkDay) {
                lastWorkDay += 7;
            }
            Assignment<Lecture, Placement> a = s.getAssignment();
            int idx = 1;
            w.println("000." + dx.format(idx++) + " Assigned variables," + a.nrAssignedVariables());
            w.println("000." + dx.format(idx++) + " Time [sec]," + sDoubleFormat.format(s.getBestTime()));
            w.println("000." + dx.format(idx++) + " Hard student conflicts," + Math.round(m.getCriterion(StudentHardConflict.class).getValue(a)));
            if (m.getProperties().getPropertyBoolean("General.UseDistanceConstraints", true)) {
                w.println("000." + dx.format(idx++) + " Distance student conf.," + Math.round(m.getCriterion(StudentDistanceConflict.class).getValue(a)));
            }
            w.println("000." + dx.format(idx++) + " Student conflicts," + Math.round(m.getCriterion(StudentConflict.class).getValue(a)));
            w.println("000." + dx.format(idx++) + " Committed student conflicts," + Math.round(m.getCriterion(StudentCommittedConflict.class).getValue(a)));
            w.println("000." + dx.format(idx++) + " All Student conflicts," + Math.round(m.getCriterion(StudentConflict.class).getValue(a) + m.getCriterion(StudentCommittedConflict.class).getValue(a)));
            w.println("000." + dx.format(idx++) + " Time preferences," + sDoubleFormat.format(m.getCriterion(TimePreferences.class).getValue(a)));
            w.println("000." + dx.format(idx++) + " Room preferences," + Math.round(m.getCriterion(RoomPreferences.class).getValue(a)));
            w.println("000." + dx.format(idx++) + " Useless half-hours," + Math.round(m.getCriterion(UselessHalfHours.class).getValue(a)));
            w.println("000." + dx.format(idx++) + " Broken time patterns," + Math.round(m.getCriterion(BrokenTimePatterns.class).getValue(a)));
            w.println("000." + dx.format(idx++) + " Too big room," + Math.round(m.getCriterion(TooBigRooms.class).getValue(a)));
            w.println("000." + dx.format(idx++) + " Distribution preferences," + sDoubleFormat.format(m.getCriterion(DistributionPreferences.class).getValue(a)));
            if (m.getProperties().getPropertyBoolean("General.UseDistanceConstraints", true)) {
                w.println("000." + dx.format(idx++) + " Back-to-back instructor pref.," + Math.round(m.getCriterion(BackToBackInstructorPreferences.class).getValue(a)));
            }
            if (m.getProperties().getPropertyBoolean("General.DeptBalancing", true)) {
                w.println("000." + dx.format(idx++) + " Dept. balancing penalty," + sDoubleFormat.format(m.getCriterion(DepartmentBalancingPenalty.class).getValue(a)));
            }
            w.println("000." + dx.format(idx++) + " Same subpart balancing penalty," + sDoubleFormat.format(m.getCriterion(SameSubpartBalancingPenalty.class).getValue(a)));
            if (m.getProperties().getPropertyBoolean("General.MPP", false)) {
                Map<String, Double> mppInfo = ((UniversalPerturbationsCounter)((Perturbations)m.getCriterion(Perturbations.class)).getPerturbationsCounter()).getCompactInfo(a, m, false, false);
                int pidx = 51;
                w.println("000." + dx.format(pidx++) + " Perturbation penalty," + sDoubleFormat.format(m.getCriterion(Perturbations.class).getValue(a)));
                w.println("000." + dx.format(pidx++) + " Additional perturbations," + m.perturbVariables(a).size());
                int nrPert = 0;
                int nrStudentPert = 0;
                for (Lecture lecture : m.variables()) {
                    if (lecture.getInitialAssignment() != null) continue;
                    ++nrPert;
                    nrStudentPert += lecture.classLimit(a);
                }
                w.println("000." + dx.format(pidx++) + " Given perturbations," + nrPert);
                w.println("000." + dx.format(pidx++) + " Given student perturbations," + nrStudentPert);
                for (String key : new TreeSet<String>(mppInfo.keySet())) {
                    Double value = mppInfo.get(key);
                    w.println("000." + dx.format(pidx++) + " " + key + "," + sDoubleFormat.format(value));
                }
            }
            HashSet<Student> students = new HashSet<Student>();
            int enrls = 0;
            int minRoomPref = 0;
            int maxRoomPref = 0;
            int minGrPref = 0;
            int maxGrPref = 0;
            int minTimePref = 0;
            int maxTimePref = 0;
            int worstInstrPref = 0;
            HashSet used = new HashSet();
            for (Object lecture : m.variables()) {
                enrls += ((Lecture)lecture).students() == null ? 0 : ((Lecture)lecture).students().size();
                students.addAll(((Lecture)lecture).students());
                int[] nArray = ((Lecture)lecture).getMinMaxRoomPreference();
                maxRoomPref += nArray[1] - nArray[0];
                double[] minMaxTimePref = ((Lecture)lecture).getMinMaxTimePreference();
                maxTimePref = (int)((double)maxTimePref + (minMaxTimePref[1] - minMaxTimePref[0]));
                for (Constraint c : ((Variable)lecture).constraints()) {
                    GroupConstraint gc;
                    if (!used.add(c)) continue;
                    if (c instanceof InstructorConstraint) {
                        InstructorConstraint ic = (InstructorConstraint)c;
                        worstInstrPref += ic.getWorstPreference();
                    }
                    if (!(c instanceof GroupConstraint) || (gc = (GroupConstraint)c).isHard()) continue;
                    maxGrPref += Math.abs(gc.getPreference()) * (1 + gc.variables().size() * (gc.variables().size() - 1) / 2);
                }
            }
            int totalCommitedPlacements = 0;
            for (Student student : students) {
                if (student.getCommitedPlacements() == null) continue;
                totalCommitedPlacements += student.getCommitedPlacements().size();
            }
            HashMap<Long, ArrayList<Lecture>> subs = new HashMap<Long, ArrayList<Lecture>>();
            for (Lecture lecture : m.variables()) {
                if (lecture.isCommitted() || lecture.getScheduler() == null) continue;
                ArrayList<Lecture> vars = (ArrayList<Lecture>)subs.get(lecture.getScheduler());
                if (vars == null) {
                    vars = new ArrayList<Lecture>();
                    subs.put(lecture.getScheduler(), vars);
                }
                vars.add(lecture);
            }
            int n = 101;
            w.println("000." + dx.format(n) + " Assigned variables max," + m.variables().size());
            w.println("000." + dx.format((long)(++var23_33)) + " Student enrollments," + enrls);
            w.println("000." + dx.format((long)(++var23_34)) + " Student commited enrollments," + totalCommitedPlacements);
            w.println("000." + dx.format((long)(++var23_35)) + " All student enrollments," + (enrls + totalCommitedPlacements));
            w.println("000." + dx.format((long)(++var23_36)) + " Time preferences min," + minTimePref);
            w.println("000." + dx.format((long)(++var23_37)) + " Time preferences max," + maxTimePref);
            w.println("000." + dx.format((long)(++var23_38)) + " Room preferences min," + minRoomPref);
            w.println("000." + dx.format((long)(++var23_39)) + " Room preferences max," + maxRoomPref);
            w.println("000." + dx.format((long)(++var23_40)) + " Useless half-hours max," + Constants.sPreferenceLevelStronglyDiscouraged * m.getRoomConstraints().size() * (lastDaySlot - firstDaySlot + 1) * (lastWorkDay - firstWorkDay + 1));
            w.println("000." + dx.format((long)(++var23_41)) + " Too big room max," + Constants.sPreferenceLevelStronglyDiscouraged * m.variables().size());
            w.println("000." + dx.format((long)(++var23_42)) + " Distribution preferences min," + minGrPref);
            w.println("000." + dx.format((long)(++var23_43)) + " Distribution preferences max," + maxGrPref);
            ++var23_45;
            w.println("000." + dx.format((long)(++var23_44)) + " Back-to-back instructor pref max," + worstInstrPref);
            TooBigRooms tbr = (TooBigRooms)m.getCriterion(TooBigRooms.class);
            for (Long scheduler : new TreeSet(subs.keySet())) {
                List vars = (List)subs.get(scheduler);
                idx = 1;
                int n2 = 101;
                int nrAssg = 0;
                enrls = 0;
                int roomPref = 0;
                minRoomPref = 0;
                maxRoomPref = 0;
                double timePref = 0.0;
                minTimePref = 0;
                maxTimePref = 0;
                double grPref = 0.0;
                minGrPref = 0;
                maxGrPref = 0;
                long allSC = 0L;
                long hardSC = 0L;
                long distSC = 0L;
                int instPref = 0;
                worstInstrPref = 0;
                int spreadPen = 0;
                int deptSpreadPen = 0;
                int tooBigRooms = 0;
                int rcs = 0;
                int uselessSlots = 0;
                used = new HashSet();
                for (Lecture lecture : vars) {
                    if (lecture.isCommitted()) continue;
                    enrls += lecture.students().size();
                    Placement placement = a.getValue(lecture);
                    if (placement != null) {
                        ++nrAssg;
                    }
                    int[] minMaxRoomPref = lecture.getMinMaxRoomPreference();
                    minRoomPref += minMaxRoomPref[0];
                    maxRoomPref += minMaxRoomPref[1];
                    double[] minMaxTimePref = lecture.getMinMaxTimePreference();
                    minTimePref = (int)((double)minTimePref + minMaxTimePref[0]);
                    maxTimePref = (int)((double)maxTimePref + minMaxTimePref[1]);
                    if (placement != null) {
                        roomPref += placement.getRoomPreference();
                        timePref += placement.getTimeLocation().getNormalizedPreference();
                        if (tbr != null) {
                            tooBigRooms += tbr.getPreference(placement);
                        }
                    }
                    for (Constraint c : lecture.constraints()) {
                        if (!used.add(c)) continue;
                        if (c instanceof InstructorConstraint) {
                            InstructorConstraint ic = (InstructorConstraint)c;
                            instPref += ic.getPreference(a);
                            worstInstrPref += ic.getWorstPreference();
                        }
                        if (c instanceof DepartmentSpreadConstraint) {
                            DepartmentSpreadConstraint dsc = (DepartmentSpreadConstraint)c;
                            deptSpreadPen += dsc.getPenalty(a);
                        } else if (c instanceof SpreadConstraint) {
                            SpreadConstraint sc = (SpreadConstraint)c;
                            spreadPen += sc.getPenalty(a);
                        }
                        if (c instanceof GroupConstraint) {
                            GroupConstraint gc = (GroupConstraint)c;
                            if (gc.isHard()) continue;
                            minGrPref -= Math.abs(gc.getPreference());
                            maxGrPref += 0;
                            grPref += (double)Math.min(0, gc.getCurrentPreference(a));
                        }
                        if (c instanceof JenrlConstraint) {
                            JenrlConstraint jc = (JenrlConstraint)c;
                            if (!jc.isInConflict(a) || !jc.isOfTheSameProblem()) continue;
                            Lecture l1 = (Lecture)jc.first();
                            Lecture l2 = (Lecture)jc.second();
                            allSC += jc.getJenrl();
                            if (l1.areStudentConflictsHard(l2)) {
                                hardSC += jc.getJenrl();
                            }
                            Placement p1 = a.getValue(l1);
                            Placement p2 = a.getValue(l2);
                            if (!p1.getTimeLocation().hasIntersection(p2.getTimeLocation())) {
                                distSC += jc.getJenrl();
                            }
                        }
                        if (!(c instanceof RoomConstraint)) continue;
                        RoomConstraint rc = (RoomConstraint)c;
                        uselessSlots += UselessHalfHours.countUselessSlotsHalfHours((RoomConstraint.RoomConstraintContext)rc.getContext((Assignment)a)) + BrokenTimePatterns.countUselessSlotsBrokenTimePatterns((RoomConstraint.RoomConstraintContext)rc.getContext((Assignment)a));
                        ++rcs;
                    }
                }
                w.println(dx.format(scheduler) + "." + dx.format(idx++) + " Assigned variables," + nrAssg);
                w.println(dx.format(scheduler) + "." + dx.format(n2++) + " Assigned variables max," + vars.size());
                w.println(dx.format(scheduler) + "." + dx.format(idx++) + " Hard student conflicts," + hardSC);
                w.println(dx.format(scheduler) + "." + dx.format(n2++) + " Student enrollments," + enrls);
                if (m.getProperties().getPropertyBoolean("General.UseDistanceConstraints", true)) {
                    w.println(dx.format(scheduler) + "." + dx.format(idx++) + " Distance student conf.," + distSC);
                }
                w.println(dx.format(scheduler) + "." + dx.format(idx++) + " Student conflicts," + allSC);
                w.println(dx.format(scheduler) + "." + dx.format(idx++) + " Time preferences," + timePref);
                w.println(dx.format(scheduler) + "." + dx.format(n2++) + " Time preferences min," + minTimePref);
                w.println(dx.format(scheduler) + "." + dx.format(n2++) + " Time preferences max," + maxTimePref);
                w.println(dx.format(scheduler) + "." + dx.format(idx++) + " Room preferences," + roomPref);
                w.println(dx.format(scheduler) + "." + dx.format(n2++) + " Room preferences min," + minRoomPref);
                w.println(dx.format(scheduler) + "." + dx.format(n2++) + " Room preferences max," + maxRoomPref);
                w.println(dx.format(scheduler) + "." + dx.format(idx++) + " Useless half-hours," + uselessSlots);
                w.println(dx.format(scheduler) + "." + dx.format(n2++) + " Useless half-hours max," + Constants.sPreferenceLevelStronglyDiscouraged * rcs * (lastDaySlot - firstDaySlot + 1) * (lastWorkDay - firstWorkDay + 1));
                w.println(dx.format(scheduler) + "." + dx.format(idx++) + " Too big room," + tooBigRooms);
                w.println(dx.format(scheduler) + "." + dx.format(n2++) + " Too big room max," + Constants.sPreferenceLevelStronglyDiscouraged * vars.size());
                w.println(dx.format(scheduler) + "." + dx.format(idx++) + " Distribution preferences," + grPref);
                w.println(dx.format(scheduler) + "." + dx.format(n2++) + " Distribution preferences min," + minGrPref);
                w.println(dx.format(scheduler) + "." + dx.format(n2++) + " Distribution preferences max," + maxGrPref);
                if (m.getProperties().getPropertyBoolean("General.UseDistanceConstraints", true)) {
                    w.println(dx.format(scheduler) + "." + dx.format(idx++) + " Back-to-back instructor pref," + instPref);
                }
                w.println(dx.format(scheduler) + "." + dx.format(n2++) + " Back-to-back instructor pref max," + worstInstrPref);
                if (m.getProperties().getPropertyBoolean("General.DeptBalancing", true)) {
                    w.println(dx.format(scheduler) + "." + dx.format(idx++) + " Department balancing penalty," + sDoubleFormat.format((double)deptSpreadPen / 12.0));
                }
                w.println(dx.format(scheduler) + "." + dx.format(idx++) + " Same subpart balancing penalty," + sDoubleFormat.format((double)spreadPen / 12.0));
            }
            w.flush();
            w.close();
        }
        catch (IOException io) {
            sLogger.error(io.getMessage(), io);
        }
    }

    private class ShutdownHook
    extends Thread {
        Solver<Lecture, Placement> iSolver = null;

        private ShutdownHook(Solver<Lecture, Placement> solver) {
            this.setName("ShutdownHook");
            this.iSolver = solver;
        }

        @Override
        public void run() {
            try {
                if (this.iSolver.isRunning()) {
                    this.iSolver.stopSolver();
                }
                Solution<Lecture, Placement> solution = this.iSolver.lastSolution();
                long lastIt = solution.getIteration();
                double lastTime = solution.getTime();
                DataProperties properties = this.iSolver.getProperties();
                TimetableModel model = (TimetableModel)solution.getModel();
                File outDir = new File(properties.getProperty("General.Output", "."));
                if (solution.getBestInfo() != null) {
                    Solution<Lecture, Placement> bestSolution = solution;
                    sLogger.info("Last solution: " + ToolBox.dict2string(bestSolution.getExtendedInfo(), 1));
                    sLogger.info("Best solution (before restore): " + ToolBox.dict2string(bestSolution.getBestInfo(), 1));
                    bestSolution.restoreBest();
                    sLogger.info("Best solution: " + ToolBox.dict2string(bestSolution.getExtendedInfo(), 1));
                    if (properties.getPropertyBoolean("General.SwitchStudents", true)) {
                        ((TimetableModel)bestSolution.getModel()).switchStudents(bestSolution.getAssignment());
                    }
                    sLogger.info("Best solution: " + ToolBox.dict2string(bestSolution.getExtendedInfo(), 1));
                    Test.saveOutputCSV(bestSolution, new File(outDir, "output.csv"));
                    Test.printSomeStuff(bestSolution);
                    if (properties.getPropertyBoolean("General.Save", true)) {
                        TimetableSaver saver = null;
                        try {
                            saver = (TimetableSaver)Class.forName(Test.this.getTimetableSaverClass(properties)).getConstructor(Solver.class).newInstance(this.iSolver);
                        }
                        catch (ClassNotFoundException e) {
                            System.err.println(e.getClass().getSimpleName() + ": " + e.getMessage());
                            saver = new TimetableXMLSaver(this.iSolver);
                        }
                        if (saver instanceof TimetableXMLSaver && properties.getProperty("General.SolutionFile") != null) {
                            ((TimetableXMLSaver)saver).save(new File(properties.getProperty("General.SolutionFile")));
                        } else {
                            saver.save();
                        }
                    }
                } else {
                    sLogger.info("Last solution:" + ToolBox.dict2string(solution.getExtendedInfo(), 1));
                }
                Test.this.iCSVFile.close();
                sLogger.info("Total number of done iteration steps:" + lastIt);
                sLogger.info("Achieved speed: " + sDoubleFormat.format((double)lastIt / lastTime) + " iterations/second");
                PrintWriter out = new PrintWriter(new FileWriter(new File(outDir, "solver.html")));
                out.println("<html><title>Save log</title><body>");
                out.println(Progress.getInstance(model).getHtmlLog(0, true));
                out.println("</html>");
                out.flush();
                out.close();
                Progress.removeInstance(model);
                if (Test.this.iStat != null) {
                    PrintWriter cbs = new PrintWriter(new FileWriter(new File(outDir, "cbs.txt")));
                    cbs.println(Test.this.iStat.toString());
                    cbs.flush();
                    cbs.close();
                }
                System.out.println("Unassigned variables: " + model.nrUnassignedVariables(solution.getAssignment()));
            }
            catch (Throwable t) {
                sLogger.error("Test failed.", t);
            }
        }
    }
}

