/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.webutil.timegrid;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.cpsolver.coursett.constraint.DepartmentSpreadConstraint;
import org.cpsolver.coursett.constraint.DiscouragedRoomConstraint;
import org.cpsolver.coursett.constraint.GroupConstraint;
import org.cpsolver.coursett.constraint.InstructorConstraint;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.constraint.RoomConstraint;
import org.cpsolver.coursett.criteria.TooBigRooms;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomSharingModel;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.model.StudentGroup;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solver.Solver;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.dao.CurriculumDAO;
import org.unitime.timetable.solver.ui.StudentGroupInfo;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.webutil.timegrid.TimetableGridCell;
import org.unitime.timetable.webutil.timegrid.TimetableGridContext;
import org.unitime.timetable.webutil.timegrid.TimetableGridModel;

public class SolverGridModel
extends TimetableGridModel
implements Serializable {
    protected static final GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    private static final long serialVersionUID = 1L;
    private transient Long iRoomId = null;

    public SolverGridModel() {
    }

    public SolverGridModel(Solver solver, int resourceType, long resourceId, String name, int size, Collection<Placement> placements, TimetableGridContext context) {
        super(resourceType, resourceId);
        this.setName(name);
        this.setSize(size);
        this.setFirstDay(context.getFirstDay());
        this.init(solver, placements, context.getBgMode(), context);
    }

    public SolverGridModel(Solver solver, RoomConstraint room, TimetableGridContext context) {
        super(0, room.getResourceId());
        Assignment assignment = solver.currentSolution().getAssignment();
        if (room instanceof DiscouragedRoomConstraint) {
            this.setName("<span style='color:" + PreferenceLevel.prolog2color(PreferenceLevel.sStronglyDiscouraged) + "'>" + room.getRoomName() + "</span>");
        } else {
            this.setName(room.getRoomName());
        }
        this.setSize(room.getCapacity());
        this.setType(room.getType());
        this.setFirstDay(context.getFirstDay());
        this.iRoomId = room.getResourceId();
        if (context.getFirstDay() < 0) {
            Vector<Placement> placements = new Vector<Placement>();
            for (Lecture lecture : room.variables()) {
                Placement placement = (Placement)assignment.getValue((Variable)lecture);
                if (placement == null || !placement.hasRoomLocation(this.iRoomId)) continue;
                placements.add(placement);
            }
            this.init(solver, placements, context.getBgMode(), context);
        } else {
            this.init(solver, room.getResourceOfWeek(assignment, context.getFirstDay()), context);
        }
        HashSet<Long> deptIds = new HashSet<Long>();
        String deptIdsStr = solver.getProperties().getProperty("General.DepartmentIds");
        if (deptIdsStr != null) {
            StringTokenizer stk = new StringTokenizer(deptIdsStr, ",");
            while (stk.hasMoreTokens()) {
                deptIds.add(Long.valueOf(stk.nextToken()));
            }
        }
        HashSet<Placement> done = new HashSet<Placement>();
        RoomSharingModel sharing = room.getSharingModel();
        for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
            for (int j = 0; j < 288; ++j) {
                List placements;
                if (sharing != null) {
                    if (sharing.isNotAvailable(i, j)) {
                        this.setAvailable(i, j, false);
                    } else {
                        Long dept = sharing.getDepartmentId(i * 288 + j);
                        if (dept != null && !deptIds.contains(dept)) {
                            this.setAvailable(i, j, false);
                        }
                    }
                }
                List list = placements = room.getAvailableArray() == null ? null : room.getAvailableArray()[i * 288 + j];
                if (placements == null || placements.isEmpty()) continue;
                for (Placement p : placements) {
                    if (!context.isShowEvents() && p.getAssignmentId() == null || !done.add(p)) continue;
                    this.init(solver, p, -1, context);
                }
            }
        }
    }

    public SolverGridModel(Solver solver, InstructorConstraint instructor, TimetableGridContext context) {
        super(1, instructor.getResourceId());
        Assignment assignment = solver.currentSolution().getAssignment();
        this.setName(instructor.getName());
        this.setType(instructor.getType());
        this.setFirstDay(context.getFirstDay());
        if (context.getFirstDay() < 0) {
            Vector<Placement> placements = new Vector<Placement>();
            for (Lecture lecture : instructor.variables()) {
                Placement placement = (Placement)assignment.getValue((Variable)lecture);
                if (placement == null) continue;
                placements.add(placement);
            }
            this.init(solver, placements, context.getBgMode(), context);
        } else {
            this.init(solver, ((InstructorConstraint.InstructorConstraintContext)instructor.getContext(assignment)).getResourceOfWeek(context.getFirstDay()), context);
        }
        if (instructor.getUnavailabilities() != null) {
            for (Placement p : instructor.getUnavailabilities()) {
                if (!context.isShowEvents() && p.getAssignmentId() == null) continue;
                this.init(solver, p, -1, context);
            }
        }
        for (Student student : ((TimetableModel)solver.currentSolution().getModel()).getAllStudents()) {
            if (!instructor.equals((Object)student.getInstructor())) continue;
            for (Lecture lecture : student.getLectures()) {
                Placement placement = (Placement)assignment.getValue((Variable)lecture);
                if (placement == null || instructor.variables().contains(lecture)) continue;
                for (TimetableGridCell cell = this.init(solver, placement, context.getBgMode(), context); cell != null; cell = cell.getParent()) {
                    cell.setName("<i>" + cell.getName() + "</i>");
                    cell.setRoomName("<i>" + cell.getRoomName() + "</i>");
                }
            }
        }
    }

    public SolverGridModel(Solver solver, DepartmentSpreadConstraint dept, TimetableGridContext context) {
        super(1, dept.getDepartmentId());
        Assignment assignment = solver.currentSolution().getAssignment();
        this.setName(dept.getName());
        this.setSize(dept.variables().size());
        this.setFirstDay(context.getFirstDay());
        Vector<Placement> placements = new Vector<Placement>();
        for (Lecture lecture : dept.variables()) {
            Placement placement = (Placement)assignment.getValue((Variable)lecture);
            if (placement == null) continue;
            placements.add(placement);
        }
        this.init(solver, placements, context.getBgMode(), context);
    }

    public SolverGridModel(Solver solver, String name, List<Student> students, TimetableGridContext context) {
        super(3, -1L);
        Assignment assignment = solver.currentSolution().getAssignment();
        this.setName(name);
        this.setFirstDay(context.getFirstDay());
        Hashtable<Long, String> groups = new Hashtable<Long, String>();
        for (Object[] o : CurriculumDAO.getInstance().getSession().createQuery("select c.course.instructionalOffering.uniqueId, g.name from CurriculumCourse c inner join c.groups g where c.classification.curriculum.abbv || ' ' || c.classification.academicClassification.code = :name and c.classification.curriculum.department.session.uniqueId = :sessionId").setString("name", name).setLong("sessionId", solver.getProperties().getPropertyLong("General.SessionId", null).longValue()).setCacheable(true).list()) {
            Long courseId = (Long)o[0];
            String group = (String)o[1];
            String string = (String)groups.get(courseId);
            groups.put(courseId, (string == null ? "" : string + ", ") + group);
        }
        double size = 0.0;
        Hashtable<Placement, Double> placements = new Hashtable<Placement, Double>();
        for (Student student : students) {
            int cnt = 0;
            double w = 0.0;
            for (Lecture lecture : student.getLectures()) {
                w += student.getOfferingWeight(lecture.getConfiguration());
                ++cnt;
                Placement placement = (Placement)assignment.getValue((Variable)lecture);
                if (placement == null) continue;
                Double old = (Double)placements.get(placement);
                placements.put(placement, student.getOfferingWeight(lecture.getConfiguration()) + (old == null ? 0.0 : old));
            }
            if (student.getCommitedPlacements() != null) {
                for (Placement placement : student.getCommitedPlacements()) {
                    w += student.getOfferingWeight(((Lecture)placement.variable()).getConfiguration());
                    ++cnt;
                    Double old = (Double)placements.get(placement);
                    placements.put(placement, student.getOfferingWeight(((Lecture)placement.variable()).getConfiguration()) + (old == null ? 0.0 : old));
                }
            }
            if (cnt <= 0) continue;
            size += w / (double)cnt;
        }
        this.setSize((int)Math.round(size));
        this.setUtilization(this.countUtilization(context, placements.keySet()));
        for (Map.Entry entry : placements.entrySet()) {
            String group;
            String string = group = ((Lecture)((Placement)entry.getKey()).variable()).getConfiguration() == null ? null : (String)groups.get(((Lecture)((Placement)entry.getKey()).variable()).getConfiguration().getOfferingId());
            for (TimetableGridCell cell = this.init(solver, (Placement)entry.getKey(), ((Lecture)((Placement)entry.getKey()).variable()).isCommitted() ? -1 : context.getBgMode(), context); cell != null; cell = cell.getParent()) {
                cell.setRoomName(cell.getRoomName() + " (" + Math.round((Double)entry.getValue()) + (group == null ? "" : ", " + group) + ")");
            }
        }
    }

    public SolverGridModel(Solver solver, StudentGroup group, TimetableGridContext context) {
        super(5, group.getId());
        Assignment assignment = solver.currentSolution().getAssignment();
        this.setName(group.getName());
        this.setFirstDay(context.getFirstDay());
        double size = 0.0;
        Hashtable<Placement, Double> placements = new Hashtable<Placement, Double>();
        for (Student student : group.getStudents()) {
            int cnt = 0;
            double w = 0.0;
            for (Lecture lecture : student.getLectures()) {
                w += student.getOfferingWeight(lecture.getConfiguration());
                ++cnt;
                Placement placement = (Placement)assignment.getValue((Variable)lecture);
                if (placement == null) continue;
                Double old = (Double)placements.get(placement);
                placements.put(placement, student.getOfferingWeight(lecture.getConfiguration()) + (old == null ? 0.0 : old));
            }
            if (student.getCommitedPlacements() != null) {
                for (Placement placement : student.getCommitedPlacements()) {
                    w += student.getOfferingWeight(((Lecture)placement.variable()).getConfiguration());
                    ++cnt;
                    Double old = (Double)placements.get(placement);
                    placements.put(placement, student.getOfferingWeight(((Lecture)placement.variable()).getConfiguration()) + (old == null ? 0.0 : old));
                }
            }
            if (cnt <= 0) continue;
            size += w / (double)cnt;
        }
        this.setSize((int)Math.round(size));
        this.setUtilization(StudentGroupInfo.value(group));
        for (Map.Entry entry : placements.entrySet()) {
            for (TimetableGridCell cell = this.init(solver, (Placement)entry.getKey(), ((Lecture)((Placement)entry.getKey()).variable()).isCommitted() ? -1 : context.getBgMode(), context); cell != null; cell = cell.getParent()) {
                cell.setRoomName(cell.getRoomName() + " (" + Math.round((Double)entry.getValue()) + ")");
            }
        }
    }

    private void init(Solver solver, Placement[] resource, TimetableGridContext context) {
        HashMap<Lecture, TimetableGridCell> processed = new HashMap<Lecture, TimetableGridCell>();
        ArrayList<Placement> placements = new ArrayList<Placement>();
        for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
            for (int j = 0; j < 288; ++j) {
                Lecture lecture;
                Placement placement = resource[i * 288 + j];
                if (placement == null || (lecture = (Lecture)placement.variable()).isCommitted()) continue;
                TimetableGridCell cell = (TimetableGridCell)processed.get(lecture);
                if (cell == null) {
                    cell = this.createCell(solver, i, j, lecture, placement, context.getBgMode());
                    processed.put(lecture, cell);
                    placements.add(placement);
                } else {
                    cell = cell.copyCell(i, cell.getMeetingNumber() + 1);
                }
                this.addCell(i, j, cell);
                j += placement.getTimeLocation().getNrSlotsPerMeeting() - 1;
            }
        }
        this.setUtilization(this.countUtilization(context, placements));
    }

    private void init(Solver solver, Collection<Placement> placements, int bgMode, TimetableGridContext context) {
        this.setUtilization(this.countUtilization(context, placements));
        for (Placement placement : placements) {
            if (((Lecture)placement.variable()).isCommitted()) continue;
            this.init(solver, placement, bgMode, context);
        }
    }

    private TimetableGridCell init(Solver solver, Placement placement, int bgMode, TimetableGridContext context) {
        TimetableGridCell cell = null;
        TimeLocation.IntEnumeration f = placement.getTimeLocation().getStartSlots();
        while (f.hasMoreElements()) {
            int slot = (Integer)f.nextElement();
            if (context.getFirstDay() >= 0 && !placement.getTimeLocation().getWeekCode().get(context.getFirstDay() + slot / 288)) continue;
            cell = cell == null ? this.createCell(solver, slot / 288, slot % 288, (Lecture)placement.variable(), placement, bgMode) : cell.copyCell(slot / 288, cell.getMeetingNumber() + 1);
            this.addCell(slot, cell);
        }
        return cell;
    }

    public static String hardConflicts2pref(Assignment<Lecture, Placement> assignment, Lecture lecture, Placement placement) {
        if (placement != null) {
            if (placement.getExtra() == null || placement.getExtra() instanceof CachedHardConflictPreference) {
                CachedHardConflictPreference cached;
                CachedHardConflictPreference cachedHardConflictPreference = cached = placement.getExtra() == null ? null : (CachedHardConflictPreference)placement.getExtra();
                if (cached != null && cached.isValid()) {
                    return cached.getPreference();
                }
                String preference = SolverGridModel.hardConflicts2prefNoCache(assignment, lecture, placement);
                placement.setExtra((Object)new CachedHardConflictPreference(preference));
                return preference;
            }
            return SolverGridModel.hardConflicts2prefNoCache(assignment, lecture, placement);
        }
        if (lecture.getExtra() == null || lecture.getExtra() instanceof CachedHardConflictPreference) {
            CachedHardConflictPreference cached;
            CachedHardConflictPreference cachedHardConflictPreference = cached = lecture.getExtra() == null ? null : (CachedHardConflictPreference)lecture.getExtra();
            if (cached != null && cached.isValid()) {
                return cached.getPreference();
            }
            String preference = SolverGridModel.hardConflicts2prefNoCache(assignment, lecture, placement);
            lecture.setExtra((Object)new CachedHardConflictPreference(preference));
            return preference;
        }
        return SolverGridModel.hardConflicts2prefNoCache(assignment, lecture, placement);
    }

    public static String hardConflicts2prefNoCache(Assignment<Lecture, Placement> assignment, Lecture lecture, Placement placement) {
        if (lecture.isCommitted()) {
            return PreferenceLevel.sRequired;
        }
        List values = lecture.values(assignment);
        if (placement == null) {
            boolean hasNoConf = false;
            for (Placement p : values) {
                if (p.isHard(assignment) || !lecture.getModel().conflictValues(assignment, (Value)p).isEmpty()) continue;
                hasNoConf = true;
                break;
            }
            if (lecture.nrTimeLocations() == 1) {
                if (lecture.nrRoomLocations() == 1) {
                    return PreferenceLevel.sRequired;
                }
                return hasNoConf ? PreferenceLevel.sDiscouraged : PreferenceLevel.sStronglyDiscouraged;
            }
            if (lecture.nrRoomLocations() == 1) {
                return hasNoConf ? PreferenceLevel.sStronglyPreferred : PreferenceLevel.sNeutral;
            }
            return hasNoConf ? PreferenceLevel.sStronglyPreferred : PreferenceLevel.sPreferred;
        }
        if (values.size() == 1) {
            return PreferenceLevel.sRequired;
        }
        boolean hasTime = false;
        boolean hasRoom = false;
        boolean hasTimeNoConf = false;
        boolean hasRoomNoConf = false;
        for (Placement p : values) {
            Set conf;
            if (p.equals((Object)placement) || p.isHard(assignment)) continue;
            if (p.getTimeLocation().equals((Object)placement.getTimeLocation())) {
                hasTime = true;
                if (!hasTimeNoConf && ((conf = lecture.getModel().conflictValues(assignment, (Value)p)).isEmpty() || conf.size() == 1 && conf.contains(placement))) {
                    hasTimeNoConf = true;
                }
            }
            if (p.sameRooms(placement)) {
                hasRoom = true;
                if (!hasRoomNoConf && ((conf = lecture.getModel().conflictValues(assignment, (Value)p)).isEmpty() || conf.size() == 1 && conf.contains(placement))) {
                    hasRoomNoConf = true;
                }
            }
            if (!hasRoomNoConf || !hasTimeNoConf) continue;
            break;
        }
        if (hasTimeNoConf) {
            return PreferenceLevel.sStronglyPreferred;
        }
        if (hasTime && hasRoomNoConf) {
            return PreferenceLevel.sPreferred;
        }
        if (hasTime) {
            return PreferenceLevel.sNeutral;
        }
        if (hasRoomNoConf) {
            return PreferenceLevel.sDiscouraged;
        }
        if (hasRoom) {
            return PreferenceLevel.sStronglyDiscouraged;
        }
        return PreferenceLevel.sRequired;
    }

    private TimetableGridCell createCell(Solver solver, int day, int slot, Lecture lecture, Placement placement, int bgMode) {
        DepartmentSpreadConstraint deptConstraint;
        double penalty;
        int studConf;
        DecimalFormat df;
        String background;
        String onClick;
        String shortCommentNoColor;
        String shortComment;
        int nrMeetings;
        int length;
        String title;
        String name;
        Assignment assignment;
        block41: {
            TimetableModel model;
            assignment = solver.currentSolution().getAssignment();
            name = lecture.getName();
            title = "";
            length = placement.getTimeLocation().getNrSlotsPerMeeting();
            nrMeetings = placement.getTimeLocation().getNrMeetings();
            shortComment = null;
            shortCommentNoColor = null;
            onClick = "showGwtDialog('Suggestions', 'suggestions.do?id=" + lecture.getClassId() + "&op=Reset','900','90%');";
            background = TimetableGridCell.sBgColorNeutral;
            df = new DecimalFormat("0.0");
            if (bgMode == -1) {
                background = TimetableGridCell.sBgColorNotAvailable;
            }
            studConf = lecture.countStudentConflicts(assignment, placement) + lecture.getCommitedConflicts(placement);
            penalty = 0.0;
            if (solver.getPerturbationsCounter() != null) {
                penalty = solver.getPerturbationsCounter().getPerturbationPenalty(assignment, solver.currentSolution().getModel(), (Value)placement, new Vector());
            }
            deptConstraint = null;
            for (Constraint c : lecture.constraints()) {
                if (!(c instanceof DepartmentSpreadConstraint)) continue;
                deptConstraint = (DepartmentSpreadConstraint)c;
                break;
            }
            if (bgMode == 1) {
                int pref = placement.getTimeLocation().getPreference();
                if (PreferenceLevel.sNeutral.equals(PreferenceLevel.int2prolog(pref)) && lecture.nrTimeLocations() == 1) {
                    pref = PreferenceLevel.sIntLevelRequired;
                }
                background = TimetableGridCell.pref2color(pref);
            } else if (bgMode == 2) {
                int pref;
                int n = pref = this.iRoomId == null ? placement.getRoomPreference() : placement.getRoomLocation(this.iRoomId).getPreference();
                if (PreferenceLevel.sNeutral.equals(PreferenceLevel.int2prolog(pref)) && lecture.nrRoomLocations() == lecture.getNrRooms()) {
                    pref = PreferenceLevel.sIntLevelRequired;
                }
                background = TimetableGridCell.pref2color(pref);
            } else if (bgMode == 3) {
                background = TimetableGridCell.conflicts2color(studConf);
                if (this.getResourceType() == 1) {
                    for (JenrlConstraint jenrl : lecture.jenrlConstraints()) {
                        if (jenrl.getNrInstructors() <= 0 || !jenrl.isInConflict(assignment)) continue;
                        for (Student student : jenrl.getInstructors()) {
                            if (this.getResourceId() != student.getInstructor().getResourceId().longValue() || student.getInstructor().variables().contains(lecture)) continue;
                            background = TimetableGridCell.sBgColorRequired;
                            break block41;
                        }
                    }
                }
            } else if (bgMode == 4) {
                int pref = 0;
                for (InstructorConstraint ic : lecture.getInstructorConstraints()) {
                    pref += ic.getPreferenceCombination(assignment, placement);
                }
                background = TimetableGridCell.pref2color(pref);
            } else if (bgMode == 6) {
                Object pref = PreferenceLevel.sNeutral;
                if (lecture.getInitialAssignment() != null) {
                    pref = placement.equals((Object)lecture.getInitialAssignment()) ? PreferenceLevel.sStronglyPreferred : (placement.sameTime((Placement)lecture.getInitialAssignment()) ? PreferenceLevel.sDiscouraged : (placement.sameRooms((Placement)lecture.getInitialAssignment()) ? PreferenceLevel.sStronglyDiscouraged : PreferenceLevel.sProhibited));
                }
                background = TimetableGridCell.pref2color((String)pref);
            } else if (bgMode == 7) {
                background = TimetableGridCell.conflicts2color((int)Math.ceil(penalty));
            } else if (bgMode == 8) {
                background = TimetableGridCell.pref2color(SolverGridModel.hardConflicts2pref((Assignment<Lecture, Placement>)assignment, lecture, placement));
            } else if (bgMode == 9) {
                if (deptConstraint != null) {
                    background = TimetableGridCell.conflicts2colorFast(deptConstraint.getMaxPenalty(assignment, placement));
                }
            } else if (bgMode == 10) {
                long minRoomSize = lecture.minRoomSize();
                int roomSize = placement.getRoomSize();
                background = roomSize < lecture.minRoomSize() ? TimetableGridCell.pref2color(PreferenceLevel.sRequired) : TimetableGridCell.pref2color(((TooBigRooms)solver.currentSolution().getModel().getCriterion(TooBigRooms.class)).getPreference(placement));
                if (lecture.getNrRooms() > 0) {
                    shortComment = "<span style='color:rgb(200,200,200)'>" + (lecture.nrRoomLocations() == 1 ? "<u>" : "") + lecture.minRoomUse() + (lecture.maxRoomUse() != lecture.minRoomUse() ? " - " + lecture.maxRoomUse() : "") + " / " + (minRoomSize == Integer.MAX_VALUE ? "-" : String.valueOf(minRoomSize)) + " / " + roomSize + (lecture.nrRoomLocations() == 1 ? "</u>" : "") + "</span>";
                    shortCommentNoColor = lecture.minRoomUse() + (lecture.maxRoomUse() != lecture.minRoomUse() ? " - " + lecture.maxRoomUse() : "") + " / " + (minRoomSize == Integer.MAX_VALUE ? "-" : String.valueOf(minRoomSize)) + " / " + roomSize;
                }
            } else if (bgMode == 11 && !(model = (TimetableModel)solver.currentSolution().getModel()).getStudentGroups().isEmpty()) {
                int nrGroups = 0;
                double value = 0.0;
                int allAssigned = 0;
                int grandTotal = 0;
                for (StudentGroup group : model.getStudentGroups()) {
                    int total = 0;
                    int assigned = 0;
                    if (this.getResourceType() == 5 && this.getResourceId() != group.getId()) continue;
                    for (Student student : group.getStudents()) {
                        if (!student.hasOffering(lecture.getConfiguration().getOfferingId())) continue;
                        ++total;
                        if (!lecture.students().contains(student)) continue;
                        ++assigned;
                    }
                    if (total <= true || assigned <= 0) continue;
                    allAssigned += assigned;
                    grandTotal += total;
                    int limit = Math.max(lecture.students().size(), lecture.classLimit(assignment));
                    if (total > limit) {
                        total = limit;
                    }
                    ++nrGroups;
                    value += (double)assigned / (double)total;
                }
                if (nrGroups > 0) {
                    background = TimetableGridCell.percentage2color((int)Math.round(100.0 * value / (double)nrGroups));
                    shortCommentNoColor = nrGroups == 1 ? allAssigned + " of " + grandTotal : nrGroups + " groups";
                    shortComment = "<span style='color:rgb(200,200,200)'>" + shortCommentNoColor + "</span>";
                }
            }
        }
        if (bgMode != -1) {
            int roomPref;
            int n = roomPref = this.iRoomId == null ? placement.getRoomPreference() : placement.getRoomLocation(this.iRoomId).getPreference();
            if (shortComment == null) {
                shortComment = "<span style='color:rgb(200,200,200)'>" + (lecture.getBestTimePreference() < placement.getTimeLocation().getNormalizedPreference() ? "<span style='color:red'>" + (int)(placement.getTimeLocation().getNormalizedPreference() - lecture.getBestTimePreference()) + "</span>" : "" + (int)(placement.getTimeLocation().getNormalizedPreference() - lecture.getBestTimePreference())) + ", " + (studConf > 0 ? "<span style='color:rgb(20,130,10)'>" + studConf + "</span>" : "" + studConf) + ", " + (lecture.getBestRoomPreference() < roomPref ? "<span style='color:blue'>" + (roomPref - lecture.getBestRoomPreference()) + "</span>" : "" + (roomPref - lecture.getBestRoomPreference())) + "</span>";
            }
            if (shortCommentNoColor == null) {
                shortCommentNoColor = (int)(placement.getTimeLocation().getNormalizedPreference() - lecture.getBestTimePreference()) + ", " + studConf + ", " + (roomPref - lecture.getBestRoomPreference());
            }
            int btbInstrPref = 0;
            for (InstructorConstraint ic : lecture.getInstructorConstraints()) {
                btbInstrPref += ic.getPreferenceCombination(assignment, placement);
            }
            title = "Time preference: " + (int)placement.getTimeLocation().getNormalizedPreference() + "<br>Student conflicts: " + (lecture.countStudentConflicts(assignment, placement) + lecture.getCommitedConflicts(placement)) + " [committed:" + (lecture.countCommittedStudentConflicts(assignment, placement) + lecture.getCommitedConflicts(placement)) + ", distance:" + lecture.countDistanceStudentConflicts(assignment, placement) + ", hard:" + lecture.countHardStudentConflicts(assignment, placement) + "]<br>Room preference: " + roomPref + (lecture.getInstructorConstraints().isEmpty() ? "" : "<br>Back-to-back instructor pref.: " + btbInstrPref) + (lecture.getInitialAssignment() != null ? "<br>Initial assignment: " + (((Placement)lecture.getInitialAssignment()).equals((Object)placement) ? "<i>current assignment</i>" : ((Placement)lecture.getInitialAssignment()).getName()) : "") + (lecture.getInitialAssignment() != null ? "<br>Perturbation penalty: " + df.format(penalty) : "") + (deptConstraint == null ? "" : "<br>Department balance: " + deptConstraint.getMaxPenalty(assignment, placement));
            int gcPref = 0;
            for (Constraint c : lecture.constraints()) {
                GroupConstraint gc;
                if (!(c instanceof GroupConstraint) || (gc = (GroupConstraint)c).isHard() || gc.getPreference() > 0 && gc.getCurrentPreference(assignment) == 0 || gc.getPreference() < 0 && gc.getCurrentPreference(assignment) < 0) continue;
                gcPref = Math.max(gcPref, Math.abs(gc.getPreference()));
            }
            title = title + "<br>Distribution preference: " + gcPref;
            if (bgMode == 5) {
                background = TimetableGridCell.pref2color(gcPref);
            }
        }
        return new TimetableGridCell(day, slot, placement.getId(), this.iRoomId == null ? 0L : this.iRoomId, placement.getNrRooms() == 0 ? null : placement.getRoomName(","), name, shortComment, shortCommentNoColor, bgMode == -1 ? null : onClick, title, background, length, 0, nrMeetings, placement.getTimeLocation().getDatePatternName(), placement.getTimeLocation().getWeekCode(), lecture.getInstructorName(), placement.getTimeLocation().getStartTimeHeader(CONSTANTS.useAmPm()) + " - " + placement.getTimeLocation().getEndTimeHeader(CONSTANTS.useAmPm()));
    }

    private double countUtilization(TimetableGridContext context, Iterable<Placement> placements) {
        HashSet<Integer> slots = new HashSet<Integer>();
        for (Placement p : placements) {
            int slot;
            int dow;
            int idx;
            int stop;
            int start;
            TimeLocation t = p == null ? null : p.getTimeLocation();
            if (t == null || (start = Math.max(context.getFirstSlot(), t.getStartSlot())) > (stop = Math.min(context.getLastSlot(), t.getStartSlot() + t.getLength() - 1))) continue;
            if (context.getFirstDay() >= 0) {
                for (idx = context.getFirstDay(); idx < 7 + context.getFirstDay(); ++idx) {
                    dow = (idx + context.getStartDayDayOfWeek()) % 7;
                    if (!t.getWeekCode().get(idx) || (t.getDayCode() & Constants.DAY_CODES[dow]) == 0 || (context.getDayCode() & Constants.DAY_CODES[dow]) == 0) continue;
                    for (slot = start; slot <= stop; ++slot) {
                        slots.add(288 * idx + slot);
                    }
                }
                continue;
            }
            idx = -1;
            while ((idx = t.getWeekCode().nextSetBit(1 + idx)) >= 0) {
                dow = (idx + context.getStartDayDayOfWeek()) % 7;
                if (!context.getDefaultDatePattern().get(idx) || (t.getDayCode() & Constants.DAY_CODES[dow]) == 0 || (context.getDayCode() & Constants.DAY_CODES[dow]) == 0) continue;
                for (slot = start; slot <= stop; ++slot) {
                    slots.add(288 * idx + slot);
                }
            }
        }
        return (float)slots.size() / context.getNumberOfWeeks();
    }

    public static class CachedHardConflictPreference
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String iPreference = null;
        private Long iCreated = null;

        public CachedHardConflictPreference(String preference) {
            this.iPreference = preference;
            this.iCreated = System.currentTimeMillis();
        }

        public void setPreference(String preference) {
            this.iPreference = preference;
        }

        public String getPreference() {
            return this.iPreference;
        }

        public boolean isValid() {
            return System.currentTimeMillis() - this.iCreated < 900000L;
        }

        public String toString() {
            return this.iPreference;
        }
    }
}

