/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.webutil.timegrid;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.jsp.JspWriter;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.ExamGridForm;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamInfo;
import org.unitime.timetable.solver.exam.ui.ExamRoomInfo;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.RoomAvailability;

public class ExamGridTable {
    public static Formats.Format<Date> sDF = Formats.getDateFormat(Formats.Pattern.DATE_EXAM_PERIOD);
    public static final int sResourceRoom = 0;
    public static final int sResourceInstructor = 1;
    public static final int sResourceSubject = 2;
    public static final String[] sResources = new String[]{"Room", "Instructor", "Subject Area"};
    public static final int sBgNone = 0;
    public static final int sBgStudentConfs = 1;
    public static final int sBgDirectStudentConfs = 2;
    public static final int sBgMoreThanTwoADayStudentConfs = 3;
    public static final int sBgBackToBackStudentConfs = 4;
    public static final int sBgInstructorConfs = 5;
    public static final int sBgDirectInstructorConfs = 6;
    public static final int sBgMoreThanTwoADayInstructorConfs = 7;
    public static final int sBgBackToBackInstructorConfs = 8;
    public static final int sBgPeriodPref = 9;
    public static final int sBgRoomPref = 10;
    public static final int sBgDistPref = 11;
    public static final String[] sBackgrounds = new String[]{"No Background", "Student Conflicts", "Student Direct Conflicts", "Student >2 A Day Conlicts", "Student Back-To-Back Conlicts", "Instructor Conflicts", "Instructor Direct Conflicts", "Instructor >2 A Day Conlicts", "Instructor Back-To-Back Conlicts", "Period Preferences", "Room Preferences", "Distribution Preferences"};
    public static final int sDispModeInRowHorizontal = 0;
    public static final int sDispModeInRowVertical = 1;
    public static final int sDispModePerDayHorizontal = 2;
    public static final int sDispModePerDayVertical = 3;
    public static final int sDispModePerWeekHorizontal = 4;
    public static final int sDispModePerWeekVertical = 5;
    public static String[] sDispModes = new String[]{"In Row [horizontal]", "In Row [vertical]", "Per Day [horizontal]", "Per Day [vertical]", "Per Week [horizontal]", "Per Week [vertical]"};
    public static final int sOrderByNameAsc = 0;
    public static final int sOrderByNameDesc = 1;
    public static final int sOrderBySizeAsc = 2;
    public static final int sOrderBySizeDesc = 3;
    public static String[] sOrders = new String[]{"name [asc]", "name [desc]", "size [asc]", "size [desc]"};
    public static String sBgColorEmpty = "rgb(255,255,255)";
    public static String sBgColorRequired = "rgb(80,80,200)";
    public static String sBgColorStronglyPreferred = "rgb(40,180,60)";
    public static String sBgColorPreferred = "rgb(170,240,60)";
    public static String sBgColorNeutral = "rgb(240,240,240)";
    public static String sBgColorDiscouraged = "rgb(240,210,60)";
    public static String sBgColorStronglyDiscouraged = "rgb(240,120,60)";
    public static String sBgColorProhibited = "rgb(220,50,40)";
    public static String sBgColorNotAvailable = "rgb(200,200,200)";
    public static String sBgColorNotAvailableButAssigned = sBgColorProhibited;
    Vector<ExamGridModel> iModels = new Vector();
    ExamGridForm iForm = null;
    TreeSet<Integer> iDates = new TreeSet();
    TreeSet<Integer> iStartsSlots = new TreeSet();
    Hashtable<Integer, Hashtable<Integer, ExamPeriod>> iPeriods = new Hashtable();

    public ExamGridTable(ExamGridForm form, SessionContext context, ExamSolverProxy solver) throws Exception {
        this.iForm = form;
        for (ExamPeriod period : this.iForm.getPeriods(this.iForm.getExamType().toString())) {
            this.iDates.add(period.getDateOffset());
            this.iStartsSlots.add(period.getStartSlot());
            Hashtable<Integer, ExamPeriod> periodsThisDay = this.iPeriods.get(period.getDateOffset());
            if (periodsThisDay == null) {
                periodsThisDay = new Hashtable();
                this.iPeriods.put(period.getDateOffset(), periodsThisDay);
            }
            periodsThisDay.put(period.getStartSlot(), period);
        }
        if (this.iForm.getResource() == 0) {
            Date[] bounds = ExamPeriod.getBounds(form.getSessionId(), form.getExamBeginDate(), form.getExamType());
            for (Location location : Location.findAllExamLocations(this.iForm.getSessionId(), this.iForm.getExamType())) {
                if (!this.match(location.getLabel())) continue;
                if (solver != null && solver.getExamTypeId().equals(this.iForm.getExamType())) {
                    this.iModels.add(new RoomExamGridModel(location, solver.getAssignedExamsOfRoom(location.getUniqueId()), bounds));
                    continue;
                }
                this.iModels.add(new RoomExamGridModel(location, Exam.findAssignedExamsOfLocation(location.getUniqueId(), this.iForm.getExamType()), bounds));
            }
        } else if (this.iForm.getResource() == 1) {
            String instructorNameFormat = UserProperty.NameFormat.get(context.getUser());
            Hashtable<String, ExamGridModel> models = new Hashtable<String, ExamGridModel>();
            for (DepartmentalInstructor instructor : DepartmentalInstructor.findAllExamInstructors(this.iForm.getSessionId(), this.iForm.getExamType())) {
                if (!this.match(instructor.getName(instructorNameFormat))) continue;
                Collection<ExamAssignmentInfo> assignments = null;
                assignments = solver != null && solver.getExamTypeId().equals(this.iForm.getExamType()) ? solver.getAssignedExamsOfInstructor(instructor.getUniqueId()) : Exam.findAssignedExamsOfInstructor(instructor.getUniqueId(), this.iForm.getExamType());
                if (instructor.getExternalUniqueId() == null) {
                    this.iModels.add(new ExamGridModel(instructor.getUniqueId(), instructor.getName(instructorNameFormat), -1, assignments));
                    continue;
                }
                ExamGridModel m = (ExamGridModel)models.get(instructor.getExternalUniqueId());
                if (m == null) {
                    m = new ExamGridModel(instructor.getUniqueId(), instructor.getName(instructorNameFormat), -1, assignments);
                    this.iModels.add(m);
                    models.put(instructor.getExternalUniqueId(), m);
                    continue;
                }
                m.addAssignments(assignments);
            }
        } else if (this.iForm.getResource() == 2) {
            for (SubjectArea subject : SubjectArea.getSubjectAreaList(this.iForm.getSessionId())) {
                if (!this.match(subject.getSubjectAreaAbbreviation())) continue;
                if (solver != null && solver.getExamTypeId().equals(this.iForm.getExamType())) {
                    this.iModels.add(new ExamGridModel(subject.getUniqueId(), subject.getSubjectAreaAbbreviation(), -1, solver.getAssignedExams(subject.getUniqueId())));
                    continue;
                }
                this.iModels.add(new ExamGridModel(subject.getUniqueId(), subject.getSubjectAreaAbbreviation(), -1, Exam.findAssignedExams(this.iForm.getSessionId(), subject.getUniqueId(), this.iForm.getExamType())));
            }
        }
        Collections.sort(this.iModels);
    }

    public ExamPeriod getPeriod(int day, Integer time) {
        if (time == null) {
            return null;
        }
        Hashtable<Integer, ExamPeriod> periods = this.iPeriods.get(day);
        return periods == null ? null : periods.get(time);
    }

    public void printToHtml(JspWriter jsp) {
        PrintWriter out = new PrintWriter((Writer)jsp);
        this.printToHtml(out);
        out.flush();
    }

    public int getMaxIdx(ExamGridModel model, int startDay, int endDay, int firstSlot, int lastSlot) {
        int max = 0;
        for (ExamPeriod period : this.iForm.getPeriods(this.iForm.getExamType().toString())) {
            if (period.getDateOffset() < startDay || period.getDateOffset() > endDay || period.getStartSlot() < firstSlot || period.getStartSlot() > lastSlot) continue;
            max = Math.max(max, model.getAssignments(period).size() - 1);
        }
        return max;
    }

    public int getMaxIdx(ExamGridModel model, int dayOfWeek, int firstSlot, int lastSlot) {
        int max = 0;
        for (ExamPeriod period : this.iForm.getPeriods(this.iForm.getExamType().toString())) {
            if (this.getDayOfWeek(period.getDateOffset()) != dayOfWeek || period.getStartSlot() < firstSlot || period.getStartSlot() > lastSlot) continue;
            max = Math.max(max, model.getAssignments(period).size() - 1);
        }
        return max;
    }

    public int getMaxIdx(ExamGridModel model, int week, int slot) {
        int max = 0;
        for (ExamPeriod period : this.iForm.getPeriods(this.iForm.getExamType().toString())) {
            if (this.getWeek(period.getDateOffset()) != week || period.getStartSlot() != slot) continue;
            max = Math.max(max, model.getAssignments(period).size() - 1);
        }
        return max;
    }

    public int getMaxIdx(int day, int time) {
        int max = 0;
        ExamPeriod period = this.getPeriod(day, time);
        if (period == null) {
            return max;
        }
        for (ExamGridModel model : this.models()) {
            max = Math.max(max, model.getAssignments(period).size() - 1);
        }
        return max;
    }

    public String getDayName(int day) {
        Calendar c = Calendar.getInstance(Locale.US);
        c.setTime(this.iForm.getExamBeginDate());
        c.add(6, day);
        return sDF.format(c.getTime());
    }

    public String getDayOfWeekName(int dayOfWeek) {
        Calendar c = Calendar.getInstance(Locale.US);
        c.set(7, dayOfWeek);
        return Formats.getDateFormat(Formats.Pattern.DATE_DAY_OF_WEEK).format(c.getTime());
    }

    public String getWeekName(int week) {
        Calendar c = Calendar.getInstance(Locale.US);
        c.setTime(this.iForm.getSessionBeginDate());
        c.setLenient(true);
        c.add(3, week - 1);
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT);
        while (c.get(7) != 2) {
            c.add(6, -1);
        }
        String first = df.format(c.getTime());
        while (c.get(7) != 1) {
            c.add(6, 1);
        }
        String end = df.format(c.getTime());
        return "Week " + week + "<br>" + first + " - " + end;
    }

    public String getSlotName(int slot) {
        return Constants.toTime(slot * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN);
    }

    public void printHeaderCell(PrintWriter out, String name, boolean vertical, boolean eod, boolean eol) {
        String style = "TimetableHeadCell" + (eol ? "EOL" : (eod ? "EOD" : ""));
        out.println("<th nowrap width='130' height='40' class='" + style + "'>");
        out.println(name == null ? "" : name);
        out.println("</th>");
    }

    public boolean isVertical() {
        return this.iForm.getDispMode() == 1 || this.iForm.getDispMode() == 3 || this.iForm.getDispMode() == 5;
    }

    public void printHeader(PrintWriter out, String name) {
        out.println("<tr valign='top'>");
        boolean vertical = this.isVertical();
        this.printHeaderCell(out, name, vertical, false, false);
        TreeSet<Integer> days = this.days();
        TreeSet<Integer> slots = this.slots();
        TreeSet<Integer> weeks = this.weeks();
        TreeSet<Integer> daysOfWeek = this.daysOfWeek();
        if (this.iForm.getDispMode() == 0) {
            for (Integer day : days) {
                for (Integer slot : this.slots()) {
                    boolean eod = slot == slots.last();
                    boolean eol = eod && day == days.last();
                    this.printHeaderCell(out, this.getDayName(day) + "<br>" + this.getSlotName(slot), vertical, eod, eol);
                }
            }
        } else if (this.iForm.getDispMode() == 1) {
            for (ExamGridModel m : this.models()) {
                boolean eol = m.equals(this.models().lastElement());
                this.printHeaderCell(out, m.getName() + (m.getSize() > 0 ? " (" + m.getSize() + ")" : ""), vertical, false, eol);
            }
        } else if (this.iForm.getDispMode() == 2) {
            for (Integer slot : this.slots()) {
                boolean eol = slot == slots.last();
                this.printHeaderCell(out, this.getSlotName(slot), vertical, false, eol);
            }
        } else if (this.iForm.getDispMode() == 3) {
            for (Integer day : days) {
                boolean eol = day == days.last();
                this.printHeaderCell(out, this.getDayName(day), vertical, false, eol);
            }
        } else if (this.iForm.getDispMode() == 4) {
            for (Integer week : weeks) {
                for (Integer slot : slots) {
                    boolean eod = slot == slots.last();
                    boolean eol = eod && week == weeks.last();
                    this.printHeaderCell(out, this.getWeekName(week) + "<br>" + this.getSlotName(slot), vertical, eod, eol);
                }
            }
        } else if (this.iForm.getDispMode() == 5) {
            for (Integer dow : daysOfWeek) {
                boolean eol = dow == daysOfWeek.last();
                this.printHeaderCell(out, this.getDayOfWeekName(dow), vertical, false, eol);
            }
        }
        out.println("</tr>");
    }

    private void getMouseOverAndMouseOut(StringBuffer onMouseOver, StringBuffer onMouseOut, ExamGridModel.ExamGridCell cell, String bgColor, boolean changeMouse) {
        if (cell == null) {
            return;
        }
        ExamAssignmentInfo info = cell.getInfo();
        if (info == null) {
            return;
        }
        onMouseOver.append(" onmouseover=\"");
        onMouseOut.append(" onmouseout=\"");
        if (this.iForm.getResource() == 0) {
            for (ExamRoomInfo room : info.getRooms()) {
                Long roomId = room.getLocationId();
                onMouseOver.append("if (document.getElementById('" + info.getExamId() + "." + roomId + "')!=null) document.getElementById('" + info.getExamId() + "." + roomId + "').style.backgroundColor='rgb(223,231,242)';");
                onMouseOut.append("if (document.getElementById('" + info.getExamId() + "." + roomId + "')!=null) document.getElementById('" + info.getExamId() + "." + roomId + "').style.backgroundColor='" + (bgColor == null ? "transparent" : bgColor) + "';");
            }
        } else if (this.iForm.getResource() == 1) {
            Enumeration<ExamInfo.ExamInstructorInfo> e = info.getInstructors().elements();
            while (e.hasMoreElements()) {
                Long instructorId = e.nextElement().getId();
                onMouseOver.append("if (document.getElementById('" + info.getExamId() + "." + instructorId + "')!=null) document.getElementById('" + info.getExamId() + "." + instructorId + "').style.backgroundColor='rgb(223,231,242)';");
                onMouseOut.append("if (document.getElementById('" + info.getExamId() + "." + instructorId + "')!=null) document.getElementById('" + info.getExamId() + "." + instructorId + "').style.backgroundColor='" + (bgColor == null ? "transparent" : bgColor) + "';");
            }
        } else {
            onMouseOver.append("if (document.getElementById('" + info.getExamId() + "')!=null) document.getElementById('" + info.getExamId() + "').style.backgroundColor='rgb(223,231,242)';");
            onMouseOut.append("if (document.getElementById('" + info.getExamId() + "')!=null) document.getElementById('" + info.getExamId() + "').style.backgroundColor='" + (bgColor == null ? "transparent" : bgColor) + "';");
        }
        if (changeMouse) {
            onMouseOver.append("this.style.cursor='hand';this.style.cursor='pointer';");
        }
        onMouseOver.append("\" ");
        onMouseOut.append("\" ");
    }

    public int getWeek(int day) {
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setTime(this.iForm.getExamBeginDate());
        cal.setLenient(true);
        cal.add(6, day);
        int week = 1;
        while (cal.getTime().after(this.iForm.getSessionBeginDate()) && cal.get(3) != this.iForm.getSessionBeginWeek()) {
            cal.add(6, -7);
            ++week;
        }
        while (cal.getTime().before(this.iForm.getSessionBeginDate()) && cal.get(3) != this.iForm.getSessionBeginWeek()) {
            cal.add(7, 7);
            --week;
        }
        return week;
    }

    public int getDayOfWeek(int day) {
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setTime(this.iForm.getExamBeginDate());
        cal.setLenient(true);
        cal.add(6, day);
        return cal.get(7);
    }

    public int getDay(int week, int dayOfWeek) {
        Calendar c = Calendar.getInstance(Locale.US);
        c.setTime(this.iForm.getSessionBeginDate());
        c.setLenient(true);
        c.add(3, week - 1);
        c.add(7, dayOfWeek - c.get(7));
        Calendar ec = Calendar.getInstance(Locale.US);
        ec.setTime(this.iForm.getExamBeginDate());
        return c.get(6) - ec.get(6);
    }

    public TreeSet<Integer> days() {
        if (this.iForm.isAllDates(this.iForm.getExamType().toString())) {
            return this.iDates;
        }
        TreeSet<Integer> days = new TreeSet<Integer>();
        if (this.iForm.getDate(this.iForm.getExamType().toString()) > 500) {
            for (Integer day : this.iDates) {
                if (1000 + this.getWeek(day) != this.iForm.getDate(this.iForm.getExamType().toString())) continue;
                days.add(day);
            }
        } else {
            days.add(this.iForm.getDate(this.iForm.getExamType().toString()));
        }
        return days;
    }

    public TreeSet<Integer> daysOfWeek() {
        TreeSet<Integer> daysOfWeek = new TreeSet<Integer>();
        for (Integer day : this.days()) {
            daysOfWeek.add(this.getDayOfWeek(day));
        }
        return daysOfWeek;
    }

    public TreeSet<Integer> weeks() {
        TreeSet<Integer> weeks = new TreeSet<Integer>();
        for (Integer day : this.days()) {
            weeks.add(this.getWeek(day));
        }
        return weeks;
    }

    public TreeSet<Integer> days(int week) {
        TreeSet<Integer> days = new TreeSet<Integer>();
        for (Integer day : this.days()) {
            if (this.getWeek(day) != week) continue;
            days.add(day);
        }
        return days;
    }

    public TreeSet<Integer> slots() {
        TreeSet<Integer> slots = new TreeSet<Integer>();
        for (Integer slot : this.iStartsSlots) {
            if (slot < this.iForm.getStartTime(this.iForm.getExamType().toString()) || slot > this.iForm.getEndTime(this.iForm.getExamType().toString())) continue;
            slots.add(slot);
        }
        return slots;
    }

    public Integer prev(int slot) {
        Integer prev = null;
        for (Integer s : this.iStartsSlots) {
            if (s < this.iForm.getStartTime(this.iForm.getExamType().toString()) || s >= slot) continue;
            if (prev == null) {
                prev = s;
                continue;
            }
            prev = Math.max(prev, s);
        }
        return prev;
    }

    public Integer next(int slot) {
        Integer next = null;
        for (Integer s : this.iStartsSlots) {
            if (s <= slot || s > this.iForm.getEndTime(this.iForm.getExamType().toString())) continue;
            if (next == null) {
                next = s;
                continue;
            }
            next = Math.min(next, s);
        }
        return next;
    }

    public void printCell(PrintWriter out, ExamGridModel model, int day, int slot, int idx, int maxIdx, boolean head, boolean vertical, boolean in, boolean eod, boolean eol) {
        ExamPeriod period = this.getPeriod(day, slot);
        ExamGridModel.ExamGridCell cell = model.getAssignment(period, idx);
        String style = "Timetable" + (head || !in && !vertical ? "Head" : "") + "Cell" + (!head && in && vertical ? "In" : "") + (vertical ? "Vertical" : "") + (eol ? "EOL" : (eod ? "EOD" : ""));
        if (cell == null) {
            String bgColor = model.getBackground(period);
            if (bgColor == null && !model.isAvailable(period)) {
                bgColor = sBgColorNotAvailable;
            }
            if (period == null) {
                bgColor = sBgColorNotAvailable;
            }
            if (idx > 0 && model.getAssignment(day, slot, idx - 1) == null) {
                return;
            }
            int rowspan = 1 + maxIdx - idx;
            out.println("<td rowspan='" + rowspan + "' class='" + style + "' " + (bgColor == null ? "" : "style='background-color:" + bgColor + "'") + ">&nbsp;</td>");
        } else {
            String bgColor = cell.getBackground();
            if (this.iForm.getBackground() == 0 && !sBgColorNotAvailable.equals(bgColor) && !model.isAvailable(period)) {
                bgColor = sBgColorNotAvailableButAssigned;
            }
            StringBuffer onMouseOver = new StringBuffer();
            StringBuffer onMouseOut = new StringBuffer();
            this.getMouseOverAndMouseOut(onMouseOver, onMouseOut, cell, bgColor, cell.getOnClick() != null);
            out.println("<td nowrap " + (bgColor == null ? "" : "style='background-color:" + bgColor + "' ") + " class='" + style + "' align='center' " + (cell.getOnClick() == null ? "" : "onclick=\"" + cell.getOnClick() + "\" ") + (cell.getId() != null ? "id='" + cell.getId() + "' " : "") + onMouseOver + onMouseOut + (cell.getTitle() == null ? "" : "title=\"" + cell.getTitle() + "\" ") + ">");
            out.print(cell.getName());
            if (this.iForm.getResource() != 0) {
                out.print("<BR>" + cell.getRoomName());
            } else {
                out.print(cell.getShortComment() == null ? "" : "<BR>" + cell.getShortComment());
            }
            out.println("</td>");
        }
    }

    public String getModelName(ExamGridModel model) {
        return model.getName() + (model.getSize() > 0 ? " (" + model.getSize() + ")" : "");
    }

    public void printRowHeaderCell(PrintWriter out, String name, int maxIdx, boolean vertical, boolean head, boolean in) {
        String style = "Timetable" + (head || !in && !vertical ? "Head" : "") + "Cell" + (!head && in && vertical ? "In" : "") + (vertical ? "Vertical" : "");
        out.println("<th nowrap width='130' height='40' rowspan='" + (1 + maxIdx) + "' class='" + style + "'>");
        out.println(name);
        out.println("</th>");
    }

    public void printToHtml(PrintWriter out) {
        boolean vertical = this.isVertical();
        out.println("<table border='0' cellpadding='2' cellspacing='0'>");
        TreeSet<Integer> days = this.days();
        TreeSet<Integer> slots = this.slots();
        TreeSet<Integer> weeks = this.weeks();
        TreeSet<Integer> daysOfWeek = this.daysOfWeek();
        int rowNumber = 0;
        if (this.iForm.getDispMode() == 1) {
            int globalMaxIdx = 0;
            for (Integer n : days) {
                for (Integer slot : slots) {
                    globalMaxIdx = Math.max(globalMaxIdx, this.getMaxIdx(n, slot));
                }
            }
            int week = -1;
            for (Integer day : days) {
                boolean head = false;
                if (week != this.getWeek(day)) {
                    week = this.getWeek(day);
                    head = true;
                    this.printHeader(out, this.getWeekName(week));
                }
                for (Integer slot : slots) {
                    if (this.getPeriod(day, slot) == null) continue;
                    out.println("<tr valign='top'>");
                    int maxIdx = this.getMaxIdx(day, slot);
                    this.printRowHeaderCell(out, this.getDayName(day) + "<br>" + this.getSlotName(slot), maxIdx, vertical, head && slot == slots.first(), globalMaxIdx == 0);
                    for (int idx = 0; idx <= maxIdx; ++idx) {
                        if (idx > 0) {
                            out.println("</tr><tr valign='top'>");
                        }
                        for (ExamGridModel model : this.models()) {
                            this.printCell(out, model, day, slot, idx, maxIdx, head && slot == slots.first() && idx == 0, vertical, globalMaxIdx == 0 || idx > 0, false, model.equals(this.models().lastElement()));
                        }
                    }
                    out.println("</tr>");
                    ++rowNumber;
                }
            }
        } else {
            int tmx = 0;
            for (ExamGridModel examGridModel : this.models()) {
                tmx = Math.max(tmx, this.getMaxIdx(examGridModel, days.first(), days.last(), slots.first(), slots.last()));
            }
            for (ExamGridModel examGridModel : this.models()) {
                int gmx;
                if (this.iForm.getDispMode() == 0) {
                    if (rowNumber % 10 == 0) {
                        this.printHeader(out, null);
                    }
                    int maxIdx = this.getMaxIdx(examGridModel, days.first(), days.last(), slots.first(), slots.last());
                    out.println("<tr valign='top'>");
                    this.printRowHeaderCell(out, examGridModel.getName() + (examGridModel.getSize() > 0 ? " (" + examGridModel.getSize() + ")" : ""), maxIdx, vertical, rowNumber % 10 == 0, tmx == 0);
                    for (int idx = 0; idx <= maxIdx; ++idx) {
                        if (idx > 0) {
                            out.println("</tr><tr valign='top'>");
                        }
                        for (Integer day : days) {
                            for (Integer slot : slots) {
                                boolean eod = slot == slots.last();
                                boolean eol = eod && day == days.last();
                                this.printCell(out, examGridModel, day, slot, idx, maxIdx, rowNumber % 10 == 0 && idx == 0, vertical, tmx == 0 || idx > 0, eod, eol);
                            }
                        }
                    }
                    out.println("</tr>");
                } else if (this.iForm.getDispMode() == 3) {
                    this.printHeader(out, this.getModelName(examGridModel));
                    gmx = this.getMaxIdx(examGridModel, days.first(), days.last(), slots.first(), slots.last());
                    for (Integer slot : slots) {
                        out.println("<tr valign='top'>");
                        int maxIdx = this.getMaxIdx(examGridModel, days.first(), days.last(), slot, slot);
                        this.printRowHeaderCell(out, this.getSlotName(slot), maxIdx, vertical, slot == slots.first(), gmx == 0);
                        for (int idx = 0; idx <= maxIdx; ++idx) {
                            if (idx > 0) {
                                out.println("</tr><tr valign='top'>");
                            }
                            for (Integer day : days) {
                                this.printCell(out, examGridModel, day, slot, idx, maxIdx, slot == slots.first() && idx == 0, vertical, gmx == 0 || idx > 0, false, day == days.last());
                            }
                        }
                        out.println("</tr>");
                    }
                } else if (this.iForm.getDispMode() == 2) {
                    this.printHeader(out, this.getModelName(examGridModel));
                    gmx = this.getMaxIdx(examGridModel, days.first(), days.last(), slots.first(), slots.last());
                    for (Integer day : days) {
                        out.println("<tr valign='top'>");
                        int maxIdx = this.getMaxIdx(examGridModel, day, day, slots.first(), slots.last());
                        this.printRowHeaderCell(out, this.getDayName(day), maxIdx, vertical, day == days.first(), gmx == 0);
                        for (int idx = 0; idx <= maxIdx; ++idx) {
                            if (idx > 0) {
                                out.println("</tr><tr valign='top'>");
                            }
                            for (Integer slot : slots) {
                                this.printCell(out, examGridModel, day, slot, idx, maxIdx, day == days.first() && idx == 0, vertical, gmx == 0 || idx > 0, false, slot == slots.last());
                            }
                        }
                        out.println("</tr>");
                    }
                } else if (this.iForm.getDispMode() == 4) {
                    this.printHeader(out, this.getModelName(examGridModel));
                    gmx = this.getMaxIdx(examGridModel, days.first(), days.last(), slots.first(), slots.last());
                    for (Integer dow : this.daysOfWeek()) {
                        out.println("<tr valign='top'>");
                        int maxIdx = this.getMaxIdx(examGridModel, dow, slots.first(), slots.last());
                        this.printRowHeaderCell(out, this.getDayOfWeekName(dow), maxIdx, vertical, dow == daysOfWeek.first(), gmx == 0);
                        for (int idx = 0; idx <= maxIdx; ++idx) {
                            if (idx > 0) {
                                out.println("</tr><tr valign='top'>");
                            }
                            for (Integer week : weeks) {
                                for (Integer slot : slots) {
                                    this.printCell(out, examGridModel, this.getDay(week, dow), slot, idx, maxIdx, dow == daysOfWeek.first() && idx == 0, vertical, gmx == 0 || idx > 0, slot == slots.last(), slot == slots.last() && week == weeks.last());
                                }
                            }
                        }
                        out.println("</tr>");
                    }
                } else if (this.iForm.getDispMode() == 5) {
                    this.printHeader(out, this.getModelName(examGridModel));
                    gmx = this.getMaxIdx(examGridModel, days.first(), days.last(), slots.first(), slots.last());
                    for (Integer week : weeks) {
                        for (Integer slot : slots) {
                            out.println("<tr valign='top'>");
                            int maxIdx = this.getMaxIdx(examGridModel, week, slot);
                            this.printRowHeaderCell(out, this.getWeekName(week) + "<br>" + this.getSlotName(slot), maxIdx, vertical, slot == slots.first(), gmx == 0);
                            for (int idx = 0; idx <= maxIdx; ++idx) {
                                if (idx > 0) {
                                    out.println("</tr><tr valign='top'>");
                                }
                                for (Integer dow : daysOfWeek) {
                                    this.printCell(out, examGridModel, this.getDay(week, dow), slot, idx, maxIdx, slot == slots.first() && idx == 0, vertical, gmx == 0 || idx > 0, false, dow == daysOfWeek.last());
                                }
                            }
                            out.println("</tr>");
                        }
                    }
                }
                ++rowNumber;
            }
        }
        out.println("</table>");
    }

    private boolean match(String name) {
        if (this.iForm.getFilter() == null || this.iForm.getFilter().trim().length() == 0) {
            return true;
        }
        String n = name.toUpperCase();
        StringTokenizer stk1 = new StringTokenizer(this.iForm.getFilter().toUpperCase(), ";");
        while (stk1.hasMoreTokens()) {
            StringTokenizer stk2 = new StringTokenizer(stk1.nextToken(), " ,");
            boolean match = true;
            while (match && stk2.hasMoreTokens()) {
                String token = stk2.nextToken().trim();
                if (token.length() == 0 || n.indexOf(token) >= 0) continue;
                match = false;
            }
            if (!match) continue;
            return true;
        }
        return false;
    }

    public void printLegend(JspWriter jsp) {
        PrintWriter out = new PrintWriter((Writer)jsp);
        this.printLegend(out);
        out.flush();
    }

    public void printLegend(PrintWriter out) {
        if (this.iForm.getBackground() != 0) {
            out.println("<tr><td colspan='2'>Assigned examinations:</td></tr>");
        }
        if (this.iForm.getBackground() == 9) {
            out.println("<tr><td width=40 style='background-color:" + ExamGridTable.pref2color(PreferenceLevel.sRequired) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Required period</td><td></td></tr>");
            out.println("<tr><td width=40 style='background-color:" + ExamGridTable.pref2color(PreferenceLevel.sStronglyPreferred) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Strongly preferred period</td><td></td></tr>");
            out.println("<tr><td width=40 style='background-color:" + ExamGridTable.pref2color(PreferenceLevel.sPreferred) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Preferred period</td><td></td></tr>");
            out.println("<tr><td width=40 style='background-color:" + ExamGridTable.pref2color(PreferenceLevel.sNeutral) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>No period preference</td><td></td></tr>");
            out.println("<tr><td width=40 style='background-color:" + ExamGridTable.pref2color(PreferenceLevel.sDiscouraged) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Discouraged period</td><td></td></tr>");
            out.println("<tr><td width=40 style='background-color:" + ExamGridTable.pref2color(PreferenceLevel.sStronglyDiscouraged) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Strongly discouraged period</td><td></td></tr>");
            out.println("<tr><td width=40 style='background-color:" + ExamGridTable.pref2color(PreferenceLevel.sProhibited) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Prohibited period</td><td></td></tr>");
        } else if (this.iForm.getBackground() == 10) {
            out.println("<tr><td width=40 style='background-color:" + ExamGridTable.pref2color(PreferenceLevel.sRequired) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Required room</td><td></td></tr>");
            out.println("<tr><td width=40 style='background-color:" + ExamGridTable.pref2color(PreferenceLevel.sStronglyPreferred) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Strongly preferred room</td><td></td></tr>");
            out.println("<tr><td width=40 style='background-color:" + ExamGridTable.pref2color(PreferenceLevel.sPreferred) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Preferred room</td><td></td></tr>");
            out.println("<tr><td width=40 style='background-color:" + ExamGridTable.pref2color(PreferenceLevel.sNeutral) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>No room preference</td><td></td></tr>");
            out.println("<tr><td width=40 style='background-color:" + ExamGridTable.pref2color(PreferenceLevel.sDiscouraged) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Discouraged room</td><td></td></tr>");
            out.println("<tr><td width=40 style='background-color:" + ExamGridTable.pref2color(PreferenceLevel.sStronglyDiscouraged) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Strongly discouraged room</td><td></td></tr>");
            out.println("<tr><td width=40 style='background-color:" + ExamGridTable.pref2color(PreferenceLevel.sProhibited) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Prohibited room</td><td></td></tr>");
        } else if (this.iForm.getBackground() == 5) {
            out.println("<tr><td width=40 style='background-color:" + ExamGridTable.pref2color(PreferenceLevel.sNeutral) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>No instructor conflict</td><td></td></tr>");
            out.println("<tr><td width=40 style='background-color:" + ExamGridTable.pref2color(PreferenceLevel.sDiscouraged) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>One or more instructor back-to-back conflicts</td><td></td></tr>");
            out.println("<tr><td width=40 style='background-color:" + ExamGridTable.pref2color(PreferenceLevel.sStronglyDiscouraged) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>One or more instructor three or more exams a day conflicts</td><td></td></tr>");
            out.println("<tr><td width=40 style='background-color:" + ExamGridTable.pref2color(PreferenceLevel.sProhibited) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>One or more instructor direct conflicts</td><td></td></tr>");
        } else if (this.iForm.getBackground() == 1) {
            out.println("<tr><td width=40 style='background-color:" + ExamGridTable.pref2color(PreferenceLevel.sNeutral) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>No student conflict</td><td></td></tr>");
            out.println("<tr><td width=40 style='background-color:" + ExamGridTable.pref2color(PreferenceLevel.sDiscouraged) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>One or more student back-to-back conflicts</td><td></td></tr>");
            out.println("<tr><td width=40 style='background-color:" + ExamGridTable.pref2color(PreferenceLevel.sStronglyDiscouraged) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>One or more student three or more exams a day student conflicts</td><td></td></tr>");
            out.println("<tr><td width=40 style='background-color:" + ExamGridTable.pref2color(PreferenceLevel.sProhibited) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>One or more student direct conflicts</td><td></td></tr>");
        } else if (this.iForm.getBackground() == 6) {
            for (int nrConflicts = 0; nrConflicts <= 6; ++nrConflicts) {
                String color = ExamGridTable.lessConflicts2color(nrConflicts);
                out.println("<tr><td width=40 style='background-color:" + color + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>" + nrConflicts + " " + (nrConflicts == 6 ? "or more " : "") + "instructor direct conflicts</td><td></td></tr>");
            }
        } else if (this.iForm.getBackground() == 7) {
            for (int nrConflicts = 0; nrConflicts <= 15; ++nrConflicts) {
                String color = ExamGridTable.conflicts2color(nrConflicts);
                out.println("<tr><td width=40 style='background-color:" + color + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>" + nrConflicts + " " + (nrConflicts == 15 ? "or more " : "") + "instructor more than two exams a day conflicts</td><td></td></tr>");
            }
        } else if (this.iForm.getBackground() == 8) {
            for (int nrConflicts = 0; nrConflicts <= 15; ++nrConflicts) {
                String color = ExamGridTable.conflicts2color(nrConflicts);
                out.println("<tr><td width=40 style='background-color:" + color + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>" + nrConflicts + " " + (nrConflicts == 15 ? "or more " : "") + "instructor back to back conflicts</td><td></td></tr>");
            }
        } else if (this.iForm.getBackground() == 2) {
            for (int nrConflicts = 0; nrConflicts <= 6; ++nrConflicts) {
                String color = ExamGridTable.lessConflicts2color(nrConflicts);
                out.println("<tr><td width=40 style='background-color:" + color + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>" + nrConflicts + " " + (nrConflicts == 6 ? "or more " : "") + "student direct conflicts</td><td></td></tr>");
            }
        } else if (this.iForm.getBackground() == 3) {
            for (int nrConflicts = 0; nrConflicts <= 15; ++nrConflicts) {
                String color = ExamGridTable.conflicts2color(nrConflicts);
                out.println("<tr><td width=40 style='background-color:" + color + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>" + nrConflicts + " " + (nrConflicts == 15 ? "or more " : "") + "student more than two exams a day conflicts</td><td></td></tr>");
            }
        } else if (this.iForm.getBackground() == 4) {
            for (int nrConflicts = 0; nrConflicts <= 15; ++nrConflicts) {
                String color = ExamGridTable.conflicts2color(nrConflicts);
                out.println("<tr><td width=40 style='background-color:" + color + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>" + nrConflicts + " " + (nrConflicts == 15 ? "or more " : "") + "student back to back conflicts</td><td></td></tr>");
            }
        } else if (this.iForm.getBackground() == 11) {
            out.println("<tr><td width=40 style='background-color:" + ExamGridTable.pref2color(PreferenceLevel.sNeutral) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>No violated constraint<i>(distance=0)</i></td><td></td></tr>");
            out.println("<tr><td width=40 style='background-color:" + ExamGridTable.pref2color(PreferenceLevel.sDiscouraged) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Discouraged/preferred constraint violated</td><td></td></tr>");
            out.println("<tr><td width=40 style='background-color:" + ExamGridTable.pref2color(PreferenceLevel.sStronglyDiscouraged) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Strongly discouraged/preferred constraint violated</i></td><td></td></tr>");
            out.println("<tr><td width=40 style='background-color:" + ExamGridTable.pref2color(PreferenceLevel.sProhibited) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Required/prohibited constraint violated</i></td><td></td></tr>");
        }
        out.println("<tr><td colspan='2'>Free times:</td></tr>");
        out.println("<tr><td width=40 style='background-color:" + sBgColorNotAvailable + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Period not available</td><td></td></tr>");
        if (this.iForm.getBgPreferences() && this.iForm.getBackground() == 9) {
            out.println("<tr><td width=40 style='background-color:" + ExamGridTable.pref2color(PreferenceLevel.sStronglyPreferred) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Strongly preferred period</td><td></td></tr>");
            out.println("<tr><td width=40 style='background-color:" + ExamGridTable.pref2color(PreferenceLevel.sPreferred) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Preferred period</td><td></td></tr>");
        }
        out.println("<tr><td width=40 style='background-color:" + ExamGridTable.pref2color(PreferenceLevel.sNeutral) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>No period preference</td><td></td></tr>");
        if (this.iForm.getBgPreferences() && this.iForm.getBackground() == 9) {
            out.println("<tr><td width=40 style='background-color:" + ExamGridTable.pref2color(PreferenceLevel.sDiscouraged) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Discouraged period</td><td></td></tr>");
            out.println("<tr><td width=40 style='background-color:" + ExamGridTable.pref2color(PreferenceLevel.sStronglyDiscouraged) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Strongly discouraged period</td><td></td></tr>");
            out.println("<tr><td width=40 style='background-color:" + ExamGridTable.pref2color(PreferenceLevel.sProhibited) + ";border:1px solid rgb(0,0,0)'>&nbsp;</td><td>Prohibited period</td><td></td></tr>");
        }
    }

    public static String pref2color(String pref) {
        if (pref == null) {
            return null;
        }
        return PreferenceLevel.prolog2bgColor(pref);
    }

    public static String pref2color(int pref) {
        return PreferenceLevel.prolog2bgColor(PreferenceLevel.int2prolog(pref));
    }

    public static String conflicts2color(int nrConflicts) {
        if (nrConflicts > 15) {
            nrConflicts = 15;
        }
        String color = null;
        color = nrConflicts == 0 ? "rgb(240,240,240)" : (nrConflicts < 5 ? "rgb(240," + (240 - 30 * nrConflicts / 5) + "," + (240 - 180 * nrConflicts / 5) + ")" : (nrConflicts < 10 ? "rgb(240," + (210 - 90 * (nrConflicts - 5) / 5) + ",60)" : "rgb(" + (240 - 20 * (nrConflicts - 10) / 5) + "," + (120 - 70 * (nrConflicts - 10) / 5) + "," + (60 - 20 * (nrConflicts - 10) / 5) + ")"));
        return color;
    }

    public static String lessConflicts2color(int nrConflicts) {
        if (nrConflicts > 6) {
            nrConflicts = 6;
        }
        String color = null;
        color = nrConflicts == 0 ? "rgb(240,240,240)" : (nrConflicts < 2 ? "rgb(240," + (240 - 30 * nrConflicts / 2) + "," + (240 - 180 * nrConflicts / 2) + ")" : (nrConflicts < 4 ? "rgb(240," + (210 - 90 * (nrConflicts - 2) / 2) + ",60)" : "rgb(" + (240 - 20 * (nrConflicts - 4) / 2) + "," + (120 - 70 * (nrConflicts - 4) / 2) + "," + (60 - 20 * (nrConflicts - 4) / 2) + ")"));
        return color;
    }

    public Vector<ExamGridModel> models() {
        return this.iModels;
    }

    public ExamGridForm getForm() {
        return this.iForm;
    }

    public class RoomExamGridModel
    extends ExamGridModel {
        private Hashtable iExamPrefs;
        private Collection<RoomAvailabilityInterface.TimeBlock> iUnavailabilities;

        RoomExamGridModel(Location location, Collection<ExamAssignmentInfo> assignments, Date[] bounds) {
            super(location.getUniqueId(), location.getLabel(), location.getCapacity(), assignments);
            this.iExamPrefs = new Hashtable();
            this.iUnavailabilities = null;
            this.iExamPrefs = location.getExamPreferences(ExamGridTable.this.iForm.getExamType());
            if (!location.isIgnoreRoomCheck().booleanValue() && RoomAvailability.getInstance() != null) {
                this.iUnavailabilities = RoomAvailability.getInstance().getRoomAvailability(location.getUniqueId(), bounds[0], bounds[1], ((ExamType)ExamTypeDAO.getInstance().get(ExamGridTable.this.iForm.getExamType())).getReference());
            }
        }

        public RoomAvailabilityInterface.TimeBlock getBlock(ExamPeriod period) {
            if (period == null || this.iUnavailabilities == null || this.iUnavailabilities.isEmpty()) {
                return null;
            }
            for (RoomAvailabilityInterface.TimeBlock block : this.iUnavailabilities) {
                if (!period.overlap(block)) continue;
                return block;
            }
            return null;
        }

        public PreferenceLevel getPreference(ExamPeriod period) {
            return this.iExamPrefs == null ? null : (PreferenceLevel)this.iExamPrefs.get(period);
        }

        @Override
        public boolean isAvailable(ExamPeriod period) {
            if (!super.isAvailable(period)) {
                return false;
            }
            if (this.getBlock(period) != null) {
                return false;
            }
            PreferenceLevel pref = this.getPreference(period);
            return pref == null || !PreferenceLevel.sProhibited.equals(pref.getPrefProlog());
        }

        @Override
        public String getBackground(ExamPeriod period) {
            if (period == null) {
                return null;
            }
            if (ExamGridTable.this.iForm.getBgPreferences() && ExamGridTable.this.iForm.getBackground() == 9) {
                PreferenceLevel pref = this.getPreference(period);
                if (pref != null && !PreferenceLevel.sNeutral.equals(pref.getPrefProlog())) {
                    return ExamGridTable.pref2color(pref.getPrefProlog());
                }
                if (period.getPrefLevel() != null && !PreferenceLevel.sNeutral.equals(period.getPrefLevel().getPrefProlog())) {
                    return ExamGridTable.pref2color(period.getPrefLevel().getPrefProlog());
                }
            }
            return null;
        }

        @Override
        public ExamGridModel.ExamGridCell getAssignment(ExamPeriod period, int idx) {
            RoomAvailabilityInterface.TimeBlock block;
            ExamGridModel.ExamGridCell cell = super.getAssignment(period, idx);
            if (cell != null) {
                return cell;
            }
            if (idx == this.getAssignments(period).size() && (block = this.getBlock(period)) != null) {
                return (ExamGridModel)this.new ExamGridModel.BlockGridCell(block);
            }
            return null;
        }
    }

    public class ExamGridModel
    implements Comparable<ExamGridModel> {
        private Long iId = null;
        private String iName = null;
        private int iSize = 0;
        private int iNrAssignments = 0;
        private Hashtable<ExamPeriod, Vector<ExamAssignmentInfo>> iAssignments = new Hashtable();

        ExamGridModel(Long id, String name, int size, Collection<ExamAssignmentInfo> assignments) {
            this.iId = id;
            this.iName = name;
            this.iSize = size;
            for (ExamAssignmentInfo exam : assignments) {
                Vector<ExamAssignmentInfo> a = this.iAssignments.get(exam.getPeriod());
                if (a == null) {
                    a = new Vector();
                    this.iAssignments.put(exam.getPeriod(), a);
                }
                a.add(exam);
                ++this.iNrAssignments;
            }
        }

        public void addAssignments(Collection<ExamAssignmentInfo> assignments) {
            for (ExamAssignmentInfo exam : assignments) {
                Vector<ExamAssignmentInfo> a = this.iAssignments.get(exam.getPeriod());
                if (a == null) {
                    a = new Vector();
                    this.iAssignments.put(exam.getPeriod(), a);
                }
                a.add(exam);
                ++this.iNrAssignments;
            }
        }

        public Long getId() {
            return this.iId;
        }

        public int getSize() {
            if (this.iSize < 0) {
                return this.iNrAssignments;
            }
            return this.iSize;
        }

        public String getName() {
            return this.iName;
        }

        public Vector<ExamAssignmentInfo> getAssignments(ExamPeriod period) {
            if (period == null) {
                return new Vector<ExamAssignmentInfo>();
            }
            Vector ret = this.iAssignments.get(period);
            return ret == null ? new Vector() : ret;
        }

        public ExamGridCell getAssignment(int day, int slot, int idx) {
            return this.getAssignment(ExamGridTable.this.getPeriod(day, slot), idx);
        }

        public ExamGridCell getAssignment(ExamPeriod period, int idx) {
            if (period == null) {
                return null;
            }
            Vector<ExamAssignmentInfo> assignments = this.iAssignments.get(period);
            if (assignments == null || assignments.size() <= idx) {
                return null;
            }
            ExamAssignmentInfo info = assignments.elementAt(idx);
            return info == null ? null : new ExamGridCell(info);
        }

        public boolean isAvailable(ExamPeriod period) {
            return period != null && !PreferenceLevel.sProhibited.equals(period.getPrefLevel().getPrefProlog());
        }

        public String getBackground(ExamPeriod period) {
            if (period == null) {
                return null;
            }
            if (ExamGridTable.this.iForm.getBgPreferences() && ExamGridTable.this.iForm.getBackground() == 9 && period.getPrefLevel() != null && !PreferenceLevel.sNeutral.equals(period.getPrefLevel().getPrefProlog())) {
                return ExamGridTable.pref2color(period.getPrefLevel().getPrefProlog());
            }
            return null;
        }

        @Override
        public int compareTo(ExamGridModel model) {
            switch (ExamGridTable.this.iForm.getOrder()) {
                case 0: {
                    return this.getName().compareTo(model.getName());
                }
                case 1: {
                    return -this.getName().compareTo(model.getName());
                }
                case 2: {
                    return Double.compare(this.getSize(), model.getSize());
                }
                case 3: {
                    return -Double.compare(this.getSize(), model.getSize());
                }
            }
            return this.getId().compareTo(model.getId());
        }

        public class BlockGridCell
        extends ExamGridCell {
            private RoomAvailabilityInterface.TimeBlock iBlock;

            public BlockGridCell(RoomAvailabilityInterface.TimeBlock block) {
                this.iBlock = null;
                this.iBlock = block;
            }

            @Override
            public String getBackground() {
                return sBgColorNotAvailable;
            }

            @Override
            public String getOnClick() {
                return null;
            }

            @Override
            public String getId() {
                return null;
            }

            @Override
            public String getTitle() {
                return this.iBlock.getEventName() + " (" + this.iBlock.getEventType() + ")";
            }

            @Override
            public String getName() {
                return this.iBlock.getEventName();
            }

            @Override
            public String getRoomName() {
                return this.iBlock.getEventType();
            }

            @Override
            public String getShortComment() {
                return "";
            }

            @Override
            public String getShortCommentNoColors() {
                return "";
            }
        }

        public class ExamGridCell {
            private ExamAssignmentInfo iInfo = null;

            public ExamGridCell() {
            }

            public ExamGridCell(ExamAssignmentInfo info) {
                this.iInfo = info;
            }

            private ExamAssignmentInfo getInfo() {
                return this.iInfo;
            }

            public String getBackground() {
                switch (ExamGridTable.this.iForm.getBackground()) {
                    case 9: {
                        return ExamGridTable.pref2color(this.getInfo().getPeriodPref());
                    }
                    case 10: {
                        if (ExamGridTable.this.iForm.getResource() == 0) {
                            return ExamGridTable.pref2color(this.getInfo().getRoomPref(ExamGridModel.this.getId()));
                        }
                        return ExamGridTable.pref2color(this.getInfo().getRoomPref());
                    }
                    case 11: {
                        return ExamGridTable.pref2color(this.getInfo().getDistributionPref());
                    }
                    case 1: {
                        if (this.getInfo().getNrDirectConflicts() > 0) {
                            return ExamGridTable.pref2color(PreferenceLevel.sProhibited);
                        }
                        if (this.getInfo().getNrMoreThanTwoConflicts() > 0) {
                            return ExamGridTable.pref2color(PreferenceLevel.sStronglyDiscouraged);
                        }
                        if (this.getInfo().getNrBackToBackConflicts() > 0) {
                            return ExamGridTable.pref2color(PreferenceLevel.sDiscouraged);
                        }
                        return ExamGridTable.pref2color(PreferenceLevel.sNeutral);
                    }
                    case 2: {
                        return ExamGridTable.lessConflicts2color(this.getInfo().getNrDirectConflicts());
                    }
                    case 3: {
                        return ExamGridTable.conflicts2color(this.getInfo().getNrMoreThanTwoConflicts());
                    }
                    case 4: {
                        return ExamGridTable.conflicts2color(this.getInfo().getNrBackToBackConflicts());
                    }
                    case 5: {
                        if (this.getInfo().getNrInstructorDirectConflicts() > 0) {
                            return ExamGridTable.pref2color(PreferenceLevel.sProhibited);
                        }
                        if (this.getInfo().getNrInstructorMoreThanTwoConflicts() > 0) {
                            return ExamGridTable.pref2color(PreferenceLevel.sStronglyDiscouraged);
                        }
                        if (this.getInfo().getNrInstructorBackToBackConflicts() > 0) {
                            return ExamGridTable.pref2color(PreferenceLevel.sDiscouraged);
                        }
                        return ExamGridTable.pref2color(PreferenceLevel.sNeutral);
                    }
                    case 6: {
                        return ExamGridTable.lessConflicts2color(this.getInfo().getNrInstructorDirectConflicts());
                    }
                    case 7: {
                        return ExamGridTable.conflicts2color(this.getInfo().getNrInstructorMoreThanTwoConflicts());
                    }
                    case 8: {
                        return ExamGridTable.conflicts2color(this.getInfo().getNrInstructorBackToBackConflicts());
                    }
                }
                return null;
            }

            public String getOnClick() {
                return "showGwtDialog('Examination Assignment', 'examInfo.do?examId=" + this.getInfo().getExamId() + "','900','90%');";
            }

            public String getId() {
                String id = this.getInfo().getExamId().toString();
                if (ExamGridTable.this.iForm.getResource() == 0 || ExamGridTable.this.iForm.getResource() == 1) {
                    id = id + "." + ExamGridModel.this.getId();
                }
                return id;
            }

            public String getTitle() {
                return this.getInfo().toString();
            }

            public String getName() {
                return ExamGridTable.this.iForm.getShowSections() ? this.getInfo().getSectionName("<br>") : this.getInfo().getExamName();
            }

            public String getRoomName() {
                return this.getInfo().getRoomsName(",");
            }

            public String getShortComment() {
                int dc = this.getInfo().getNrDirectConflicts();
                int m2d = this.getInfo().getNrMoreThanTwoConflicts();
                int btb = this.getInfo().getNrBackToBackConflicts();
                return "<font color='" + (dc > 0 ? PreferenceLevel.prolog2color("P") : "gray") + "'>" + dc + "</font>, <font color='" + (m2d > 0 ? PreferenceLevel.prolog2color("2") : "gray") + "'>" + m2d + "</font>, <font color='" + (btb > 0 ? PreferenceLevel.prolog2color("1") : "gray") + "'>" + btb + "</font>";
            }

            public String getShortCommentNoColors() {
                int dc = this.getInfo().getNrDirectConflicts();
                int m2d = this.getInfo().getNrMoreThanTwoConflicts();
                int btb = this.getInfo().getNrBackToBackConflicts();
                return dc + ", " + m2d + ", " + btb;
            }
        }
    }
}

